/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.Verifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.security.CertificatePair;
import org.eclipse.update.internal.security.JarVerificationResult;
import org.eclipse.update.internal.security.KeyStores;
import org.eclipse.update.internal.security.KeystoreHandle;

public class JarVerifier
extends Verifier {
    private static final String MANIFEST = "META-INF";
    private JarVerificationResult result;
    private List trustedCertificates;
    private boolean acceptUnsignedFiles;
    private List listOfKeystores;
    private int entries;
    private IProgressMonitor monitor;
    private String jarFileName;
    private File jarFile;

    public JarVerifier() {
        this.initialize();
    }

    private List getKeyStores() throws CoreException {
        if (this.listOfKeystores == null) {
            this.listOfKeystores = new ArrayList(0);
            KeyStores listOfKeystoreHandles = new KeyStores();
            InputStream in = null;
            KeyStore keystore = null;
            KeystoreHandle handle = null;
            while (listOfKeystoreHandles.hasNext()) {
                try {
                    Object var6_5;
                    handle = listOfKeystoreHandles.next();
                    in = UpdateCore.getPlugin().get(handle.getLocation()).getInputStream();
                    try {
                        try {
                            keystore = KeyStore.getInstance(handle.getType());
                            keystore.load(in, null);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw Utilities.newCoreException(Policy.bind("JarVerifier.UnableToFindEncryption", handle.getLocation().toExternalForm()), e);
                        }
                        catch (CertificateException e) {
                            throw Utilities.newCoreException(Policy.bind("JarVerifier.UnableToLoadCertificate", handle.getLocation().toExternalForm()), e);
                        }
                        catch (KeyStoreException e) {
                            throw Utilities.newCoreException(Policy.bind("JarVerifier.UnableToFindProviderForKeystore", handle.getType()), e);
                        }
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    var6_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.listOfKeystores.add(keystore);
                }
                catch (IOException iOException) {}
            }
        }
        return this.listOfKeystores;
    }

    private void initialize() {
        this.result = null;
        this.trustedCertificates = null;
        this.acceptUnsignedFiles = false;
        this.listOfKeystores = null;
    }

    private void init(IFeature feature, ContentReference contentRef) throws CoreException {
        this.jarFile = null;
        if (contentRef instanceof JarContentReference) {
            JarContentReference jarReference = (JarContentReference)contentRef;
            try {
                this.jarFile = jarReference.asFile();
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("Attempting to read JAR file:" + this.jarFile);
                }
                if (!this.jarFile.exists()) {
                    throw new IOException();
                }
                JarFile jar = new JarFile(this.jarFile);
                this.entries = jar.size();
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
                this.jarFileName = this.jarFile.getName();
            }
            catch (ZipException e) {
                throw Utilities.newCoreException(Policy.bind("JarVerifier.InvalidJar", jarReference.toString()), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("JarVerifier.UnableToAccessJar", jarReference.toString()), e);
            }
        }
        this.result = new JarVerificationResult();
        this.result.setVerificationCode(6);
        this.result.setResultException(null);
        this.result.setFeature(feature);
        this.result.setContentReference(contentRef);
    }

    private boolean existsInKeystore(Certificate cert) throws CoreException {
        try {
            List keyStores = this.getKeyStores();
            if (!keyStores.isEmpty()) {
                Iterator listOfKeystores = keyStores.iterator();
                while (listOfKeystores.hasNext()) {
                    KeyStore keystore = (KeyStore)listOfKeystores.next();
                    if (keystore.getCertificateAlias(cert) == null) continue;
                    return true;
                }
            }
        }
        catch (KeyStoreException e) {
            throw Utilities.newCoreException(Policy.bind("JarVerifier.KeyStoreNotLoaded"), e);
        }
        return false;
    }

    private List readJarFile(JarFile jarFile) throws IOException, InterruptedException {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        byte[] buffer = new byte[4096];
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry currentEntry = null;
        InputStream in = null;
        if (this.monitor != null) {
            this.monitor.setTaskName(Policy.bind("JarVerifier.Verify", jarFile.getName()));
        }
        try {
            while (entries.hasMoreElements()) {
                currentEntry = entries.nextElement();
                list.add(currentEntry);
                in = jarFile.getInputStream(currentEntry);
                while (in.read(buffer, 0, buffer.length) != -1) {
                }
                if (in == null) continue;
                in.close();
            }
        }
        catch (IOException e) {
            this.result.setVerificationCode(6);
            this.result.setResultException(e);
        }
        return list;
    }

    public void setMonitor(IProgressMonitor newMonitor) {
        this.monitor = newMonitor;
    }

    public IVerificationResult verify(IFeature feature, ContentReference reference, boolean isFeatureVerification, InstallMonitor monitor) throws CoreException {
        IVerificationResult vr;
        if (reference == null) {
            return this.result;
        }
        if (this.getParent() != null && (vr = this.getParent().verify(feature, reference, isFeatureVerification, monitor)).getVerificationCode() != 8) {
            return vr;
        }
        this.setMonitor(monitor);
        this.init(feature, reference);
        this.result.isFeatureVerification(isFeatureVerification);
        if (this.jarFile != null) {
            this.result = this.verify(this.jarFile.getAbsolutePath());
        } else {
            this.result.setVerificationCode(8);
        }
        return this.result;
    }

    private JarVerificationResult verify(String file) {
        try {
            this.verifyIntegrity(file);
            this.result.alreadySeen(this.alreadyValidated());
            if (this.result.getVerificationCode() == 5) {
                this.verifyAuthentication();
            }
            if (this.result.getVerificationCode() == 1) {
                this.acceptUnsignedFiles = true;
            }
        }
        catch (Exception e) {
            this.result.setVerificationCode(6);
            this.result.setResultException(e);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
            if (this.monitor.isCanceled()) {
                this.result.setVerificationCode(7);
            }
        }
        return this.result;
    }

    private void verifyAuthentication() throws CoreException {
        CertificatePair[] entries = this.result.getRootCertificates();
        boolean certificateFound = false;
        int i = 0;
        while (i < entries.length) {
            certificateFound = this.existsInKeystore(entries[i].getRoot());
            if (certificateFound) {
                this.result.setVerificationCode(3);
                this.result.setFoundCertificate(entries[i]);
                return;
            }
            ++i;
        }
    }

    private void verifyIntegrity(String file) {
        block17: {
            JarFile jarFile;
            block15: {
                jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(file, true);
                        List filesInJar = this.readJarFile(jarFile);
                        if (jarFile.getManifest() != null) {
                            Iterator iter = filesInJar.iterator();
                            boolean certificateFound = false;
                            while (iter.hasNext()) {
                                JarEntry currentJarEntry = (JarEntry)iter.next();
                                Certificate[] certs = currentJarEntry.getCertificates();
                                if (certs != null && certs.length != 0) {
                                    certificateFound = true;
                                    this.result.addCertificates(certs);
                                    continue;
                                }
                                String jarEntryName = currentJarEntry.getName();
                                if (!jarEntryName.toUpperCase().startsWith(MANIFEST) && !currentJarEntry.isDirectory()) break;
                            }
                            if (certificateFound) {
                                this.result.setVerificationCode(5);
                            } else {
                                this.result.setVerificationCode(1);
                            }
                            break block15;
                        }
                        Exception e = new Exception(Policy.bind("JarVerifier.InvalidFile", file));
                        this.result.setResultException(e);
                        this.result.setVerificationCode(1);
                        UpdateCore.warn(null, e);
                    }
                    catch (SecurityException securityException) {
                        this.result.setVerificationCode(2);
                    }
                    catch (InterruptedException interruptedException) {
                        this.result.setVerificationCode(7);
                    }
                    catch (Exception e) {
                        this.result.setVerificationCode(6);
                        this.result.setResultException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            Object var9_13 = null;
            if (jarFile == null) break block17;
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean alreadyValidated() {
        if (this.result.getVerificationCode() == 1) {
            return this.acceptUnsignedFiles;
        }
        if (this.getTrustedCertificates() != null) {
            Iterator iter = this.getTrustedCertificates().iterator();
            CertificatePair[] jarPairs = this.result.getRootCertificates();
            while (iter.hasNext()) {
                CertificatePair trustedCertificate = (CertificatePair)iter.next();
                int i = 0;
                while (i < jarPairs.length) {
                    if (trustedCertificate.equals(jarPairs[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < jarPairs.length) {
                this.addTrustedCertificate(jarPairs[i]);
                ++i;
            }
        }
        return false;
    }

    private void addTrustedCertificate(CertificatePair pair) {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        if (pair != null) {
            this.trustedCertificates.add(pair);
        }
    }

    private List getTrustedCertificates() {
        if (this.trustedCertificates == null) {
            this.trustedCertificates = new ArrayList();
        }
        return this.trustedCertificates;
    }

    public void setParent(IVerifier parentVerifier) {
        super.setParent(parentVerifier);
        this.initialize();
    }
}

