/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.security.CertificatePair;

public class JarVerificationResult
implements IVerificationResult {
    private int resultCode;
    private int verificationCode;
    private Exception resultException;
    private List certificates;
    private CertificatePair[] rootCertificates;
    private CertificatePair foundCertificate;
    private String signerInfo;
    private String verifierInfo;
    private ContentReference contentReference;
    private String text;
    private IFeature feature;
    private boolean featureVerification;
    private boolean alreadySeen;

    public int getResultCode() {
        return this.resultCode;
    }

    public Exception getVerificationException() {
        return this.resultException;
    }

    public void setResultCode(int newResultCode) {
        this.resultCode = newResultCode;
    }

    public void setResultException(Exception newResultException) {
        this.resultException = newResultException;
    }

    public int getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(int verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void addCertificates(Certificate[] certs) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(certs);
        this.rootCertificates = null;
    }

    private List getCertificates() {
        return this.certificates;
    }

    public CertificatePair[] getRootCertificates() {
        if (this.rootCertificates == null) {
            this.rootCertificates = new CertificatePair[0];
            ArrayList<CertificatePair> rootCertificatesList = new ArrayList<CertificatePair>();
            if (this.certificates != null && this.certificates.size() > 0) {
                Iterator iter = this.certificates.iterator();
                while (iter.hasNext()) {
                    Certificate[] certs = (Certificate[])iter.next();
                    if (certs == null || certs.length <= 0) continue;
                    CertificatePair pair = new CertificatePair();
                    pair.setIssuer(certs[0]);
                    int i = 0;
                    while (i < certs.length - 1) {
                        X509Certificate x509certRoot = (X509Certificate)certs[i];
                        X509Certificate x509certIssuer = (X509Certificate)certs[i + 1];
                        if (!x509certRoot.getIssuerDN().equals(x509certIssuer.getSubjectDN())) {
                            pair.setRoot(x509certRoot);
                            if (!rootCertificatesList.contains(pair)) {
                                rootCertificatesList.add(pair);
                            }
                            pair = new CertificatePair();
                            pair.setIssuer(x509certIssuer);
                        }
                        ++i;
                    }
                    if (pair == null) continue;
                    pair.setRoot(certs[certs.length - 1]);
                    if (rootCertificatesList.contains(pair)) continue;
                    rootCertificatesList.add(pair);
                }
            }
            if (rootCertificatesList.size() > 0) {
                this.rootCertificates = new CertificatePair[rootCertificatesList.size()];
                rootCertificatesList.toArray(this.rootCertificates);
            }
        }
        return this.rootCertificates;
    }

    private CertificatePair getFoundCertificate() {
        return this.foundCertificate;
    }

    public void setFoundCertificate(CertificatePair foundCertificate) {
        this.foundCertificate = foundCertificate;
    }

    private void initializeCertificates() {
        CertificatePair trustedCertificate;
        X509Certificate certRoot = null;
        X509Certificate certIssuer = null;
        if (this.getFoundCertificate() == null) {
            CertificatePair[] certs = this.getRootCertificates();
            if (certs.length == 0) {
                return;
            }
            trustedCertificate = certs[0];
        } else {
            trustedCertificate = this.getFoundCertificate();
        }
        certRoot = (X509Certificate)trustedCertificate.getRoot();
        certIssuer = (X509Certificate)trustedCertificate.getIssuer();
        StringBuffer strb = new StringBuffer();
        strb.append(this.issuerString(certIssuer.getSubjectDN()));
        strb.append("\r\n");
        strb.append(Policy.bind("JarVerificationResult.ValidBetween", this.dateString(certIssuer.getNotBefore()), this.dateString(certIssuer.getNotAfter())));
        strb.append(this.checkValidity(certIssuer));
        this.signerInfo = strb.toString();
        if (certIssuer != null && !certIssuer.equals(certRoot)) {
            strb = new StringBuffer();
            strb.append(this.issuerString(certIssuer.getIssuerDN()));
            strb.append("\r\n");
            strb.append(Policy.bind("JarVerificationResult.ValidBetween", this.dateString(certRoot.getNotBefore()), this.dateString(certRoot.getNotAfter())));
            strb.append(this.checkValidity(certRoot));
            this.verifierInfo = strb.toString();
        }
    }

    private String checkValidity(X509Certificate cert) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return "\r\n" + Policy.bind("JarVerificationResult.ExpiredCertificate");
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return "\r\n" + Policy.bind("JarVerificationResult.CertificateNotYetValid");
        }
        return "\r\n" + Policy.bind("JarVerificationResult.CertificateValid");
    }

    private String issuerString(Principal principal) {
        return principal.toString();
    }

    private String dateString(Date date) {
        return DateFormat.getDateInstance().format(date);
    }

    public String getSignerInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.signerInfo;
    }

    public String getVerifierInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.verifierInfo;
    }

    public ContentReference getContentReference() {
        return this.contentReference;
    }

    public void setContentReference(ContentReference ref) {
        this.contentReference = ref;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public String getText() {
        return null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isFeatureVerification() {
        return this.featureVerification;
    }

    public void isFeatureVerification(boolean featureVerification) {
        this.featureVerification = featureVerification;
    }

    public boolean alreadySeen() {
        return this.alreadySeen;
    }

    public boolean alreadySeen(boolean seen) {
        this.alreadySeen = seen;
        return this.alreadySeen;
    }
}

