/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.eclipse.update.internal.model.SiteLocalModel;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SiteLocalParser
extends DefaultHandler {
    private SAXParser parser = new SAXParser();
    private InputStream siteStream;
    private SiteLocalModel site;
    private String text;
    public static final String SITE = "localsite";
    public static final String CONFIG = "config";
    public static final String PRESERVED_CONFIGURATIONS = "preservedConfigurations";
    private ResourceBundle bundle;
    private IFeatureReference feature;
    private boolean preserved = false;

    private ResourceBundle getResourceBundle() throws CoreException {
        ResourceBundle bundle = null;
        URL url = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(this.site.getLocationURL());
            URLClassLoader l = new URLClassLoader(new URL[]{url}, null);
            bundle = ResourceBundle.getBundle("v2LocalSite.xml", Locale.getDefault(), l);
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(String.valueOf(e.getLocalizedMessage()) + ":" + url.toExternalForm());
        }
        catch (MalformedURLException e) {
            UpdateCore.warn(e.getLocalizedMessage());
        }
        return bundle;
    }

    public SiteLocalParser(InputStream siteStream, ILocalSite site) throws IOException, SAXException, CoreException {
        this.parser.setContentHandler((ContentHandler)this);
        this.siteStream = siteStream;
        Assert.isTrue(site instanceof SiteLocalModel);
        this.site = (SiteLocalModel)((Object)site);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing localsite:" + ((SiteLocalModel)((Object)site)).getLocationURLString());
        }
        this.bundle = this.getResourceBundle();
        this.parser.parse(new InputSource(this.siteStream));
    }

    private URL getResourceBundleURL() throws CoreException {
        URL url = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(this.site.getLocationURL());
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(String.valueOf(e.getLocalizedMessage()) + ":" + url.toExternalForm());
        }
        catch (MalformedURLException e) {
            UpdateCore.warn(e.getLocalizedMessage());
        }
        return url;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        try {
            String tag = localName.trim();
            if (tag.equalsIgnoreCase(SITE)) {
                this.processSite(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(CONFIG)) {
                this.processConfig(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(PRESERVED_CONFIGURATIONS)) {
                this.preserved = true;
                return;
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException(Policy.bind("Parser.UnableToCreateURL", e.getMessage()), e);
        }
        catch (CoreException e) {
            throw new SAXException(Policy.bind("Parser.InternalError", e.toString()), (Exception)((Object)e));
        }
    }

    private void processSite(Attributes attributes) throws MalformedURLException {
        String info = attributes.getValue("label");
        info = UpdateManagerUtils.getResourceString(info, this.bundle);
        this.site.setLabel(info);
        String historyString = attributes.getValue("history");
        int history = historyString == null || historyString.equals("") ? SiteLocalModel.DEFAULT_HISTORY : Integer.parseInt(historyString);
        this.site.setMaximumHistoryCount(history);
        String stampString = attributes.getValue("stamp");
        long stamp = Long.parseLong(stampString);
        this.site.setStamp(stamp);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End process Site label:" + info);
        }
    }

    private void processConfig(Attributes attributes) throws MalformedURLException, CoreException {
        URL url = UpdateManagerUtils.getURL(this.site.getLocationURL(), attributes.getValue("url"), null);
        String label = attributes.getValue("label");
        label = UpdateManagerUtils.getResourceString(label, this.bundle);
        InstallConfigurationModel config = new BaseSiteLocalFactory().createInstallConfigurationModel();
        config.setLocationURLString(url.toExternalForm());
        config.setLabel(label);
        config.resolve(url, this.getResourceBundleURL());
        if (this.preserved) {
            this.site.addPreservedInstallConfigurationModel(config);
        } else {
            this.site.addConfigurationModel(config);
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Config Tag: url:" + url.toExternalForm());
        }
    }

    public void endElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        if ((tag = localName.trim()).equalsIgnoreCase(PRESERVED_CONFIGURATIONS)) {
            this.preserved = false;
            return;
        }
    }
}

