/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class SiteLocalModel
extends ModelObject {
    public static final String SITE_LOCAL_PREFIX = "v2LocalSite";
    public static final String DEFAULT_CONFIG_PREFIX = "v2Config";
    public static final String DEFAULT_PRESERVED_CONFIG_PREFIX = "v2PreservedConfig";
    public static final String SITE_LOCAL_FILE = "v2LocalSite.xml";
    public static final String DEFAULT_CONFIG_FILE = "v2Config.xml";
    public static final String DEFAULT_PRESERVED_CONFIG_FILE = "v2PreservedConfig.xml";
    public static int DEFAULT_HISTORY = Integer.MAX_VALUE;
    private long stamp;
    private String label;
    private URL location;
    private String locationURLString;
    private int history = DEFAULT_HISTORY;
    private List configurations;
    private List preservedConfigurations;
    private InstallConfigurationModel currentConfiguration;

    public InstallConfigurationModel getCurrentConfigurationModel() {
        return this.currentConfiguration;
    }

    public InstallConfigurationModel[] getConfigurationHistoryModel() {
        if (this.configurations == null) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.configurations.toArray(this.arrayTypeFor(this.configurations));
    }

    public void addConfigurationModel(InstallConfigurationModel config) {
        if (config != null) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            if (!this.configurations.contains((Object)config)) {
                this.configurations.add(config);
            }
        }
    }

    public boolean removeConfigurationModel(InstallConfigurationModel config) {
        if (config != null) {
            return this.configurations.remove((Object)config);
        }
        return false;
    }

    public URL getLocationURL() {
        return this.location;
    }

    public String getLocationURLString() {
        return this.locationURLString;
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
        this.location = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
    }

    public int getMaximumHistoryCount() {
        return this.history;
    }

    public void setMaximumHistoryCount(int history) {
        this.assertIsWriteable();
        this.history = history;
    }

    public void addPreservedInstallConfigurationModel(InstallConfigurationModel configuration) {
        if (this.preservedConfigurations == null) {
            this.preservedConfigurations = new ArrayList();
        }
        this.preservedConfigurations.add(configuration);
    }

    public boolean removePreservedConfigurationModel(InstallConfigurationModel configuration) {
        if (this.preservedConfigurations != null) {
            return this.preservedConfigurations.remove((Object)configuration);
        }
        return false;
    }

    public InstallConfigurationModel[] getPreservedConfigurationsModel() {
        if (this.preservedConfigurations == null || this.preservedConfigurations.isEmpty()) {
            return new InstallConfigurationModel[0];
        }
        return (InstallConfigurationModel[])this.preservedConfigurations.toArray(this.arrayTypeFor(this.preservedConfigurations));
    }

    public void setCurrentConfigurationModel(InstallConfigurationModel currentConfiguration) {
        this.assertIsWriteable();
        this.currentConfiguration = currentConfiguration;
        ConfiguredSiteModel[] confSites = currentConfiguration.getConfigurationSitesModel();
        int i = 0;
        while (i < confSites.length) {
            confSites[i].getSiteModel().setConfiguredSiteModel(confSites[i]);
            ++i;
        }
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.location = this.resolveURL(base, bundleURL, this.getLocationURLString());
        this.resolveListReference(this.getConfigurationHistoryModel(), base, bundleURL);
        this.resolveListReference(this.getPreservedConfigurationsModel(), base, bundleURL);
        this.resolveReference(this.getCurrentConfigurationModel(), base, bundleURL);
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setStamp(long stamp) {
        this.stamp = stamp;
    }

    protected String getPropertyName() {
        return SITE_LOCAL_FILE;
    }
}

