/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationParser;
import org.xml.sax.SAXException;

public class InstallConfigurationModel
extends ModelObject {
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;
    private boolean isCurrent;
    private URL locationURL;
    private String locationURLString;
    private Date date;
    private String label;
    private List activities;
    private List configurationSites;
    private long timeline;
    protected boolean initialized = false;

    public ConfiguredSiteModel[] getConfigurationSitesModel() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites == null) {
            return new ConfiguredSiteModel[0];
        }
        return (ConfiguredSiteModel[])this.configurationSites.toArray(this.arrayTypeFor(this.configurationSites));
    }

    public void addConfigurationSiteModel(ConfiguredSiteModel site) {
        if (this.configurationSites == null) {
            this.configurationSites = new ArrayList();
        }
        if (!this.configurationSites.contains((Object)site)) {
            this.configurationSites.add(site);
        }
    }

    public void setConfigurationSiteModel(ConfiguredSiteModel[] sites) {
        this.configurationSites = null;
        int i = 0;
        while (i < sites.length) {
            this.addConfigurationSiteModel(sites[i]);
            ++i;
        }
    }

    public boolean removeConfigurationSiteModel(ConfiguredSiteModel site) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites != null) {
            return this.configurationSites.remove((Object)site);
        }
        return false;
    }

    public boolean isCurrent() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isCurrent;
    }

    public void setCurrent(boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    public ConfigurationActivityModel[] getActivityModel() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.activities == null) {
            return new ConfigurationActivityModel[0];
        }
        return (ConfigurationActivityModel[])this.activities.toArray(this.arrayTypeFor(this.activities));
    }

    public void addActivityModel(ConfigurationActivityModel activity) {
        if (this.activities == null) {
            this.activities = new ArrayList();
        }
        if (!this.activities.contains((Object)activity)) {
            this.activities.add(activity);
            activity.setInstallConfigurationModel(this);
        }
    }

    public Date getCreationDate() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.date;
    }

    public void setCreationDate(Date date) {
        this.assertIsWriteable();
        this.date = date;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.locationURL;
    }

    public String getLabel() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
    }

    public String getLocationURLString() {
        if (!this.initialized) {
            this.delayedResolve();
        }
        return this.locationURLString;
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
        this.locationURL = null;
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.base = base;
        this.bundleURL = bundleURL;
    }

    public long getTimeline() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.timeline;
    }

    public void setTimeline(long timeline) {
        this.timeline = timeline;
    }

    private void initialize() {
        try {
            try {
                try {
                    URL resolvedURL = URLEncoder.encode(this.getURL());
                    InputStream in = UpdateCore.getPlugin().get(resolvedURL).getInputStream();
                    new InstallConfigurationParser(in, this);
                }
                catch (FileNotFoundException exception) {
                    UpdateCore.warn(String.valueOf(this.locationURLString) + " does not exist, The local site is not in synch with the file system and is pointing to a file that doesn't exist.", exception);
                    throw Utilities.newCoreException(Policy.bind("InstallConfiguration.ErrorDuringFileAccess", this.locationURLString), exception);
                }
                catch (SAXException exception) {
                    throw Utilities.newCoreException(Policy.bind("InstallConfiguration.ParsingErrorDuringCreation", this.locationURLString, "\r\n" + exception.toString()), exception);
                }
                catch (IOException exception) {
                    throw Utilities.newCoreException(Policy.bind("InstallConfiguration.ErrorDuringFileAccess", this.locationURLString), exception);
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("Error processing configuration history:" + this.locationURL.toExternalForm(), e);
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.initialized = true;
            throw throwable;
        }
        Object var3_9 = null;
        this.initialized = true;
        try {
            this.resolveListReference(this.getActivityModel(), this.base, this.bundleURL);
            this.resolveListReference(this.getConfigurationSitesModel(), this.base, this.bundleURL);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        try {
            this.locationURL = this.resolveURL(this.base, this.bundleURL, this.locationURLString);
        }
        catch (MalformedURLException malformedURLException) {}
    }
}

