/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SessionDelta;
import org.eclipse.update.internal.core.UpdateCore;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallChangeParser
extends DefaultHandler {
    private SAXParser parser = new SAXParser();
    private SessionDelta change;
    private File file;
    public static final String CHANGE = "change";
    public static final String NEW_FEATURE = "newFeatures";
    public static final String REFERENCE = "reference";
    private ResourceBundle bundle;

    public InstallChangeParser(File file) throws IOException, SAXException, CoreException {
        this.parser.setContentHandler((ContentHandler)this);
        FileInputStream changeStream = new FileInputStream(file);
        this.file = file;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Start parsing Install Change:");
        }
        InputSource source = new InputSource(changeStream);
        this.parser.parse(source);
        if (this.change != null) {
            this.change.setFile(file);
        }
    }

    public ISessionDelta getInstallChange() {
        return this.change;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        try {
            String tag = localName.trim();
            if (tag.equalsIgnoreCase(CHANGE)) {
                this.processChange(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(NEW_FEATURE)) {
                this.processNewFeature(attributes);
                return;
            }
            if (tag.equalsIgnoreCase(REFERENCE)) {
                this.processFeatureReference(attributes);
                return;
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException(Policy.bind("Parser.UnableToCreateURL", e.getMessage()), e);
        }
        catch (CoreException e) {
            throw new SAXException(Policy.bind("Parser.InternalError", e.toString()), (Exception)((Object)e));
        }
    }

    private void processFeatureReference(Attributes attributes) throws MalformedURLException, CoreException {
        String siteUrlPath = attributes.getValue("siteURL");
        URL siteURL = new URL(siteUrlPath);
        try {
            siteURL = Platform.resolve((URL)siteURL);
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("Parser.UnableToResolveURL", new Object[]{siteURL}), e);
        }
        ISite currentSite = SiteManager.getSite(siteURL, null);
        String featureUrlPath = attributes.getValue("featureURL");
        URL featureURL = new URL(siteURL, featureUrlPath);
        if (featureURL != null) {
            SiteFeatureReference ref = new SiteFeatureReference();
            ref.setSite(currentSite);
            ref.setURL(featureURL);
            this.change.addReference(ref);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("End Processing Feature Reference: url:" + featureURL.toExternalForm());
            }
        } else {
            String msg = Policy.bind("InstallConfigurationParser.FeatureReferenceNoURL");
            UpdateCore.log(msg, new Exception());
        }
    }

    private void processNewFeature(Attributes attributes) {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("End Processing New Features:");
        }
    }

    private void processChange(Attributes attributes) {
        this.change = new SessionDelta();
        long date = Long.parseLong(attributes.getValue("date"));
        this.change.setCreationDate(new Date(date));
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("End Processing Change: date:" + date);
        }
    }
}

