/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultPluginParser
extends DefaultHandler {
    private SAXParser parser = new SAXParser();
    private String id = null;
    private String version = null;
    private PluginEntry pluginEntry;
    private static final String PLUGIN = "plugin";
    private static final String FRAGMENT = "fragment";
    private static final String ID = "id";
    private static final String VERSION = "version";

    public DefaultPluginParser() {
        this.parser.setContentHandler((ContentHandler)this);
    }

    public synchronized PluginEntry parse(InputStream in) throws SAXException, IOException {
        try {
            this.pluginEntry = new PluginEntry();
            this.parser.parse(new InputSource(in));
        }
        catch (ParseCompleteException parseCompleteException) {}
        this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(this.id, this.version));
        return this.pluginEntry;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tag = localName.trim();
        if (tag.equalsIgnoreCase(PLUGIN)) {
            this.pluginEntry.isFragment(false);
            this.processPlugin(attributes);
            return;
        }
        if (tag.equalsIgnoreCase(FRAGMENT)) {
            this.pluginEntry.isFragment(true);
            this.processPlugin(attributes);
            return;
        }
    }

    private void processPlugin(Attributes attributes) throws ParseCompleteException {
        this.id = attributes.getValue(ID);
        this.version = attributes.getValue(VERSION);
        throw new ParseCompleteException("");
    }

    private class ParseCompleteException
    extends SAXException {
        public ParseCompleteException(String arg0) {
            super(arg0);
        }
    }
}

