/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class ConfiguredSiteModel
extends ModelObject {
    private String[] previousPluginPath;
    private SiteModel site;
    private String platformURLString;
    private ConfigurationPolicyModel policy;
    private InstallConfigurationModel installConfiguration;
    private boolean installable = false;

    public SiteModel getSiteModel() {
        return this.site;
    }

    public void setSiteModel(SiteModel site) {
        this.assertIsWriteable();
        this.site = site;
    }

    public ConfigurationPolicyModel getConfigurationPolicyModel() {
        return this.policy;
    }

    public void setConfigurationPolicyModel(ConfigurationPolicyModel policy) {
        this.assertIsWriteable();
        this.policy = policy;
        policy.setConfiguredSiteModel(this);
    }

    public boolean isUpdatable() {
        return this.installable;
    }

    public void setUpdatable(boolean installable) {
        this.assertIsWriteable();
        this.installable = installable;
    }

    public InstallConfigurationModel getInstallConfigurationModel() {
        return this.installConfiguration;
    }

    public void setInstallConfigurationModel(InstallConfigurationModel installConfiguration) {
        this.assertIsWriteable();
        this.installConfiguration = installConfiguration;
    }

    public String getPlatformURLString() {
        return this.platformURLString;
    }

    public void setPlatformURLString(String platformURLString) {
        this.platformURLString = platformURLString;
    }

    public String[] getPreviousPluginPath() {
        if (this.previousPluginPath == null) {
            this.previousPluginPath = new String[0];
        }
        return this.previousPluginPath;
    }

    public void setPreviousPluginPath(String[] previousPluginPath) {
        this.previousPluginPath = new String[previousPluginPath.length];
        System.arraycopy(previousPluginPath, 0, this.previousPluginPath, 0, previousPluginPath.length);
    }

    protected IStatus createStatus(int statusType, String msg, Exception e) {
        if (statusType != 0) {
            statusType = 4;
        }
        return this.createStatus(statusType, 0, msg.toString(), e);
    }

    protected IStatus createStatus(int statusSeverity, int statusCode, String msg, Exception e) {
        String id = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        StringBuffer completeString = new StringBuffer("");
        if (msg != null) {
            completeString.append(msg);
        }
        if (e != null) {
            completeString.append("\r\n[");
            completeString.append(e.toString());
            completeString.append("]\r\n");
        }
        return new Status(statusSeverity, id, statusCode, completeString.toString(), (Throwable)e);
    }

    public boolean isEnabled() {
        return this.getConfigurationPolicyModel().isEnabled();
    }

    public void setEnabled(boolean value) {
        this.getConfigurationPolicyModel().setEnabled(value);
    }
}

