/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class ConfigurationPolicyModel
extends ModelObject {
    private int policy;
    private Map configuredFeatureReferences = new HashMap();
    private Map unconfiguredFeatureReferences = new HashMap();
    private ConfiguredSiteModel configuredSiteModel;
    private boolean enable = true;

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.assertIsWriteable();
        this.policy = policy;
    }

    public FeatureReferenceModel[] getConfiguredFeaturesModel() {
        if (this.configuredFeatureReferences == null || this.configuredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.configuredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.configuredFeatureReferences.keySet()));
    }

    public FeatureReferenceModel[] getUnconfiguredFeaturesModel() {
        if (this.unconfiguredFeatureReferences == null || this.unconfiguredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.unconfiguredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.unconfiguredFeatureReferences.keySet()));
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    private boolean remove(FeatureReferenceModel feature, Map list) {
        URL featureURL = feature.getURL();
        boolean found = false;
        Iterator iter = list.keySet().iterator();
        while (iter.hasNext() && !found) {
            FeatureReferenceModel element = (FeatureReferenceModel)((Object)iter.next());
            if (!UpdateManagerUtils.sameURL(element.getURL(), featureURL)) continue;
            list.remove((Object)element);
            found = true;
        }
        return found;
    }

    private void add(FeatureReferenceModel feature, Map list) {
        URL featureURL = feature.getURL();
        boolean found = false;
        Iterator iter = list.keySet().iterator();
        while (iter.hasNext() && !found) {
            FeatureReferenceModel element = (FeatureReferenceModel)((Object)iter.next());
            if (!UpdateManagerUtils.sameURL(element.getURL(), featureURL)) continue;
            found = true;
        }
        if (!found) {
            list.put(feature, null);
        } else {
            UpdateCore.warn("Feature Reference :" + (Object)((Object)feature) + " already part of the list.");
        }
    }

    public void addConfiguredFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.configuredFeatureReferences == null) {
            this.configuredFeatureReferences = new HashMap();
        }
        if (!this.configuredFeatureReferences.containsKey((Object)feature)) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Configuring " + feature.getURLString());
            }
            this.add(feature, this.configuredFeatureReferences);
        }
        if (this.unconfiguredFeatureReferences != null && !(success = this.remove(feature, this.unconfiguredFeatureReferences))) {
            UpdateCore.warn("Feature not part of Unconfigured list: " + feature.getURLString());
        }
    }

    public void addUnconfiguredFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences == null) {
            this.unconfiguredFeatureReferences = new HashMap();
        }
        if (!this.unconfiguredFeatureReferences.containsKey((Object)feature)) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Unconfiguring " + feature.getURLString());
            }
            this.add(feature, this.unconfiguredFeatureReferences);
        }
        if (this.configuredFeatureReferences != null && !(success = this.remove(feature, this.configuredFeatureReferences))) {
            UpdateCore.warn("Feature not part of Configured list: " + feature.getURLString());
        }
    }

    public void removeFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences != null && !(success = this.remove(feature, this.unconfiguredFeatureReferences))) {
            UpdateCore.warn(String.valueOf(feature.getURLString()) + " not part of unconfigured list.");
        }
        if (this.configuredFeatureReferences != null && !(success = this.remove(feature, this.configuredFeatureReferences))) {
            UpdateCore.warn(String.valueOf(feature.getURLString()) + " not part of configured list.");
        }
    }

    protected void setUnconfiguredFeatureReferences(IFeatureReference[] featureReferences) {
        this.unconfiguredFeatureReferences = new HashMap();
        int i = 0;
        while (i < featureReferences.length) {
            this.unconfiguredFeatureReferences.put(featureReferences[i], null);
            ++i;
        }
    }

    protected void setConfiguredFeatureReferences(IFeatureReference[] featureReferences) {
        this.configuredFeatureReferences = new HashMap();
        int i = 0;
        while (i < featureReferences.length) {
            this.configuredFeatureReferences.put(featureReferences[i], null);
            ++i;
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean value) {
        this.enable = value;
    }
}

