/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.UpdateCore;

public class UpdateManagerReconciler
implements IPlatformRunnable {
    private String originalApplication = "org.eclipse.update.UNKNOWN";
    private boolean initialize = false;
    private boolean firstUse = false;
    private boolean optimistic = false;
    private boolean dumpfile = false;
    private boolean DEBUG = false;
    private String dumpFilename = "";
    private static final String RECONCILER_APP = "org.eclipse.update.core.reconciler";
    private static final String APPLICATION = "-application";
    private static final String INITIALIZE = "-initialize";
    private static final String DUMPFILE = "-dumpfile";
    private static final String FIRSTUSE = "-firstuse";
    private static final String NEWUPDATES = "-newUpdates";
    private static final String CHANGES_MARKER = ".newupdates";

    public Object run(Object args) throws Exception {
        this.DEBUG = UpdateCore.DEBUG_SHOW_RECONCILER;
        this.processCommandLine((String[])args);
        IPlatformConfiguration cfg = BootLoader.getCurrentPlatformConfiguration();
        long start = 0L;
        if (this.DEBUG) {
            start = new Date().getTime();
            this.debug("begin");
        }
        this.optimistic = this.initialize || this.firstUse;
        boolean changes = this.reconcile(cfg);
        if (this.DEBUG) {
            long delta = new Date().getTime() - start;
            this.debug("end [" + delta + "ms]");
        }
        if (this.dumpfile) {
            this.dumpFeatures();
        }
        if (this.initialize) {
            Platform.endSplash();
            return IPlatformRunnable.EXIT_OK;
        }
        if (RECONCILER_APP.equals(this.originalApplication)) {
            Platform.endSplash();
            if (changes) {
                this.markChanges(cfg);
            }
            return IPlatformRunnable.EXIT_OK;
        }
        if (this.dumpfile) {
            Platform.endSplash();
            if (changes) {
                this.markChanges(cfg);
            }
            return IPlatformRunnable.EXIT_OK;
        }
        Platform.endSplash();
        if (changes) {
            this.markChanges(cfg);
        }
        if (this.DEBUG) {
            this.debug("restarting ..." + new Date());
        }
        return IPlatformRunnable.EXIT_RESTART;
    }

    private void dumpFeatures() {
        block23: {
            if (this.dumpFilename == null) {
                return;
            }
            ArrayList<VersionedIdentifier> features = new ArrayList<VersionedIdentifier>();
            IConfiguredSite[] configuredSites = new IConfiguredSite[]{};
            try {
                configuredSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
            }
            catch (Exception exception) {}
            int i = 0;
            while (i < configuredSites.length) {
                ISiteFeatureReference[] ref = configuredSites[i].getSite().getFeatureReferences();
                try {
                    int j = 0;
                    while (j < ref.length) {
                        features.add(ref[j].getVersionedIdentifier());
                        ++j;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            File dumpFile = new File(this.dumpFilename);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(dumpFile);
                    Iterator iter = features.iterator();
                    while (iter.hasNext()) {
                        VersionedIdentifier element = (VersionedIdentifier)iter.next();
                        try {
                            String feature = String.valueOf(element.getIdentifier()) + "," + element.getVersion() + '\n';
                            out.write(feature.getBytes());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    Object var8_10 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception2) {}
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            Object var8_12 = null;
            if (out == null) break block23;
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean reconcile(IPlatformConfiguration cfg) {
        boolean changes = true;
        try {
            if (this.DEBUG) {
                this.debug("mode: " + (this.optimistic ? "optimistic" : "pessimistic"));
            }
            changes = InternalSiteManager.reconcile(this.optimistic);
            if (this.DEBUG) {
                this.debug(changes ? "changes detected" : "no changes detected");
            }
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
        }
        catch (Exception e) {
            UpdateCore.warn(null, e);
        }
        cfg.refresh();
        return changes;
    }

    private boolean pluginPathChanged(IPlatformConfiguration cfg, URL[] originalPluginPath) {
        String key;
        URL[] currentPluginPath = cfg.getPluginPath();
        HashMap originalMap = new HashMap();
        HashMap currentMap = new HashMap();
        int i = 0;
        while (i < originalPluginPath.length) {
            originalMap.put(originalPluginPath[i].toExternalForm(), null);
            ++i;
        }
        i = 0;
        while (i < currentPluginPath.length) {
            currentMap.put(currentPluginPath[i].toExternalForm(), null);
            ++i;
        }
        i = 0;
        while (i < originalPluginPath.length) {
            key = originalPluginPath[i].toExternalForm();
            if (!currentMap.containsKey(key)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < currentPluginPath.length) {
            key = currentPluginPath[i].toExternalForm();
            if (!originalMap.containsKey(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void markChanges(IPlatformConfiguration cfg) {
        block4: {
            FileOutputStream fos = null;
            try {
                URL markerLocation = new URL(cfg.getConfigurationLocation(), CHANGES_MARKER);
                fos = new FileOutputStream(new File(markerLocation.getFile()));
                fos.write(0);
                fos.close();
            }
            catch (IOException iOException) {
                if (fos == null) break block4;
                try {
                    fos.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    private String[] markChanges(String[] args) {
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = NEWUPDATES;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return newArgs;
    }

    private String[] processCommandLine(String[] args) {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(INITIALIZE)) {
                this.initialize = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(FIRSTUSE)) {
                this.firstUse = true;
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(APPLICATION)) {
                    found = true;
                    this.originalApplication = arg;
                }
                if (args[i - 1].equalsIgnoreCase(DUMPFILE)) {
                    found = true;
                    this.dumpfile = true;
                    this.dumpFilename = arg;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private IPlatformRunnable getRunnable(String application) {
        return InternalPlatform.loaderGetRunnable((String)application);
    }

    private void debug(String s) {
        UpdateCore.debug(String.valueOf(this.getClass().getName()) + ": " + s);
    }
}

