/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteStatusAnalyzer {
    private static List allRunningPlugins;
    private static List allConfiguredFeatures;
    private SiteLocal siteLocal;

    public SiteStatusAnalyzer(SiteLocal siteLocal) {
        this.siteLocal = siteLocal;
    }

    private IStatus getStatus(IFeature feature) {
        IStatus status;
        ISite featureSite = feature.getSite();
        if (featureSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Cannot determine status of feature:" + feature.getLabel() + ". Site is NULL.");
            }
            String msg = Policy.bind("SiteLocal.UnableToDetermineFeatureStatusSiteNull", new Object[]{feature.getURL()});
            return this.createStatus(4, 1, msg, null);
        }
        ConfiguredSite cSite = (ConfiguredSite)featureSite.getCurrentConfiguredSite();
        if (cSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("Cannot determine status of feature: " + feature.getLabel() + ". Configured Site is NULL.");
            }
            String msg = Policy.bind("SiteLocal.UnableToDetermineFeatureStatusConfiguredSiteNull", new Object[]{feature.getURL()});
            return this.createStatus(4, 1, msg, null);
        }
        ISiteFeatureReference ref = cSite.getSite().getFeatureReference(feature);
        if (ref != null) {
            if (!cSite.getConfigurationPolicy().isConfigured(ref)) {
                return this.createStatus(0, -1, "", null);
            }
        } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("Unable to find reference for feature " + feature + " in site " + cSite.getSite().getURL());
        }
        if ((status = cSite.getBrokenStatus(feature)).getSeverity() != 0) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Feature broken:" + feature.getLabel() + ".Site:" + cSite.toString());
            }
            return status;
        }
        IPluginEntry[] featuresEntries = feature.getPluginEntries();
        return this.status(featuresEntries);
    }

    public IStatus getFeatureStatus(IFeature feature) throws CoreException {
        IFeature childFeature = null;
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        String msg = Policy.bind("SiteLocal.FeatureDisable");
        int code = -1;
        IStatus featureStatus = this.getStatus(feature);
        MultiStatus multiTemp = new MultiStatus(featureStatus.getPlugin(), code, msg, null);
        if (featureStatus.getSeverity() == 4) {
            if (featureStatus.isMultiStatus()) {
                multiTemp.addAll(featureStatus);
            } else {
                multiTemp.add(featureStatus);
            }
        }
        if (featureStatus.getCode() > code) {
            code = featureStatus.getCode();
        }
        if (code != -1) {
            int i = 0;
            while (i < children.length) {
                if (!UpdateManagerUtils.isOptional(children[i])) {
                    block22: {
                        try {
                            childFeature = children[i].getFeature(null);
                        }
                        catch (CoreException coreException) {
                            if (UpdateManagerUtils.isOptional(children[i])) break block22;
                            UpdateCore.warn("Error retrieving feature:" + children[i]);
                        }
                    }
                    if (childFeature == null) {
                        UpdateCore.warn("getFeatureStatus: Feature is null for:" + children[i]);
                        Object featureAsPrintableObject = children[i].getURL();
                        featureAsPrintableObject = children[i].getVersionedIdentifier();
                        String msg1 = Policy.bind("SiteLocal.NestedFeatureUnavailable", new Object[]{featureAsPrintableObject});
                        multiTemp.add(this.createStatus(4, 2, msg1, null));
                        if (2 > code) {
                            code = 2;
                        }
                    } else {
                        String msg1;
                        String featureVer;
                        VersionedIdentifier versionID;
                        IStatus childStatus = this.getFeatureStatus(childFeature);
                        if (childStatus.getCode() == -1) {
                            versionID = childFeature.getVersionedIdentifier();
                            featureVer = versionID == null ? "" : versionID.getVersion().toString();
                            msg1 = Policy.bind("SiteLocal.NestedFeatureDisable", childFeature.getLabel(), featureVer);
                            multiTemp.add(this.createStatus(4, childStatus.getCode(), msg1, null));
                            if (2 > code) {
                                code = 2;
                            }
                        }
                        if (childStatus.getSeverity() != 0) {
                            versionID = childFeature.getVersionedIdentifier();
                            featureVer = versionID == null ? "" : versionID.getVersion().toString();
                            msg1 = Policy.bind("SiteLocal.NestedFeatureUnHappy", childFeature.getLabel(), featureVer);
                            multiTemp.add(this.createStatus(4, childStatus.getCode(), msg1, null));
                            if (childStatus.getCode() > code) {
                                code = childStatus.getCode();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        switch (code) {
            case 0: {
                msg = Policy.bind("SiteLocal.FeatureHappy");
                break;
            }
            case 2: {
                msg = Policy.bind("SiteLocal.FeatureUnHappy");
                break;
            }
            case 1: {
                msg = Policy.bind("SiteLocal.FeatureAmbiguous");
                break;
            }
            case -1: {
                msg = Policy.bind("SiteLocal.FeatureDisable");
                break;
            }
            default: {
                msg = Policy.bind("SiteLocal.FeatureStatusUnknown");
            }
        }
        MultiStatus multi = new MultiStatus(featureStatus.getPlugin(), code, msg, null);
        multi.addAll((IStatus)multiTemp);
        return multi;
    }

    private IStatus status(IPluginEntry[] featurePlugins) {
        String happyMSG = Policy.bind("SiteLocal.FeatureHappy");
        String ambiguousMSG = Policy.bind("SiteLocal.FeatureAmbiguous");
        IStatus featureStatus = this.createStatus(0, 0, "", null);
        MultiStatus multi = new MultiStatus(featureStatus.getPlugin(), 1, ambiguousMSG, null);
        PluginIdentifier[] ids = this.getAllRunningPlugins();
        int i = 0;
        while (i < featurePlugins.length) {
            MultiStatus tempmulti = new MultiStatus(featureStatus.getPlugin(), 1, ambiguousMSG, null);
            VersionedIdentifier featureID = featurePlugins[i].getVersionedIdentifier();
            boolean found = false;
            int k = 0;
            while (k < ids.length && !found) {
                VersionedIdentifier compareID = ids[k].getVersionedIdentifier();
                String pluginName = null;
                if (featureID.getIdentifier().equals(compareID.getIdentifier())) {
                    pluginName = ids[k].getLabel();
                    if (featureID.getVersion().isPerfect(compareID.getVersion())) {
                        found = true;
                    } else {
                        IFeature feature = this.getFeatureForId(compareID);
                        String msg = null;
                        if (feature == null) {
                            Object[] values = new Object[]{pluginName, featureID.getVersion(), compareID.getVersion()};
                            msg = Policy.bind("SiteLocal.TwoVersionSamePlugin1", values);
                        } else {
                            String label = feature.getLabel();
                            String version = feature.getVersionedIdentifier().getVersion().toString();
                            Object[] values = new Object[]{pluginName, featureID.getVersion(), compareID.getVersion(), label, version};
                            msg = Policy.bind("SiteLocal.TwoVersionSamePlugin2", values);
                        }
                        UpdateCore.warn("Found another version of the same plugin on the path:" + compareID.toString());
                        tempmulti.add(this.createStatus(4, 1, msg, null));
                    }
                }
                ++k;
            }
            if (!found) {
                if (tempmulti.getChildren().length > 0) {
                    multi.addAll((IStatus)tempmulti);
                } else {
                    if (multi.getCode() != 2) {
                        String unhappyMSG = Policy.bind("SiteLocal.FeatureUnHappy");
                        MultiStatus newMulti = new MultiStatus(featureStatus.getPlugin(), 2, unhappyMSG, null);
                        newMulti.addAll((IStatus)multi);
                        multi = newMulti;
                    }
                    String msg = Policy.bind("SiteLocal.NoPluginVersion", featureID.getIdentifier());
                    multi.add(this.createStatus(4, 2, msg, null));
                }
            }
            ++i;
        }
        if (!multi.isOK()) {
            return multi;
        }
        return this.createStatus(0, 0, happyMSG, null);
    }

    private IStatus createStatus(int statusSeverity, int statusCode, String msg, Exception e) {
        String id = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        StringBuffer completeString = new StringBuffer("");
        if (msg != null) {
            completeString.append(msg);
        }
        if (e != null) {
            completeString.append("\r\n[");
            completeString.append(e.toString());
            completeString.append("]\r\n");
        }
        return new Status(statusSeverity, id, statusCode, completeString.toString(), (Throwable)e);
    }

    private PluginIdentifier[] getAllRunningPlugins() {
        if (allRunningPlugins == null) {
            allRunningPlugins = new ArrayList();
            IPluginRegistry reg = Platform.getPluginRegistry();
            IPluginDescriptor[] desc = reg.getPluginDescriptors();
            int i = 0;
            while (i < desc.length) {
                PluginDescriptorModel descModel;
                PluginFragmentModel[] frags;
                String id = desc[i].getUniqueIdentifier();
                String ver = desc[i].getVersionIdentifier().toString();
                VersionedIdentifier versionID = new VersionedIdentifier(id, ver);
                PluginIdentifier pluginIdentifier = new PluginIdentifier(versionID, desc[i].getLabel(), false);
                allRunningPlugins.add(pluginIdentifier);
                if (desc[i] instanceof PluginDescriptorModel && (frags = (descModel = (PluginDescriptorModel)desc[i]).getFragments()) != null) {
                    int j = 0;
                    while (j < frags.length) {
                        String fragID = frags[j].getId();
                        String fragVER = frags[j].getVersion();
                        VersionedIdentifier fragVersionID = new VersionedIdentifier(fragID, fragVER);
                        pluginIdentifier = new PluginIdentifier(fragVersionID, frags[j].getName(), true);
                        allRunningPlugins.add(pluginIdentifier);
                        ++j;
                    }
                }
                ++i;
            }
        }
        PluginIdentifier[] ids = new PluginIdentifier[allRunningPlugins.size()];
        if (allRunningPlugins.size() > 0) {
            allRunningPlugins.toArray(ids);
        }
        return ids;
    }

    private IFeature[] getAllConfiguredFeatures() {
        if (allConfiguredFeatures == null) {
            allConfiguredFeatures = new ArrayList();
            IConfiguredSite[] allConfiguredSites = this.siteLocal.getCurrentConfiguration().getConfiguredSites();
            int i = 0;
            while (i < allConfiguredSites.length) {
                IFeatureReference[] refs = allConfiguredSites[i].getConfiguredFeatures();
                IFeature feature = null;
                int j = 0;
                while (j < refs.length) {
                    feature = null;
                    try {
                        feature = refs[j].getFeature(null);
                    }
                    catch (CoreException coreException) {}
                    if (feature != null) {
                        allConfiguredFeatures.add(feature);
                    }
                    ++j;
                }
                ++i;
            }
        }
        IFeature[] features = new IFeature[allConfiguredFeatures.size()];
        if (allConfiguredFeatures.size() > 0) {
            allConfiguredFeatures.toArray(features);
        }
        return features;
    }

    private IFeature getFeatureForId(VersionedIdentifier id) {
        if (id == null) {
            return null;
        }
        IFeature[] allFeatures = this.getAllConfiguredFeatures();
        IFeature currentFeature = null;
        IPluginEntry[] allPlugins = null;
        IPluginEntry currentPlugin = null;
        int i = 0;
        while (i < allFeatures.length) {
            currentFeature = allFeatures[i];
            allPlugins = currentFeature.getPluginEntries();
            int j = 0;
            while (j < allPlugins.length) {
                currentPlugin = allPlugins[j];
                if (id.equals(currentPlugin.getVersionedIdentifier())) {
                    return currentFeature;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public class PluginIdentifier {
        private VersionedIdentifier id;
        private String label;
        private boolean isFragment = false;

        public PluginIdentifier(VersionedIdentifier id, String label, boolean fragment) {
            this.id = id;
            this.label = label;
            this.isFragment = fragment;
        }

        public VersionedIdentifier getVersionedIdentifier() {
            return this.id;
        }

        public boolean isFragment() {
            return this.isFragment;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

