/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.IWritable;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;

public class SiteReconciler
extends ModelObject
implements IWritable {
    private SiteLocal siteLocal;
    private List newFoundFeatures;
    private Date date;
    private static final String DEFAULT_INSTALL_CHANGE_NAME = "delta.xml";
    private static final String UPDATE_STATE_SUFFIX = ".metadata";

    public SiteReconciler(SiteLocal siteLocal) {
        this.siteLocal = siteLocal;
    }

    public boolean reconcile(boolean isOptimistic) throws CoreException {
        IPlatformConfiguration platformConfig = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.ISiteEntry[] newSiteEntries = platformConfig.getConfiguredSites();
        IInstallConfiguration newInstallConfiguration = this.siteLocal.createNewInstallConfiguration();
        IInstallConfiguration oldInstallConfiguration = this.siteLocal.getCurrentConfiguration();
        IConfiguredSite[] oldConfiguredSites = new IConfiguredSite[]{};
        this.newFoundFeatures = new ArrayList();
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Old install configuration" + (oldInstallConfiguration == null ? "NULL" : oldInstallConfiguration.getLabel()));
        }
        if (oldInstallConfiguration != null) {
            oldConfiguredSites = oldInstallConfiguration.getConfiguredSites();
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                int i = 0;
                while (i < oldConfiguredSites.length) {
                    UpdateCore.debug("Old Site :" + oldConfiguredSites[i].getSite().getURL());
                    ++i;
                }
            }
        }
        if (!isOptimistic) {
            isOptimistic = this.platformBaseChanged(oldConfiguredSites);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Platform has changed? :" + isOptimistic);
            }
        }
        int siteIndex = 0;
        while (siteIndex < newSiteEntries.length) {
            IPlatformConfiguration.ISiteEntry currentSiteEntry = newSiteEntries[siteIndex];
            URL resolvedURL = this.resolveSiteEntry(currentSiteEntry);
            boolean found = false;
            IConfiguredSite currentConfigurationSite = null;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Checking if:" + resolvedURL + " is a new site or a site to reconcile.");
            }
            if (!isOptimistic) {
                int index = 0;
                while (index < oldConfiguredSites.length && !found) {
                    currentConfigurationSite = oldConfiguredSites[index];
                    URL currentConfigURL = currentConfigurationSite.getSite().getURL();
                    if (UpdateManagerUtils.sameURL(resolvedURL, currentConfigURL)) {
                        found = true;
                        ConfiguredSite reconciledConfiguredSite = this.reconcile(currentConfigurationSite, isOptimistic);
                        reconciledConfiguredSite.setPreviousPluginPath(currentSiteEntry.getSitePolicy().getList());
                        newInstallConfiguration.addConfiguredSite(reconciledConfiguredSite);
                    }
                    ++index;
                }
            }
            if (!found) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("Site not found in previous configurations.Create new Configured Site:" + resolvedURL);
                }
                ISite site = SiteManager.getSite(resolvedURL, null);
                IPlatformConfiguration.ISitePolicy sitePolicy = currentSiteEntry.getSitePolicy();
                ConfiguredSite configSite = (ConfiguredSite)new BaseSiteLocalFactory().createConfigurationSiteModel((SiteModel)((Object)site), sitePolicy.getType());
                configSite.setPlatformURLString(currentSiteEntry.getURL().toExternalForm());
                configSite.setPreviousPluginPath(currentSiteEntry.getSitePolicy().getList());
                configSite.setUpdatable(currentSiteEntry.isUpdateable());
                ISiteFeatureReference[] newFeaturesRef = site.getFeatureReferences();
                int i = 0;
                while (i < newFeaturesRef.length) {
                    if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                        String reconciliationType = isOptimistic ? "enable (optimistic)" : "disable (pessimistic)";
                        UpdateCore.debug("New Site Found:New Feature to create: " + newFeaturesRef[i].getURL() + " as " + reconciliationType);
                    }
                    if (isOptimistic) {
                        configSite.getConfigurationPolicy().configure(newFeaturesRef[i], true, false);
                    } else {
                        configSite.getConfigurationPolicy().unconfigure(newFeaturesRef[i], true, false);
                        this.newFoundFeatures.add(newFeaturesRef[i]);
                    }
                    ++i;
                }
                newInstallConfiguration.addConfiguredSite(configSite);
            }
            ++siteIndex;
        }
        this.checkConfiguredFeatures(newInstallConfiguration);
        BaseSiteLocalFactory siteLocalFactory = new BaseSiteLocalFactory();
        ConfigurationActivityModel activity = siteLocalFactory.createConfigurationActivityModel();
        activity.setAction(8);
        activity.setDate(new Date());
        activity.setLabel(this.siteLocal.getLocationURLString());
        ((InstallConfiguration)newInstallConfiguration).addActivityModel(activity);
        if (!isOptimistic && oldInstallConfiguration != null && newInstallConfiguration instanceof InstallConfiguration) {
            ((InstallConfiguration)newInstallConfiguration).setTimeline(oldInstallConfiguration.getTimeline());
        }
        this.siteLocal.addConfiguration(newInstallConfiguration);
        this.siteLocal.save();
        return this.saveNewFeatures(newInstallConfiguration);
    }

    private static URL getUpdateStateLocation(IPlatformConfiguration config) throws IOException {
        URL configLocation = Platform.resolve((URL)config.getConfigurationLocation());
        String temp = configLocation.toExternalForm();
        temp = String.valueOf(temp) + ".metadata/";
        URL updateLocation = new URL(temp);
        return updateLocation;
    }

    URL resolveSiteEntry(IPlatformConfiguration.ISiteEntry newSiteEntry) throws CoreException {
        URL resolvedURL = null;
        try {
            resolvedURL = Platform.resolve((URL)newSiteEntry.getURL());
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("SiteLocal.UnableToResolve", newSiteEntry.getURL().toExternalForm()), e);
        }
        return resolvedURL;
    }

    private ConfiguredSite reconcile(IConfiguredSite oldConfiguredSite, boolean isOptimistic) throws CoreException {
        int i;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Configured Site to reconfigure:" + oldConfiguredSite.getSite().getURL() + (isOptimistic ? " OPTIMISTIC" : " PESSIMISTIC"));
        }
        ConfiguredSite newConfiguredSite = this.createNewConfigSite(oldConfiguredSite);
        ConfigurationPolicy newSitePolicy = newConfiguredSite.getConfigurationPolicy();
        ConfigurationPolicy oldSitePolicy = ((ConfiguredSite)oldConfiguredSite).getConfigurationPolicy();
        ArrayList<IFeatureReference> toCheck = new ArrayList<IFeatureReference>();
        ISite site = oldConfiguredSite.getSite();
        ISiteFeatureReference[] foundFeatures = site.getFeatureReferences();
        IFeatureReference[] oldConfiguredFeaturesRef = oldConfiguredSite.getFeatureReferences();
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            i = 0;
            while (i < oldConfiguredFeaturesRef.length) {
                UpdateCore.debug("Old feature :" + oldConfiguredFeaturesRef[i].getURL());
                ++i;
            }
        }
        i = 0;
        while (i < foundFeatures.length) {
            boolean newFeatureFound = true;
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Is this feature new? :" + foundFeatures[i].getURL());
            }
            int j = 0;
            while (j < oldConfiguredFeaturesRef.length) {
                IFeatureReference oldFeatureRef = oldConfiguredFeaturesRef[j];
                if (oldFeatureRef != null && oldFeatureRef.equals(foundFeatures[i])) {
                    toCheck.add(oldFeatureRef);
                    newFeatureFound = false;
                }
                ++j;
            }
            if (newFeatureFound) {
                this.configureNewFoundFeature(isOptimistic, newSitePolicy, oldSitePolicy, foundFeatures[i], oldConfiguredFeaturesRef);
            }
            ++i;
        }
        Iterator featureIter = toCheck.iterator();
        while (featureIter.hasNext()) {
            IFeatureReference oldFeatureRef = (IFeatureReference)featureIter.next();
            if (oldSitePolicy.isConfigured(oldFeatureRef)) {
                newSitePolicy.configure(oldFeatureRef, false, false);
                continue;
            }
            newSitePolicy.unconfigure(oldFeatureRef, false, false);
        }
        return newConfiguredSite;
    }

    private void configureNewFoundFeature(boolean isOptimistic, ConfigurationPolicy newSitePolicy, ConfigurationPolicy oldSitePolicy, IFeatureReference foundFeature, IFeatureReference[] possibleParents) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            String reconciliationType = isOptimistic ? "enable (optimistic)" : "disable (pessimistic)";
            UpdateCore.debug("This feature is new: " + foundFeature.getURL() + " reconciled as " + reconciliationType);
        }
        if (isOptimistic) {
            newSitePolicy.configure(foundFeature, true, false);
            return;
        }
        IFeatureReference[] allOptionalParents = UpdateManagerUtils.getParentFeatures(foundFeature, possibleParents, true);
        IFeatureReference[] allParents = UpdateManagerUtils.getParentFeatures(foundFeature, possibleParents, false);
        if (allOptionalParents.length == 0) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("There are no features who consider the feature as optional. Treat as root feature.");
            }
            newSitePolicy.unconfigure(foundFeature, true, false);
            this.newFoundFeatures.add(foundFeature);
            return;
        }
        if (allParents.length > allOptionalParents.length) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("At least one parent considers the feature as NON optional. Treat as root feature.");
            }
            newSitePolicy.unconfigure(foundFeature, true, false);
            this.newFoundFeatures.add(foundFeature);
            return;
        }
        int i = 0;
        while (i < allOptionalParents.length) {
            if (oldSitePolicy.isConfigured(allOptionalParents[i])) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("Found parent feature:" + allOptionalParents[i] + " as enable: Enable optional child feature:" + foundFeature);
                }
                newSitePolicy.configure(foundFeature, true, false);
                return;
            }
            ++i;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("No parents are enable. Disable feature.");
        }
        newSitePolicy.unconfigure(foundFeature, true, false);
    }

    private void checkConfiguredFeatures(IInstallConfiguration newDefaultConfiguration) throws CoreException {
        IConfiguredSite[] configuredSites = newDefaultConfiguration.getConfiguredSites();
        int indexConfiguredSites = 0;
        while (indexConfiguredSites < configuredSites.length) {
            SiteReconciler.checkConfiguredFeatures(configuredSites[indexConfiguredSites]);
            ++indexConfiguredSites;
        }
    }

    public static void checkConfiguredFeaturesOld(IConfiguredSite configuredSite) throws CoreException {
        ConfiguredSite cSite = (ConfiguredSite)configuredSite;
        IFeatureReference[] configuredFeatures = cSite.getConfiguredFeatures();
        ConfigurationPolicy cPolicy = cSite.getConfigurationPolicy();
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare features within :" + configuredSite.getSite().getURL());
        }
        int indexConfiguredFeatures = 0;
        while (indexConfiguredFeatures < configuredFeatures.length - 1) {
            IFeatureReference featureToCompare = configuredFeatures[indexConfiguredFeatures];
            int restOfConfiguredFeatures = indexConfiguredFeatures + 1;
            while (restOfConfiguredFeatures < configuredFeatures.length) {
                int result = SiteReconciler.compare(featureToCompare, configuredFeatures[restOfConfiguredFeatures]);
                if (result != 0) {
                    if (result == 1) {
                        cPolicy.unconfigure(configuredFeatures[restOfConfiguredFeatures], true, false);
                    }
                    if (result == 2) {
                        cPolicy.unconfigure(featureToCompare, true, false);
                    }
                }
                ++restOfConfiguredFeatures;
            }
            ++indexConfiguredFeatures;
        }
    }

    private static int compare(IFeatureReference featureRef1, IFeatureReference featureRef2) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare: " + featureRef1 + " && " + featureRef2);
        }
        if (featureRef1 == null) {
            return 0;
        }
        IFeature feature1 = null;
        IFeature feature2 = null;
        try {
            feature1 = featureRef1.getFeature(null);
            feature2 = featureRef2.getFeature(null);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return 0;
        }
        if (feature1 == null || feature2 == null) {
            return 0;
        }
        VersionedIdentifier id1 = feature1.getVersionedIdentifier();
        VersionedIdentifier id2 = feature2.getVersionedIdentifier();
        if (id1 == null || id2 == null) {
            return 0;
        }
        if (id1.getIdentifier() != null && id1.getIdentifier().equals(id2.getIdentifier())) {
            PluginVersionIdentifier version1 = id1.getVersion();
            PluginVersionIdentifier version2 = id2.getVersion();
            if (version1 != null) {
                if (version1.isGreaterThan(version2)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        return 0;
    }

    private ConfiguredSite createNewConfigSite(IConfiguredSite oldConfiguredSiteToReconcile) throws CoreException {
        ConfiguredSite cSiteToReconcile = (ConfiguredSite)oldConfiguredSiteToReconcile;
        SiteModel siteModel = cSiteToReconcile.getSiteModel();
        int policy = cSiteToReconcile.getConfigurationPolicy().getPolicy();
        ConfiguredSite newConfigurationSite = (ConfiguredSite)new BaseSiteLocalFactory().createConfigurationSiteModel(siteModel, policy);
        newConfigurationSite.setUpdatable(cSiteToReconcile.isUpdatable());
        newConfigurationSite.setEnabled(cSiteToReconcile.isEnabled());
        newConfigurationSite.setPlatformURLString(cSiteToReconcile.getPlatformURLString());
        return newConfigurationSite;
    }

    private IFeatureReference[] getFeatureReferences() {
        if (this.newFoundFeatures == null || this.newFoundFeatures.size() == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])this.newFoundFeatures.toArray(this.arrayTypeFor(this.newFoundFeatures));
    }

    private boolean saveNewFeatures(IInstallConfiguration installConfig) throws CoreException {
        if (this.getFeatureReferences().length == 0) {
            UpdateCore.warn("No new features found");
            return false;
        }
        IFeatureReference[] refs = this.getFeatureReferences();
        this.newFoundFeatures = new ArrayList();
        int i = 0;
        while (i < refs.length) {
            IFeatureReference[] parents = UpdateManagerUtils.getParentFeatures(refs[i], refs, false);
            if (parents.length == 0) {
                this.newFoundFeatures.add(refs[i]);
            }
            ++i;
        }
        if (this.getFeatureReferences().length == 0) {
            UpdateCore.warn("No root feature found when saving new features");
            return false;
        }
        this.removeInvalidEfixes(installConfig);
        if (this.getFeatureReferences().length == 0) {
            UpdateCore.warn("No new features found after removing invalid efixes");
            return false;
        }
        this.date = new Date();
        String fileName = UpdateManagerUtils.getLocalRandomIdentifier(DEFAULT_INSTALL_CHANGE_NAME, this.date);
        IPath path = UpdateCore.getPlugin().getStateLocation();
        IPath filePath = path.append(fileName);
        File file = filePath.toFile();
        try {
            UpdateManagerUtils.Writer writer = UpdateManagerUtils.getWriter(file, "UTF-8");
            writer.write(this);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw Utilities.newCoreException(Policy.bind("SiteReconciler.UnableToEncodeConfiguration", file.getAbsolutePath()), e);
        }
        catch (FileNotFoundException e) {
            throw Utilities.newCoreException(Policy.bind("SiteReconciler.UnableToSaveStateIn", file.getAbsolutePath()), e);
        }
    }

    public void write(int indent, PrintWriter w) {
        String gap = "";
        int i = 0;
        while (i < indent) {
            gap = String.valueOf(gap) + " ";
            ++i;
        }
        String increment = "";
        int i2 = 0;
        while (i2 < 3) {
            increment = String.valueOf(increment) + " ";
            ++i2;
        }
        w.print(String.valueOf(gap) + "<" + "change" + " ");
        long time = this.date != null ? this.date.getTime() : 0L;
        w.println("date=\"" + time + "\" >");
        w.println(String.valueOf(gap) + increment + "<" + "newFeatures" + " >");
        IFeatureReference[] references = this.getFeatureReferences();
        String URLFeatureString = null;
        if (references != null) {
            int index = 0;
            while (index < references.length) {
                IFeatureReference ref = references[index];
                if (ref.getURL() != null) {
                    ISite featureSite = ref.getSite();
                    URLFeatureString = UpdateManagerUtils.getURLAsString(featureSite.getURL(), ref.getURL());
                    w.print(String.valueOf(gap) + increment + increment + "<" + "reference" + " ");
                    w.println("siteURL = \"" + UpdateManagerUtils.Writer.xmlSafe(this.getURLSiteString(featureSite)) + "\" ");
                    w.println(String.valueOf(gap) + increment + increment + increment + "featureURL=\"" + UpdateManagerUtils.Writer.xmlSafe(URLFeatureString) + "\" />");
                }
                w.println("");
                ++index;
            }
        }
        w.println(String.valueOf(gap) + increment + "</" + "newFeatures" + " >");
        w.println(String.valueOf(gap) + "</" + "change" + ">");
    }

    private String getURLSiteString(ISite site) {
        ConfiguredSite cSite = (ConfiguredSite)site.getCurrentConfiguredSite();
        if (cSite != null) {
            return cSite.getPlatformURLString();
        }
        return site.getURL().toExternalForm();
    }

    private boolean platformBaseChanged(IConfiguredSite[] oldConfiguredSites) {
        if (oldConfiguredSites == null) {
            UpdateCore.warn("No previous configured sites. Optimistic reconciliation.");
            return true;
        }
        String platformString = "platform:/base/";
        URL platformURL = null;
        try {
            platformURL = new URL(platformString);
        }
        catch (MalformedURLException e) {
            UpdateCore.warn("Unable to resolve platform:/base/. Check you are running a Platform", e);
            return true;
        }
        URL resolvedCurrentBaseURL = null;
        try {
            resolvedCurrentBaseURL = Platform.resolve((URL)platformURL);
        }
        catch (IOException e) {
            UpdateCore.warn("Error while resolving platform:/base/. Check you are running a Platform", e);
            return true;
        }
        int index = 0;
        boolean found = false;
        ConfiguredSite cSite = null;
        while (!found && index < oldConfiguredSites.length) {
            if (oldConfiguredSites[index] instanceof ConfiguredSite && platformString.equalsIgnoreCase((cSite = (ConfiguredSite)oldConfiguredSites[index]).getPlatformURLString())) {
                found = true;
            }
            ++index;
        }
        if (!found) {
            UpdateCore.warn("Unable to find an old configured site with platform:/base/ as a platform URL");
            return true;
        }
        if (cSite == null) {
            UpdateCore.warn("The configuredSite that contains the platform is null");
            return true;
        }
        if (UpdateManagerUtils.sameURL(resolvedCurrentBaseURL, cSite.getSite().getURL())) {
            UpdateCore.warn("Platform URL found are the same:" + resolvedCurrentBaseURL + " : " + cSite.getSite().getURL());
            return false;
        }
        UpdateCore.warn("Platform URL found is different than the one previously saved. Reconcile optimistically:" + resolvedCurrentBaseURL + " : " + cSite.getSite().getURL());
        return true;
    }

    public static void checkConfiguredFeatures(IConfiguredSite configuredSite) {
        Map patches;
        ConfiguredSite cSite = (ConfiguredSite)configuredSite;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Validate configuration of site " + cSite.getSite().getURL());
        }
        IFeatureReference[] configuredRefs = cSite.getConfiguredFeatures();
        ArrayList<IFeature> allPossibleConfiguredFeatures = new ArrayList<IFeature>();
        int i = 0;
        while (i < configuredRefs.length) {
            try {
                IFeature feature = configuredRefs[i].getFeature(null);
                allPossibleConfiguredFeatures.add(feature);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("   configured feature " + feature.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            ++i;
        }
        ArrayList topFeatures = SiteReconciler.computeTopFeatures(allPossibleConfiguredFeatures, configuredSite);
        ArrayList topNonEfixFeatures = SiteReconciler.getNonEfixFeatures(topFeatures);
        ArrayList configuredFeatures = SiteReconciler.expandFeatures(topNonEfixFeatures, configuredSite);
        if (topFeatures.size() != topNonEfixFeatures.size() && !(patches = SiteReconciler.getPatchesAsFeature(allPossibleConfiguredFeatures)).isEmpty()) {
            List efixesToEnable = SiteReconciler.getPatchesToEnable(patches, configuredFeatures);
            Iterator iter = efixesToEnable.iterator();
            while (iter.hasNext()) {
                IFeature element = (IFeature)iter.next();
                ArrayList expandedEfix = new ArrayList();
                SiteReconciler.expandEfixFeature(element, expandedEfix, configuredSite);
                configuredFeatures.addAll(expandedEfix);
            }
        }
        ArrayList extras = SiteReconciler.diff(allPossibleConfiguredFeatures, configuredFeatures);
        ConfigurationPolicy cPolicy = cSite.getConfigurationPolicy();
        int i2 = 0;
        while (i2 < extras.size()) {
            IFeature feature = (IFeature)extras.get(i2);
            ISiteFeatureReference ref = cSite.getSite().getFeatureReference(feature);
            try {
                cPolicy.unconfigure(ref, true, false);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                    UpdateCore.debug("Unconfiguring \"extra\" feature " + feature.getVersionedIdentifier().toString());
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            ++i2;
        }
    }

    private static ArrayList computeTopFeatures(ArrayList features, IConfiguredSite configuredSite) {
        ArrayList result = new ArrayList();
        result.addAll(features);
        IFeature[] list = result.toArray(new IFeature[0]);
        int i = 0;
        while (i < list.length) {
            IIncludedFeatureReference[] children = null;
            try {
                children = list[i].getIncludedFeatureReferences();
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    SiteReconciler.removeMatchingFeatures(children[j], result);
                    ++j;
                }
            }
            ++i;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Computed top-level features");
            i = 0;
            while (i < result.size()) {
                UpdateCore.debug("   " + ((IFeature)result.get(i)).getVersionedIdentifier().toString());
                ++i;
            }
        }
        list = result.toArray(new IFeature[0]);
        i = 0;
        while (i < list.length - 1) {
            IFeature left = list[i];
            VersionedIdentifier leftVid = left.getVersionedIdentifier();
            int j = i + 1;
            while (j < list.length) {
                IFeature right = list[j];
                VersionedIdentifier rightVid = right.getVersionedIdentifier();
                if (leftVid.getIdentifier().equals(rightVid.getIdentifier())) {
                    IFeature oldest = null;
                    oldest = rightVid.getVersion().isGreaterOrEqualTo(leftVid.getVersion()) ? left : right;
                    ((AbstractCollection)result).remove(oldest);
                    if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                        UpdateCore.debug("Removing \"duplicate\" " + oldest.getVersionedIdentifier().toString());
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static ArrayList expandFeatures(ArrayList features, IConfiguredSite configuredSite) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < features.size()) {
            SiteReconciler.expandFeature((IFeature)features.get(i), result, configuredSite);
            ++i;
        }
        return result;
    }

    private static void expandFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        int j = 0;
        while (j < children.length) {
            IFeature child;
            block8: {
                child = null;
                try {
                    child = children[j].getFeature(false, configuredSite, null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(children[j])) break block8;
                    UpdateCore.warn("", e);
                }
            }
            if (child != null) {
                SiteReconciler.expandFeature(child, features, configuredSite);
            }
            ++j;
        }
    }

    private static ArrayList diff(ArrayList left, ArrayList right) {
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        int i = 0;
        while (i < left.size()) {
            IFeature feature = (IFeature)left.get(i);
            if (!right.contains(feature)) {
                result.add(feature);
            }
            ++i;
        }
        return result;
    }

    private static void removeMatchingFeatures(IIncludedFeatureReference featureReference, ArrayList possibleRootFeaturesArray) {
        if (possibleRootFeaturesArray == null || possibleRootFeaturesArray.isEmpty()) {
            return;
        }
        IFeature[] possibleRootFeatures = new IFeature[possibleRootFeaturesArray.size()];
        possibleRootFeaturesArray.toArray(possibleRootFeatures);
        int ref = 0;
        while (ref < possibleRootFeatures.length) {
            block5: {
                try {
                    VersionedIdentifier possibleRootFeatureRefID;
                    if (possibleRootFeatures[ref] != null && SiteReconciler.matches(featureReference, possibleRootFeatureRefID = possibleRootFeatures[ref].getVersionedIdentifier())) {
                        ((AbstractCollection)possibleRootFeaturesArray).remove(possibleRootFeatures[ref]);
                    }
                }
                catch (CoreException e) {
                    if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) break block5;
                    UpdateCore.warn("", e);
                }
            }
            ++ref;
        }
    }

    private static boolean matches(IIncludedFeatureReference featureReference, VersionedIdentifier id) throws CoreException {
        VersionedIdentifier baseIdentifier = featureReference.getVersionedIdentifier();
        if (baseIdentifier == null || id == null) {
            return false;
        }
        if (!id.getIdentifier().equals(baseIdentifier.getIdentifier())) {
            return false;
        }
        switch (featureReference.getMatch()) {
            case 1: {
                return id.getVersion().isPerfect(baseIdentifier.getVersion());
            }
            case 3: {
                return id.getVersion().isCompatibleWith(baseIdentifier.getVersion());
            }
            case 2: {
                return id.getVersion().isEquivalentTo(baseIdentifier.getVersion());
            }
            case 4: {
                return id.getVersion().isGreaterOrEqualTo(baseIdentifier.getVersion());
            }
        }
        UpdateCore.warn("Unknown matching rule:" + featureReference.getMatch());
        return false;
    }

    private static Map getPatchesAsFeature(ArrayList allConfiguredFeatures) {
        HashMap patches = new HashMap();
        if (allConfiguredFeatures != null) {
            Iterator iter = ((AbstractList)allConfiguredFeatures).iterator();
            while (iter.hasNext()) {
                ArrayList<VersionedIdentifier> patchedFeaturesID = new ArrayList<VersionedIdentifier>();
                IFeature element = (IFeature)iter.next();
                int i = 0;
                while (i < element.getImports().length) {
                    if (element.getImports()[i].isPatch()) {
                        VersionedIdentifier id = element.getImports()[i].getVersionedIdentifier();
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                            UpdateCore.debug("Found patch " + element + " for feature identifier " + id);
                        }
                        patchedFeaturesID.add(id);
                    }
                    ++i;
                }
                if (patchedFeaturesID.isEmpty()) continue;
                patches.put(element, patchedFeaturesID);
            }
        }
        return patches;
    }

    private static List getPatchesToEnable(Map efixes, ArrayList configuredFeatures) {
        ArrayList<VersionedIdentifier> enabledVersionedIdentifier = new ArrayList<VersionedIdentifier>();
        Iterator<Object> iter = ((AbstractList)configuredFeatures).iterator();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            enabledVersionedIdentifier.add(element.getVersionedIdentifier());
        }
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        iter = efixes.keySet().iterator();
        while (iter.hasNext()) {
            boolean toEnable = false;
            IFeature efixFeature = (IFeature)iter.next();
            List patchedFeatures = (List)efixes.get(efixFeature);
            Iterator patchedFeaturesIter = patchedFeatures.iterator();
            while (patchedFeaturesIter.hasNext() && !toEnable) {
                VersionedIdentifier patchedFeatureID = (VersionedIdentifier)patchedFeaturesIter.next();
                if (!enabledVersionedIdentifier.contains(patchedFeatureID)) continue;
                toEnable = true;
            }
            if (!toEnable) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("The Patch " + efixFeature + " does not patch any enabled features: it will be disabled");
                continue;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("The patch " + efixFeature + " will be enabled.");
            }
            result.add(efixFeature);
        }
        return result;
    }

    private static ArrayList getNonEfixFeatures(ArrayList topFeatures) {
        Map efixFeatures = SiteReconciler.getPatchesAsFeature(topFeatures);
        Set keySet = efixFeatures.keySet();
        if (keySet == null || keySet.isEmpty()) {
            return topFeatures;
        }
        Iterator iter = ((AbstractList)topFeatures).iterator();
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            if (keySet.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    private Map getPatchesAsFeatureReference(List listOfFeatureReferences) {
        HashMap patches = new HashMap();
        if (listOfFeatureReferences != null) {
            Iterator iter = listOfFeatureReferences.iterator();
            while (iter.hasNext()) {
                ArrayList<VersionedIdentifier> patchedFeaturesID = new ArrayList<VersionedIdentifier>();
                IFeatureReference element = (IFeatureReference)iter.next();
                try {
                    IFeature feature = element.getFeature(null);
                    if (feature != null) {
                        IImport[] imports = feature.getImports();
                        int i = 0;
                        while (i < imports.length) {
                            if (imports[i].isPatch()) {
                                VersionedIdentifier id = imports[i].getVersionedIdentifier();
                                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                                    UpdateCore.debug("Found patch " + element + " for feature identifier " + id);
                                }
                                patchedFeaturesID.add(id);
                            }
                            ++i;
                        }
                    }
                    if (patchedFeaturesID.isEmpty()) continue;
                    patches.put(element, patchedFeaturesID);
                }
                catch (CoreException coreException) {}
            }
        }
        return patches;
    }

    private void removeInvalidEfixes(IInstallConfiguration installConfig) {
        Map newFoundEfixesAsReference = this.getPatchesAsFeatureReference(this.newFoundFeatures);
        if (newFoundEfixesAsReference.size() > 0) {
            ArrayList<IFeature> allEnabledFeatures = new ArrayList<IFeature>();
            IConfiguredSite[] configSites = installConfig.getConfiguredSites();
            int i = 0;
            while (i < configSites.length) {
                IFeatureReference[] references = configSites[i].getConfiguredFeatures();
                int j = 0;
                while (j < references.length) {
                    try {
                        allEnabledFeatures.add(references[j].getFeature(null));
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i;
            }
            ArrayList<IFeature> arrayOfNewFoundFeatures = new ArrayList<IFeature>();
            Iterator iter = this.newFoundFeatures.iterator();
            while (iter.hasNext()) {
                IFeatureReference element = (IFeatureReference)iter.next();
                try {
                    arrayOfNewFoundFeatures.add(element.getFeature(null));
                }
                catch (CoreException coreException) {}
            }
            List patchesForNewFoundFeatures = this.getFeatureReferencePatchesToEnable(newFoundEfixesAsReference, allEnabledFeatures);
            List patchesForEnabledFeatures = this.getFeatureReferencePatchesToEnable(newFoundEfixesAsReference, arrayOfNewFoundFeatures);
            this.newFoundFeatures.removeAll(newFoundEfixesAsReference.keySet());
            this.newFoundFeatures.addAll(0, patchesForEnabledFeatures);
            this.newFoundFeatures.addAll(0, patchesForNewFoundFeatures);
        }
    }

    private List getFeatureReferencePatchesToEnable(Map efixes, List configuredFeatures) {
        ArrayList<VersionedIdentifier> enabledVersionedIdentifier = new ArrayList<VersionedIdentifier>();
        Iterator<Object> iter = configuredFeatures.iterator();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            enabledVersionedIdentifier.add(element.getVersionedIdentifier());
        }
        ArrayList<IFeatureReference> result = new ArrayList<IFeatureReference>();
        iter = efixes.keySet().iterator();
        while (iter.hasNext()) {
            boolean toEnable = false;
            IFeatureReference efixFeatureReference = (IFeatureReference)iter.next();
            List patchedFeatures = (List)efixes.get(efixFeatureReference);
            Iterator patchedFeaturesIter = patchedFeatures.iterator();
            while (patchedFeaturesIter.hasNext() && !toEnable) {
                VersionedIdentifier patchedFeatureID = (VersionedIdentifier)patchedFeaturesIter.next();
                if (!enabledVersionedIdentifier.contains(patchedFeatureID)) continue;
                toEnable = true;
            }
            if (!toEnable) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("The Patch " + efixFeatureReference + " does not patch any enabled features: it will be disabled");
                continue;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("The patch " + efixFeatureReference + " will be enabled.");
            }
            result.add(efixFeatureReference);
        }
        return result;
    }

    private static void expandEfixFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        int j = 0;
        while (j < children.length) {
            IFeature child;
            block8: {
                child = null;
                try {
                    child = children[j].getFeature(false, configuredSite, null);
                }
                catch (CoreException e) {
                    if (children[j].isOptional()) break block8;
                    UpdateCore.warn("", e);
                }
            }
            if (child != null && !UpdateCore.isPatch(child)) {
                SiteReconciler.expandEfixFeature(child, features, configuredSite);
            }
            ++j;
        }
    }
}

