/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.FeaturePackagedContentProvider;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.DefaultPluginParser;
import org.xml.sax.SAXException;

public class SiteFileFactory
extends BaseSiteFactory {
    private SiteFile site;

    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        Site site = null;
        InputStream siteStream = null;
        SiteFileFactory factory = this;
        try {
            try {
                String path = url.getFile();
                File siteLocation = new File(path);
                if (siteLocation.isDirectory()) {
                    path = siteLocation.getAbsolutePath().replace(File.separatorChar, '/');
                    if (!path.endsWith("/")) {
                        path = String.valueOf(path) + "/";
                    }
                    url = new URL("file:" + path);
                    if (new File(siteLocation, "site.xml").exists()) {
                        siteStream = new FileInputStream(new File(siteLocation, "site.xml"));
                        site = (Site)factory.parseSite(siteStream);
                    } else {
                        site = this.parseSite(siteLocation);
                    }
                } else {
                    try {
                        URL resolvedURL = URLEncoder.encode(url);
                        siteStream = this.openStream(resolvedURL);
                        site = (Site)factory.parseSite(siteStream);
                    }
                    catch (IOException iOException) {
                        File file = new File(url.getFile());
                        File parentDirectory = file.getParentFile();
                        if (parentDirectory != null && !parentDirectory.exists()) {
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.DirectoryDoesNotExist", file.getAbsolutePath()), null);
                        }
                        if (parentDirectory == null || !parentDirectory.isDirectory()) {
                            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToObtainParentDirectory", file.getAbsolutePath()), null);
                        }
                        site = this.parseSite(parentDirectory);
                    }
                }
                SiteFileContentProvider contentProvider = new SiteFileContentProvider(url);
                site.setSiteContentProvider(contentProvider);
                contentProvider.setSite(site);
                site.resolve(url, url);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURL", url == null ? "" : url.toExternalForm()), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToAccessSite"), 42, e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (siteStream != null) {
                    siteStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var9_13 = null;
        try {
            if (siteStream != null) {
                siteStream.close();
            }
        }
        catch (IOException iOException) {}
        return site;
    }

    private Site parseSite(File directory) throws CoreException {
        this.site = (SiteFile)this.createSiteMapModel();
        if (!directory.exists()) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.FileDoesNotExist", directory.getAbsolutePath()), null);
        }
        File pluginPath = new File(directory, "plugins/");
        this.parsePackagedFeature(directory);
        this.parsePackagedPlugins(pluginPath);
        this.parseInstalledFeature(directory);
        this.parseInstalledPlugin(pluginPath);
        return this.site;
    }

    private void parseInstalledFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list();
                int index = 0;
                while (index < dir.length) {
                    newFilePath = String.valueOf(dir[index]) + (dir[index].endsWith("/") ? "/" : "");
                    File currentFeatureDir = new File(featureDir, newFilePath);
                    File featureXMLFile = new File(currentFeatureDir, "feature.xml");
                    if (!featureXMLFile.exists()) {
                        UpdateCore.warn("Unable to find feature.xml in directory:" + currentFeatureDir);
                    } else {
                        URL featureURL = currentFeatureDir.toURL();
                        SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                        featureRef.setSiteModel(this.site);
                        featureRef.setURLString(featureURL.toExternalForm());
                        featureRef.setType("org.eclipse.update.core.installed");
                        this.site.addFeatureReferenceModel(featureRef);
                    }
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", newFilePath), e);
            }
        }
    }

    private void parsePackagedFeature(File directory) throws CoreException {
        File featureDir = new File(directory, "features/");
        if (featureDir.exists()) {
            String newFilePath = null;
            try {
                String[] dir = featureDir.list(FeaturePackagedContentProvider.filter);
                int index = 0;
                while (index < dir.length) {
                    File currentFeatureFile = new File(featureDir, dir[index]);
                    JarContentReference ref = new JarContentReference("", currentFeatureFile);
                    ContentReference result = null;
                    try {
                        result = ref.peek("feature.xml", null, null);
                    }
                    catch (IOException e) {
                        UpdateCore.warn("Exception retrieving feature.xml in file:" + currentFeatureFile, e);
                    }
                    if (result == null) {
                        UpdateCore.warn("Unable to find feature.xml in file:" + currentFeatureFile);
                    } else {
                        URL featureURL = currentFeatureFile.toURL();
                        SiteFeatureReferenceModel featureRef = this.createFeatureReferenceModel();
                        featureRef.setSiteModel(this.site);
                        featureRef.setURLString(featureURL.toExternalForm());
                        featureRef.setType("org.eclipse.update.core.packaged");
                        this.site.addFeatureReferenceModel(featureRef);
                    }
                    ++index;
                }
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", newFilePath), e);
            }
        }
    }

    private void parseInstalledPlugin(File dir) throws CoreException {
        File pluginFile = null;
        try {
            if (dir.exists() && dir.isDirectory()) {
                File[] files = dir.listFiles();
                DefaultPluginParser parser = new DefaultPluginParser();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        pluginFile = new File(files[i], "plugin.xml");
                        if (!pluginFile.exists()) {
                            pluginFile = new File(files[i], "fragment.xml");
                        }
                        if (pluginFile != null && pluginFile.exists() && !pluginFile.isDirectory()) {
                            PluginEntry entry = parser.parse(new FileInputStream(pluginFile));
                            this.addParsedPlugin(entry, files[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            String pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorAccessing", pluginFileString), e);
        }
        catch (SAXException e) {
            String pluginFileString = pluginFile == null ? null : pluginFile.getAbsolutePath();
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorParsingFile", pluginFileString), e);
        }
    }

    private void addParsedPlugin(PluginEntry entry, File file) throws CoreException {
        String location = null;
        try {
            if (entry != null) {
                ((Site)this.site).addPluginEntry(entry);
                ArchiveReferenceModel archive = this.createArchiveReferenceModel();
                String id = entry.getVersionedIdentifier().toString();
                String pluginID = "plugins/" + id + ".jar";
                archive.setPath(pluginID);
                location = file.toURL().toExternalForm();
                archive.setURLString(location);
                this.site.addArchiveReferenceModel(archive);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                    UpdateCore.debug("Added archive to site:" + pluginID + " pointing to: " + location);
                }
            }
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.UnableToCreateURLForFile", location), e);
        }
    }

    private void parsePackagedPlugins(File pluginDir) throws CoreException {
        File file = null;
        ContentReference ref = null;
        String refString = null;
        try {
            if (pluginDir.exists()) {
                String[] dir = pluginDir.list(FeaturePackagedContentProvider.filter);
                int i = 0;
                while (i < dir.length) {
                    file = new File(pluginDir, dir[i]);
                    JarContentReference jarReference = new JarContentReference(null, file);
                    ref = jarReference.peek("plugin.xml", null, null);
                    if (ref == null) {
                        jarReference.peek("fragment.xml", null, null);
                    }
                    String string = refString = ref == null ? null : ref.asURL().toExternalForm();
                    if (ref != null) {
                        PluginEntry entry = new DefaultPluginParser().parse(ref.getInputStream());
                        this.addParsedPlugin(entry, file);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorAccessing", refString), e);
        }
        catch (SAXException e) {
            throw Utilities.newCoreException(Policy.bind("SiteFileFactory.ErrorParsingFile", refString), e);
        }
    }

    public SiteModel createSiteMapModel() {
        return new SiteFile();
    }

    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.file".equalsIgnoreCase(type);
    }
}

