/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SessionDelta
extends ModelObject
implements ISessionDelta {
    private Date date;
    private List featureReferences;
    private File file;
    private int process = 1;
    private boolean deleted = false;

    public IFeatureReference[] getFeatureReferences() {
        if (this.featureReferences == null) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])this.featureReferences.toArray(this.arrayTypeFor(this.featureReferences));
    }

    public Date getDate() {
        return this.date;
    }

    public void process(IProgressMonitor pm) throws CoreException {
        if (this.featureReferences.isEmpty()) {
            return;
        }
        IFeatureReference[] selected = new IFeatureReference[this.featureReferences.size()];
        this.featureReferences.toArray(selected);
        this.process(selected, pm);
    }

    public void delete() {
        if (this.deleted) {
            UpdateCore.warn("Attempt to delete an already deleted session delta:" + this.file);
            return;
        }
        if (this.file != null) {
            UpdateManagerUtils.removeFromFileSystem(this.file);
            UpdateCore.warn("Removing SessionDelta:" + this.file);
        } else {
            UpdateCore.warn("Unable to remove SessionDelta. File is null");
        }
        this.deleted = true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void addReference(IFeatureReference reference) {
        if (this.featureReferences == null) {
            this.featureReferences = new ArrayList();
        }
        this.featureReferences.add(reference);
    }

    public void setCreationDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getType() {
        return this.process;
    }

    private void createInstallConfiguration() throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        IInstallConfiguration config = localSite.cloneCurrentConfiguration();
        config.setLabel(Utilities.format(config.getCreationDate()));
        localSite.addConfiguration(config);
    }

    private void saveLocalSite() throws CoreException {
        ILocalSite localSite = SiteManager.getLocalSite();
        localSite.save();
    }

    private boolean enable(IFeature newlyConfiguredFeatures) throws CoreException {
        ILocalSite siteLocal = SiteManager.getLocalSite();
        IInstallConfiguration currentConfiguration = siteLocal.getCurrentConfiguration();
        IConfiguredSite[] configuredSites = currentConfiguration.getConfiguredSites();
        int i = 0;
        while (i < configuredSites.length) {
            IFeatureReference[] configuredFeaturesRef = configuredSites[i].getConfiguredFeatures();
            int j = 0;
            while (j < configuredFeaturesRef.length) {
                try {
                    IFeature feature = configuredFeaturesRef[j].getFeature(null);
                    int result = this.compare(newlyConfiguredFeatures, feature);
                    if (result != 0) {
                        if (result == 1) {
                            ConfiguredSite cSite = (ConfiguredSite)configuredSites[i];
                            cSite.unconfigure(feature);
                            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                                UpdateCore.debug("Found an old version of the feature to disable:" + feature);
                            }
                        }
                        if (result == 2) {
                            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                                UpdateCore.debug("Found an old version of the feature with a higher version:" + feature);
                            }
                            return false;
                        }
                    }
                }
                catch (CoreException e) {
                    UpdateCore.warn(null, e);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private int compare(IFeature feature1, IFeature feature2) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare: " + feature1 + " && " + feature2);
        }
        if (feature1 == null) {
            return 0;
        }
        if (feature1 == null || feature2 == null) {
            return 0;
        }
        VersionedIdentifier id1 = feature1.getVersionedIdentifier();
        VersionedIdentifier id2 = feature2.getVersionedIdentifier();
        if (id1 == null || id2 == null) {
            return 0;
        }
        if (id1.getIdentifier() != null && id1.getIdentifier().equals(id2.getIdentifier())) {
            PluginVersionIdentifier version1 = id1.getVersion();
            PluginVersionIdentifier version2 = id2.getVersion();
            if (version1 != null) {
                if (version1.isGreaterThan(version2)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public void process(IFeatureReference[] selected, IProgressMonitor pm) throws CoreException {
        this.createInstallConfiguration();
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (this.process == 1) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("ENABLE SESSION DELTA");
            }
            if (this.featureReferences != null && this.featureReferences.size() > 0) {
                int nbFeatures = this.featureReferences.size();
                pm.beginTask(Policy.bind("SessionDelta.EnableFeatures"), nbFeatures);
                IFeatureReference ref = null;
                IConfiguredSite configSite = null;
                IFeature featureToConfigure = null;
                int i = 0;
                while (i < selected.length) {
                    block13: {
                        ref = selected[i];
                        try {
                            featureToConfigure = ref.getFeature(null);
                        }
                        catch (CoreException e) {
                            UpdateCore.warn(null, e);
                        }
                        if (featureToConfigure != null) {
                            pm.worked(1);
                            configSite = ref.getSite().getCurrentConfiguredSite();
                            try {
                                if (this.enable(featureToConfigure)) {
                                    configSite.configure(featureToConfigure);
                                    if (UpdateCore.isPatch(featureToConfigure)) {
                                        this.disablePatchedFeature(featureToConfigure, configSite);
                                    }
                                    break block13;
                                }
                                configSite.unconfigure(featureToConfigure);
                            }
                            catch (CoreException e) {
                                UpdateCore.warn("Unable to configure feature:" + featureToConfigure, e);
                            }
                        } else {
                            UpdateCore.warn("Unable to configure null feature:" + ref, null);
                        }
                    }
                    ++i;
                }
            }
        }
        this.delete();
        this.saveLocalSite();
    }

    private void disablePatchedFeature(IFeature patchToEnable, IConfiguredSite configSite) {
        block12: {
            try {
                IIncludedFeatureReference[] children = patchToEnable.getIncludedFeatureReferences();
                IFeature child = null;
                int i = 0;
                while (i < children.length) {
                    block11: {
                        try {
                            child = children[i].getFeature(true, configSite, null);
                        }
                        catch (CoreException coreException) {}
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                            UpdateCore.debug("Checking if children :" + child + " of efix " + patchToEnable + " should be enabled");
                        }
                        if (child != null) {
                            if (UpdateCore.isPatch(child)) {
                                this.disablePatchedFeature(child, configSite);
                            } else {
                                try {
                                    this.enable(child);
                                }
                                catch (CoreException e) {
                                    if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) break block11;
                                    UpdateCore.warn("Unable to enable child " + child, e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) break block12;
                UpdateCore.warn("Unable to retrieve children of patch " + patchToEnable, e);
            }
        }
    }
}

