/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.UpdateCore;

public class Response {
    protected URL url;
    protected InputStream in;
    protected URLConnection connection;

    public Response(InputStream in) {
        this.in = in;
    }

    public Response(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            this.in = this.connection.getInputStream();
        }
        return this.in;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException {
        return this.getInputStream();
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection != null && this.connection instanceof HttpURLConnection) {
            try {
                return ((HttpURLConnection)this.connection).getResponseCode();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null && this.connection instanceof HttpURLConnection) {
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return "";
    }
}

