/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;

public class ConfigurationPolicy
extends ConfigurationPolicyModel {
    public ConfigurationPolicy() {
    }

    public ConfigurationPolicy(ConfigurationPolicy configPolicy) {
        this.setPolicy(configPolicy.getPolicy());
        this.setConfiguredFeatureReferences(configPolicy.getConfiguredFeatures());
        this.setUnconfiguredFeatureReferences(configPolicy.getUnconfiguredFeatures());
        this.setConfiguredSiteModel(configPolicy.getConfiguredSiteModel());
    }

    private boolean isUnconfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getUnconfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            if (featureReference.equals(refs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isConfigured(IFeatureReference featureReference) {
        if (featureReference == null) {
            return false;
        }
        IFeatureReference[] refs = this.getConfiguredFeatures();
        int i = 0;
        while (i < refs.length) {
            if (featureReference.equals(refs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void configure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        IFeature feature;
        block23: {
            if (this.isConfigured(featureReference)) {
                return;
            }
            if (featureReference == null) {
                UpdateCore.warn("The feature reference to configure is null");
                return;
            }
            feature = null;
            try {
                feature = featureReference.getFeature(null);
            }
            catch (CoreException e) {
                if (UpdateManagerUtils.isOptional(featureReference)) break block23;
                URL url = featureReference.getURL();
                String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("Error retrieving feature:" + urlString, e);
                return;
            }
        }
        if (feature == null) {
            URL url = featureReference.getURL();
            String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
        }
        InstallHandlerProxy handler = null;
        if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
            handler = new InstallHandlerProxy(2, feature, feature.getInstallHandlerEntry(), null);
        }
        boolean success = false;
        Throwable originalException = null;
        try {
            try {
                if (handler != null) {
                    handler.configureInitiated();
                }
                ConfigurationActivity activity = null;
                if (createActivity) {
                    activity = new ConfigurationActivity(6);
                    activity.setLabel(feature.getVersionedIdentifier().toString());
                    activity.setDate(new Date());
                }
                this.addConfiguredFeatureReference((FeatureReferenceModel)((Object)featureReference));
                if (activity != null) {
                    InstallConfiguration installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                    activity.setStatus(0);
                    installConfig.addActivity(activity);
                }
                if (handler != null) {
                    handler.completeConfigure();
                }
                success = true;
            }
            catch (Throwable t) {
                originalException = t;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            Throwable newException = null;
            try {
                if (handler != null) {
                    handler.configureCompleted(success);
                }
            }
            catch (Throwable t) {
                newException = t;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
            }
            throw throwable;
        }
        Object var10_17 = null;
        Throwable newException = null;
        try {
            if (handler != null) {
                handler.configureCompleted(success);
            }
        }
        catch (Throwable t) {
            newException = t;
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
        }
    }

    public boolean unconfigure(IFeatureReference featureReference, boolean callInstallHandler, boolean createActivity) throws CoreException {
        IFeature feature;
        block25: {
            if (this.isUnconfigured(featureReference)) {
                UpdateCore.warn("Feature already unconfigured");
                return true;
            }
            if (featureReference == null) {
                UpdateCore.warn("The feature reference to unconfigure is null");
                return false;
            }
            feature = null;
            try {
                feature = featureReference.getFeature(null);
            }
            catch (CoreException e) {
                if (UpdateManagerUtils.isOptional(featureReference)) break block25;
                URL url = featureReference.getURL();
                String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
                UpdateCore.warn("Error retrieving feature:" + urlString, e);
                return false;
            }
        }
        if (feature == null) {
            URL url = featureReference.getURL();
            String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("The feature to unconfigure is null: feature reference is:" + urlString);
            return false;
        }
        InstallHandlerProxy handler = null;
        if (callInstallHandler && feature.getInstallHandlerEntry() != null) {
            handler = new InstallHandlerProxy(3, feature, feature.getInstallHandlerEntry(), null);
        }
        boolean success = false;
        Throwable originalException = null;
        try {
            try {
                ConfigurationActivity activity = null;
                if (createActivity) {
                    activity = new ConfigurationActivity(5);
                    activity.setLabel(feature.getVersionedIdentifier().toString());
                    activity.setDate(new Date());
                }
                InstallConfiguration installConfig = null;
                if (activity != null) {
                    installConfig = (InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration();
                }
                if (handler != null) {
                    handler.unconfigureInitiated();
                }
                this.addUnconfiguredFeatureReference((FeatureReferenceModel)((Object)featureReference));
                if (handler != null) {
                    handler.completeUnconfigure();
                }
                if (activity != null) {
                    activity.setStatus(0);
                    installConfig.addActivity(activity);
                }
                success = true;
            }
            catch (Throwable t) {
                originalException = t;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            Throwable newException = null;
            try {
                if (handler != null) {
                    handler.unconfigureCompleted(success);
                }
            }
            catch (Throwable t) {
                newException = t;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
            }
            throw throwable;
        }
        Object var10_18 = null;
        Throwable newException = null;
        try {
            if (handler != null) {
                handler.unconfigureCompleted(success);
            }
        }
        catch (Throwable t) {
            newException = t;
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
        }
        if (!success) {
            URL url = featureReference.getURL();
            String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("Unable to unconfigure:" + urlString);
        }
        return success;
    }

    public String[] getPluginPath(ISite site, String[] pluginRead) throws CoreException {
        String[] pluginsToWrite;
        if (this.getPolicy() == 1) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("UNCONFIGURED PLUGINS");
            }
            String[] unconfigured = this.getPluginString(site, this.getUnconfiguredFeatures());
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("CONFIGURED PLUGINS");
            }
            String[] configured = this.getPluginString(site, this.getConfiguredFeatures());
            pluginsToWrite = this.isEnabled() ? this.delta(configured, unconfigured) : this.union(configured, unconfigured);
        } else {
            pluginsToWrite = this.isEnabled() ? this.getPluginString(site, this.getConfiguredFeatures()) : new String[]{};
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("GetPluginPath for: " + (site == null ? "<No site>" : site.getURL().toString()));
            int i = 0;
            while (i < pluginsToWrite.length) {
                UpdateCore.debug("To write:" + pluginsToWrite[i]);
                ++i;
            }
        }
        String[] result = pluginsToWrite;
        return result;
    }

    public IFeatureReference[] getConfiguredFeatures() {
        FeatureReferenceModel[] result = this.getConfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IFeatureReference[] getUnconfiguredFeatures() {
        FeatureReferenceModel[] result = this.getUnconfiguredFeaturesModel();
        if (result.length == 0) {
            return new IFeatureReference[0];
        }
        return (IFeatureReference[])result;
    }

    public IConfiguredSite getConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public void removeFeatureReference(IFeatureReference featureRef) {
        if (featureRef instanceof FeatureReferenceModel) {
            this.removeFeatureReference((FeatureReferenceModel)((Object)featureRef));
        }
    }

    private String[] getPluginString(ISite site, IFeatureReference[] arrayOfFeatureRef) throws CoreException {
        String[] result = new String[]{};
        if (arrayOfFeatureRef != null) {
            HashSet<String> pluginsString = new HashSet<String>();
            int i = 0;
            while (i < arrayOfFeatureRef.length) {
                IFeatureReference element = arrayOfFeatureRef[i];
                IFeature feature = null;
                try {
                    feature = element.getFeature(null);
                }
                catch (CoreException e) {
                    UpdateCore.warn(null, e);
                }
                IPluginEntry[] entries = null;
                if (feature == null) {
                    UpdateCore.warn("Null Feature", new Exception());
                    entries = new IPluginEntry[]{};
                } else {
                    entries = feature.getPluginEntries();
                }
                int index = 0;
                while (index < entries.length) {
                    IPluginEntry entry = entries[index];
                    ContentReference[] featureContentReference = null;
                    try {
                        featureContentReference = feature.getFeatureContentProvider().getPluginEntryArchiveReferences(entry, null);
                    }
                    catch (CoreException e) {
                        UpdateCore.warn(null, e);
                    }
                    if (featureContentReference != null) {
                        int j = 0;
                        while (j < featureContentReference.length) {
                            URL url = site.getSiteContentProvider().getArchiveReference(featureContentReference[j].getIdentifier());
                            if (url != null) {
                                String path = UpdateManagerUtils.getURLAsString(site.getURL(), url);
                                path = String.valueOf(path) + (path.endsWith(File.separator) || path.endsWith("/") ? "" : "/");
                                path = String.valueOf(path) + (entry.isFragment() ? "fragment.xml" : "plugin.xml");
                                pluginsString.add(path);
                                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                                    UpdateCore.warn("Add plugin: " + path + " to the list");
                                }
                            }
                            ++j;
                        }
                    }
                    ++index;
                }
                ++i;
            }
            if (!pluginsString.isEmpty()) {
                result = new String[pluginsString.size()];
                pluginsString.toArray(result);
            }
        }
        return result;
    }

    private String[] delta(String[] pluginsToRemove, String[] allPlugins) {
        if (pluginsToRemove == null || pluginsToRemove.length == 0) {
            return allPlugins;
        }
        if (allPlugins == null || allPlugins.length == 0) {
            return new String[0];
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.addAll(Arrays.asList(allPlugins));
        int i = 0;
        while (i < pluginsToRemove.length) {
            if (list1.contains(pluginsToRemove[i])) {
                list1.remove(pluginsToRemove[i]);
            }
            ++i;
        }
        String[] resultEntry = new String[list1.size()];
        if (list1.size() > 0) {
            list1.toArray(resultEntry);
        }
        return resultEntry;
    }

    private String[] union(String[] targetArray, String[] sourceArray) {
        if (sourceArray == null || sourceArray.length == 0) {
            return targetArray;
        }
        if (targetArray == null || targetArray.length == 0) {
            return sourceArray;
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.addAll(Arrays.asList(targetArray));
        int i = 0;
        while (i < sourceArray.length) {
            if (!list1.contains(sourceArray[i])) {
                list1.add(sourceArray[i]);
            }
            ++i;
        }
        String[] resultEntry = new String[list1.size()];
        if (list1.size() > 0) {
            list1.toArray(resultEntry);
        }
        return resultEntry;
    }
}

