/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class FeatureReferenceModel
extends ModelObject {
    private String type;
    private URL url;
    private String urlString;
    private String featureId;
    private String featureVersion;
    private SiteModel site;
    private String label;
    private String localizedLabel;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;
    private String os;
    private String ws;
    private String nl;
    private String arch;
    private String patch;

    public FeatureReferenceModel() {
    }

    public FeatureReferenceModel(FeatureReferenceModel ref) {
        this.setFeatureIdentifier(ref.getFeatureIdentifier());
        this.setFeatureVersion(ref.getFeatureVersion());
        this.setType(ref.getType());
        this.setSiteModel(ref.getSiteModel());
        this.setLabel(ref.getLabel());
        this.setWS(ref.getWS());
        this.setOS(ref.getOS());
        this.setArch(ref.getOSArch());
        this.setNL(this.getNL());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        if (!(object instanceof FeatureReferenceModel)) {
            return false;
        }
        FeatureReferenceModel f = (FeatureReferenceModel)((Object)object);
        return UpdateManagerUtils.sameURL(this.getURL(), f.getURL());
    }

    public String getType() {
        return this.type;
    }

    public SiteModel getSiteModel() {
        return this.site;
    }

    public String getURLString() {
        return this.urlString;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public String getFeatureIdentifier() {
        return this.featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public void setType(String type) {
        this.assertIsWriteable();
        this.type = type;
    }

    public void setSiteModel(SiteModel site) {
        this.assertIsWriteable();
        this.site = site;
    }

    public void setURLString(String urlString) {
        this.assertIsWriteable();
        this.urlString = urlString;
        this.url = null;
    }

    public void setFeatureIdentifier(String featureId) {
        this.assertIsWriteable();
        this.featureId = featureId;
    }

    public void setFeatureVersion(String featureVersion) {
        this.assertIsWriteable();
        this.featureVersion = featureVersion;
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.base = base;
        this.bundleURL = bundleURL;
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.localizedLabel = this.resolveNLString(this.bundleURL, this.label);
        try {
            this.url = this.resolveURL(this.base, this.bundleURL, this.urlString);
        }
        catch (MalformedURLException e) {
            UpdateCore.warn("", e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(((Object)((Object)this)).getClass().toString()) + " :");
        buffer.append(" at ");
        if (this.url != null) {
            buffer.append(this.url.toExternalForm());
        }
        return buffer.toString();
    }

    protected String getPropertyName() {
        return "site";
    }

    public String getLabel() {
        this.delayedResolve();
        if (this.localizedLabel != null) {
            return this.localizedLabel;
        }
        return this.label;
    }

    public String getLabelNonLocalized() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getOSArch() {
        return this.arch;
    }

    public String getNL() {
        return this.nl;
    }

    public void setOS(String os) {
        this.assertIsWriteable();
        this.os = os;
    }

    public void setWS(String ws) {
        this.assertIsWriteable();
        this.ws = ws;
    }

    public void setNL(String nl) {
        this.assertIsWriteable();
        this.nl = nl;
    }

    public void setArch(String arch) {
        this.assertIsWriteable();
        this.arch = arch;
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }
}

