/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureModelFactory;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.InstallHandlerEntryModel;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultFeatureParser
extends DefaultHandler {
    private SAXParser parser;
    private FeatureModelFactory factory;
    private MultiStatus status;
    private boolean URL_ALREADY_SEEN = false;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_INCLUDES = 1;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_HANDLER = 3;
    private static final int STATE_DESCRIPTION = 4;
    private static final int STATE_COPYRIGHT = 5;
    private static final int STATE_LICENSE = 6;
    private static final int STATE_URL = 7;
    private static final int STATE_UPDATE = 8;
    private static final int STATE_DISCOVERY = 9;
    private static final int STATE_REQUIRES = 10;
    private static final int STATE_IMPORT = 11;
    private static final int STATE_PLUGIN = 12;
    private static final int STATE_DATA = 13;
    private static final String PLUGIN_ID = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
    private static final String FEATURE = "feature";
    private static final String INCLUDES = "includes";
    private static final String HANDLER = "install-handler";
    private static final String DESCRIPTION = "description";
    private static final String COPYRIGHT = "copyright";
    private static final String LICENSE = "license";
    private static final String URL = "url";
    private static final String UPDATE = "update";
    private static final String DISCOVERY = "discovery";
    private static final String REQUIRES = "requires";
    private static final String IMPORT = "import";
    private static final String PLUGIN = "plugin";
    private static final String DATA = "data";
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    private int currentState;

    public DefaultFeatureParser() {
        this.parser = new SAXParser();
        try {
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException sAXException) {}
        this.parser.setContentHandler((ContentHandler)this);
        this.parser.setErrorHandler((ErrorHandler)this);
    }

    public void init(FeatureModelFactory factory) {
        this.factory = factory;
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        this.status = null;
        this.URL_ALREADY_SEEN = false;
    }

    public FeatureModel parse(InputStream in) throws SAXException, IOException {
        this.stateStack.push(new Integer(0));
        this.currentState = (Integer)this.stateStack.peek();
        this.parser.parse(new InputSource(in));
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Policy.bind("DefaultFeatureParser.NoFeatureTag"));
        }
        if (this.objectStack.peek() instanceof FeatureModel) {
            return (FeatureModel)((Object)this.objectStack.pop());
        }
        String stack = "";
        Iterator iter = ((AbstractList)this.objectStack).iterator();
        while (iter.hasNext()) {
            stack = "\r\n" + iter.next().toString() + stack;
        }
        throw new SAXException(Policy.bind("DefaultFeatureParser.WrongParsingStack", stack));
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        switch (this.currentState) {
            case -1: {
                this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", localName, this.getState(this.currentState)));
                break;
            }
            case 0: {
                this.handleInitialState(localName, attributes);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleFeatureState(localName, attributes);
                break;
            }
            case 7: {
                if (this.URL_ALREADY_SEEN) {
                    this.internalError(Policy.bind("DefaultFeatureParser.TooManyURLtag"));
                }
                this.handleURLState(localName, attributes);
                break;
            }
            case 8: 
            case 9: {
                this.handleUpdateDiscoveryState(localName, attributes);
                break;
            }
            case 10: {
                this.handleRequiresState(localName, attributes);
                break;
            }
            case 11: {
                this.handleImportState(localName, attributes);
                break;
            }
            case 12: 
            case 13: {
                this.handleFeatureState(localName, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownStartState", Integer.toString(this.currentState)));
            }
        }
        int newState = (Integer)this.stateStack.peek();
        if (newState != -1) {
            this.currentState = newState;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        URLEntryModel info = null;
        FeatureModel featureModel = null;
        String text = null;
        int innerState = 0;
        int state = (Integer)this.stateStack.peek();
        block0 : switch (state) {
            case -1: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Policy.bind("DefaultFeatureParser.ParsingStackBackToInitialState"));
                break;
            }
            case 2: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                FeatureModel feature = (FeatureModel)((Object)this.objectStack.peek());
                feature.getDescriptionModel().setAnnotation(text);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof IncludedFeatureReferenceModel)) break;
                IncludedFeatureReferenceModel includedFeatureRefModel = (IncludedFeatureReferenceModel)this.objectStack.pop();
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addIncludedFeatureReferenceModel(includedFeatureRefModel);
                break;
            }
            case 3: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof InstallHandlerEntryModel)) break;
                InstallHandlerEntryModel handlerModel = (InstallHandlerEntryModel)((Object)this.objectStack.pop());
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                if (featureModel.getInstallHandlerModel() != null) {
                    this.internalError(Policy.bind("DefaultFeatureParser.ElementAlreadySet", this.getState(state)));
                    break;
                }
                featureModel.setInstallHandlerModel(handlerModel);
                break;
            }
            case 4: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    text = String.valueOf((String)this.objectStack.pop()) + text;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if ((text = this.cleanupText(text)) != null) {
                    info.setAnnotation(text);
                }
                innerState = (Integer)this.stateStack.peek();
                switch (innerState) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getDescriptionModel() != null) {
                            this.internalError(Policy.bind("DefaultFeatureParser.ElementAlreadySet", this.getState(state)));
                            break;
                        }
                        featureModel.setDescriptionModel(info);
                        break;
                    }
                    default: {
                        this.internalError(Policy.bind("DefaultFeatureParser.StateIncludeWrongElement", this.getState(innerState), this.getState(state)));
                        break;
                    }
                }
                break;
            }
            case 5: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    text = String.valueOf((String)this.objectStack.pop()) + text;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if ((text = this.cleanupText(text)) != null) {
                    info.setAnnotation(text);
                }
                innerState = (Integer)this.stateStack.peek();
                switch (innerState) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getCopyrightModel() != null) {
                            this.internalError(Policy.bind("DefaultFeatureParser.ElementAlreadySet", this.getState(state)));
                            break;
                        }
                        featureModel.setCopyrightModel(info);
                        break;
                    }
                    default: {
                        this.internalError(Policy.bind("DefaultFeatureParser.StateIncludeWrongElement", this.getState(innerState), this.getState(state)));
                        break;
                    }
                }
                break;
            }
            case 6: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    text = String.valueOf((String)this.objectStack.pop()) + text;
                }
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if ((text = this.cleanupText(text)) != null) {
                    info.setAnnotation(text);
                }
                innerState = (Integer)this.stateStack.peek();
                switch (innerState) {
                    case 2: {
                        if (!(this.objectStack.peek() instanceof FeatureModel)) break block0;
                        featureModel = (FeatureModel)((Object)this.objectStack.peek());
                        if (featureModel.getLicenseModel() != null) {
                            this.internalError(Policy.bind("DefaultFeatureParser.ElementAlreadySet", this.getState(state)));
                            break;
                        }
                        featureModel.setLicenseModel(info);
                        break;
                    }
                    default: {
                        this.internalError(Policy.bind("DefaultFeatureParser.StateIncludeWrongElement", this.getState(innerState), this.getState(state)));
                        break;
                    }
                }
                break;
            }
            case 7: {
                this.stateStack.pop();
                this.URL_ALREADY_SEEN = true;
                break;
            }
            case 8: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                if (featureModel.getUpdateSiteEntryModel() != null) {
                    this.internalError(Policy.bind("DefaultFeatureParser.ElementAlreadySet", this.getState(state)));
                    break;
                }
                featureModel.setUpdateSiteEntryModel(info);
                break;
            }
            case 9: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof URLEntryModel)) break;
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addDiscoverySiteEntryModel(info);
                break;
            }
            case 10: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                ImportModel[] importModels = featureModel.getImportModels();
                if (importModels.length == 0) {
                    this.internalError(Policy.bind("DefaultFeatureParser.RequireStateWithoutImportElement"));
                    break;
                }
                boolean patchMode = false;
                int i = 0;
                while (i < importModels.length) {
                    ImportModel importModel = importModels[i];
                    if (importModel.isPatch()) {
                        if (!patchMode) {
                            patchMode = true;
                        } else {
                            this.internalError(Policy.bind("DefaultFeatureParser.MultiplePatchImports"));
                            break block0;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 11: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof ImportModel)) break;
                ImportModel importModel = (ImportModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addImportModel(importModel);
                break;
            }
            case 12: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof PluginEntryModel)) break;
                PluginEntryModel pluginEntry = (PluginEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addPluginEntryModel(pluginEntry);
                break;
            }
            case 13: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof NonPluginEntryModel)) break;
                NonPluginEntryModel nonPluginEntry = (NonPluginEntryModel)((Object)this.objectStack.pop());
                if (!(this.objectStack.peek() instanceof FeatureModel)) break;
                featureModel = (FeatureModel)((Object)this.objectStack.peek());
                featureModel.addNonPluginEntryModel(nonPluginEntry);
                break;
            }
            default: {
                this.internalErrorUnknownTag(String.valueOf(Policy.bind("DefaultFeatureParser.UnknownEndState")) + state);
            }
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("End Element:" + uri + ":" + localName + ":" + qName);
        }
    }

    private String cleanupText(String text) {
        if ("".equals(text = text.trim())) {
            return null;
        }
        return text;
    }

    public void characters(char[] ch, int start, int length) {
        int state;
        String text = "";
        boolean valid = true;
        if (valid) {
            text = new String(ch, start, length);
        }
        if ((state = ((Integer)this.stateStack.peek()).intValue()) == 4 || state == 5 || state == 6) {
            this.objectStack.push(text);
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private void handleInitialState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleFeatureState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (elementName.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (elementName.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (elementName.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (elementName.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (elementName.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (elementName.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleDescriptionState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (elementName.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (elementName.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (elementName.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (elementName.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (elementName.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleURLState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(UPDATE)) {
            this.stateStack.push(new Integer(8));
            this.processURLInfo(attributes);
        } else if (elementName.equals(DISCOVERY)) {
            this.stateStack.push(new Integer(9));
            this.processURLInfo(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleRequiresState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(IMPORT)) {
            this.stateStack.push(new Integer(11));
            this.processImport(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleUpdateDiscoveryState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (elementName.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (elementName.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (elementName.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (elementName.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (elementName.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (elementName.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else if (elementName.equals(UPDATE)) {
            this.stateStack.push(new Integer(8));
            this.processURLInfo(attributes);
        } else if (elementName.equals(DISCOVERY)) {
            this.stateStack.push(new Integer(9));
            this.processURLInfo(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void handleImportState(String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(HANDLER)) {
            this.stateStack.push(new Integer(3));
            this.processHandler(attributes);
        } else if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(4));
            this.processInfo(attributes);
        } else if (elementName.equals(COPYRIGHT)) {
            this.stateStack.push(new Integer(5));
            this.processInfo(attributes);
        } else if (elementName.equals(LICENSE)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(URL)) {
            this.stateStack.push(new Integer(7));
        } else if (elementName.equals(INCLUDES)) {
            this.stateStack.push(new Integer(1));
            this.processIncludes(attributes);
        } else if (elementName.equals(REQUIRES)) {
            this.stateStack.push(new Integer(10));
            this.processRequire(attributes);
        } else if (elementName.equals(PLUGIN)) {
            this.stateStack.push(new Integer(12));
            this.processPlugin(attributes);
        } else if (elementName.equals(DATA)) {
            this.stateStack.push(new Integer(13));
            this.processData(attributes);
        } else if (elementName.equals(IMPORT)) {
            this.stateStack.push(new Integer(11));
            this.processImport(attributes);
        } else {
            this.internalErrorUnknownTag(Policy.bind("DefaultFeatureParser.UnknownElement", elementName, this.getState(this.currentState)));
        }
    }

    private void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            this.internalError(Policy.bind("DefaultFeatureParser.IdOrVersionInvalid", new String[]{id, ver, this.getState(this.currentState)}));
        } else {
            FeatureModel feature = this.factory.createFeatureModel();
            feature.setFeatureIdentifier(id);
            feature.setFeatureVersion(ver);
            String label = attributes.getValue("label");
            feature.setLabel(label);
            String provider = attributes.getValue("provider-name");
            feature.setProvider(provider);
            String imageURL = attributes.getValue("image");
            feature.setImageURLString(imageURL);
            String os = attributes.getValue("os");
            feature.setOS(os);
            String ws = attributes.getValue("ws");
            feature.setWS(ws);
            String nl = attributes.getValue("nl");
            feature.setNL(nl);
            String arch = attributes.getValue("arch");
            feature.setArch(arch);
            String primary = attributes.getValue("primary");
            feature.setPrimary(primary != null && primary.trim().equalsIgnoreCase("true"));
            String exclusive = attributes.getValue("exclusive");
            feature.setExclusive(exclusive != null && exclusive.trim().equalsIgnoreCase("true"));
            String application = attributes.getValue("application");
            feature.setApplication(application);
            String affinity = attributes.getValue("colocation-affinity");
            feature.setAffinityFeature(affinity);
            String plugin = attributes.getValue(PLUGIN);
            feature.setPrimaryPluginID(plugin);
            this.objectStack.push(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                this.debug("End process DefaultFeature tag: id:" + id + " ver:" + ver + " label:" + label + " provider:" + provider);
                this.debug("End process DefaultFeature tag: image:" + imageURL);
                this.debug("End process DefaultFeature tag: ws:" + ws + " os:" + os + " nl:" + nl + " application:" + application);
            }
        }
    }

    private void processHandler(Attributes attributes) {
        InstallHandlerEntryModel handler = this.factory.createInstallHandlerEntryModel();
        String handlerURL = attributes.getValue(URL);
        handler.setURLString(handlerURL);
        String library = attributes.getValue("library");
        handler.setLibrary(library);
        String clazz = attributes.getValue("handler");
        handler.setHandlerName(clazz);
        this.objectStack.push(handler);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("Processed Handler: url:" + handlerURL + " library:" + library + " class:" + clazz);
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntryModel inf = this.factory.createURLEntryModel();
        String infoURL = attributes.getValue(URL);
        inf.setURLString(infoURL);
        this.objectStack.push(inf);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("Processed Info: url:" + infoURL);
        }
    }

    private void processIncludes(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            this.internalError(Policy.bind("DefaultFeatureParser.IdOrVersionInvalid", new String[]{id, ver, this.getState(this.currentState)}));
        }
        IncludedFeatureReferenceModel includedFeature = this.factory.createIncludedFeatureReferenceModel();
        includedFeature.setFeatureIdentifier(id);
        includedFeature.setFeatureVersion(ver);
        String name = attributes.getValue("name");
        includedFeature.setLabel(name);
        String optional = attributes.getValue("optional");
        boolean isOptional = "true".equalsIgnoreCase(optional);
        includedFeature.isOptional(isOptional);
        String ruleName = attributes.getValue("match");
        int rule = UpdateManagerUtils.getMatchingRule(ruleName);
        includedFeature.setMatchingRule(rule);
        String locationName = attributes.getValue("search-location");
        if (locationName == null) {
            locationName = attributes.getValue("search_location");
        }
        int searchLocation = 2;
        if ("both".equalsIgnoreCase(locationName)) {
            searchLocation = 0;
        }
        if ("self".equalsIgnoreCase(locationName)) {
            searchLocation = 4;
        }
        includedFeature.setSearchLocation(searchLocation);
        String os = attributes.getValue("os");
        includedFeature.setOS(os);
        String ws = attributes.getValue("ws");
        includedFeature.setWS(ws);
        String arch = attributes.getValue("arch");
        includedFeature.setArch(arch);
        this.objectStack.push(includedFeature);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("End process Includes tag: id:" + id + " ver:" + ver);
            this.debug("name =" + name + " optional=" + optional + " match=" + ruleName + " search-location=" + locationName);
            this.debug("os=" + os + " ws=" + ws + " arch=" + arch);
        }
    }

    private void processURLInfo(Attributes attributes) {
        URLEntryModel inf = this.factory.createURLEntryModel();
        String infoURL = attributes.getValue(URL);
        String label = attributes.getValue("label");
        String type = attributes.getValue("type");
        inf.setURLString(infoURL);
        inf.setAnnotation(label);
        if ("web".equalsIgnoreCase(type)) {
            inf.setType(1);
        } else {
            inf.setType(0);
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            this.debug("Processed URLInfo: url:" + infoURL + " label:" + label + " type:" + type);
        }
        this.objectStack.push(inf);
    }

    private void processImport(Attributes attributes) {
        String pluginID = attributes.getValue(PLUGIN);
        String featureID = attributes.getValue(FEATURE);
        String idMatch = attributes.getValue("id-match");
        if (!(pluginID == null ^ featureID == null)) {
            this.internalError(Policy.bind("DefaultFeatureParser.PluginAndFeatureId"));
            return;
        }
        String id = null;
        id = pluginID == null ? featureID : pluginID;
        if (id == null || id.trim().equals("")) {
            this.internalError(Policy.bind("DefaultFeatureParser.MissingId", this.getState(this.currentState)));
        } else {
            ImportModel imp = this.factory.createImportModel();
            String ver = attributes.getValue("version");
            String match = attributes.getValue("match");
            String patch = attributes.getValue("patch");
            imp.setPatch(patch != null && patch.equalsIgnoreCase("true"));
            if (ver == null) {
                if (imp.isPatch()) {
                    this.internalError(Policy.bind("DefaultFeatureParser.MissingPatchVersion"));
                }
                ver = "0.0.0";
                match = "greaterOrEqual";
            } else if (match == null) {
                match = imp.isPatch() ? "perfect" : "compatible";
            }
            imp.setIdentifier(id);
            imp.setVersion(ver);
            imp.setFeatureImport(featureID != null);
            imp.setMatchingRuleName(match);
            imp.setMatchingIdRuleName(idMatch);
            if (imp.isPatch()) {
                if (match != null && !match.equalsIgnoreCase("perfect")) {
                    this.internalError(Policy.bind("DefaultFeatureParser.wrongMatchForPatch"));
                }
                if (!imp.isFeatureImport()) {
                    imp.setPatch(false);
                    this.internalError(Policy.bind("DefaultFeatureParser.patchWithPlugin"));
                }
            }
            String os = attributes.getValue("os");
            imp.setOS(os);
            String ws = attributes.getValue("ws");
            imp.setWS(ws);
            String arch = attributes.getValue("arch");
            imp.setOSArch(arch);
            this.objectStack.push(imp);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                this.debug("Processed import: id:" + id + " ver:" + ver);
                this.debug("Processed import: match:" + match);
            }
        }
    }

    private void processRequire(Attributes attributes) {
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id == null || id.trim().equals("") || ver == null || ver.trim().equals("")) {
            this.internalError(Policy.bind("DefaultFeatureParser.IdOrVersionInvalid", new String[]{id, ver, this.getState(this.currentState)}));
        } else {
            PluginEntryModel pluginEntry = this.factory.createPluginEntryModel();
            pluginEntry.setPluginIdentifier(id);
            pluginEntry.setPluginVersion(ver);
            String fragment = attributes.getValue("fragment");
            pluginEntry.isFragment(fragment != null && fragment.trim().equalsIgnoreCase("true"));
            String os = attributes.getValue("os");
            pluginEntry.setOS(os);
            String ws = attributes.getValue("ws");
            pluginEntry.setWS(ws);
            String nl = attributes.getValue("nl");
            pluginEntry.setNL(nl);
            String arch = attributes.getValue("arch");
            pluginEntry.setArch(arch);
            long download_size = -1L;
            String download = attributes.getValue("download-size");
            if (download != null && !download.trim().equals("")) {
                try {
                    download_size = Long.valueOf(download);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            pluginEntry.setDownloadSize(download_size);
            long install_size = -1L;
            String install = attributes.getValue("install-size");
            if (install != null && !install.trim().equals("")) {
                try {
                    install_size = Long.valueOf(install);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            pluginEntry.setInstallSize(install_size);
            this.objectStack.push(pluginEntry);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                this.debug("Processed Plugin: id:" + id + " ver:" + ver + " fragment:" + fragment);
                this.debug("Processed Plugin: os:" + os + " ws:" + ws + " nl:" + nl);
                this.debug("Processed Plugin: download size:" + download_size + " install size:" + install_size);
            }
        }
    }

    private void processData(Attributes attributes) {
        String id = attributes.getValue("id");
        if (id == null || id.trim().equals("")) {
            this.internalError(Policy.bind("DefaultFeatureParser.MissingId", this.getState(this.currentState)));
        } else {
            NonPluginEntryModel dataEntry = this.factory.createNonPluginEntryModel();
            dataEntry.setIdentifier(id);
            String os = attributes.getValue("os");
            dataEntry.setOS(os);
            String ws = attributes.getValue("ws");
            dataEntry.setWS(ws);
            String nl = attributes.getValue("nl");
            dataEntry.setNL(nl);
            String arch = attributes.getValue("arch");
            dataEntry.setArch(arch);
            long download_size = -1L;
            String download = attributes.getValue("download-size");
            if (download != null && !download.trim().equals("")) {
                try {
                    download_size = Long.valueOf(download);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            dataEntry.setDownloadSize(download_size);
            long install_size = -1L;
            String install = attributes.getValue("install-size");
            if (install != null && !install.trim().equals("")) {
                try {
                    install_size = Long.valueOf(install);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            dataEntry.setInstallSize(install_size);
            this.objectStack.push(dataEntry);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                this.debug("Processed Data: id:" + id);
                this.debug("Processed Data: download size:" + download_size + " install size:" + install_size);
            }
        }
    }

    private void debug(String s) {
        UpdateCore.debug("DefaultFeatureParser: " + s);
    }

    private void logStatus(SAXParseException ex) {
        String msg;
        String name = ex.getSystemId();
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        if (name.equals("")) {
            msg = Policy.bind("DefaultFeatureParser.ErrorParsing", ex.getMessage());
        } else {
            Object[] values = new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()};
            msg = Policy.bind("DefaultFeatureParser.ErrorlineColumnMessage", values);
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, msg, (Throwable)ex));
    }

    private void error(IStatus error) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 1, Policy.bind("DefaultFeatureParser.ErrorParsingFeature"), null);
        }
        this.status.add(error);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.log(error);
        }
    }

    private void internalErrorUnknownTag(String msg) {
        this.stateStack.push(new Integer(-1));
        this.internalError(msg);
    }

    private void internalError(String message) {
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, message, null));
    }

    private String getState(int state) {
        switch (state) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 2: {
                return "Feature";
            }
            case 3: {
                return "Install Handler";
            }
            case 4: {
                return DESCRIPTION;
            }
            case 1: {
                return INCLUDES;
            }
            case 5: {
                return "Copyright";
            }
            case 6: {
                return "License";
            }
            case 7: {
                return "URL";
            }
            case 8: {
                return "Update URL";
            }
            case 9: {
                return "Discovery URL";
            }
            case 10: {
                return "Require";
            }
            case 11: {
                return "Import";
            }
            case 12: {
                return "Plugin";
            }
            case 13: {
                return "Data";
            }
        }
        return Policy.bind("DefaultFeatureParser.UnknownState", Integer.toString(state));
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        super.ignorableWhitespace(arg0, arg1, arg2);
    }
}

