/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public abstract class FeatureContentProvider
implements IFeatureContentProvider {
    private static final boolean SWITCH_COPY_LOCAL = true;
    private URL base;
    private IFeature feature;
    private File tmpDir;
    public static final String JAR_EXTENSION = ".jar";
    private static final String DOT_PERMISSIONS = "permissions.properties";
    private static final String EXECUTABLES = "permissions.executable";
    private static final Object lock = new Object();

    public FeatureContentProvider(URL base) {
        this.base = base;
        this.feature = null;
    }

    public URL getURL() {
        return this.base;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public ContentReference asLocalReference(ContentReference ref, InstallMonitor monitor) throws IOException, CoreException {
        if (ref.isLocalReference()) {
            return ref;
        }
        String key = ref.toString();
        File localFile = null;
        Object object = lock;
        synchronized (object) {
            localFile = Utilities.lookupLocalFile(key);
            if (localFile != null) {
                return ref.createContentReference(ref.getIdentifier(), localFile);
            }
            InputStream is = null;
            OutputStream os = null;
            localFile = Utilities.createLocalFile(this.getWorkingDirectory(), null);
            boolean sucess = false;
            if (monitor != null) {
                monitor.saveState();
                monitor.setTaskName(Policy.bind("FeatureContentProvider.Downloading"));
                monitor.subTask(String.valueOf(ref.getIdentifier()) + " ");
                monitor.setTotalCount(ref.getInputSize());
                monitor.showCopyDetails(true);
            }
            try {
                try {
                    try {
                        is = ref.getInputStream();
                    }
                    catch (IOException e) {
                        throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToRetrieve", new Object[]{ref}), e);
                    }
                    try {
                        os = new BufferedOutputStream(new FileOutputStream(localFile));
                    }
                    catch (FileNotFoundException e) {
                        throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToCreate", new Object[]{localFile}), e);
                    }
                    Date start = new Date();
                    Utilities.copy(is, os, monitor);
                    Date stop = new Date();
                    long timeInseconds = (stop.getTime() - start.getTime()) / 1000L;
                    InternalSiteManager.downloaded(ref.getInputSize(), timeInseconds, ref.asURL());
                    sucess = true;
                    Utilities.mapLocalFile(key, localFile);
                }
                catch (ClassCastException e) {
                    throw Utilities.newCoreException(Policy.bind("FeatureContentProvider.UnableToCreate", new Object[]{localFile}), e);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (sucess && is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                if (monitor != null) {
                    monitor.restoreState();
                }
                throw throwable;
            }
            Object var13_17 = null;
            if (sucess && is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.restoreState();
            }
        }
        ContentReference reference = ref.createContentReference(ref.getIdentifier(), localFile);
        return reference;
    }

    public File asLocalFile(ContentReference ref, InstallMonitor monitor) throws IOException, CoreException {
        File file = ref.asFile();
        ContentReference localRef = this.asLocalReference(ref, monitor);
        file = localRef.asFile();
        return file;
    }

    protected File getWorkingDirectory() throws IOException {
        if (this.tmpDir == null) {
            this.tmpDir = Utilities.createWorkingDirectory();
        }
        return this.tmpDir;
    }

    public long getDownloadSizeFor(IPluginEntry[] pluginEntries, INonPluginEntry[] nonPluginEntries) {
        int i;
        long result = 0L;
        if (!(pluginEntries != null && pluginEntries.length != 0 || nonPluginEntries != null && nonPluginEntries.length != 0)) {
            return -1L;
        }
        long size = 0L;
        if (pluginEntries != null) {
            i = 0;
            while (i < pluginEntries.length) {
                size = ((PluginEntryModel)((Object)pluginEntries[i])).getDownloadSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        if (nonPluginEntries != null) {
            i = 0;
            while (i < nonPluginEntries.length) {
                size = ((NonPluginEntryModel)((Object)nonPluginEntries[i])).getDownloadSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        return result;
    }

    public long getInstallSizeFor(IPluginEntry[] pluginEntries, INonPluginEntry[] nonPluginEntries) {
        int i;
        long result = 0L;
        if (!(pluginEntries != null && pluginEntries.length != 0 || nonPluginEntries != null && nonPluginEntries.length != 0)) {
            return -1L;
        }
        long size = 0L;
        if (pluginEntries != null) {
            i = 0;
            while (i < pluginEntries.length) {
                size = ((PluginEntryModel)((Object)pluginEntries[i])).getInstallSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        if (nonPluginEntries != null) {
            i = 0;
            while (i < nonPluginEntries.length) {
                size = ((NonPluginEntryModel)((Object)nonPluginEntries[i])).getInstallSize();
                if (size == -1L) {
                    return -1L;
                }
                result += size;
                ++i;
            }
        }
        return result;
    }

    protected String getPathID(IPluginEntry entry) {
        return "plugins/" + entry.getVersionedIdentifier().toString() + JAR_EXTENSION;
    }

    protected String getPathID(INonPluginEntry entry) {
        String nonPluginBaseID = "features/" + this.feature.getVersionedIdentifier().toString() + "/";
        return String.valueOf(nonPluginBaseID) + entry.getIdentifier();
    }

    protected void validatePermissions(ContentReference[] references) {
        if (references == null || references.length == 0) {
            return;
        }
        Map permissions = this.getPermissions(references);
        if (permissions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < references.length) {
            ContentReference contentReference = references[i];
            String id = contentReference.getIdentifier();
            Object value = null;
            value = this.matchesOneRule(id, permissions);
            if (value != null) {
                Integer permission = (Integer)value;
                contentReference.setPermission(permission);
            }
            ++i;
        }
    }

    private Object matchesOneRule(String id, Map permissions) {
        Set keySet = permissions.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            FileFilter rule = (FileFilter)iter.next();
            if (!rule.accept(id)) continue;
            return permissions.get(rule);
        }
        return null;
    }

    private Map getPermissions(ContentReference[] references) {
        HashMap<FileFilter, Integer> result = new HashMap<FileFilter, Integer>();
        boolean notfound = true;
        ContentReference permissionReference = null;
        int i = 0;
        while (i < references.length && notfound) {
            ContentReference contentReference = references[i];
            if (DOT_PERMISSIONS.equals(contentReference.getIdentifier())) {
                notfound = false;
                permissionReference = contentReference;
            }
            ++i;
        }
        if (notfound) {
            return result;
        }
        Properties prop = new Properties();
        try {
            prop.load(permissionReference.getInputStream());
        }
        catch (IOException e) {
            UpdateCore.warn("", e);
        }
        String executables = prop.getProperty(EXECUTABLES);
        if (executables == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(executables, ",");
        Integer defaultExecutablePermission = new Integer(-1);
        while (tokenizer.hasMoreTokens()) {
            FileFilter filter = new FileFilter(tokenizer.nextToken());
            result.put(filter, defaultExecutablePermission);
        }
        return result;
    }

    public abstract ContentReference getFeatureManifestReference(InstallMonitor var1) throws CoreException;

    public abstract ContentReference[] getArchiveReferences(InstallMonitor var1) throws CoreException;

    public abstract ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor var1) throws CoreException;

    public abstract ContentReference[] getPluginEntryArchiveReferences(IPluginEntry var1, InstallMonitor var2) throws CoreException;

    public abstract ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry var1, InstallMonitor var2) throws CoreException;

    public abstract ContentReference[] getFeatureEntryContentReferences(InstallMonitor var1) throws CoreException;

    public abstract ContentReference[] getPluginEntryContentReferences(IPluginEntry var1, InstallMonitor var2) throws CoreException;

    public abstract IVerifier getVerifier() throws CoreException;

    public class FileFilter {
        private String filterString = null;
        private IPath filterPath = null;

        public FileFilter(String filter) {
            this.filterString = filter;
            this.filterPath = new Path(filter);
        }

        public boolean accept(String name) {
            IPath noExtension;
            String fileName;
            if (name == null) {
                return false;
            }
            Path namePath = new Path(name);
            if (this.filterPath.lastSegment().indexOf(42) == -1) {
                return this.filterPath.equals((Object)namePath);
            }
            String extension = this.filterPath.getFileExtension();
            if (!extension.equals("*") ? !extension.equalsIgnoreCase(namePath.getFileExtension()) : !(fileName = (noExtension = this.filterPath.removeFileExtension()).lastSegment()).equals("*") && !namePath.lastSegment().startsWith(fileName)) {
                return false;
            }
            IPath p1 = namePath.removeLastSegments(1);
            IPath p2 = this.filterPath.removeLastSegments(1);
            return p1.equals((Object)p2);
        }
    }
}

