/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.util.imp.SSOUtils;
import com.sap.security.core.util.imp.Util;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class UMEAdapter {
    private static final String UMECONFIGOPTION = "ume.configuration.active";
    private static final String AUTH_NAME = "sap.security.auth.configuration.name";
    public static int USERID_MODE_PORTAL = 0;
    public static int USERID_MODE_ABAP = 1;
    private boolean umeConfigurationActive;
    private Map sharedState;
    private Properties options;
    private static IUMParameters umeProps = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMEAdapter(Map sharedState, Properties poptions) {
        block19: {
            block18: {
                this.umeConfigurationActive = false;
                this.sharedState = null;
                this.options = null;
                String METHOD = "constructor(Map, Properties)";
                try {
                    String secureCookie;
                    String cookieDomain;
                    String umeConfig;
                    if (ExceptionLogger.LOCATION.bePath()) {
                        ExceptionLogger.LOCATION.entering("constructor(Map, Properties)", new Object[]{sharedState, this.options});
                    }
                    boolean bl = this.umeConfigurationActive = null != (umeConfig = (String)((Hashtable)poptions).get(UMECONFIGOPTION)) && umeConfig.equalsIgnoreCase("true");
                    if (ExceptionLogger.LOCATION.beInfo()) {
                        ExceptionLogger.LOCATION.infoT("got [{0}]: [{1}]", new Object[]{UMECONFIGOPTION, new Boolean(this.umeConfigurationActive)});
                    }
                    this.options = new Properties();
                    ((Hashtable)this.options).putAll(poptions);
                    this.sharedState = sharedState;
                    String authentication_template = (String)sharedState.get(AUTH_NAME);
                    if (authentication_template != null) {
                        String authscheme_name = "default";
                        IAuthScheme ias = InternalUMFactory.getAuthSchemeFactory().getAuthSchemeByAuthTemplate(authentication_template);
                        if (ias != null) {
                            authscheme_name = ias.getName();
                        } else if (ExceptionLogger.LOCATION.beWarning()) {
                            ExceptionLogger.LOCATION.warningT("no authscheme found that has auth template " + authentication_template);
                        }
                        this.options.setProperty("j_authscheme", authscheme_name);
                    }
                    if (umeProps == null) {
                        umeProps = UMFactory.getProperties();
                    }
                    String sid = null;
                    if (!this.umeConfigurationActive) {
                        sid = (String)this.sharedState.get("System-ID");
                        ((Hashtable)this.options).put("system", sid);
                        Object var17_8 = null;
                        break block18;
                    }
                    sid = umeProps.get("login.ticket_issuer", (String)this.sharedState.get("System-ID"));
                    String client = umeProps.get("login.ticket_client", "000");
                    ((Hashtable)this.options).put("system", sid);
                    ((Hashtable)this.options).put("client", client);
                    String ksKeyAlias = umeProps.get("login.ticket_keyalias", "testkey");
                    String ksView = umeProps.get("login.ticket_keystore", "ticketKeyStore");
                    ((Hashtable)this.options).put("password", "");
                    ((Hashtable)this.options).put("keystore", ksView);
                    ((Hashtable)this.options).put("alias", ksKeyAlias);
                    boolean includeCert = umeProps.getBoolean("login.ticket_include_cert", false);
                    ((Hashtable)this.options).put("inclcert", includeCert ? "1" : "0");
                    String strValid = umeProps.get("login.ticket_lifetime", "8");
                    String strValidHour = null;
                    String strValidMin = null;
                    int idx = strValid.indexOf(58);
                    if (idx > 0) {
                        strValidHour = strValid.substring(0, idx);
                        strValidMin = strValid.substring(idx + 1);
                    } else {
                        strValidHour = strValid;
                    }
                    try {
                        Integer.parseInt(strValidHour);
                        if (strValidMin != null) {
                            Integer.parseInt(strValidMin);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        strValidHour = "8";
                    }
                    ((Hashtable)this.options).put("validity", strValidHour);
                    if (null != strValidMin) {
                        ((Hashtable)this.options).put("validityMin", strValidMin);
                    }
                    if ((cookieDomain = umeProps.get("ume.logon.security.cookie_domain")) != null) {
                        ((Hashtable)this.options).put("ume.logon.security.cookie_domain", cookieDomain);
                    }
                    if ((secureCookie = umeProps.get("ume.logon.security.enforce_secure_cookie")) != null) {
                        ((Hashtable)this.options).put("ume.logon.security.enforce_secure_cookie", secureCookie);
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var17_10 = null;
                    if (!ExceptionLogger.LOCATION.bePath()) throw throwable;
                    ExceptionLogger.LOCATION.exiting((Object)new Object[]{this.options});
                    throw throwable;
                }
            }
            if (!ExceptionLogger.LOCATION.bePath()) return;
            ExceptionLogger.LOCATION.exiting((Object)new Object[]{this.options});
            return;
        }
        Object var17_9 = null;
        if (!ExceptionLogger.LOCATION.bePath()) return;
        ExceptionLogger.LOCATION.exiting((Object)new Object[]{this.options});
    }

    public boolean isUMEConfigurationActive() {
        return this.umeConfigurationActive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getMergedOptions() {
        Properties properties;
        String METHOD = "getMergedOptions()";
        try {
            ExceptionLogger.LOCATION.entering("getMergedOptions()");
            properties = this.options;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!ExceptionLogger.LOCATION.bePath()) throw throwable;
            ExceptionLogger.LOCATION.exiting((Object)new Object[]{this.options});
            throw throwable;
        }
        if (!ExceptionLogger.LOCATION.bePath()) return properties;
        ExceptionLogger.LOCATION.exiting((Object)new Object[]{this.options});
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMappedUser(String user) {
        String string;
        String userR3;
        block9: {
            String string2;
            block8: {
                String string3;
                block7: {
                    String METHOD = "getMappedUser()";
                    userR3 = null;
                    try {
                        if (ExceptionLogger.LOCATION.bePath()) {
                            ExceptionLogger.LOCATION.entering("getMappedUser()", new Object[]{user});
                        }
                        if (user == null) {
                            string3 = null;
                            Object var9_5 = null;
                            break block7;
                        }
                        if (!this.umeConfigurationActive) {
                            string2 = user;
                            break block8;
                        }
                        try {
                            IUser userUME = UMFactory.getUserFactory().getUserByLogonID(user);
                            userR3 = UMFactory.getUserMapping().getR3UserName(userUME, null, false);
                        }
                        catch (UMException umex) {
                            String string4 = null;
                            Object var9_7 = null;
                            if (!ExceptionLogger.LOCATION.bePath()) return string4;
                            ExceptionLogger.LOCATION.exiting((Object)new Object[]{userR3});
                            return string4;
                        }
                        string = userR3;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (!ExceptionLogger.LOCATION.bePath()) throw throwable;
                        ExceptionLogger.LOCATION.exiting((Object)new Object[]{userR3});
                        throw throwable;
                    }
                }
                if (!ExceptionLogger.LOCATION.bePath()) return string3;
                ExceptionLogger.LOCATION.exiting((Object)new Object[]{userR3});
                return string3;
            }
            Object var9_6 = null;
            if (!ExceptionLogger.LOCATION.bePath()) return string2;
            ExceptionLogger.LOCATION.exiting((Object)new Object[]{userR3});
            return string2;
        }
        Object var9_8 = null;
        if (!ExceptionLogger.LOCATION.bePath()) return string;
        ExceptionLogger.LOCATION.exiting((Object)new Object[]{userR3});
        return string;
    }

    public void setTicketAsCookie(CallbackHandler callbackHandler, String ticket, String user) throws LoginException {
        String METHOD = "setTicketAsCookie()";
        try {
            String secureCookie;
            String httpOnlyCookie;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("setTicketAsCookie()", new Object[]{callbackHandler, ticket});
            }
            HttpSetterCallback setCookieCb = new HttpSetterCallback();
            setCookieCb.setType((byte)1);
            setCookieCb.setName("Set-Cookie");
            StringBuffer cookieValue = new StringBuffer("MYSAPSSO2=");
            cookieValue.append(ticket);
            cookieValue.append(";path=/");
            HttpGetterCallback userAgentCb = new HttpGetterCallback();
            userAgentCb.setType((byte)1);
            userAgentCb.setName("User-Agent");
            HttpGetterCallback serverNameCb = new HttpGetterCallback();
            serverNameCb.setType((byte)1);
            serverNameCb.setName("Host");
            Callback[] getterArray = new Callback[]{userAgentCb, serverNameCb};
            try {
                callbackHandler.handle(getterArray);
            }
            catch (IOException ioe) {
                throw new DetailedLoginException(ioe.getMessage(), 18);
            }
            catch (UnsupportedCallbackException uce) {
                throw new DetailedLoginException(uce.getMessage(), 10);
            }
            String serverName = (String)serverNameCb.getValue();
            String userAgent = (String)userAgentCb.getValue();
            if (serverName == null) {
                if (ExceptionLogger.LOCATION.beDebug()) {
                    ExceptionLogger.LOCATION.debugT(ExceptionLogger.CATEGORY, "HttpGetterCallback (http header 'host') returns null. Cannot set cookie.");
                }
                throw new LoginException("Cannot get remote host header field.");
            }
            String cookieDomain = UMFactory.getProperties().get("ume.logon.security.cookie_domain", SSOUtils.getSSOCookieDomain((String)userAgent, (String)serverName));
            if (cookieDomain != null) {
                cookieValue.append(";domain=" + cookieDomain);
            }
            if ((httpOnlyCookie = (String)((Hashtable)this.options).get("ume.logon.httponlycookie")) != null && httpOnlyCookie.equalsIgnoreCase("true")) {
                cookieValue.append(";HttpOnly");
            }
            if ((secureCookie = (String)((Hashtable)this.options).get("ume.logon.security.enforce_secure_cookie")) != null && secureCookie.equalsIgnoreCase("true")) {
                cookieValue.append(";secure");
            }
            setCookieCb.setValue((Object)cookieValue.toString());
            Callback[] setterArray = new Callback[]{setCookieCb};
            try {
                callbackHandler.handle(setterArray);
                if (ExceptionLogger.LOCATION.beInfo()) {
                    ExceptionLogger.LOCATION.infoT("header set: " + cookieValue);
                }
            }
            catch (IOException ioe) {
                throw new DetailedLoginException(ioe.getMessage(), 18);
            }
            catch (UnsupportedCallbackException uce) {
                throw new DetailedLoginException(uce.getMessage(), 10);
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
    }

    public void setMappedUser() {
        if (!this.isUMEConfigurationActive()) {
            return;
        }
        String umeUser = null;
        String abapUser = null;
        String loginUser = (String)this.sharedState.get("javax.security.auth.login.name");
        if (loginUser != null) {
            abapUser = this.getMappedUser(loginUser);
            if (this.usePortalUserId()) {
                umeUser = loginUser;
            }
        }
        if (umeUser != null) {
            ((Hashtable)this.options).put("user", umeUser);
        } else {
            ((Hashtable)this.options).remove("user");
        }
        if (abapUser != null) {
            ((Hashtable)this.options).put("mappeduser", abapUser);
        }
    }

    public boolean usePortalUserId() {
        String mode = umeProps.get("login.ticket_portalid", "auto");
        boolean bResult = false;
        if (mode.equalsIgnoreCase("auto")) {
            bResult = !Util.isRepositoryAvailable((int)1) || Util.isRepositoryAvailable((int)2);
        } else if (mode.equalsIgnoreCase("yes")) {
            bResult = true;
        } else if (mode.equalsIgnoreCase("no")) {
            bResult = false;
        } else {
            throw new IllegalStateException("Illegal configuration state discovered: UME param login.ticket_portalid=" + mode);
        }
        return bResult;
    }
}

