/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.keystore.KeystoreManager;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPAuthenticationAssertionTicket;
import com.sap.security.core.server.util0.LRUHashMap;
import com.sap.security.core.ticket.imp.Ticket;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompoundName;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.security.auth.login.LoginException;

public class SAPLogonTicketHelper {
    public static MessageDigest mDigest = null;
    protected static final String AUTH_NAME = "sap.security.auth.configuration.name";
    private static final int DEFAULTCACHESIZE = 1000;
    private static KeystoreManager m_manager = null;
    private static LRUHashMap m_usercache;
    private static int m_currentCacheSize;
    private static int m_neededCacheSize;

    public static void evaluateTicket(Ticket ticket, Map ticketProps) throws Exception {
        String METHOD = "evaluateTicket() with ticket: {0} \n and options: {1}.";
        try {
            Ticket sapLogonTicket;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("evaluateTicket() with ticket: {0} \n and options: {1}.", new Object[]{ticket, ticketProps});
            }
            String ownID = (String)ticketProps.get("system");
            String ownClient = (String)ticketProps.get("client");
            try {
                if (ticket == null) {
                    DetailedLoginException exception = new DetailedLoginException("Received no ticket for ticket evaluation.", 7);
                    throw (LoginException)exception;
                }
                if (ticketProps == null) {
                    DetailedLoginException exception = new DetailedLoginException("Received no properties for ticket evaluation.", 7);
                    throw (LoginException)exception;
                }
                sapLogonTicket = ticket;
                if (ticketProps.get("debug") != null && ((String)ticketProps.get("debug")).equalsIgnoreCase("1")) {
                    sapLogonTicket.debug = true;
                }
                X509Certificate[] certs = (X509Certificate[])ticketProps.get("certificates");
                sapLogonTicket.setCertificates((java.security.cert.X509Certificate[])certs);
                sapLogonTicket.setMode(0);
                sapLogonTicket.verify();
            }
            catch (DetailedLoginException e) {
                throw e;
            }
            catch (Exception e) {
                DetailedLoginException exception = new DetailedLoginException(ExceptionLogger.getStackTrace(e), 7);
                throw (LoginException)exception;
            }
            String ticketSystemId = sapLogonTicket.getSystemID().trim();
            String ticketClient = sapLogonTicket.getSystemClient().trim();
            X509Certificate ticketSignerCertificate = sapLogonTicket.getSignerCertificate();
            if (!(ownID.equals(ticketSystemId) && ownClient.equals(ticketClient) && ticketSignerCertificate.equals(ticketProps.get("cert")))) {
                if (ExceptionLogger.LOCATION.beInfo()) {
                    ExceptionLogger.LOCATION.infoT("The recieved SAP Logon Ticket is not created on this sytem. This system is with system id {0}, client {1} and signer certificate {2}. The ticket issuing system is: system ID - [{3}], client - [{4}], and signer certificate - [{5}]. Authentication stack: [{6}].  Check the login module options and UME properties.", new Object[]{ownID, ownClient, ticketProps.get("cert"), ticketSystemId, ticketClient, ticketSignerCertificate, ticketProps.get(AUTH_NAME)});
                }
                if (!SAPLogonTicketHelper.isSystemTrusted(ticketProps, ticketSystemId, ticketClient, ticketSignerCertificate)) {
                    DetailedLoginException exception = new DetailedLoginException("Authentication failed: Issuer of SAP Logon Ticket is not trusted. Authentication stack: " + ticketProps.get(AUTH_NAME), 7);
                    throw (LoginException)exception;
                }
                if (ExceptionLogger.LOCATION.beDebug()) {
                    ExceptionLogger.LOCATION.debugT("OK: The recieved SAP Logon Ticket is trusted. Authentication stack: [{0}].", new Object[]{ticketProps.get(AUTH_NAME)});
                }
            } else if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("OK: The recieved SAP Logon Ticket is created on the same system. Authentication stack: [{0}].", new Object[]{ticketProps.get(AUTH_NAME)});
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
    }

    public static Ticket createTicket(Map ticketProps) throws Exception {
        Ticket ticket;
        String METHOD = "createTicket()";
        try {
            Object o;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("createTicket()", new Object[]{ticketProps});
            }
            Ticket sapLogonTicket = null;
            String strValid = null;
            String strValidMin = null;
            if (ticketProps == null) {
                DetailedLoginException exception = new DetailedLoginException("Received no properties for ticket evaluation. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
                throw (LoginException)exception;
            }
            String system = (String)ticketProps.get("system");
            if (system == null) {
                throw new DetailedLoginException("Issuing system needs to be specified. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            String client = (String)ticketProps.get("client");
            if (client == null) {
                throw new DetailedLoginException("Issuing client needs to be specified. Check the login module options and UME properties. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            String user = (String)ticketProps.get("user");
            String mappeduser = (String)ticketProps.get("mappeduser");
            PrivateKey key = (PrivateKey)ticketProps.get("key");
            X509Certificate cert = (X509Certificate)ticketProps.get("cert");
            if (key == null || cert == null) {
                throw new DetailedLoginException("Signing keypair needs to be specified. Check the login module options and UME properties. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            sapLogonTicket = new Ticket();
            if (ticketProps.get("debug") != null && ((String)ticketProps.get("debug")).equalsIgnoreCase("1")) {
                sapLogonTicket.debug = true;
            }
            sapLogonTicket.setPrivateKeyPair(key, cert);
            sapLogonTicket.setMode(Ticket.MODE_CREATE);
            if (user != null) {
                InfoUnit iuUserID = new InfoUnit(32, InfoUnit.jcharToUTF8((String)("portal:" + user)));
                sapLogonTicket.addInfoUnit(iuUserID);
            }
            InfoUnit iuAuthscheme = new InfoUnit(136, InfoUnit.jcharToUTF8((String)((o = ticketProps.get("j_authscheme")) == null ? "default" : (String)o)));
            sapLogonTicket.addInfoUnit(iuAuthscheme);
            if (mappeduser != null) {
                sapLogonTicket.setUser(mappeduser);
                if (ExceptionLogger.LOCATION.beDebug()) {
                    ExceptionLogger.LOCATION.debugT("Mapped user [{0}] set in SAP Logon Ticket. The authenticated user is [{1}]. Authentication stack: [{2}].", new Object[]{mappeduser, user, ticketProps.get(AUTH_NAME)});
                }
            } else if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("No mapped user set in SAP Logon Ticket. The authenticated user is [{0}]. Authentication stack: [{1}].", new Object[]{user, ticketProps.get(AUTH_NAME)});
            }
            sapLogonTicket.setSystemClient(client);
            sapLogonTicket.setSystemID(system);
            if (ticketProps.get("inclcert") != null) {
                sapLogonTicket.setIncludeOwnCert(((String)ticketProps.get("inclcert")).equals("1"));
            }
            strValid = (String)ticketProps.get("validity");
            strValidMin = (String)ticketProps.get("validityMin");
            if (null != strValid) {
                sapLogonTicket.setValidTime(Integer.parseInt(strValid));
            }
            if (null != strValidMin) {
                sapLogonTicket.setValidTimeMin(Integer.parseInt(strValidMin));
            }
            sapLogonTicket.create();
            ticket = sapLogonTicket;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
        return ticket;
    }

    public static SAPAuthenticationAssertionTicket createAssertionTicket(Map ticketProps) throws Exception {
        SAPAuthenticationAssertionTicket sAPAuthenticationAssertionTicket;
        String METHOD = "createAssertionTicket()";
        try {
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("createAssertionTicket()", new Object[]{ticketProps});
            }
            SAPAuthenticationAssertionTicket sapAssertionTicket = null;
            String strValid = null;
            String strValidMin = null;
            if (ticketProps == null) {
                DetailedLoginException exception = new DetailedLoginException("Received no properties for ticket evaluation. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
                throw (LoginException)exception;
            }
            String system = (String)ticketProps.get("system");
            if (system == null) {
                throw new DetailedLoginException("Issuing system needs to be specified. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            String client = (String)ticketProps.get("client");
            if (client == null) {
                throw new DetailedLoginException("Issuing client needs to be specified. Check the login module options and UME properties. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            String user = (String)ticketProps.get("user");
            if (user == null) {
                throw new DetailedLoginException("User needs to be specified. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            String mappeduser = (String)ticketProps.get("mappeduser");
            PrivateKey key = (PrivateKey)ticketProps.get("key");
            X509Certificate cert = (X509Certificate)ticketProps.get("cert");
            if (key == null || cert == null) {
                throw new DetailedLoginException("Signing keypair needs to be specified. Check the login module options and UME properties. Authentication stack: " + ticketProps.get(AUTH_NAME), 8);
            }
            sapAssertionTicket = new SAPAuthenticationAssertionTicket();
            if (ticketProps.get("debug") != null && ((String)ticketProps.get("debug")).equalsIgnoreCase("1")) {
                sapAssertionTicket.debug = true;
            }
            sapAssertionTicket.setPrivateKeyPair(key, cert);
            sapAssertionTicket.setMode(Ticket.MODE_CREATE);
            InfoUnit iuUserID = new InfoUnit(32, InfoUnit.jcharToUTF8((String)("portal:" + user)));
            sapAssertionTicket.addInfoUnit(iuUserID);
            Object o = ticketProps.get("j_authscheme");
            InfoUnit iuAuthscheme = new InfoUnit(136, InfoUnit.jcharToUTF8((String)(o == null ? "default" : (String)o)));
            sapAssertionTicket.addInfoUnit(iuAuthscheme);
            if (mappeduser != null) {
                sapAssertionTicket.setUser(mappeduser);
            }
            sapAssertionTicket.setSystemClient(client);
            sapAssertionTicket.setSystemID(system);
            if (ticketProps.get("inclcert") != null) {
                sapAssertionTicket.setIncludeOwnCert(((String)ticketProps.get("inclcert")).equals("1"));
            }
            strValid = (String)ticketProps.get("validity");
            strValidMin = (String)ticketProps.get("validityMin");
            if (null != strValid) {
                sapAssertionTicket.setValidTime(Integer.parseInt(strValid));
            }
            if (null != strValidMin) {
                sapAssertionTicket.setValidTimeMin(Integer.parseInt(strValidMin));
            }
            sapAssertionTicket.setDoNotCacheTicket(true);
            sapAssertionTicket.create();
            sAPAuthenticationAssertionTicket = sapAssertionTicket;
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
        return sAPAuthenticationAssertionTicket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSystemTrusted(Map props, String sys, String client, X509Certificate signerCert) {
        boolean bl;
        Boolean b;
        block20: {
            boolean bl2;
            block17: {
                boolean bl3;
                block18: {
                    block19: {
                        String METHOD = "isSystemTrusted()";
                        b = null;
                        try {
                            if (ExceptionLogger.LOCATION.bePath()) {
                                ExceptionLogger.LOCATION.entering("isSystemTrusted()", new Object[]{props, sys, client, signerCert});
                            }
                            Object[] keys = props.keySet().toArray();
                            int k = 0;
                            int i = 0;
                            while (true) {
                                if (i >= keys.length) {
                                    if (k != 0) break;
                                    if (ExceptionLogger.LOCATION.beWarning()) {
                                        ExceptionLogger.LOCATION.warningT("No trusted systems are configured in EvaluateTicketLoginModule options in [{0}] authentication stack. The ticket issuing system is: system ID - [{1}], client - [{2}], certificate with issuer DN - [{3}] and subject DN - [{4}].", new Object[]{props.get(AUTH_NAME), sys, client, signerCert.getIssuerDN().getName(), signerCert.getSubjectDN().getName()});
                                    }
                                    bl2 = false;
                                    break block17;
                                }
                                if (((String)keys[i]).startsWith("trustedsys")) {
                                    ++k;
                                    String token = ((String)keys[i]).substring(10);
                                    String optionSYS = (String)props.get("trustedsys" + token);
                                    String optionISS = (String)props.get("trustediss" + token);
                                    String optionDN = (String)props.get("trusteddn" + token);
                                    if (optionSYS != null && optionISS != null && optionDN != null) {
                                        int seperator = optionSYS.indexOf(",");
                                        String optionSysID = optionSYS.substring(0, seperator).trim();
                                        String optionSysClient = optionSYS.substring(seperator + 1).trim();
                                        CompoundName compDN = null;
                                        CompoundName compDNCert = null;
                                        CompoundName compISS = null;
                                        CompoundName compISSCert = null;
                                        Properties syntax = new Properties();
                                        syntax.setProperty("jndi.syntax.direction", "right_to_left");
                                        syntax.setProperty("jndi.syntax.escape", "\\");
                                        syntax.setProperty("jndi.syntax.trimblanks", "true");
                                        syntax.setProperty("jndi.syntax.separator", ",");
                                        try {
                                            compDNCert = new CompoundName(signerCert.getSubjectDN().getName(), syntax);
                                            compISSCert = new CompoundName(signerCert.getIssuerDN().getName(), syntax);
                                            compDN = new CompoundName(optionDN, syntax);
                                            compISS = new CompoundName(optionISS, syntax);
                                        }
                                        catch (InvalidNameException e) {
                                            e.printStackTrace();
                                        }
                                        if (compDN.equals(compDNCert) && compISS.equals(compISSCert) && optionSysID.equalsIgnoreCase(sys) && optionSysClient.equalsIgnoreCase(client)) {
                                            if (ExceptionLogger.LOCATION.beInfo()) {
                                                ExceptionLogger.LOCATION.infoT("OK: The system defined in the ACL of EvaluateTicketLoginModule in [{0}] authentication stack under the name [trustedsys{1}] equals SAP Logon Ticket issuing sistem. The system in the ACL is: system ID - [{2}], client - [{3}], certificate with issuer DN - [{4}] and subject DN - [{5}]. SAP Logon Ticket issuing system is: system ID - [{6}], client - [{7}], certificate with issuer DN - [{8}] and subject DN - [{9}].", new Object[]{props.get(AUTH_NAME), token, optionSysID, optionSysClient, optionISS, optionDN, sys, client, signerCert.getIssuerDN().getName(), signerCert.getSubjectDN().getName()});
                                            }
                                            b = new Boolean(true);
                                            bl3 = true;
                                            Object var23_25 = null;
                                            if (b == null) break block18;
                                            break block19;
                                        }
                                        if (ExceptionLogger.LOCATION.beInfo()) {
                                            ExceptionLogger.LOCATION.infoT("The system defined in the ACL of EvaluateTicketLoginModule in [{0}] authentication stack under the name [trustedsys{1}] does not equal to SAP Logon Ticket issuing sistem. The system in the ACL is: system ID - [{2}], client - [{3}], certificate with issuer DN - [{4}] and subject DN - [{5}]. SAP Logon Ticket issuing system is: system ID - [{6}], client - [{7}], certificate with issuer DN - [{8}] and subject DN - [{9}]. Check the login module options and UME properties.", new Object[]{props.get(AUTH_NAME), token, optionSysID, optionSysClient, optionISS, optionDN, sys, client, signerCert.getIssuerDN().getName(), signerCert.getSubjectDN().getName()});
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (ExceptionLogger.LOCATION.beWarning()) {
                                ExceptionLogger.LOCATION.warningT("None of the systems defined in the ACL of EvaluateTicketLoginModule in [{0}] authentication stack equals to SAP Logon Ticket issuing system. The ticket issuing system is: system ID - [{1}], client - [{2}], certificate with issuer DN - [{3}] and subject DN - [{4}].", new Object[]{props.get(AUTH_NAME), sys, client, signerCert.getIssuerDN().getName(), signerCert.getSubjectDN().getName()});
                            }
                            b = new Boolean(false);
                            bl = false;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var23_28 = null;
                            if (b != null) {
                                ExceptionLogger.LOCATION.exiting(b);
                                throw throwable;
                            }
                            ExceptionLogger.LOCATION.exiting();
                            throw throwable;
                        }
                    }
                    ExceptionLogger.LOCATION.exiting((Object)b);
                    return bl3;
                }
                ExceptionLogger.LOCATION.exiting();
                return bl3;
            }
            Object var23_26 = null;
            if (b != null) {
                ExceptionLogger.LOCATION.exiting((Object)b);
                return bl2;
            }
            ExceptionLogger.LOCATION.exiting();
            return bl2;
        }
        Object var23_27 = null;
        if (b != null) {
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl;
        }
        ExceptionLogger.LOCATION.exiting();
        return bl;
    }

    static void setCacheSize(int size) {
        m_neededCacheSize = size;
    }

    static void resetCache(int size) {
        m_usercache = new LRUHashMap(size);
        m_currentCacheSize = size;
        m_neededCacheSize = size;
    }

    static LRUHashMap getCache() {
        if (m_neededCacheSize == 0) {
            m_neededCacheSize = 1000;
        }
        if (m_currentCacheSize != m_neededCacheSize) {
            SAPLogonTicketHelper.resetCache(m_neededCacheSize);
        }
        if (m_usercache != null) {
            return m_usercache;
        }
        SAPLogonTicketHelper.resetCache(m_neededCacheSize);
        return m_usercache;
    }

    static String getCacheKey(String token) throws NoSuchAlgorithmException, NoSuchProviderException {
        Security.addProvider((Provider)new IAIK());
        if (mDigest == null) {
            mDigest = MessageDigest.getInstance("MD5", "IAIK");
        }
        String key = null;
        MessageDigest messageDigest = mDigest;
        synchronized (messageDigest) {
            mDigest.reset();
            key = new String(mDigest.digest(token.getBytes()));
        }
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static KeyStore getTicketKeyStore(String keystore, String password, Map options) throws Exception {
        Object ctx;
        String METHOD = "getTicketKeyStore()";
        try {
            try {
                if (ExceptionLogger.LOCATION.bePath()) {
                    ExceptionLogger.LOCATION.entering("getTicketKeyStore()", new Object[]{keystore, password});
                }
                if (m_manager == null) {
                    ctx = null;
                    ctx = new InitialContext();
                    Object o = ((InitialContext)ctx).lookup("keystore");
                    m_manager = (KeystoreManager)o;
                }
                ctx = m_manager.getKeystore(keystore);
                Object var7_7 = null;
            }
            catch (Exception e) {
                if ("TicketKeystore".equals(keystore)) {
                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Error in retrieving keystore view [{0}]. This is the default keystore view used for SSO with SAP Logon Ticket. The keystore view does not exist or not everyone has permission to read it.", new Object[]{keystore});
                } else {
                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Error in retrieving keystore view [{0}]. The keystore view does not exist or not everyone has permission to read it. The default keystore view for SSO with SAP Logon Ticket is [{1}]. Check the login module options in [{2}] authentication stack and UME properties.", new Object[]{keystore, "TicketKeystore", options.get(AUTH_NAME)});
                }
                ExceptionLogger.LOCATION.traceThrowableT(500, "Error in retrieving keystore view [{0}] for SAP Logon Ticket in [{1}] authentication stack.", new Object[]{keystore, options.get(AUTH_NAME)}, (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
        return ctx;
    }

    static Vector getTrustedCerts(KeyStore store) throws Exception {
        Vector<Certificate> certs = null;
        String entry = null;
        certs = new Vector<Certificate>();
        Enumeration<String> enumeration = store.aliases();
        while (enumeration.hasMoreElements()) {
            entry = enumeration.nextElement();
            if (store.isCertificateEntry(entry)) {
                certs.add(store.getCertificate(entry));
            }
            if (!store.isKeyEntry(entry)) continue;
            Certificate[] trustCerts = store.getCertificateChain(entry);
            int i = 0;
            while (i < trustCerts.length) {
                certs.add(trustCerts[i]);
                ++i;
            }
        }
        return certs;
    }

    public static String replaceSpecialChar(String value) {
        StringBuffer replaced_cookie = new StringBuffer(value);
        int i = 0;
        while (i < replaced_cookie.length()) {
            if (replaced_cookie.charAt(i) == '+') {
                replaced_cookie.replace(i, i + 1, "%2B");
            } else if (replaced_cookie.charAt(i) == '/') {
                replaced_cookie.replace(i, i + 1, "%2F");
            } else if (replaced_cookie.charAt(i) == '=') {
                replaced_cookie.replace(i, i + 1, "%3D");
            }
            ++i;
        }
        return replaced_cookie.toString();
    }

    public static String undoReplaceChar(String value) {
        if (value != null && value.length() > 0) {
            while (value.indexOf(37) != -1) {
                value = URLDecoder.decode(value);
            }
        }
        return value;
    }

    protected static String removeEndingSpaces(String string) {
        int length = string.length();
        int i = length - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(string.charAt(i))) break;
            --i;
        }
        if (i == length - 1) {
            return string;
        }
        return string.substring(0, i + 1);
    }

    static {
        m_currentCacheSize = 0;
        m_neededCacheSize = 0;
    }
}

