/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.security.core.server.jaas.ExceptionLogger;
import java.io.Serializable;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.GenericCredential;

public class SAPLogonTicketCredential
implements GenericCredential,
Serializable {
    private static String OID = "1.3.6.1.4.1.694.2.1.3";
    private String mLogonTicket;
    private String mName;

    public SAPLogonTicketCredential(String ticket, String name) {
        this.mLogonTicket = ticket;
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public String getMechType() {
        return OID;
    }

    public byte[] getCredentialData() throws SecurityException {
        return this.mLogonTicket.getBytes();
    }

    public boolean equals(Object ticketCredential) {
        if (!(ticketCredential instanceof SAPLogonTicketCredential)) {
            return false;
        }
        try {
            String otherLogonTicket = new String(((GenericCredential)ticketCredential).getCredentialData());
            return otherLogonTicket.equals(this.mLogonTicket);
        }
        catch (SecurityException e) {
            e.fillInStackTrace();
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT(ExceptionLogger.getStackTrace(e));
            }
            return false;
        }
    }

    public int hashCode() {
        return this.mLogonTicket.hashCode();
    }
}

