/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPLogonTicketCredential;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.GenericCredential;

public class SAPAuthenticationAssertionTicketCredential
extends SAPLogonTicketCredential {
    private static String OID = "1.3.6.1.4.1.694.2.1.3.1";
    private String assertionTicket;

    public SAPAuthenticationAssertionTicketCredential(String ticket, String name) {
        super(ticket, name);
        this.assertionTicket = ticket;
    }

    public String getMechType() {
        return OID;
    }

    public boolean equals(Object ticketCredential) {
        if (!(ticketCredential instanceof SAPAuthenticationAssertionTicketCredential)) {
            return false;
        }
        try {
            String otherAssertionTicket = new String(((GenericCredential)ticketCredential).getCredentialData());
            return otherAssertionTicket.equals(this.assertionTicket);
        }
        catch (SecurityException e) {
            e.fillInStackTrace();
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT(ExceptionLogger.getStackTrace(e));
            }
            return false;
        }
    }
}

