/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.security.api.UMFactory;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPLogonTicketHelper;
import com.sap.security.core.server.jaas.UMEAdapter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class HeaderVariableLoginModule
extends AbstractLoginModule {
    private static final String WINDOWS_INTEGRATED = "windows_integrated";
    private static final String HEADER = "Header";
    private static final String ALLOWED_DOMAINS = "domain";
    private String _header_name;
    private String _user_name;
    private boolean _b_succeeded = false;
    private boolean _b_windows_integrated = false;
    private boolean _b_windows_integrated_md = false;
    private HashSet _allowed_domains = new HashSet();
    protected UMEAdapter _ume_adapter;
    protected Map _shared_state;
    protected Map _options;
    protected CallbackHandler _callback_handler;
    protected Subject _subject;
    static int SEVERITY = 300;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        ExceptionLogger.LOCATION.entering(new Object[]{subject, handler, sharedState, options});
        try {
            Properties props = new Properties();
            ((Hashtable)props).putAll(options);
            this._options = options;
            this._shared_state = sharedState;
            this._callback_handler = handler;
            this._subject = subject;
            this._ume_adapter = new UMEAdapter(sharedState, props);
            this._header_name = (String)options.get(HEADER);
            if (this._header_name == null && this._ume_adapter.isUMEConfigurationActive()) {
                this._header_name = UMFactory.getProperties().get("ume.logon.header", "REMOTE_USER");
            }
            if (options.get(WINDOWS_INTEGRATED) != null && "true".equalsIgnoreCase((String)options.get(WINDOWS_INTEGRATED))) {
                this._b_windows_integrated = true;
                String windowsdomain = (String)options.get(ALLOWED_DOMAINS);
                if (windowsdomain != null) {
                    StringTokenizer st = new StringTokenizer(windowsdomain, ",");
                    while (st.hasMoreTokens()) {
                        this._allowed_domains.add(st.nextToken().trim());
                    }
                }
            }
            if (UMFactory.getProperties().getBoolean("ume.ldap.access.multidomain.enabled", false)) {
                this._b_windows_integrated_md = true;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
    }

    public boolean login() throws LoginException {
        HttpGetterCallback hgc = new HttpGetterCallback();
        Exception onthewayexc = null;
        hgc.setName(this._header_name);
        hgc.setType((byte)1);
        try {
            this._callback_handler.handle(new Callback[]{hgc});
        }
        catch (IOException e) {
            onthewayexc = e;
        }
        catch (UnsupportedCallbackException e) {
            onthewayexc = e;
        }
        if (onthewayexc != null) {
            ExceptionLogger.log(400, onthewayexc);
            throw new LoginException(onthewayexc.toString());
        }
        this._user_name = (String)hgc.getValue();
        ExceptionLogger.LOCATION.debugT("login", "header {0} has value {1}", new Object[]{this._header_name, this._user_name});
        if (this._user_name != null) {
            if (this._b_windows_integrated) {
                if (this._b_windows_integrated_md) {
                    this._user_name = SAPLogonTicketHelper.removeEndingSpaces(this._user_name);
                } else {
                    String[] ud = this.parseUserAndDomain(this._user_name);
                    if (!(this._allowed_domains.size() <= 0 || ud[0] != null && this._allowed_domains.contains(ud[0]))) {
                        ExceptionLogger.LOCATION.errorT("login", "Domain " + ud[0] + " isn't part of allowed domains");
                        throw new LoginException("Domain " + ud[0] + " isn't part of allowed domains");
                    }
                    this._user_name = SAPLogonTicketHelper.removeEndingSpaces(ud[1]);
                }
            }
            this._shared_state.put("javax.security.auth.login.name", this._user_name);
            this.refreshUserInfo(this._user_name);
            this._b_succeeded = true;
        }
        ExceptionLogger.LOCATION.debugT("login", "login exits with {0}", new Object[]{this._b_succeeded ? Boolean.TRUE : Boolean.FALSE});
        return this._b_succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this._b_succeeded) {
            return false;
        }
        Principal p = new Principal(this._user_name);
        this._shared_state.put("javax.security.auth.login.principal", p);
        this._subject.getPrincipals().add((java.security.Principal)p);
        return true;
    }

    public boolean abort() throws LoginException {
        return false;
    }

    public boolean logout() throws LoginException {
        return false;
    }

    private String[] parseUserAndDomain(String remote_user) {
        StringTokenizer st = new StringTokenizer(remote_user, "\\");
        String d = st.nextToken();
        if (st.hasMoreTokens()) {
            String t = st.nextToken();
            return new String[]{d, t};
        }
        return new String[]{null, d};
    }
}

