/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.AuthSchemePrincipal;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.umap.NoLogonDataAvailableException;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPLogonTicketCredential;
import com.sap.security.core.server.jaas.SAPLogonTicketHelper;
import com.sap.security.core.server.jaas.UMEAdapter;
import com.sap.security.core.server.util0.LRUHashMap;
import com.sap.security.core.ticket.imp.Ticket;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class EvaluateTicketLoginModule
extends AbstractLoginModule {
    Subject m_subject;
    Map m_sharedState;
    CallbackHandler m_handler;
    Properties m_options = new Properties();
    SAPLogonTicketCredential m_credential = null;
    String m_ticketString = null;
    Principal m_principal = null;
    String m_authscheme = null;
    String m_authscheme_to_be;
    AuthSchemePrincipal m_authscheme_principal;
    boolean m_succeeded = false;
    Exception m_exception;
    private UMEAdapter m_umeadapter = null;
    private static final int DEFAULT_TIME_TOL = 3;
    private int m_timetolerance;
    String m_username;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        String METHOD = "initialize()";
        try {
            Object option;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("initialize()", new Object[]{subject, handler});
            }
            super.initialize(subject, handler, sharedState, options);
            this.m_subject = subject;
            this.m_handler = handler;
            this.m_sharedState = sharedState;
            ((Hashtable)this.m_options).putAll(options);
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of EvaluateTicketLoginModule in [{0}] authentication stack are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            this.m_umeadapter = new UMEAdapter(sharedState, this.m_options);
            this.m_options = this.m_umeadapter.getMergedOptions();
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.logT(100, "The options of EvaluateTicketLoginModule in [{0}] authentication stack after merge with UME properties are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            if ((option = ((Hashtable)this.m_options).get("keystore")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("keystore", "TicketKeystore");
            }
            if ((option = ((Hashtable)this.m_options).get("password")) == null) {
                ((Hashtable)this.m_options).put("password", "");
            }
            if ((option = ((Hashtable)this.m_options).get("alias")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("alias", "SAPLogonTicketKeypair");
            }
            if ((option = ((Hashtable)this.m_options).get("client")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("client", "000");
            }
            this.m_timetolerance = (option = (String)((Hashtable)this.m_options).get("timetolerance")) == null || option.equals("") ? 3 : Integer.parseInt((String)option);
            this.m_authscheme_to_be = (String)((Hashtable)this.m_options).get("j_authscheme");
            if (this.m_authscheme_to_be == null) {
                this.m_authscheme_to_be = "default";
            }
            if ((option = this.m_sharedState.get("sap.security.auth.configuration.name")) != null) {
                ((Hashtable)this.m_options).put("sap.security.auth.configuration.name", option);
            }
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of EvaluateTicketLoginModule in [{0}] authentication stack after adding the default values are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        boolean bl;
        Boolean b;
        block33: {
            boolean bl2;
            block32: {
                boolean bl3;
                block31: {
                    boolean bl4;
                    block30: {
                        String METHOD = "login()";
                        b = null;
                        try {
                            try {
                                java.security.cert.X509Certificate tempCert;
                                Vector certs;
                                ExceptionLogger.LOCATION.entering("login()");
                                Ticket ticket = null;
                                this.m_ticketString = SAPLogonTicketHelper.undoReplaceChar(this.getSAPLogonTicket());
                                if (this.m_ticketString == null || this.m_ticketString.equals("")) {
                                    if (ExceptionLogger.LOCATION.beInfo()) {
                                        ExceptionLogger.LOCATION.infoT("Received no SAPLogonTicket. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    bl4 = false;
                                    Object var16_7 = null;
                                    break block30;
                                }
                                ticket = new Ticket();
                                ticket.setTicket(this.m_ticketString);
                                if (ExceptionLogger.LOCATION.beInfo()) {
                                    ExceptionLogger.LOCATION.infoT("SAP Logon Ticket received. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("Ticket: \n [{0}]. Authentication stack: [{1}].", new Object[]{ticket.toString(), this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                LRUHashMap cache = SAPLogonTicketHelper.getCache();
                                String cacheKey = null;
                                cacheKey = SAPLogonTicketHelper.getCacheKey(this.m_ticketString);
                                if (!ticket.isValid(this.m_timetolerance)) {
                                    if (ExceptionLogger.LOCATION.beInfo()) {
                                        ExceptionLogger.LOCATION.infoT("SAP Logon Ticket has expired or it is not valid yet. The ticket is valid from {0} until {1} and now it is {2}. Authentication stack: [{3}].", new Object[]{ticket.getStartValidDate().getTime(), ticket.getExpirationDate().getTime(), Calendar.getInstance(new SimpleTimeZone(0, "GMT")).getTime(), this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    if (cache.containsKey(cacheKey)) {
                                        cache.remove((Object)cacheKey);
                                        if (ExceptionLogger.LOCATION.beDebug()) {
                                            ExceptionLogger.LOCATION.debugT("User has been removed from cache.");
                                        }
                                    }
                                    this.setSSOCookie("", "");
                                    this.m_succeeded = false;
                                    b = new Boolean(false);
                                    bl3 = false;
                                    break block31;
                                }
                                if (cache.containsKey(cacheKey)) {
                                    if (ExceptionLogger.LOCATION.beDebug()) {
                                        ExceptionLogger.LOCATION.debugT("Authentication succeeded.");
                                    }
                                    this.m_username = (String)cache.get((Object)cacheKey);
                                    if (ExceptionLogger.LOCATION.beDebug()) {
                                        ExceptionLogger.LOCATION.debugT("User [{0}] found in cache. Authentication stack: [{1}].", new Object[]{this.m_username, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    this.refreshUserInfo(this.m_username);
                                    ticket.setEnforceVerify(false);
                                    this.getAuthschemeFromTicket(ticket);
                                    if (ExceptionLogger.LOCATION.beInfo()) {
                                        ExceptionLogger.LOCATION.infoT("Ticket contains authscheme [{0}]. Authentication stack: [{1}].", new Object[]{this.m_authscheme, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    this.verifyAuthschemesOk();
                                    this.m_succeeded = true;
                                    b = new Boolean(true);
                                    bl2 = true;
                                    break block32;
                                }
                                String sid = (String)this.m_sharedState.get("System-ID");
                                if (sid == null) {
                                    this.m_exception = new DetailedLoginException("Can not continue. Own SID not available.", 7);
                                    throw (LoginException)this.m_exception;
                                }
                                ((Hashtable)this.m_options).put("system", sid);
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("Found SID: [{0}].", new Object[]{sid});
                                }
                                String keystore = (String)((Hashtable)this.m_options).get("keystore");
                                String password = (String)((Hashtable)this.m_options).get("password");
                                String alias = (String)((Hashtable)this.m_options).get("alias");
                                KeyStore store = SAPLogonTicketHelper.getTicketKeyStore(keystore, password, this.m_options);
                                if (store == null) {
                                    if (!ExceptionLogger.LOCATION.beWarning()) throw new DetailedLoginException("Keystore view for ticket evaluation does not exist or has no entries.", 7);
                                    ExceptionLogger.LOCATION.warningT("Keystore view [{0}] does not exist or has no entries. The default keystore is [{1}]. Authentication stack: [{2}]. Check the login module options and UME properties.", new Object[]{keystore, "TicketKeystore", this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    throw new DetailedLoginException("Keystore view for ticket evaluation does not exist or has no entries.", 7);
                                }
                                try {
                                    certs = SAPLogonTicketHelper.getTrustedCerts(store);
                                }
                                catch (Exception e) {
                                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "The certificates contained in keystore view [{0}] cannot be retrieved. Authentication stack: [{1}]. The default kestore view is [{2}]. The default keypair alias is [{3}]. Check the login module options and UME properties.", new Object[]{keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), "TicketKeystore", "SAPLogonTicketKeypair"});
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "The certificates contained in keystore view [{0}] cannot be retrieved. Authentication stack: [{1}].", new Object[]{keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                                    throw e;
                                }
                                try {
                                    tempCert = (java.security.cert.X509Certificate)store.getCertificate(alias);
                                }
                                catch (Exception e) {
                                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), "TicketKeystore", "SAPLogonTicketKeypair"});
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}].", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                                    throw e;
                                }
                                if (tempCert == null) {
                                    if (ExceptionLogger.CATEGORY.beWarning()) {
                                        ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Keypair for signing not found in keystore view [{0}] under alias [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{keystore, alias, this.m_sharedState.get("sap.security.auth.configuration.name"), "TicketKeystore", "SAPLogonTicketKeypair"});
                                    }
                                    this.m_exception = new DetailedLoginException("Signing key pair not found.", 7);
                                    throw (LoginException)this.m_exception;
                                }
                                X509Certificate cert = (X509Certificate)tempCert;
                                ((Hashtable)this.m_options).put("certificates", certs.toArray(new X509Certificate[0]));
                                ((Hashtable)this.m_options).put("cert", cert);
                                SAPLogonTicketHelper.evaluateTicket(ticket, this.m_options);
                                this.getUserFromTicket(ticket);
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("Ticket verify of user [{0}] is successful. Authentication stack: [{1}].", new Object[]{this.m_username, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                this.refreshUserInfo(this.m_username);
                                this.getAuthschemeFromTicket(ticket);
                                if (ExceptionLogger.LOCATION.beInfo()) {
                                    ExceptionLogger.LOCATION.infoT("Ticket contains authscheme [{0}]. Authentication stack: [{1}].", new Object[]{this.m_authscheme, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                this.verifyAuthschemesOk();
                                this.m_succeeded = true;
                                b = new Boolean(true);
                                bl = true;
                                break block33;
                            }
                            catch (Throwable e) {
                                if (e instanceof Error) {
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (Error)e;
                                }
                                if (e instanceof RuntimeException) {
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (RuntimeException)e;
                                }
                                if (e instanceof LoginException) {
                                    if (!ExceptionLogger.LOCATION.beWarning()) throw (LoginException)e;
                                    ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (LoginException)e;
                                }
                                if (!ExceptionLogger.LOCATION.beWarning()) throw new DetailedLoginException(e.toString(), 7);
                                ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                throw new DetailedLoginException(e.toString(), 7);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_11 = null;
                            ExceptionLogger.LOCATION.exiting(b);
                            throw throwable;
                        }
                    }
                    ExceptionLogger.LOCATION.exiting(b);
                    return bl4;
                }
                Object var16_8 = null;
                ExceptionLogger.LOCATION.exiting((Object)b);
                return bl3;
            }
            Object var16_9 = null;
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl2;
        }
        Object var16_10 = null;
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    private void verifyAuthschemesOk() throws LoginException {
        IAuthScheme is_authscheme = null;
        IAuthScheme should_authscheme = null;
        is_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(this.m_authscheme);
        should_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(this.m_authscheme_to_be);
        if (is_authscheme.getPriority() < should_authscheme.getPriority()) {
            if (ExceptionLogger.LOCATION.beInfo()) {
                ExceptionLogger.LOCATION.infoT("authscheme not sufficient: [{0}] < [{1}]. Authntication stack: [{2}]. Authenticated user: [{3}]", new Object[]{is_authscheme.getName(), should_authscheme.getName(), this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            throw new DetailedLoginException("authscheme not sufficient: " + is_authscheme.getName() + "<" + should_authscheme.getName(), 7);
        }
    }

    private void getAuthschemeFromTicket(Ticket ticket) {
        try {
            InfoUnit iu = ticket.getInfoUnit(136);
            this.m_authscheme = "default";
            if (iu != null) {
                this.m_authscheme = iu.getString("UTF8");
            }
        }
        catch (TicketException e) {
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("getAuthschemeFromTicket", "Ticket parsing problem. Authntication stack: [{0}]. Authenticated user: [{1}]", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            ExceptionLogger.log(400, e);
        }
        catch (UnsupportedEncodingException e) {
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("getAuthschemeFromTicket", "Encoding problem. Authntication stack: [{0}]. Authenticated user: [{1}]", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            ExceptionLogger.log(400, e);
        }
    }

    private void getUserFromTicket(Ticket ticket) throws UnsupportedEncodingException, TicketException, NoLogonDataAvailableException, UMException {
        if (this.m_umeadapter.usePortalUserId()) {
            this.m_username = ticket.getUser("portal");
        }
        if (this.m_username == null) {
            String user;
            String userid = ticket.getUser();
            if (userid != null) {
                userid = SAPLogonTicketHelper.removeEndingSpaces(userid);
            }
            if ((user = UMFactory.getUserMapping().getInverseMappingData(userid, null)) != null) {
                IUser iuser = UMFactory.getUserFactory().getUser(SAPLogonTicketHelper.removeEndingSpaces(user));
                this.m_username = iuser.getUserAccounts()[0].getLogonUid();
            } else if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("getUserFromTicket", "reverse mapping for " + userid + " not possible.");
            }
        } else {
            this.m_username = SAPLogonTicketHelper.removeEndingSpaces(this.m_username);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commit() throws LoginException {
        boolean bl;
        Boolean b;
        block10: {
            boolean bl2;
            block8: {
                block9: {
                    String METHOD = "commit()";
                    b = null;
                    try {
                        ExceptionLogger.LOCATION.entering("commit()");
                        if (!this.m_succeeded) {
                            this.m_username = null;
                            this.m_subject = null;
                            this.m_handler = null;
                            this.m_options = null;
                            this.m_ticketString = null;
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("Internal Login Module data has been reset.");
                            }
                            b = new Boolean(false);
                            bl2 = false;
                            Object var6_5 = null;
                            if (b == null) break block8;
                            break block9;
                        }
                        this.m_principal = new Principal(this.m_username);
                        this.m_subject.getPrincipals().add((java.security.Principal)this.m_principal);
                        if (ExceptionLogger.LOCATION.beInfo()) {
                            ExceptionLogger.LOCATION.infoT("Added principal [{0}] of class [{1}] to Subject.", new Object[]{this.m_username, this.m_username.getClass()});
                        }
                        String max_authscheme = this.getMaxAuthScheme(this.m_authscheme_to_be, this.m_authscheme);
                        this.m_authscheme_principal = new AuthSchemePrincipal(max_authscheme);
                        this.m_subject.getPrincipals().add((java.security.Principal)this.m_authscheme_principal);
                        this.m_credential = new SAPLogonTicketCredential(this.m_ticketString, this.m_username);
                        this.m_subject.getPrivateCredentials().add(this.m_credential);
                        if (ExceptionLogger.LOCATION.beDebug()) {
                            ExceptionLogger.LOCATION.debugT("SAP Logon Ticket added to private credentials.");
                        }
                        b = new Boolean(true);
                        bl = true;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (b != null) {
                            ExceptionLogger.LOCATION.exiting(b);
                            throw throwable;
                        }
                        ExceptionLogger.LOCATION.exiting();
                        throw throwable;
                    }
                }
                ExceptionLogger.LOCATION.exiting((Object)b);
                return bl2;
            }
            ExceptionLogger.LOCATION.exiting();
            return bl2;
        }
        Object var6_6 = null;
        if (b != null) {
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl;
        }
        ExceptionLogger.LOCATION.exiting();
        return bl;
    }

    private String getMaxAuthScheme(String m_authscheme_to_be, String m_authscheme) {
        IAuthScheme is_authscheme = null;
        IAuthScheme should_authscheme = null;
        if (m_authscheme_to_be == null) {
            return m_authscheme;
        }
        is_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(m_authscheme);
        should_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(m_authscheme_to_be);
        if (is_authscheme.getPriority() > should_authscheme.getPriority()) {
            return is_authscheme.getName();
        }
        return should_authscheme.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean abort() throws LoginException {
        boolean bl;
        block3: {
            String METHOD = "abort()";
            Boolean b = null;
            try {
                ExceptionLogger.LOCATION.entering("abort()");
                this.rollBack();
                b = new Boolean(true);
                bl = true;
                Object var5_4 = null;
                if (b == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (b != null) {
                    ExceptionLogger.LOCATION.exiting(b);
                    throw throwable;
                }
                ExceptionLogger.LOCATION.exiting();
                throw throwable;
            }
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl;
        }
        ExceptionLogger.LOCATION.exiting();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean logout() throws LoginException {
        boolean bl;
        String METHOD = "logout()";
        Boolean b = null;
        try {
            ExceptionLogger.LOCATION.entering("logout()");
            this.rollBack();
            b = new Boolean(true);
            bl = true;
            Object var5_4 = null;
            if (b == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (b == null) throw throwable;
            ExceptionLogger.LOCATION.exiting(b);
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    void rollBack() {
        if (this.m_subject != null) {
            if (this.m_principal != null) {
                this.m_subject.getPrincipals().remove(this.m_principal);
            }
            if (this.m_credential != null) {
                this.m_subject.getPrivateCredentials().remove(this.m_credential);
            }
            if (this.m_authscheme_principal != null) {
                this.m_subject.getPrincipals().remove(this.m_authscheme_principal);
            }
        }
        this.m_username = null;
        this.m_subject = null;
        this.m_handler = null;
        this.m_options = null;
        this.m_principal = null;
        this.m_credential = null;
        this.m_username = null;
        this.m_ticketString = null;
        this.m_succeeded = false;
        if (ExceptionLogger.LOCATION.beDebug()) {
            ExceptionLogger.LOCATION.debugT("Internal Login Module data has been reset.");
        }
    }

    String getSAPLogonTicket() throws LoginException, UnsupportedCallbackException, IOException {
        if (this.m_handler == null) {
            this.m_exception = new DetailedLoginException("Error: No CallbackHandler available to garner authentication information from the user. " + this.m_sharedState.get("sap.security.auth.configuration.name"), 11);
            throw (LoginException)this.m_exception;
        }
        Callback[] callbacks = null;
        callbacks = new Callback[]{new HttpGetterCallback()};
        ((HttpGetterCallback)callbacks[0]).setType((byte)2);
        ((HttpGetterCallback)callbacks[0]).setName("MYSAPSSO2");
        this.m_handler.handle(callbacks);
        return (String)((HttpGetterCallback)callbacks[0]).getValue();
    }

    void setSSOCookie(String value, String user) throws UnsupportedCallbackException, IOException, LoginException {
        if (this.m_handler == null) {
            this.m_exception = new DetailedLoginException("Error: No CallbackHandler available to garner authentication information from the user. Authentication stack: " + this.m_sharedState.get("sap.security.auth.configuration.name"), 10);
            throw (LoginException)this.m_exception;
        }
        if (this.m_umeadapter.isUMEConfigurationActive()) {
            this.m_umeadapter.setTicketAsCookie(this.m_handler, value, user);
        } else {
            Callback[] callbacks = null;
            callbacks = new Callback[]{new HttpSetterCallback()};
            ((HttpSetterCallback)callbacks[0]).setType((byte)2);
            ((HttpSetterCallback)callbacks[0]).setName("MYSAPSSO2");
            ((HttpSetterCallback)callbacks[0]).setValue((Object)value);
            this.m_handler.handle(callbacks);
        }
        if (ExceptionLogger.LOCATION.beInfo()) {
            if (value.equals("")) {
                ExceptionLogger.LOCATION.infoT("Callback handler [{0}] adviced to overwrite MYSAPSSO2 cookie with empty string. Authentication stack: [{1}].", new Object[]{this.m_handler.getClass().getName(), this.m_sharedState.get("sap.security.auth.configuration.name")});
            } else {
                ExceptionLogger.LOCATION.infoT("Callback handler [{0}] adviced to set SAP Logon Ticket in MYSAPSSO2 cookie. Authentication stack: [{1}].", new Object[]{this.m_handler.getClass().getName(), this.m_sharedState.get("sap.security.auth.configuration.name")});
            }
        }
    }
}

