/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityContextObjectListener;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.logon.AuthSchemePrincipal;
import com.sap.security.api.logon.IAuthScheme;
import com.sap.security.api.ticket.InfoUnit;
import com.sap.security.api.ticket.TicketException;
import com.sap.security.api.umap.NoLogonDataAvailableException;
import com.sap.security.api.umap.system.ExceptionInImplementationException;
import com.sap.security.api.umap.system.ISystemLandscapeObject;
import com.sap.security.api.umap.system.ISystemLandscapeWrapper;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPAuthenticationAssertionTicket;
import com.sap.security.core.server.jaas.SAPAuthenticationAssertionTicketCredential;
import com.sap.security.core.server.jaas.SAPLogonTicketHelper;
import com.sap.security.core.server.jaas.UMEAdapter;
import com.sap.security.core.ticket.imp.Ticket;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class EvaluateAssertionTicketLoginModule
extends AbstractLoginModule
implements SecurityContextObjectListener {
    public static final String TICKET_HEADER = "MYSAPSSO2";
    private static final String DEFAULT_UMAP_SYSTEM_PATTERN = "{0}CLNT{1}";
    Subject m_subject;
    Map m_sharedState;
    CallbackHandler m_handler;
    Properties m_options = new Properties();
    SAPAuthenticationAssertionTicketCredential m_credential = null;
    String m_ticketString = null;
    Principal m_principal = null;
    String m_authscheme = null;
    String m_authscheme_to_be;
    AuthSchemePrincipal m_authscheme_principal;
    boolean m_succeeded = false;
    Exception m_exception;
    private UMEAdapter m_umeadapter = null;
    private static final int DEFAULT_TIME_TOL = 3;
    private int m_timetolerance;
    private SecuritySession session;
    String m_username;
    String m_umap_system_pattern;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        String METHOD = "initialize()";
        try {
            Object option;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("initialize()", new Object[]{subject, handler});
            }
            super.initialize(subject, handler, sharedState, options);
            this.m_subject = subject;
            this.m_handler = handler;
            this.m_sharedState = sharedState;
            ((Hashtable)this.m_options).putAll(options);
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of EvaluateAssertionTicketLoginModule in [{0}] authentication stack are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            this.m_umeadapter = new UMEAdapter(sharedState, this.m_options);
            this.m_options = this.m_umeadapter.getMergedOptions();
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of EvaluateAssertionTicketLoginModule in [{0}] authentication stack after merge with UME properties are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            if ((option = ((Hashtable)this.m_options).get("keystore")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("keystore", "TicketKeystore");
            }
            if ((option = ((Hashtable)this.m_options).get("password")) == null) {
                ((Hashtable)this.m_options).put("password", "");
            }
            if ((option = ((Hashtable)this.m_options).get("alias")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("alias", "SAPLogonTicketKeypair");
            }
            if ((option = ((Hashtable)this.m_options).get("client")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("client", "000");
            }
            this.m_timetolerance = (option = ((Hashtable)this.m_options).get("timetolerance")) == null || option.equals("") ? 3 : Integer.parseInt((String)option);
            this.m_authscheme_to_be = (String)options.get("j_authscheme");
            if (this.m_authscheme_to_be == null) {
                this.m_authscheme_to_be = "default";
            }
            this.m_umap_system_pattern = (String)options.get("umap-system-pattern");
            if (this.m_umap_system_pattern == null) {
                this.m_umap_system_pattern = DEFAULT_UMAP_SYSTEM_PATTERN;
            }
            if ((option = this.m_sharedState.get("sap.security.auth.configuration.name")) != null) {
                ((Hashtable)this.m_options).put("sap.security.auth.configuration.name", option);
            }
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of EvaluateAssertionTicketLoginModule in [{0}] authentication stack after adding the default values are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ExceptionLogger.LOCATION.exiting("initialize()");
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting("initialize()");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        block32: {
            block29: {
                block31: {
                    block28: {
                        METHOD = "login()";
                        b = null;
                        stringTicket = null;
                        try {
                            try {
                                ExceptionLogger.LOCATION.entering("login()");
                                ticket = null;
                                stringTicket = this.getSAPAssertionTicket();
                                this.m_ticketString = SAPLogonTicketHelper.undoReplaceChar(stringTicket);
                                if (this.m_ticketString == null || this.m_ticketString.equals("")) {
                                    if (ExceptionLogger.LOCATION.beDebug()) {
                                        ExceptionLogger.LOCATION.debugT("Received no SAP Authentication Assertion Ticket. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    this.m_exception = new DetailedLoginException("Received no SAP Authentication Assertion Ticket.", 7);
                                    throw (LoginException)this.m_exception;
                                }
                                ticket = new SAPAuthenticationAssertionTicket();
                                ticket.setTicket(this.m_ticketString);
                                if (ExceptionLogger.LOCATION.beInfo()) {
                                    ExceptionLogger.LOCATION.infoT("SAP Authentication Assertion Ticket received. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("SAP Authentication Assertion Ticket: \n [{0}]. Authentication stack: [{1}].", new Object[]{ticket.toString(), this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                if (!ticket.isValid(this.m_timetolerance)) {
                                    if (ExceptionLogger.LOCATION.beInfo()) {
                                        ExceptionLogger.LOCATION.infoT("SAP Authentication Assertion Ticket has expired or it is not valid yet. The ticket is valid from {0} until {1} and now it is {2}. Authentication stack: [{3}]. Check the system time as well as the login module options and UME properties.", new Object[]{ticket.getStartValidDate().getTime(), ticket.getExpirationDate().getTime(), Calendar.getInstance(new SimpleTimeZone(0, "GMT")).getTime(), this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    this.m_succeeded = false;
                                    b = new Boolean(false);
                                    var9_6 = false;
                                    var15_8 = null;
                                    break block28;
                                }
                                sid = (String)this.m_sharedState.get("System-ID");
                                if (sid == null) {
                                    this.m_exception = new DetailedLoginException("Cannot continue. The system ID of the target system is not available.", 7);
                                    throw (LoginException)this.m_exception;
                                }
                                this.m_options.put("system", sid);
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("Found SID: [{0}].", new Object[]{sid});
                                }
                                keystore = (String)this.m_options.get("keystore");
                                password = (String)this.m_options.get("password");
                                alias = (String)this.m_options.get("alias");
                                store = SAPLogonTicketHelper.getTicketKeyStore(keystore, password, this.m_options);
                                if (store == null) {
                                    if (ExceptionLogger.LOCATION.beInfo() == false) throw new DetailedLoginException("Keystore view for ticket evaluation does not exist or has no entries.", 7);
                                    ExceptionLogger.LOCATION.infoT("Keystore view [{0}] does not exist or has no entries. The default keystore is [{1}]. Authentication stack: [{2}]. Check the login module options and UME properties.", new Object[]{keystore, "TicketKeystore", this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    throw new DetailedLoginException("Keystore view for ticket evaluation does not exist or has no entries.", 7);
                                }
                                try {
                                    certs = SAPLogonTicketHelper.getTrustedCerts(store);
                                }
                                catch (Exception e) {
                                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "The certificates contained in keystore view [{0}] cannot be retrieved. Authentication stack: [{1}]. The default kestore view is [{2}]. The default keypair alias is [{3}]. Check the login module options and UME properties.", new Object[]{keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), "TicketKeystore", "SAPLogonTicketKeypair"});
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "The certificates contained in keystore view [{0}] cannot be retrieved. Authentication stack: [{1}].", new Object[]{keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                                    throw e;
                                }
                                try {
                                    tempCert = (java.security.cert.X509Certificate)store.getCertificate(alias);
                                }
                                catch (Exception e) {
                                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), "TicketKeystore", "SAPLogonTicketKeypair"});
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}].", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                                    throw e;
                                }
                                if (tempCert == null) {
                                    if (ExceptionLogger.LOCATION.beInfo()) {
                                        ExceptionLogger.LOCATION.infoT("Signing key pair not found in keystore view [{0}] under alias [{1}].The default keystore is [{2}]. Default alias is [{3}]. Authentication stack: [{4}]. Check the login module options and UME properties.", new Object[]{keystore, alias, "TicketKeystore", "SAPLogonTicketKeypair", this.m_sharedState.get("sap.security.auth.configuration.name")});
                                    }
                                    this.m_exception = new DetailedLoginException("Signing key pair not found.", 7);
                                    throw (LoginException)this.m_exception;
                                }
                                cert = (X509Certificate)tempCert;
                                this.m_options.put("certificates", certs.toArray(new X509Certificate[0]));
                                this.m_options.put("cert", cert);
                                SAPLogonTicketHelper.evaluateTicket(ticket, this.m_options);
                                this.getUserFromTicket(ticket);
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("The verification of assertion ticket of user [{0}] is successful. Authentication stack: [{1}].", new Object[]{this.m_username, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                this.refreshUserInfo(this.m_username);
                                this.getAuthschemeFromTicket(ticket);
                                if (ExceptionLogger.LOCATION.beInfo()) {
                                    ExceptionLogger.LOCATION.infoT("SAP Authentication Assertion Ticket contains authentication scheme [{0}]. Authentication stack: [{1}].", new Object[]{this.m_authscheme, this.m_sharedState.get("sap.security.auth.configuration.name")});
                                }
                                this.verifyAuthschemesOk();
                                this.m_succeeded = true;
                                b = new Boolean(true);
                                var13_21 = true;
                                break block29;
                            }
                            catch (Throwable e) {
                                if (e instanceof Error) {
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (Error)e;
                                }
                                if (e instanceof RuntimeException) {
                                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (RuntimeException)e;
                                }
                                if (e instanceof LoginException) {
                                    if (ExceptionLogger.LOCATION.beWarning() == false) throw (LoginException)e;
                                    ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                    throw (LoginException)e;
                                }
                                if (ExceptionLogger.LOCATION.beWarning() == false) throw new DetailedLoginException(e.toString(), 7);
                                ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                                throw new DetailedLoginException(e.toString(), 7);
                            }
                        }
                        catch (Throwable var14_24) {
                            var15_10 = null;
                            try {
                                this.removeSSOHeader(stringTicket);
                            }
                            catch (Exception e) {
                                ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                            }
                            ExceptionLogger.LOCATION.exiting(b);
                            throw var14_24;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [4 : 1211->1220)] { 
lbl131:
                    // 1 sources

                    this.removeSSOHeader(stringTicket);
                    break block31;
lbl133:
                    // 1 sources

                    catch (Exception e) {
                        ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                    }
                }
                ExceptionLogger.LOCATION.exiting((Object)b);
                return var9_6;
            }
            var15_9 = null;
            ** try [egrp 4[TRYBLOCK] [4 : 1211->1220)] { 
lbl143:
            // 1 sources

            this.removeSSOHeader(stringTicket);
            break block32;
lbl145:
            // 1 sources

            catch (Exception e) {
                ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
            }
        }
        ExceptionLogger.LOCATION.exiting((Object)b);
        return var13_21;
    }

    private void verifyAuthschemesOk() throws LoginException {
        IAuthScheme is_authscheme = null;
        IAuthScheme should_authscheme = null;
        is_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(this.m_authscheme);
        should_authscheme = InternalUMFactory.getAuthSchemeFactory().getAuthScheme(this.m_authscheme_to_be);
        if (is_authscheme.getPriority() < should_authscheme.getPriority()) {
            if (ExceptionLogger.LOCATION.beInfo()) {
                ExceptionLogger.LOCATION.infoT("authscheme not sufficient: [{0}] < [{1}]. Authntication stack: [{2}]. Authenticated user: [{3}]", new Object[]{is_authscheme.getName(), should_authscheme.getName(), this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            throw new DetailedLoginException("Authentication scheme not sufficient: " + is_authscheme.getName() + " < " + should_authscheme.getName(), 7);
        }
    }

    private void getAuthschemeFromTicket(Ticket ticket) {
        try {
            InfoUnit iu = ticket.getInfoUnit(136);
            this.m_authscheme = "default";
            if (iu != null) {
                this.m_authscheme = iu.getString("UTF8");
            }
        }
        catch (TicketException e) {
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("getAuthschemeFromTicket", "Ticket parsing problem. Authntication stack: [{0}]. Authenticated user: [{1}]", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            ExceptionLogger.log(400, e);
        }
        catch (UnsupportedEncodingException e) {
            if (ExceptionLogger.LOCATION.beWarning()) {
                ExceptionLogger.LOCATION.warningT("getAuthschemeFromTicket", "Encoding problem. Authntication stack: [{0}]. Authenticated user: [{1}]", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name"), this.m_username});
            }
            ExceptionLogger.log(400, e);
        }
    }

    private void getUserFromTicket(Ticket ticket) throws UnsupportedEncodingException, TicketException, NoLogonDataAvailableException, UMException {
        this.m_username = ticket.getUser("portal");
        if (this.m_username == null) {
            IUser user;
            ArrayList al;
            String mastersystem = UMFactory.getProperties().get("ume.r3.mastersystem");
            String r3user = ticket.getUser();
            if (r3user == null && ExceptionLogger.LOCATION.beError()) {
                ExceptionLogger.LOCATION.errorT("Corrupted ticket: No UME user and no r3 user. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")});
                throw new TicketException("Ticket without UME user and r3 user");
            }
            r3user = SAPLogonTicketHelper.removeEndingSpaces(r3user);
            String sysid = ticket.getSystemID();
            String syscli = ticket.getSystemClient();
            String user_uid = null;
            String sys_alias = MessageFormat.format(this.m_umap_system_pattern, sysid.trim(), syscli.trim());
            ISystemLandscapeObject islo = null;
            ISystemLandscapeWrapper islw = null;
            if (ExceptionLogger.LOCATION.beInfo()) {
                ExceptionLogger.LOCATION.infoT("Looking up inverse user mapping for system " + sys_alias);
            }
            if ((al = UMFactory.getSystemLandscapeWrappers()) != null && al.size() > 0) {
                islw = (ISystemLandscapeWrapper)al.get(0);
                if (islw != null) {
                    try {
                        islo = islw.getSystemByAlias(sys_alias);
                    }
                    catch (ExceptionInImplementationException e) {
                        ExceptionLogger.LOCATION.traceThrowableT(500, "Exception in system landscape wrapper. Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                    }
                } else if (ExceptionLogger.LOCATION.beWarning()) {
                    ExceptionLogger.LOCATION.warningT("No System landscape wrapper installed.");
                }
            }
            if (islo == null) {
                if (ExceptionLogger.LOCATION.beWarning()) {
                    ExceptionLogger.LOCATION.warningT("Cannot get system by alias " + sys_alias);
                }
            } else if ("SAPLOGONTICKET".equals(islo.getLogonMethod())) {
                user_uid = UMFactory.getUserMapping().getInverseMappingData(r3user, islo);
                if (user_uid != null) {
                    user = UMFactory.getUserFactory().getUser(user_uid);
                    if (null == user) {
                        if (ExceptionLogger.LOCATION.beError()) {
                            ExceptionLogger.LOCATION.errorT("Strange: No user existing for uid " + user_uid);
                        }
                    } else {
                        this.m_username = user.getUserAccounts()[0].getLogonUid();
                    }
                } else if (ExceptionLogger.LOCATION.beWarning()) {
                    ExceptionLogger.LOCATION.warningT("Inverse user mapping [user={0}, system={1}] not found", new Object[]{r3user, sys_alias});
                }
            }
            if (this.m_username == null) {
                if (ExceptionLogger.LOCATION.beInfo()) {
                    ExceptionLogger.LOCATION.infoT("Inverse mapping not successful (user=" + r3user + "). Trying mastersystem.");
                }
                if ((user_uid = UMFactory.getUserMapping().getInverseMappingData(r3user, null)) == null && ExceptionLogger.LOCATION.beWarning()) {
                    ExceptionLogger.LOCATION.warningT("Inverse user mapping finally not successful (user=" + r3user + ").");
                } else {
                    user = UMFactory.getUserFactory().getUser(user_uid);
                    if (null == user) {
                        if (ExceptionLogger.LOCATION.beWarning()) {
                            ExceptionLogger.LOCATION.warningT("Inverse user mapping [user={0}, system={1}] not found", new Object[]{r3user, sys_alias});
                        }
                    } else {
                        this.m_username = user.getUserAccounts()[0].getLogonUid();
                    }
                }
            }
        } else {
            this.m_username = SAPLogonTicketHelper.removeEndingSpaces(this.m_username);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commit() throws LoginException {
        boolean bl;
        Boolean b;
        block14: {
            boolean bl2;
            block12: {
                Object object2;
                block13: {
                    String METHOD = "commit()";
                    b = null;
                    try {
                        ExceptionLogger.LOCATION.entering("commit()");
                        if (!this.m_succeeded) {
                            this.m_username = null;
                            this.m_subject = null;
                            this.m_handler = null;
                            this.m_options = null;
                            this.m_ticketString = null;
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("Internal Login Module data has been reset.");
                            }
                            b = new Boolean(false);
                            bl2 = false;
                            Object var5_5 = null;
                            object2 = this.m_sharedState.get("sap.security.auth.context.object");
                            if (object2 == null || b == null || !b.booleanValue()) break block12;
                            break block13;
                        }
                        this.m_principal = new Principal(this.m_username);
                        this.m_subject.getPrincipals().add((java.security.Principal)this.m_principal);
                        if (ExceptionLogger.LOCATION.beInfo()) {
                            ExceptionLogger.LOCATION.infoT("Added principal [{0}] of class [{1}] to Subject.", new Object[]{this.m_username, this.m_username.getClass()});
                        }
                        if (this.m_authscheme_to_be != null) {
                            this.m_authscheme_principal = new AuthSchemePrincipal(this.m_authscheme_to_be);
                            this.m_subject.getPrincipals().add((java.security.Principal)this.m_authscheme_principal);
                        }
                        this.m_credential = new SAPAuthenticationAssertionTicketCredential(this.m_ticketString, this.m_username);
                        this.m_subject.getPrivateCredentials().add(this.m_credential);
                        if (ExceptionLogger.LOCATION.beDebug()) {
                            ExceptionLogger.LOCATION.debugT("SAP Authentication Assertion Ticket added to private credentials.");
                        }
                        b = new Boolean(true);
                        bl = true;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        Object object2 = this.m_sharedState.get("sap.security.auth.context.object");
                        if (object2 != null && b != null && b.booleanValue()) {
                            ((SecurityContextObject)object2).addListener((SecurityContextObjectListener)this, true);
                        }
                        if (b != null) {
                            ExceptionLogger.LOCATION.exiting((Object)b);
                            throw throwable;
                        }
                        ExceptionLogger.LOCATION.exiting();
                        throw throwable;
                    }
                }
                ((SecurityContextObject)object2).addListener((SecurityContextObjectListener)this, true);
            }
            if (b != null) {
                ExceptionLogger.LOCATION.exiting((Object)b);
                return bl2;
            }
            ExceptionLogger.LOCATION.exiting();
            return bl2;
        }
        Object var5_6 = null;
        Object object2 = this.m_sharedState.get("sap.security.auth.context.object");
        if (object2 != null && b != null && b.booleanValue()) {
            ((SecurityContextObject)object2).addListener((SecurityContextObjectListener)this, true);
        }
        if (b != null) {
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl;
        }
        ExceptionLogger.LOCATION.exiting();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean abort() throws LoginException {
        boolean bl;
        block3: {
            String METHOD = "abort()";
            Boolean b = null;
            try {
                ExceptionLogger.LOCATION.entering("abort()");
                this.rollBack();
                b = new Boolean(true);
                bl = true;
                Object var5_4 = null;
                if (b == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (b != null) {
                    ExceptionLogger.LOCATION.exiting(b);
                    throw throwable;
                }
                ExceptionLogger.LOCATION.exiting();
                throw throwable;
            }
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl;
        }
        ExceptionLogger.LOCATION.exiting();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean logout() throws LoginException {
        boolean bl;
        String METHOD = "logout()";
        Boolean b = null;
        try {
            ExceptionLogger.LOCATION.entering("logout()");
            this.rollBack();
            b = new Boolean(true);
            bl = true;
            Object var5_4 = null;
            if (b == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (b == null) throw throwable;
            ExceptionLogger.LOCATION.exiting(b);
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    public void sessionChanged(SecurityContextObject securityContextObject, SecuritySession securitySession, boolean isAnonymous, int change) {
        block6: {
            if (change == 3) {
                if (securitySession != null) {
                    this.session = securitySession;
                }
            } else if (change == 1) {
                this.session.setExpirationPeriod(0L);
                try {
                    this.logout();
                }
                catch (LoginException e) {
                    if (!ExceptionLogger.LOCATION.beWarning()) break block6;
                    ExceptionLogger.LOCATION.traceThrowableT(400, "Cannot logout user [{0}] who has been authenticated with SAP Authentication Assertion Ticket. Authentication stack: [{1}].", new Object[]{securitySession.getPrincipal(), this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e);
                }
            }
        }
    }

    void rollBack() {
        if (this.m_subject != null) {
            if (this.m_principal != null) {
                this.m_subject.getPrincipals().remove(this.m_principal);
            }
            if (this.m_credential != null) {
                this.m_subject.getPrivateCredentials().remove(this.m_credential);
            }
            if (this.m_authscheme_principal != null) {
                this.m_subject.getPrincipals().remove(this.m_authscheme_principal);
            }
        }
        this.m_username = null;
        this.m_subject = null;
        this.m_handler = null;
        this.m_options = null;
        this.m_principal = null;
        this.m_credential = null;
        this.m_username = null;
        this.m_ticketString = null;
        this.m_succeeded = false;
        this.session = null;
        if (ExceptionLogger.LOCATION.beDebug()) {
            ExceptionLogger.LOCATION.debugT("Internal Login Module data has been reset.");
        }
    }

    private String getSAPAssertionTicket() throws LoginException, UnsupportedCallbackException, IOException {
        if (this.m_handler == null) {
            this.m_exception = new DetailedLoginException("Error: No CallbackHandler available to gather authentication information from the user. Authentication stack: " + this.m_sharedState.get("sap.security.auth.configuration.name"), 11);
            throw (LoginException)this.m_exception;
        }
        Callback[] callbacks = new Callback[]{new HttpGetterCallback()};
        ((HttpGetterCallback)callbacks[0]).setType((byte)1);
        ((HttpGetterCallback)callbacks[0]).setName(TICKET_HEADER);
        this.m_handler.handle(callbacks);
        return (String)((HttpGetterCallback)callbacks[0]).getValue();
    }

    private void removeSSOHeader(String ticket) throws UnsupportedCallbackException, IOException, LoginException {
        if (this.m_handler == null) {
            this.m_exception = new DetailedLoginException("Error: no CallbackHandler available to gather authentication information from the user. Authentication stack: " + this.m_sharedState.get("sap.security.auth.configuration.name"), 10);
            throw (LoginException)this.m_exception;
        }
        Callback[] callbacks = new Callback[]{new HttpSetterCallback()};
        ((HttpSetterCallback)callbacks[0]).setType((byte)15);
        ((HttpSetterCallback)callbacks[0]).setName(TICKET_HEADER);
        ((HttpSetterCallback)callbacks[0]).setValue((Object)ticket);
        this.m_handler.handle(callbacks);
    }
}

