/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.security.api.logon.AuthSchemePrincipal;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.SAPLogonTicketCredential;
import com.sap.security.core.server.jaas.SAPLogonTicketHelper;
import com.sap.security.core.server.jaas.UMEAdapter;
import com.sap.security.core.server.util0.LRUHashMap;
import com.sap.security.core.ticket.imp.Ticket;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class CreateTicketLoginModule
extends AbstractLoginModule {
    Subject m_subject;
    Map m_sharedState;
    CallbackHandler m_handler;
    Properties m_options = new Properties();
    SAPLogonTicketCredential m_credential = null;
    Object m_cacheKey = null;
    boolean m_cookieSet = false;
    boolean m_succeeded = false;
    Exception m_exception = null;
    private UMEAdapter m_umeadapter = null;
    private boolean isSessionLogout = false;
    static final int SEVERITY = 300;
    static final String DEFAULT_KEYSTORE_VIEW = "TicketKeystore";
    static final String DEFAULT_KEYPAIR_ALIAS = "SAPLogonTicketKeypair";
    static final String DEFAULT_TICKET_VALIDITY = "8";
    static final String DEFAULT_CLIENT = "000";

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        String METHOD = "initialize()";
        try {
            String option;
            if (ExceptionLogger.LOCATION.bePath()) {
                ExceptionLogger.LOCATION.entering("initialize()", new Object[]{subject, handler, sharedState, options});
            }
            super.initialize(subject, handler, sharedState, options);
            this.m_subject = subject;
            this.m_handler = handler;
            this.m_sharedState = sharedState;
            ((Hashtable)this.m_options).putAll(options);
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of CreateTicketLoginModule in [{0}] authentication stack are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            this.m_umeadapter = new UMEAdapter(sharedState, this.m_options);
            this.m_options = this.m_umeadapter.getMergedOptions();
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of CreateTicketLoginModule in [{0}] authentication stack after merge with UME properties are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            if ((option = (String)((Hashtable)this.m_options).get("keystore")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("keystore", DEFAULT_KEYSTORE_VIEW);
            }
            if ((option = (String)((Hashtable)this.m_options).get("password")) == null) {
                ((Hashtable)this.m_options).put("password", "");
            }
            if ((option = (String)((Hashtable)this.m_options).get("alias")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("alias", DEFAULT_KEYPAIR_ALIAS);
            }
            if ((option = (String)((Hashtable)this.m_options).get("client")) == null || option.equals("")) {
                ((Hashtable)this.m_options).put("client", DEFAULT_CLIENT);
            }
            if ((option = (String)((Hashtable)this.m_options).get("cachesize")) != null && !option.equals("")) {
                SAPLogonTicketHelper.setCacheSize(Integer.parseInt(option));
            }
            option = ((Hashtable)this.m_options).get("validity");
            Object option2 = ((Hashtable)this.m_options).get("validityMin");
            if ((option == null || option.equals("")) && (option2 == null || option2.equals(""))) {
                ((Hashtable)this.m_options).put("validity", DEFAULT_TICKET_VALIDITY);
            }
            if ((option = this.m_sharedState.get("sap.security.auth.configuration.name")) != null) {
                ((Hashtable)this.m_options).put("sap.security.auth.configuration.name", option);
            }
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("The options of CreateTicketLoginModule in [{0}] authentication stack after adding the default values are: [{1}].", new Object[]{sharedState.get("sap.security.auth.configuration.name"), this.m_options});
            }
            if (this.m_sharedState.get("sap.security.auth.session.logout") != null) {
                this.isSessionLogout = true;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ExceptionLogger.LOCATION.exiting();
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        boolean bl;
        Boolean b;
        block6: {
            boolean bl2;
            block5: {
                String METHOD = "login()";
                b = null;
                try {
                    ExceptionLogger.LOCATION.entering("login()");
                    Object option = this.m_sharedState.get("javax.security.auth.login.name");
                    if (option != null && !option.equals("")) {
                        if (ExceptionLogger.LOCATION.beInfo()) {
                            ExceptionLogger.LOCATION.infoT("Authenticated user found: user={0}. Authentication stack: [{1}].", new Object[]{option, this.m_sharedState.get("sap.security.auth.configuration.name")});
                        }
                        ((Hashtable)this.m_options).put("user", option);
                        this.refreshUserInfo((String)option);
                        this.m_succeeded = true;
                        b = new Boolean(true);
                        bl2 = true;
                        Object var6_6 = null;
                        break block5;
                    }
                    if (ExceptionLogger.LOCATION.beInfo()) {
                        ExceptionLogger.LOCATION.infoT("No authenticated user found.");
                    }
                    b = new Boolean(false);
                    bl = false;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    ExceptionLogger.LOCATION.exiting(b);
                    throw throwable;
                }
            }
            ExceptionLogger.LOCATION.exiting((Object)b);
            return bl2;
        }
        Object var6_7 = null;
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commit() throws LoginException {
        boolean bl;
        Boolean b;
        block29: {
            boolean e3;
            block28: {
                boolean bl2;
                block27: {
                    String METHOD = "commit()";
                    b = null;
                    try {
                        try {
                            PrivateKey key;
                            String user;
                            ExceptionLogger.LOCATION.entering("commit()");
                            if (!this.m_succeeded) {
                                this.m_subject = null;
                                this.m_handler = null;
                                this.m_sharedState = null;
                                this.m_options = null;
                                b = new Boolean(false);
                                bl2 = false;
                                Object var18_6 = null;
                                break block27;
                            }
                            String ticketString = null;
                            Object option = this.m_sharedState.get("javax.security.auth.login.name");
                            if (option != null && option.equals(((Hashtable)this.m_options).get("user"))) {
                                user = (String)option;
                                if (ExceptionLogger.LOCATION.beDebug()) {
                                    ExceptionLogger.LOCATION.debugT("Authenticated user still in shared state.");
                                }
                            } else {
                                this.m_exception = new DetailedLoginException("Commit method of login module doing the actual authentication seems to have failed. Authentication stack: " + this.m_sharedState.get("sap.security.auth.configuration.name"), 8);
                                throw this.m_exception;
                            }
                            option = ((Hashtable)this.m_options).get("system");
                            if (option == null) {
                                this.m_exception = new DetailedLoginException("Can not create SAP Logon Ticket. SID not available.", 8);
                                throw this.m_exception;
                            }
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("System ID found: [{0}].", new Object[]{option});
                            }
                            String keystore = (String)((Hashtable)this.m_options).get("keystore");
                            String password = (String)((Hashtable)this.m_options).get("password");
                            String alias = (String)((Hashtable)this.m_options).get("alias");
                            KeyStore store = SAPLogonTicketHelper.getTicketKeyStore(keystore, password, this.m_options);
                            if (store == null || store.size() == 0) {
                                if (!ExceptionLogger.LOCATION.beInfo()) throw new DetailedLoginException("Ticket keystore view does not exist or has no entries.", 8);
                                ExceptionLogger.LOCATION.infoT("Keystore view [{0}] does not exist or has no entries. Authentication stack: [{1}]. The default kestore view is [{2}]. Check the login module options and UME properties.", new Object[]{keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), DEFAULT_KEYSTORE_VIEW});
                                throw new DetailedLoginException("Ticket keystore view does not exist or has no entries.", 8);
                            }
                            java.security.cert.X509Certificate tempCert = null;
                            try {
                                tempCert = (java.security.cert.X509Certificate)store.getCertificate(alias);
                            }
                            catch (Exception e2) {
                                ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), DEFAULT_KEYSTORE_VIEW, DEFAULT_KEYPAIR_ALIAS});
                                ExceptionLogger.LOCATION.traceThrowableT(500, "Certificate under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}].", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e2);
                                throw e2;
                            }
                            if (tempCert != null && ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("Certificate found under [{0}] alias. Authentication stack: [{1}].", new Object[]{alias, this.m_sharedState.get("sap.security.auth.configuration.name")});
                            }
                            try {
                                key = (PrivateKey)store.getKey(alias, password.toCharArray());
                            }
                            catch (Exception e3) {
                                ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Key under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name"), DEFAULT_KEYSTORE_VIEW, DEFAULT_KEYPAIR_ALIAS});
                                ExceptionLogger.LOCATION.traceThrowableT(500, "Key under alias [{0}] cannot be retrieved from keystore view [{1}]. Authentication stack: [{2}].", new Object[]{alias, keystore, this.m_sharedState.get("sap.security.auth.configuration.name")}, (Throwable)e3);
                                throw e3;
                            }
                            if (key == null || tempCert == null) {
                                if (ExceptionLogger.CATEGORY.beWarning()) {
                                    ExceptionLogger.CATEGORY.warningT(ExceptionLogger.LOCATION, "Keypair for signing not found in keystore view [{0}] under alias [{1}]. Authentication stack: [{2}]. The default kestore view is [{3}]. The default keypair alias is [{4}]. Check the login module options and UME properties.", new Object[]{keystore, alias, this.m_sharedState.get("sap.security.auth.configuration.name"), DEFAULT_KEYSTORE_VIEW, DEFAULT_KEYPAIR_ALIAS});
                                }
                                this.m_exception = new DetailedLoginException("Keypair for signing not found in keystore.", 8);
                                throw this.m_exception;
                            }
                            X509Certificate cert = (X509Certificate)tempCert;
                            ((Hashtable)this.m_options).put("key", key);
                            ((Hashtable)this.m_options).put("cert", cert);
                            this.m_umeadapter.setMappedUser();
                            if (null == ((Hashtable)this.m_options).get("user") && null == ((Hashtable)this.m_options).get("mappeduser")) {
                                if (ExceptionLogger.LOCATION.beInfo()) {
                                    ExceptionLogger.LOCATION.infoT("No portal and no ABAP user. Ticket creation aborted.");
                                }
                                b = new Boolean(false);
                                this.m_cookieSet = false;
                                e3 = false;
                                break block28;
                            }
                            Ticket ticket = SAPLogonTicketHelper.createTicket(this.m_options);
                            ticketString = ticket.getTicket();
                            if (ExceptionLogger.LOCATION.beInfo()) {
                                ExceptionLogger.LOCATION.infoT("New SAP Logon Ticket for user [{0}] has been created. Authentication stack: [{1}].", new Object[]{user, this.m_sharedState.get("sap.security.auth.configuration.name")});
                            }
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("The created ticket is: \n [{0}]. \nAuthentication stack: [{1}].", new Object[]{ticket.toString(), this.m_sharedState.get("sap.security.auth.configuration.name")});
                            }
                            LRUHashMap cache = SAPLogonTicketHelper.getCache();
                            String m_cacheKey = SAPLogonTicketHelper.getCacheKey(ticketString);
                            cache.put((Object)m_cacheKey, (Object)user);
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("User stored in usercache, key: SAP Logon Ticket.");
                            }
                            this.m_credential = new SAPLogonTicketCredential(ticketString, user);
                            this.m_subject.getPrivateCredentials().add(this.m_credential);
                            if (ExceptionLogger.LOCATION.beDebug()) {
                                ExceptionLogger.LOCATION.debugT("SAP Logon Ticket added to private credentials.");
                            }
                            ticketString = SAPLogonTicketHelper.replaceSpecialChar(ticketString);
                            this.setSSOCookie(ticketString, user);
                            this.setAuthschemePrincipal();
                            this.m_cookieSet = true;
                            b = new Boolean(true);
                            bl = true;
                            break block29;
                        }
                        catch (Throwable e4) {
                            if (e4 instanceof Error) {
                                ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e4);
                                throw (Error)e4;
                            }
                            if (e4 instanceof RuntimeException) {
                                ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e4);
                                throw (RuntimeException)e4;
                            }
                            if (e4 instanceof LoginException) {
                                if (!ExceptionLogger.LOCATION.beWarning()) throw (LoginException)e4;
                                ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e4);
                                throw (LoginException)e4;
                            }
                            if (!ExceptionLogger.LOCATION.beWarning()) throw new DetailedLoginException(ExceptionLogger.getStackTrace(e4), 8);
                            ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e4);
                            throw new DetailedLoginException(ExceptionLogger.getStackTrace(e4), 8);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_9 = null;
                        ExceptionLogger.LOCATION.exiting(b);
                        throw throwable;
                    }
                }
                ExceptionLogger.LOCATION.exiting((Object)b);
                return bl2;
            }
            Object var18_7 = null;
            ExceptionLogger.LOCATION.exiting((Object)b);
            return e3;
        }
        Object var18_8 = null;
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    private void setAuthschemePrincipal() {
        String authscheme_of_stack = (String)((Hashtable)this.m_options).get("j_authscheme");
        this.m_subject.getPrincipals().add((Principal)new AuthSchemePrincipal(authscheme_of_stack));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean abort() throws LoginException {
        boolean bl;
        String METHOD = "abort()";
        Boolean b = null;
        try {
            try {
                ExceptionLogger.LOCATION.entering("abort()");
                this.rollBack();
                b = new Boolean(true);
                bl = true;
                Object var5_5 = null;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (RuntimeException)e;
                }
                if (e instanceof LoginException) {
                    if (!ExceptionLogger.LOCATION.beWarning()) throw (LoginException)e;
                    ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (LoginException)e;
                }
                if (!ExceptionLogger.LOCATION.beWarning()) throw new DetailedLoginException(e.toString(), 10);
                ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                throw new DetailedLoginException(e.toString(), 10);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ExceptionLogger.LOCATION.exiting(b);
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean logout() throws LoginException {
        boolean bl;
        String METHOD = "logout()";
        Boolean b = null;
        try {
            try {
                ExceptionLogger.LOCATION.entering("logout()");
                this.rollBack();
                b = new Boolean(true);
                bl = true;
                Object var5_5 = null;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    ExceptionLogger.LOCATION.traceThrowableT(500, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (RuntimeException)e;
                }
                if (e instanceof LoginException) {
                    if (!ExceptionLogger.LOCATION.beWarning()) throw (LoginException)e;
                    ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                    throw (LoginException)e;
                }
                if (!ExceptionLogger.LOCATION.beWarning()) throw new DetailedLoginException(e.toString(), 10);
                ExceptionLogger.LOCATION.traceThrowableT(400, "Authentication stack: [{0}].", new Object[]{this.m_sharedState.get("sap.security.auth.configuration.name")}, e);
                throw new DetailedLoginException(e.toString(), 10);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ExceptionLogger.LOCATION.exiting(b);
            throw throwable;
        }
        ExceptionLogger.LOCATION.exiting((Object)b);
        return bl;
    }

    void setSSOCookie(String value, String user) throws UnsupportedCallbackException, IOException, LoginException {
        if (this.m_handler == null) {
            this.m_exception = new DetailedLoginException("Error: no CallbackHandler available to garner authentication information from the user.", 10);
            throw (LoginException)this.m_exception;
        }
        if (this.m_umeadapter.isUMEConfigurationActive()) {
            this.m_umeadapter.setTicketAsCookie(this.m_handler, value, user);
        } else {
            Callback[] callbacks = null;
            callbacks = new Callback[]{new HttpSetterCallback()};
            ((HttpSetterCallback)callbacks[0]).setType((byte)2);
            ((HttpSetterCallback)callbacks[0]).setName("MYSAPSSO2");
            ((HttpSetterCallback)callbacks[0]).setValue((Object)value);
            this.m_handler.handle(callbacks);
        }
        if (ExceptionLogger.LOCATION.beInfo()) {
            if (value.equals("")) {
                ExceptionLogger.LOCATION.infoT("Callback Handler adviced to overwrite MYSAPSSO2 cookie with empty string.");
            } else {
                ExceptionLogger.LOCATION.infoT("Callback Handler adviced to set SAP Logon Ticket in MYSAPSSO2 cookie.");
            }
        }
    }

    void rollBack() throws LoginException, UnsupportedCallbackException, IOException {
        if (this.m_subject != null && this.m_credential != null) {
            this.m_subject.getPrivateCredentials().remove(this.m_credential);
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("SAP Logon Ticket has been removed from private credentials.");
            }
        }
        if (this.m_cacheKey != null) {
            LRUHashMap cache = SAPLogonTicketHelper.getCache();
            cache.remove(this.m_cacheKey);
            if (ExceptionLogger.LOCATION.beDebug()) {
                ExceptionLogger.LOCATION.debugT("User has been removed from cache.");
            }
        }
        if (this.m_cookieSet || this.isSessionLogout) {
            this.setSSOCookie("", "");
        }
        this.m_subject = null;
        this.m_handler = null;
        this.m_sharedState = null;
        this.m_options = null;
        this.m_credential = null;
        this.m_cacheKey = null;
        this.m_cookieSet = false;
        this.m_succeeded = false;
        this.m_umeadapter = null;
    }
}

