/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.jaas;

import com.sap.engine.interfaces.security.auth.AbstractLoginModule;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.UMFactory;
import com.sap.security.core.server.jaas.DetailedLoginException;
import com.sap.security.core.server.jaas.ExceptionLogger;
import com.sap.security.core.server.jaas.UMEAdapter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class CertPersisterLoginModule
extends AbstractLoginModule {
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$jaas$CertPersisterLoginModule == null ? (class$com$sap$security$core$server$jaas$CertPersisterLoginModule = CertPersisterLoginModule.class$("com.sap.security.core.server.jaas.CertPersisterLoginModule")) : class$com$sap$security$core$server$jaas$CertPersisterLoginModule));
    static Category CATEGORY = Category.getCategory((String)"/System/Security");
    static int SEVERITY = 300;
    private boolean success = false;
    private boolean accmodified = false;
    private X509Certificate[] oldCerts = null;
    private IUserAccount uacc = null;
    protected Map m_sharedState;
    protected Properties m_options = new Properties();
    private boolean m_succeeded = false;
    protected UMEAdapter _ume_adapter;
    protected CallbackHandler _callback_handler;
    protected Subject _subject;
    Exception m_exception = null;
    static /* synthetic */ Class class$com$sap$security$core$server$jaas$CertPersisterLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        LOCATION.entering(new Object[]{subject, handler, sharedState, options});
        try {
            Properties props = new Properties();
            ((Hashtable)props).putAll(options);
            this.m_options = new Properties();
            ((Hashtable)this.m_options).putAll(options);
            this.m_sharedState = sharedState;
            this._callback_handler = handler;
            this._subject = subject;
            this._ume_adapter = new UMEAdapter(sharedState, props);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            LOCATION.exiting();
            throw throwable;
        }
        LOCATION.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        boolean bl;
        Boolean b;
        block4: {
            boolean bl2;
            block3: {
                String METHOD = "login()";
                b = null;
                try {
                    LOCATION.entering("login()");
                    Object option = this.m_sharedState.get("javax.security.auth.login.name");
                    if (option != null && !option.equals("")) {
                        LOCATION.infoT("Authenticated user found: user=" + option + ".");
                        ((Hashtable)this.m_options).put("user", option);
                        this.refreshUserInfo((String)option);
                        this.m_succeeded = true;
                        b = new Boolean(true);
                        bl2 = true;
                        Object var6_6 = null;
                        break block3;
                    }
                    LOCATION.infoT("No authenticated user found.");
                    b = new Boolean(false);
                    bl = false;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    LOCATION.exiting(b);
                    throw throwable;
                }
            }
            LOCATION.exiting((Object)b);
            return bl2;
        }
        Object var6_7 = null;
        LOCATION.exiting((Object)b);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commit() throws LoginException {
        block21: {
            boolean bl;
            block20: {
                boolean bl2;
                block18: {
                    boolean bl3;
                    block17: {
                        String METHOD = "commit()";
                        try {
                            try {
                                HttpGetterCallback hgc;
                                block19: {
                                    block23: {
                                        block24: {
                                            block22: {
                                                LOCATION.entering("commit()");
                                                Object option = this.m_sharedState.get("javax.security.auth.login.name");
                                                if (option == null || !option.equals(((Hashtable)this.m_options).get("user"))) break block22;
                                                String user = (String)option;
                                                LOCATION.debugT("Authenticated user still in shared state.");
                                                this.uacc = UMFactory.getUserAccountFactory().getUserAccountByLogonId(user);
                                                if (!this.uacc.isLocked()) break block23;
                                                break block24;
                                            }
                                            this.m_exception = new DetailedLoginException("Commit method of login module doing the actual authentication seems to have failed.", 5);
                                            bl3 = false;
                                            Object var9_8 = null;
                                            break block17;
                                        }
                                        bl2 = true;
                                        break block18;
                                    }
                                    if (!this.uacc.isMutable()) {
                                        this.uacc = UMFactory.getUserAccountFactory().getMutableUserAccount(this.uacc.getUniqueID());
                                    }
                                    if (this._callback_handler == null) {
                                        throw new LoginException("error: no CallbackHandler available");
                                    }
                                    hgc = new HttpGetterCallback();
                                    hgc.setName("no_cert_storing");
                                    hgc.setType((byte)3);
                                    try {
                                        this._callback_handler.handle(new Callback[]{hgc});
                                        String[] parameters = (String[])hgc.getValue();
                                        if (parameters == null || parameters.length <= 0) break block19;
                                        int i = 0;
                                        while (i < parameters.length) {
                                            if ("on".equals(parameters[i])) {
                                                bl = true;
                                                break block20;
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (UnsupportedCallbackException uce) {
                                        throw new LoginException("Error: " + uce.getCallback().toString() + " not available to get cerificate from request");
                                    }
                                }
                                hgc = new HttpGetterCallback();
                                hgc.setName("javax.servlet.request.X509Certificate");
                                hgc.setType((byte)4);
                                try {
                                    this._callback_handler.handle(new Callback[]{hgc});
                                }
                                catch (UnsupportedCallbackException uce) {
                                    throw new LoginException("Error: " + uce.getCallback().toString() + " not available to get cerificate from request");
                                }
                                X509Certificate[] _certs = (X509Certificate[])hgc.getValue();
                                LOCATION.debugT("login", "found certificates {0}", new Object[]{_certs});
                                if (_certs != null) {
                                    this.oldCerts = this.uacc.getCertificates();
                                    this.uacc.setCertificates(_certs);
                                    this.uacc.save();
                                    this.uacc.commit();
                                    this.accmodified = true;
                                }
                                this.success = true;
                                break block21;
                            }
                            catch (Throwable e) {
                                if (e instanceof Error) {
                                    ExceptionLogger.log(500, e);
                                    throw (Error)e;
                                }
                                if (e instanceof RuntimeException) {
                                    ExceptionLogger.log(500, e);
                                    throw (RuntimeException)e;
                                }
                                if (e instanceof LoginException) {
                                    ExceptionLogger.log(400, e);
                                    throw (LoginException)e;
                                }
                                ExceptionLogger.log(400, e);
                                throw new DetailedLoginException(e.toString(), 5);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            LOCATION.exiting();
                            throw throwable;
                        }
                    }
                    LOCATION.exiting();
                    return bl3;
                }
                Object var9_9 = null;
                LOCATION.exiting();
                return bl2;
            }
            Object var9_10 = null;
            LOCATION.exiting();
            return bl;
        }
        Object var9_11 = null;
        LOCATION.exiting();
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.success) {
            return true;
        }
        if (this.accmodified) {
            try {
                this.uacc.setCertificates(this.oldCerts);
                this.uacc.save();
                this.uacc.commit();
            }
            catch (Exception ex) {
                LOCATION.warningT("abort", "Can't restore old certificates.", new Object[]{ex});
                return false;
            }
        }
        return true;
    }

    public boolean logout() throws LoginException {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

