/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.web.liTS.util.reg;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeviceConfiguration;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.UserManagerImpl;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public class WafRegistry {
    private static final String REG_SYNC_METHOD = "WAF_REGISTRY";
    private static final String DEVICEPROFILE_FIELDNAME = "DEVICEPROFILE";

    public static String getUserLongName() {
        User u = UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
        return u == null ? "" : u.getName();
    }

    public static void setUserLongName(String userLongName) {
        Configuration config;
        String oldUserName;
        if (userLongName == null) {
            userLongName = "";
        }
        if ((oldUserName = (config = Configuration.getInstance()).getProperty("MobileEngine.Sync.LongUserName", "")).equals(userLongName)) {
            return;
        }
        config.setProperty("MobileEngine.Sync.LongUserName", userLongName);
    }

    public void notifyR3() {
        int LENGTH_DEPLOYMENTID_SHORT = 12;
        String deviceType = " ";
        Trace trace = Trace.getInstance("MI/Sync");
        trace.log(80, "Notify R3 called");
        if (!InboundProcessorRegistry.getInstance().isAlreadyInOutboundQueue(REG_SYNC_METHOD, VisibilityType.SEPARATED)) {
            try {
                OutboundContainer cont = OutboundContainerFactory.getInstance().createOutboundContainer(VisibilityType.SEPARATED, REG_SYNC_METHOD, "R");
                cont.addItem("CONVIDGENERATION", "X");
                ConversationId[] allConvIds = ConversationIdHandler.getInstance().getAllConversationIds();
                int max = 0;
                int j = 0;
                while (j < allConvIds.length) {
                    MobileSolutionDescriptor msd;
                    User u = allConvIds[j].getUser();
                    if (!allConvIds[j].isSharedConversationId() && UserManagerImpl.getUserManagerImplInstance().getCurrentUser().equals(u) && ((msd = allConvIds[j].getMsd()).isInstalled() || msd.isFailed())) {
                        max = 3;
                        cont.addItem("DEPLID", ConversationIdHandler.getDeviceId());
                        StringBuffer sb = new StringBuffer("000");
                        this.fillWithSpaces(max += 12, sb);
                        sb.append(u.getUniqueName());
                        this.fillWithSpaces(max += 12, sb);
                        sb.append(deviceType);
                        this.fillWithSpaces(max += 30, sb);
                        sb.append(msd.getName());
                        this.fillWithSpaces(max += 30, sb);
                        if (msd.isFailed()) {
                            sb.append("F");
                        } else {
                            sb.append("I");
                        }
                        this.fillWithSpaces(++max, sb);
                        sb.append(msd.getVersion());
                        this.fillWithSpaces(max += 6, sb);
                        if (allConvIds[j].getId().startsWith("LOCALADMIN_") && allConvIds[j].getServerCommunicationId().startsWith("LOCALADMIN_")) {
                            StringBuffer localAdm = new StringBuffer(36);
                            localAdm.append(allConvIds[j].getMsd().getName());
                            this.fillWithSpaces(30, localAdm);
                            localAdm.append(allConvIds[j].getMsd().getVersion());
                            this.fillWithSpaces(36, localAdm);
                            cont.addItem("APP_LOCAL_INSTALL", localAdm.toString());
                        }
                        this.fillWithSpaces(++max, sb);
                        cont.addItem("DEVICE", sb.toString());
                    }
                    ++j;
                }
                this.addDeviceProfileInformationToContainer(cont);
                this.addNativeDeviceProfilerInformationToContainer(cont);
                cont.close();
            }
            catch (SyncException e) {
                AppLog.getInstance("MI/Deployment").logException("Exception while creating WAF_REGISTRY notify data container; check the device", (Throwable)e, false);
            }
        }
    }

    private void addNativeDeviceProfilerInformationToContainer(OutboundContainer cont) throws SyncException {
        try {
            Class<?> c = Class.forName("com.sap.ip.me.services.device.DeviceProfile");
            if (c != null) {
                Method getOS = c.getMethod("getOS", null);
                Integer os = (Integer)getOS.invoke(null, null);
                cont.addItem("NATIVE_OS", os.toString());
                Method getRT = c.getMethod("getRuntimeType", null);
                Integer rt = (Integer)getRT.invoke(null, null);
                cont.addItem("NATIVE_JVM", rt.toString());
                Method getCPU = c.getMethod("getProcessor", null);
                Integer cpu = (Integer)getCPU.invoke(null, null);
                cont.addItem("NATIVE_CPU", cpu.toString());
            }
        }
        catch (Throwable t) {
            AppLog.getInstance("MI/Deployment").logException("Exception while calling native profiler", t, true);
        }
    }

    private void addDeviceProfileInformationToContainer(OutboundContainer cont) throws SyncException {
        DeviceConfiguration di = new DeviceConfiguration();
        if (!"".equals(ConversationIdHandler.getDeviceId())) {
            cont.addItem(DEVICEPROFILE_FIELDNAME, "DEPLID:" + ConversationIdHandler.getDeviceId());
        }
        cont.addItem(DEVICEPROFILE_FIELDNAME, "OSNAME:" + di.getOperatingSystemName());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "OSVERSION:" + di.getOperatingSystemVersion());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "JVM_VENDOR:" + di.getJVMVendorName());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "JAVA_VERSION:" + di.getJavaVersion());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "USER_TIMEZONE:" + di.getUserTimezone());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "PROCESSOR:" + di.getProcessor());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "OSARCHITECTURE:" + di.getOperatingSystemArchitecture());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "RUNTIME:" + di.getMERuntime());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "MI_FULLNAME:" + di.getFrameworkInfos());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "USERS_ON_DEVICE:" + di.getAllUsersOnDevice());
        cont.addItem(DEVICEPROFILE_FIELDNAME, "INSTALLATION_IMAGE:" + di.getInstallationToolkitImage());
        Hashtable ht = DeviceConfiguration.getGenericInfo();
        if (ht.size() > 0) {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                cont.addItem(DEVICEPROFILE_FIELDNAME, key + ":" + (String)ht.get(key));
            }
        }
    }

    private void fillWithSpaces(int max, StringBuffer sb) {
        while (sb.length() < max) {
            sb.append(" ");
        }
    }
}

