/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.web.liTS.util.reg;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundContainerElement;
import com.sap.ip.me.api.sync.InboundProcessor;
import com.sap.ip.me.apps.InstallationScenario;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ApplicationType;
import com.sap.ip.me.core.AwtApplicationType;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.DeploymentMessages;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.JspApplicationType;
import com.sap.ip.me.core.LitsApplicationType;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.MobileSolutionDescriptorApplicationDependency;
import com.sap.ip.me.core.RegistryInboundProcessingLog;
import com.sap.ip.me.core.UnknownApplicationTypeException;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.persist.core.PersistenceCleaner;
import com.sap.ip.me.spi.smartsync.SmartSyncDeplAdapter;
import com.sapmarkets.web.liTS.util.reg.WafRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class RegistrySyncInboundProcessing
implements InboundProcessor,
Serializable {
    static final long serialVersionUID = -7296306735758335101L;
    private static final String AUTH_SYNCBO_LOC = "meta" + File.separator + "meRepMeta.XML";
    private static final String MSD_TO_INSTALL = "MSD_TO_INSTALL";
    private static final String MSD_TEXT = "MSD_TEXT";
    private static final String MSD_PROP = "MSD_PROP";
    private static final String MSD_CUSTATT = "MSD_CUST";
    private static final String ERROR_MESSAGES = "ERROR_MESSAGES";
    private static final String MSD_DEPATT = "MSD_DEP";
    private String methodName;
    private int offset_for_deplid_change;
    private transient Trace trace = Trace.getInstance("MI/Deployment");

    public RegistrySyncInboundProcessing(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void process(InboundContainer in) {
        this.initTrace();
        if (this.trace.isLogging(1000)) {
            this.trace.log(1000, this.getClass().getName() + " called");
        }
        this.offset_for_deplid_change = this.determineLengthOfDeplid(in) - 12;
        this.determineUserLongName(in);
        this.setDeploymentId(in);
        this.processBapiRet2(in);
        if (this.determineNumDelete(in) > 0) {
            this.processAppDelete(in);
        }
        if (this.determineNumInstall(in) > 0) {
            this.processAppInstall(in, true);
            if (in.getElementsWithFieldName(MSD_TO_INSTALL).length > 0) {
                this.processMSDInformation(in);
            } else {
                this.processLinks(in);
            }
            this.processAppInstall(in, false);
        }
        this.initialAuthSyncBOMetaDataDeployment();
    }

    protected void processBapiRet2(InboundContainer in) {
        InboundContainerElement[] elements = in.getElementsWithFieldName(ERROR_MESSAGES);
        this.initTrace();
        if (elements != null) {
            int k = 0;
            while (k < elements.length) {
                String message = elements[k].getFieldValue().trim();
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(message);
                DeploymentMessages.getInstance().addMessage(message);
                if (this.trace.isLogging(1000)) {
                    this.trace.log(1000, "ERROR_MESSAGES: " + message);
                }
                ++k;
            }
        }
    }

    protected void processAppDelete(InboundContainer in) {
        InboundContainerElement[] elements = in.getElementsWithFieldName("APP_DELETE");
        ApplicationManager newReg = ApplicationManager.getInstance();
        ConversationIdHandler ch = ConversationIdHandler.getInstance();
        this.initTrace();
        if (elements != null) {
            int k = 0;
            while (k < elements.length) {
                String username = elements[k].getFieldValue().substring(39, 57).trim();
                String appName = elements[k].getFieldValue().substring(57 + this.offset_for_deplid_change, 87 + this.offset_for_deplid_change).trim();
                String version = elements[k].getFieldValue().substring(88 + this.offset_for_deplid_change, 94 + this.offset_for_deplid_change).trim();
                if (!"".equals(appName) && !ApplicationManager.getInstance().getFrameworkName().equalsIgnoreCase(appName)) {
                    MobileSolutionDescriptor msd = newReg.getMobileSolutionDescriptor(appName, version);
                    this.trace.log(80, "Undeploy MSD " + msd + " for user " + username);
                    ConversationId convid = ch.getConversationId(msd, UserManagerImpl.getUserManagerImplInstance().getUser(username));
                    if (convid != null) {
                        ConversationId ci;
                        this.removeConvid(ch, msd, convid);
                        ConversationId[] convids = ch.getAllConversationIdsForApplication(msd);
                        if (convids.length == 1 && (ci = convids[0]).getUser().equals(UserManagerImpl.getSharedUser())) {
                            this.uninstallMSD(msd);
                            this.removeSharedConvid(ch, msd, ci);
                            this.unregisterMSD(newReg, msd);
                        }
                    }
                }
                ++k;
            }
        }
    }

    protected void unregisterMSD(ApplicationManager newReg, MobileSolutionDescriptor msd) {
        if (msd != null && !msd.isIncomplete()) {
            this.trace.log(90, "Unregister MSD " + msd);
            newReg.unregisterMobileSolutionDescriptor(msd);
        }
    }

    protected void uninstallMSD(MobileSolutionDescriptor msd) {
        try {
            this.trace.log(90, "Delete application physically");
            msd.getType().uninstall(msd);
            RegistryInboundProcessingLog.getInstance().addUnInstalledApplicationInfo(msd);
        }
        catch (Exception ex) {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message(ex.getMessage());
            AppLog.getInstance("MI/Deployment").logException(60, "Cannot uninstall application '" + msd.getName() + "' (Version '" + msd.getVersion() + "')", ex, true);
        }
    }

    protected int determineNumInstall(InboundContainer in) {
        int numInstall;
        block3: {
            InboundContainerElement[] elements = in.getElementsWithFieldName("NUM_INSTALL");
            numInstall = 0;
            if (elements.length <= 0) break block3;
            int k = 0;
            if (k < elements.length) {
                try {
                    numInstall = Integer.parseInt(elements[k].getFieldValue().trim());
                }
                catch (NumberFormatException e) {
                    AppLog.getInstance("MI/Deployment").logException(60, "Exception while checking the number of installations;  contact SAP support", e, false);
                    numInstall = 0;
                }
            }
        }
        return numInstall;
    }

    protected int determineNumDelete(InboundContainer in) {
        int numUninstall;
        block3: {
            InboundContainerElement[] elements = in.getElementsWithFieldName("NUM_DELETE");
            numUninstall = 0;
            if (elements.length <= 0) break block3;
            int k = 0;
            if (k < elements.length) {
                try {
                    numUninstall = Integer.parseInt(elements[k].getFieldValue().trim());
                }
                catch (NumberFormatException e) {
                    AppLog.getInstance("MI/Deployment").logException(60, "Exception while checking the number of deinstallations; contact SAP support", e, false);
                    numUninstall = 0;
                }
            }
        }
        return numUninstall;
    }

    protected int determineLengthOfDeplid(InboundContainer in) {
        int length_of_deplid;
        block3: {
            length_of_deplid = 12;
            InboundContainerElement[] elements = in.getElementsWithFieldName("LENGTH_OF_DEPLID");
            if (elements.length <= 0) break block3;
            int k = 0;
            if (k < elements.length) {
                try {
                    length_of_deplid = Integer.parseInt(elements[k].getFieldValue().trim());
                }
                catch (NumberFormatException e) {
                    AppLog.getInstance("MI/Deployment").logException(60, "Exception while checking the length of deployment id; contact SAP support", e, false);
                    length_of_deplid = 12;
                }
            }
        }
        return length_of_deplid;
    }

    protected void determineUserLongName(InboundContainer in) {
        InboundContainerElement[] elements = in.getElementsWithFieldName("USER_LONG_NAME");
        if (elements.length > 0) {
            String userLongName = elements[0].getFieldValue().trim();
            Trace.getInstance("MI/Deployment").log(90, this.getClass().getName() + " received USER_LONG_NAME: " + userLongName);
            WafRegistry.setUserLongName(userLongName);
        }
    }

    protected void processMSDInformation(InboundContainer in) {
        InboundContainerElement[] msdToInstall = in.getElementsWithFieldName(MSD_TO_INSTALL);
        InboundContainerElement[] msdText = in.getElementsWithFieldName(MSD_TEXT);
        InboundContainerElement[] msdProp = in.getElementsWithFieldName(MSD_PROP);
        InboundContainerElement[] msdCustAtt = in.getElementsWithFieldName(MSD_CUSTATT);
        InboundContainerElement[] msdDepAtt = in.getElementsWithFieldName(MSD_DEPATT);
        if (msdToInstall.length > 0) {
            MobileSolutionDescriptor msd = null;
            int k = 0;
            while (k < msdToInstall.length) {
                String msdFieldValue = msdToInstall[k].getFieldValue();
                if (this.trace.isLogging(50)) {
                    this.trace.log(70, "Receiving MSD_TO_INSTALL: " + msdFieldValue);
                }
                String applicationNamespace = msdFieldValue.substring(0, 10).trim();
                String applicationName = msdFieldValue.substring(10, 40).trim();
                String applicationVersion = msdFieldValue.substring(40, 46).trim();
                msd = this.getMSD(applicationNamespace, applicationName, applicationVersion, msdProp);
                this.readText(msdText, msd, k);
                this.readProperties(msdProp, msd);
                msd.setApplicationType();
                this.readCustomizing(msdCustAtt, msd);
                this.readDependencies(msdDepAtt, msd);
                ApplicationManager.getInstance().registerMobileSolutionDescriptor(msd);
                ++k;
            }
        }
        this.startApplicationInstallation();
    }

    protected MobileSolutionDescriptor getMSD(String namespace, String name, String version, InboundContainerElement[] msdprop) {
        int l = 0;
        while (l < msdprop.length) {
            String msdPropFieldValue = msdprop[l].getFieldValue();
            String localnamespace = msdPropFieldValue.substring(0, 10).trim();
            String localname = msdPropFieldValue.substring(10, 40).trim();
            String localversion = msdPropFieldValue.substring(40, 46).trim();
            if (localname.equalsIgnoreCase(name) && localnamespace.equalsIgnoreCase(namespace) && localversion.equalsIgnoreCase(version)) {
                String propertyType = msdprop[l].getFieldValueSubstring(46, 20).trim();
                String propertyValue = msdprop[l].getFieldValueSubstring(66, 40).trim();
                if (propertyType.equals("TYPE") && propertyValue.equals("INSTALL_SEQUENCE")) {
                    return new InstallationScenario(namespace, name, version);
                }
            }
            ++l;
        }
        return new MobileSolutionDescriptor(namespace, name, version);
    }

    protected void readProperties(InboundContainerElement[] msdProp, MobileSolutionDescriptor msd) {
        int l = 0;
        while (l < msdProp.length) {
            String msdPropFieldValue = msdProp[l].getFieldValue();
            String namespace = msdPropFieldValue.substring(0, 10).trim();
            String name = msdPropFieldValue.substring(10, 40).trim();
            String version = msdPropFieldValue.substring(40, 46).trim();
            if (msd.getName().equalsIgnoreCase(name) && msd.getNamespace().equalsIgnoreCase(namespace) && msd.getVersion().equalsIgnoreCase(version)) {
                String propertyType = msdProp[l].getFieldValueSubstring(46, 20);
                String propertyValue = msdProp[l].getFieldValueSubstring(66, 40);
                msd.setPropertyValue(propertyType.trim(), propertyValue.trim());
            }
            ++l;
        }
    }

    protected void readCustomizing(InboundContainerElement[] msdCustAtt, MobileSolutionDescriptor msd) {
        int l = 0;
        while (l < msdCustAtt.length) {
            String msdCustAttFieldValue = msdCustAtt[l].getFieldValue();
            String namespace = msdCustAttFieldValue.substring(3, 13).trim();
            String name = msdCustAttFieldValue.substring(13, 43).trim();
            String version = msdCustAttFieldValue.substring(43, 49).trim();
            if (msd.getName().equalsIgnoreCase(name) && msd.getNamespace().equalsIgnoreCase(namespace) && msd.getVersion().equalsIgnoreCase(version)) {
                String attributeName = msdCustAtt[l].getFieldValueSubstring(79, 20);
                String attributeValue = msdCustAtt[l].getFieldValueSubstring(99, 255);
                msd.setCustomizingValue(attributeName.trim(), attributeValue.trim());
            }
            ++l;
        }
    }

    protected void readDependencies(InboundContainerElement[] msdDepAtt, MobileSolutionDescriptor msd) {
        int lastindex = 1;
        MobileSolutionDescriptorApplicationDependency msdDep = new MobileSolutionDescriptorApplicationDependency();
        int l = 0;
        while (l < msdDepAtt.length) {
            String namespace = msdDepAtt[l].getFieldValueSubstring(0, 10).trim();
            String name = msdDepAtt[l].getFieldValueSubstring(10, 30).trim();
            String version = msdDepAtt[l].getFieldValueSubstring(40, 6).trim();
            String depType = msdDepAtt[l].getFieldValueSubstring(46, 20).trim();
            String localindex = msdDepAtt[l].getFieldValueSubstring(66, 10).trim();
            if (msd.getName().equalsIgnoreCase(name) && msd.getNamespace().equalsIgnoreCase(namespace) && msd.getVersion().equalsIgnoreCase(version) && depType.equals("APPLICATION")) {
                if (Integer.parseInt(localindex) > lastindex) {
                    msd.setDependencyValue(msdDep);
                    msdDep = new MobileSolutionDescriptorApplicationDependency();
                }
                lastindex = Integer.parseInt(localindex);
                String dependencyName = msdDepAtt[l].getFieldValueSubstring(76, 20).trim();
                String dependencyValue = msdDepAtt[l].getFieldValueSubstring(96, 40).trim();
                msdDep.addNewTableLine(dependencyName, dependencyValue);
            }
            ++l;
        }
        if (msdDepAtt.length > 0) {
            msd.setDependencyValue(msdDep);
        }
    }

    protected void startApplicationInstallation() {
        InstallationScenario is = (InstallationScenario)ApplicationManager.getInstance().getInstallationSequence();
        if (is != null && !is.isInstalled()) {
            try {
                is.initialize();
            }
            catch (InstallationException instex) {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(instex.getMessage());
                DeploymentMessages.getInstance().addMessage(instex.getMessage());
                if (this.trace.isLogging(50)) {
                    this.trace.logException(instex);
                }
                ApplicationManager.getInstance().unregisterMobileSolutionDescriptor(is);
                return;
            }
            this.saveMSDs();
            this.installMSDsWhichAreNotPartOfInstallationScenario(is);
            this.installApplicationFromMSD(is);
        } else if (is == null) {
            this.installMSDs();
        } else {
            this.installMSDsWhichAreNotPartOfInstallationScenario(is);
        }
    }

    protected void saveMSDs() {
        block2: {
            try {
                ApplicationManager.getInstance().saveMobileSolutionDescriptors();
            }
            catch (IOException e) {
                if (!this.trace.isLogging(50)) break block2;
                this.trace.logException(e);
            }
        }
    }

    protected void installMSDs() {
        Vector v = ApplicationManager.getInstance().getMSDsToBeInstalled();
        int size = v.size();
        int i = 0;
        while (i < size) {
            this.installApplicationFromMSD((MobileSolutionDescriptor)v.elementAt(i));
            ++i;
        }
    }

    protected void installMSDsWhichAreNotPartOfInstallationScenario(InstallationScenario is) {
        Vector v = ApplicationManager.getInstance().getMSDsToBeInstalled();
        int size = v.size();
        int i = 0;
        while (i < size) {
            MobileSolutionDescriptor nextMSD = (MobileSolutionDescriptor)v.elementAt(i);
            if (!nextMSD.equals(is) && !is.isMSDPartOfInstallationScenario(nextMSD)) {
                this.installApplicationFromMSD(nextMSD);
            }
            ++i;
        }
    }

    protected void installApplicationFromMSD(MobileSolutionDescriptor msd) {
        block4: {
            try {
                ApplicationManager.getInstance().installApplication(msd);
                RegistryInboundProcessingLog.getInstance().addInstalledApplicationInfo(msd);
            }
            catch (InstallationException instex) {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(instex.getMessage());
                AppLog.getInstance("MI/Deployment").logException(50, "Exception while trying to install application " + msd.getName(), instex, true);
                if (this.trace.isLogging(50)) {
                    this.trace.logException(instex);
                }
            }
            catch (UnknownApplicationTypeException uatex) {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(uatex.getReason());
                AppLog.getInstance("MI/Deployment").logException(50, "Exception while installing application " + msd.getName() + "; check application type", uatex, true);
                if (!this.trace.isLogging(50)) break block4;
                this.trace.logException(uatex);
            }
        }
    }

    protected boolean isApplicationAlreadyInstalled(String name, String version) {
        return ApplicationManager.getInstance().getMobileSolutionDescriptor(name, version) != null;
    }

    protected void setDeploymentId(InboundContainer in) {
        InboundContainerElement[] elements = in.getElementsWithFieldName("APP_INSTALL");
        if (elements != null && elements.length > 0) {
            this.initTrace();
            String deplid = elements[0].getFieldValue().substring(3, 36);
            boolean isLogging = this.trace.isLogging(90);
            if (isLogging) {
                this.trace.log(90, this.getClass().getName() + " received DEVICEID: " + deplid);
            }
            ConversationIdHandler.setDeviceId(deplid);
        }
    }

    protected boolean isItAnInstallationImage() {
        return Configuration.getInstance().getBoolean("MobileEngine.Installation.InstallationToolkit", false);
    }

    void _setOffset_for_deplid_change(int newOffset) {
        this.offset_for_deplid_change = newOffset;
    }

    private void initTrace() {
        if (this.trace == null) {
            this.trace = Trace.getInstance("MI/Deployment");
        }
    }

    private void removeSharedConvid(ConversationIdHandler ch, MobileSolutionDescriptor msd, ConversationId ci) {
        try {
            this.trace.log(90, "Delete all data for (shared) conversation id  " + ci);
            this.deleteAllDataForConversationId(ci);
            ch.removeConversationId(ci.getId());
        }
        catch (PersistenceException pex) {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message(pex.getMessage());
            AppLog.getInstance("MI/Deployment").logException(60, "Exception while undeploying conversation id " + ci, pex, true);
        }
        catch (InstallationException instex) {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message(instex.getMessage());
            AppLog.getInstance("MI/Deployment").logException(60, "Cannot uninstall application '" + msd.getName() + "' (Version '" + msd.getVersion() + "')", instex, true);
        }
    }

    private void removeConvid(ConversationIdHandler ch, MobileSolutionDescriptor msd, ConversationId convid) {
        try {
            this.trace.log(90, "Delete all data for conversation id  " + convid);
            this.deleteAllDataForConversationId(convid);
            ch.removeConversationId(convid.getId());
            DeploymentMessages.getInstance().addMessage(DeploymentMessages.TYPE_UNASSIGNMENT, "xmsg_APP_UNASSIGN", msd.getName() + " " + msd.getVersion());
        }
        catch (Exception pex) {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message(pex.getMessage());
            DeploymentMessages.getInstance().addMessage(DeploymentMessages.TYPE_UNASSIGNMENT, "xmsg_APP_UNASSIGN_FAIL", pex.getMessage());
            AppLog.getInstance("MI/Deployment").logException(60, "Exception while undeploying conversation id " + convid, pex, true);
        }
    }

    private void readText(InboundContainerElement[] msdText, MobileSolutionDescriptor msd, int k) {
        String msdTextFieldValue = msdText[k].getFieldValueSubstring(47, 60);
        if ("".equals(msdTextFieldValue)) {
            msd.setDescription(msd.getName());
        } else {
            msd.setDescription(msdTextFieldValue);
        }
    }

    private void processAppInstall(InboundContainer in, boolean onlyFrameworkConvIds) {
        InboundContainerElement[] elements = in.getElementsWithFieldName("APP_INSTALL");
        this.initTrace();
        if (this.trace.isLogging(1000)) {
            this.trace.log(1000, "Start Processing APP_INSTALL");
        }
        if (elements != null) {
            int k = 0;
            while (k < elements.length) {
                this.processAppInstallElement(elements[k], onlyFrameworkConvIds);
                ++k;
            }
        }
        ConversationIdHandler.getInstance().completeConvIdsForSharedUser();
    }

    private void processAppInstallElement(InboundContainerElement element, boolean onlyFrameworkConvIds) {
        String appName = this.readApplicationName(element);
        boolean newProtocol = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true);
        String[] attributes = this.readConvIdAttributes(element, appName, newProtocol);
        this.setConversationIdForApp(appName, attributes[1], attributes[2], attributes[3], newProtocol);
    }

    private String[] readConvIdAttributes(InboundContainerElement element, String appName, boolean newProtocol) {
        String convid;
        String namespace;
        String username = this.readUserName(element);
        String version = this.readVersion(element);
        if (newProtocol) {
            namespace = this.readNamespace(element);
            convid = this.readConvId(element);
        } else {
            namespace = "";
            convid = username + "_" + appName;
        }
        return new String[]{namespace, version, username, convid};
    }

    private String readConvId(InboundContainerElement element) {
        String convid = element.getFieldValue().substring(104 + this.offset_for_deplid_change, element.getFieldValue().length()).trim();
        return convid;
    }

    private String readNamespace(InboundContainerElement element) {
        String namespace = element.getFieldValue().substring(94 + this.offset_for_deplid_change, 104 + this.offset_for_deplid_change).trim();
        return namespace;
    }

    private String readVersion(InboundContainerElement element) {
        String version = element.getFieldValue().substring(88 + this.offset_for_deplid_change, 94 + this.offset_for_deplid_change).trim();
        return version;
    }

    private String readApplicationName(InboundContainerElement element) {
        String appName = element.getFieldValue().substring(57 + this.offset_for_deplid_change, 87 + this.offset_for_deplid_change).trim();
        return appName;
    }

    private String readUserName(InboundContainerElement element) {
        String username = element.getFieldValue().substring(39, 57).trim();
        return username;
    }

    private void setConversationIdForApp(String appName, String version, String username, String convid, boolean convIdGeneratedOnServer) {
        MobileSolutionDescriptor msd = ApplicationManager.getInstance().getMobileSolutionDescriptor(appName, version);
        ConversationIdHandler convIdHandler = ConversationIdHandler.getInstance();
        if (msd != null) {
            ConversationId currentConvid = null;
            currentConvid = "".equals(username) ? convIdHandler.getConversationId(msd, UserManagerImpl.getSharedUser()) : convIdHandler.getConversationId(msd, UserManagerImpl.getUserManagerImplInstance().getUser(username));
            if (currentConvid != null && currentConvid.isGeneratedOnServer()) {
                if (this.isItAnInstallationImage()) {
                    currentConvid.setServerCommunicationId(convid);
                }
            } else {
                currentConvid = this.createConvId(username, convid, convIdGeneratedOnServer, msd);
                if (!"".equals(username) && !msd.getName().startsWith("MOBILEENGINE")) {
                    DeploymentMessages.getInstance().addMessage(DeploymentMessages.TYPE_ASSIGNMENT, "xmsg_APP_ASSIGN", msd.getName() + " " + msd.getVersion());
                }
            }
            SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
            d.processMetaData(currentConvid);
        }
    }

    private ConversationId createConvId(String username, String convid, boolean convIdGeneratedOnServer, MobileSolutionDescriptor msd) {
        try {
            ConversationId newConvId = null;
            newConvId = "".equals(username) ? new ConversationId(convid, msd, UserManagerImpl.getSharedUser(), convIdGeneratedOnServer) : new ConversationId(convid, msd, UserManagerImpl.getUserManagerImplInstance().getUser(username), convIdGeneratedOnServer);
            return ConversationIdHandler.getInstance().addConversationId(newConvId);
        }
        catch (InstallationException instex) {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message(instex.getMessage());
            DeploymentMessages.getInstance().addMessage(instex.getMessage());
            this.initTrace();
            if (this.trace.isLogging(1000)) {
                this.trace.logException(1000, instex);
            }
            return null;
        }
    }

    private void processLinks(InboundContainer in) {
        InboundContainerElement[] linkElements = in.getElementsWithFieldName("LINKS");
        int l = 0;
        while (l < linkElements.length) {
            String applicationName = linkElements[l].getFieldValue().substring(0, 30).trim();
            String applicationVersion = linkElements[l].getFieldValue().substring(30, 36).trim();
            String instFileURL = linkElements[l].getFieldValue().substring(36).trim();
            MobileSolutionDescriptor msd = new MobileSolutionDescriptor("", applicationName, applicationVersion);
            if (!this.isApplicationAlreadyInstalled(applicationName, applicationVersion)) {
                this.checkApplicationRuntimeAndFrameworkRuntime(instFileURL, msd);
            }
            ++l;
        }
    }

    private void installApplicationFromLink(String url, MobileSolutionDescriptor msd, ApplicationType at) {
        boolean anotherVersionIsInstalled = this.isApplicationAlreadyInstalledInAnotherVersion(msd.getName(), msd.getVersion());
        if (!anotherVersionIsInstalled) {
            try {
                msd.setType(at);
                at.install(url, msd);
            }
            catch (UnknownApplicationTypeException uatex) {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(uatex.getReason());
                return;
            }
            catch (InstallationException instex) {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message(instex.getMessage());
                return;
            }
            msd.setInstalled(true);
            msd.setIncomplete(false);
            ApplicationManager.getInstance().registerMobileSolutionDescriptor(msd);
            RegistryInboundProcessingLog.getInstance().addInstalledApplicationInfo(msd);
        }
    }

    private boolean isApplicationAlreadyInstalledInAnotherVersion(String name, String version) {
        MobileSolutionDescriptor[] msds = ApplicationManager.getInstance().getMobileSolutionDescriptors();
        int i = 0;
        while (i < msds.length) {
            if (msds[i].getName().equalsIgnoreCase(name) && msds[i].getVersion().equalsIgnoreCase(version)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkApplicationRuntimeAndFrameworkRuntime(String instFileURL, MobileSolutionDescriptor msd) {
        if (instFileURL.endsWith(".jar")) {
            if (Configuration.getMERuntime().equalsIgnoreCase("awt")) {
                this.installApplicationFromLink(instFileURL, msd, new AwtApplicationType());
            } else {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message("Your Mobile Engine version does not support AWT applications. Therefore, the application " + msd.getName() + " does not get installed. Please contact your administrator!");
            }
        } else if (instFileURL.endsWith(".war")) {
            if (Configuration.getMERuntime().equalsIgnoreCase("tomcat")) {
                this.installApplicationFromLink(instFileURL, msd, new JspApplicationType());
            } else {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message("Your Mobile Engine version does not support JSP applications. Therefore, the application " + msd.getName() + " does not get installed. Please contact your administrator!");
            }
        } else if (instFileURL.endsWith(".zip")) {
            if (!Configuration.getMERuntime().equalsIgnoreCase("awt")) {
                this.installApplicationFromLink(instFileURL, msd, new LitsApplicationType());
            } else {
                RegistryInboundProcessingLog.getInstance().addBapiRet2Message("Your Mobile Engine version does not support MicroITS applications. Therefore, the application " + msd.getName() + " does not get installed. Please contact your administrator!");
            }
        } else {
            RegistryInboundProcessingLog.getInstance().addBapiRet2Message("The file type is not supported!");
        }
    }

    private void deleteAllDataForConversationId(ConversationId convid) throws PersistenceException {
        ((PersistenceCleaner)((Object)PersistenceRuntime.getInstance())).deleteAllDataForConversationId(convid);
    }

    private void initialAuthSyncBOMetaDataDeployment() {
        if (!this.checkIfAnApplicationIsInstalled()) {
            return;
        }
        String install = null;
        String pathname = null;
        ApplicationManager appman = ApplicationManager.getInstance();
        MobileSolutionDescriptor msd = appman.getFrameworkMobileSolutionDescriptor();
        if (!msd.isItASmartSyncApplication()) {
            ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForApplication(msd);
            int i = 0;
            while (i < cis.length) {
                if (cis[i].isSharedConversationId() && cis[i].isGeneratedOnServer()) {
                    install = Configuration.getSettingsFolder();
                    pathname = install + AUTH_SYNCBO_LOC;
                    SmartSyncDeplAdapter d = (SmartSyncDeplAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.DeplAdapterImpl");
                    msd.setUsingSmartSync(true);
                    d.setMetaDataFile(msd.getName(), new File(pathname));
                    d.processMetaData(cis[i]);
                    try {
                        appman.saveMobileSolutionDescriptors();
                    }
                    catch (IOException ioEx) {
                        AppLog.getInstance("MI/Deployment").logException("Error while updating MSD info; check the device", (Throwable)ioEx, true);
                    }
                }
                ++i;
            }
        }
    }

    private boolean checkIfAnApplicationIsInstalled() {
        ApplicationManager appman = ApplicationManager.getInstance();
        MobileSolutionDescriptor[] msds = appman.getMobileSolutionDescriptors();
        int i = 0;
        while (i < msds.length) {
            if (msds[i].getPropertyValueForKey("TYPE").equalsIgnoreCase("APPLICATION")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

