/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.web.liTS.util;

import com.sap.ip.me.api.sync.SyncManager;
import com.sapmarkets.web.liTS.util.TimeSeries;
import com.sapmarkets.web.liTS.util.TimeStamp;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PerformanceMonitor {
    int parameter;
    String _description;
    Vector _timeSeries = new Vector();
    private static TimeSeries _actualTimeSeries = null;
    long _timeForBenchmark;
    private static boolean _isRunning;

    public PerformanceMonitor(String description) {
        this._description = description;
        _isRunning = true;
    }

    public void startSeries(int parameter) {
        _isRunning = true;
        _actualTimeSeries = new TimeSeries(parameter);
        _actualTimeSeries.start();
    }

    public void stopSeries() {
        _isRunning = false;
        _actualTimeSeries.stop();
        this._timeSeries.addElement(_actualTimeSeries);
    }

    public static void changeParameter(int parameter) {
        if (!_isRunning) {
            return;
        }
        if (_actualTimeSeries == null) {
            return;
        }
        _actualTimeSeries.changeParameter(parameter);
    }

    public static void setTimeStamp(String label) {
        if (!_isRunning) {
            return;
        }
        if (_actualTimeSeries == null) {
            return;
        }
        _actualTimeSeries.setTimeStamp(label);
    }

    public void runBenchMark() {
        long time1 = System.currentTimeMillis();
        int i1 = 5;
        int i2 = 7;
        int i = 0;
        while (i < 10000000) {
            int r = i1 + i2;
            ++i;
        }
        long time2 = System.currentTimeMillis();
        this._timeForBenchmark = time2 - time1;
    }

    public void writeResult(String fileName) {
        File fileOut = new File(fileName);
        boolean append = false;
        try {
            FileWriter fileOutWriter = new FileWriter(fileOut.getAbsolutePath(), append);
            fileOutWriter.write(this._description + "\n");
            fileOutWriter.write("Time for Benchmark:; " + this._timeForBenchmark + "; mSec");
            fileOutWriter.write("\n");
            TimeSeries firstSeries = (TimeSeries)this._timeSeries.firstElement();
            TimeStamp[] firstts = firstSeries.getTimeStamps();
            fileOutWriter.write("Parameter");
            fileOutWriter.write(";");
            int i = 0;
            while (i < firstts.length) {
                if (firstts[i] != null) {
                    fileOutWriter.write(firstts[i].getLabel());
                    fileOutWriter.write(";");
                }
                ++i;
            }
            fileOutWriter.write("\n");
            Enumeration enumTseries = this._timeSeries.elements();
            TimeSeries tseries = null;
            while (enumTseries.hasMoreElements()) {
                tseries = (TimeSeries)enumTseries.nextElement();
                fileOutWriter.write(tseries.getParameter() + ";");
                TimeStamp[] ts = tseries.getTimeStamps();
                int i2 = 0;
                while (i2 < ts.length) {
                    if (ts[i2] != null) {
                        String time = Long.toString(ts[i2].getTime());
                        fileOutWriter.write(time);
                        fileOutWriter.write(";");
                    }
                    ++i2;
                }
                fileOutWriter.write("\n");
            }
            fileOutWriter.write("\n");
            fileOutWriter.flush();
            fileOutWriter.close();
        }
        catch (IOException e) {
            System.out.println("Cannot open file " + fileName + " for writing results.");
        }
    }

    public static void runSyncTest() {
        PerformanceMonitor p = new PerformanceMonitor("Sync with generic body: Send and receive an xml file with multiples of 9 kB length");
        p.runBenchMark();
        int fileSize = 9;
        int factor = 1;
        while (factor < 4) {
            p.startSeries(factor * fileSize);
            SyncManager.getInstance().synchronizeWithBackend();
            p.stopSeries();
            factor += 5;
        }
        p.writeResult("PerformanceTest.ssv");
    }

    public static void main(String[] args) {
        PerformanceMonitor p = new PerformanceMonitor("Sync with generic body: Send and receive an xml file with multiples of 9 kB length");
        p.runBenchMark();
        p.startSeries(1);
        PerformanceMonitor.changeParameter(2);
        p.stopSeries();
        p.writeResult("TestPerformanceMonitor.txt");
    }
}

