/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.web.liTS.util.PDAFile;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.services.Log;
import com.sap.ip.me.api.services.MEException;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileException;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileStructure;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PDAFileListHandling
implements FilenameFilter,
PDAFileStructure {
    public String fileBase;
    private String _fileExt;

    public PDAFileListHandling(String fileBase, String fileExt) throws MEException {
        String wwwroot = Configuration.getInstance().getProperty("MobileEngine.Runtime.WwwRoot");
        if (wwwroot == null) {
            throw new MEException("System.property 'wwwroot' not set");
        }
        StringBuffer sb = new StringBuffer(wwwroot);
        sb.append(PDAFileStructure.LITS_DIR);
        sb.append(fileBase);
        this.fileBase = sb.toString();
        this._fileExt = fileExt.startsWith(".") ? fileExt : "." + fileExt;
    }

    public PDAFileListHandling() throws MEException {
        String wwwroot = Configuration.getInstance().getProperty("MobileEngine.Runtime.WwwRoot");
        if (wwwroot == null) {
            throw new MEException("Property 'wwwroot' not set");
        }
        StringBuffer sb = new StringBuffer(wwwroot);
        sb.append(PDAFileStructure.LITS_DIR);
        sb.append(PDAFileStructure.SYNC_DIR);
        this.fileBase = sb.toString();
        this._fileExt = ".txt";
    }

    public boolean accept(File dir, String fileName) {
        return fileName.endsWith(this._fileExt);
    }

    public Enumeration files() throws PDAFileException {
        Vector<String> v = new Vector<String>();
        int extLen = this._fileExt.length();
        File f = new File(this.fileBase);
        File absoluteFile = new File(f.getAbsolutePath());
        if (!absoluteFile.exists()) {
            throw new PDAFileException(" no such folder: " + this.fileBase);
        }
        if (Log.isLogging(90)) {
            Log.log(90, "PDAFileListHandling.files: absoluteFile.getPath(): {0}", (Object)absoluteFile.getPath());
        }
        if (absoluteFile.isDirectory()) {
            String[] files;
            if (Log.isLogging(90)) {
                Log.log(90, "PDAFileListHandling.files: File is directory {0}", (Object)absoluteFile.getPath());
            }
            if ((files = absoluteFile.list(this)) != null) {
                int i = 0;
                while (i < files.length) {
                    String name = files[i].substring(0, files[i].length() - extLen);
                    v.addElement(name);
                    ++i;
                }
            }
        }
        return v.elements();
    }

    public String getBaseDir() {
        return this.fileBase;
    }

    public String getTopDir() throws MEException {
        if (System.getProperty("running_on_tomcat") != null) {
            String waftopdir = Configuration.getInstance().getProperty("MobileEngine.Runtime.WafTopDir");
            return waftopdir;
        }
        String topDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        return topDir;
    }

    public String getFileName(String file) {
        StringBuffer fileName = new StringBuffer(this.fileBase);
        fileName.append(file).append(this._fileExt);
        File helper = new File(fileName.toString());
        return helper.getAbsolutePath();
    }

    public Date getFileDate(String fName) throws PDAFileException {
        String fileName = this.getFileName(fName);
        File file = new File(fileName);
        if (!file.exists()) {
            throw new PDAFileException("file not found: " + fileName);
        }
        return new Date(file.lastModified());
    }

    public void deleteFile(String fName) throws PDAFileException {
        File file = new File(this.getFileName(fName));
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new PDAFileException("could not delete " + this.getFileName(fName));
        }
    }
}

