/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.wafJLib.collections;

import com.sapmarkets.wafJLib.collections.CLUnit;

public final class ChainedList {
    private CLUnit FirstUnit = null;
    private CLUnit LastUnit = null;
    private int Size = 0;
    private CLUnit EnumUnit;

    public CLUnit getFirstUnit() {
        return this.FirstUnit;
    }

    public CLUnit getLastUnit() {
        return this.LastUnit;
    }

    public int size() {
        return this.Size;
    }

    public boolean isEmpty() {
        return this.Size == 0;
    }

    public void resetEnum() {
        this.EnumUnit = this.FirstUnit;
    }

    public synchronized Object next() {
        CLUnit retUnit = this.EnumUnit;
        if (this.EnumUnit != null) {
            this.EnumUnit = this.EnumUnit.NextUnit;
        }
        return retUnit != null ? retUnit.Value : null;
    }

    public synchronized boolean setValue(Object value) {
        if (value == null) {
            return false;
        }
        this.LastUnit = this.FirstUnit = new CLUnit(null, null, value);
        this.Size = 1;
        return true;
    }

    public synchronized boolean appendValue(Object value) {
        if (value == null) {
            return false;
        }
        CLUnit newUnit = new CLUnit(this.LastUnit, null, value);
        if (this.FirstUnit == null) {
            this.FirstUnit = newUnit;
            this.FirstUnit.PrevUnit = null;
        }
        if (this.LastUnit != null) {
            this.LastUnit.NextUnit = newUnit;
        }
        this.LastUnit = newUnit;
        ++this.Size;
        return true;
    }

    public synchronized boolean appendValues(Object[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        CLUnit tempUnit = null;
        int i = 0;
        if (this.FirstUnit == null) {
            tempUnit = this.FirstUnit = new CLUnit(null, null, values[0]);
            i = 1;
        } else {
            tempUnit = this.LastUnit;
        }
        while (i < values.length) {
            CLUnit newUnit;
            tempUnit.NextUnit = newUnit = new CLUnit(tempUnit, null, values[i++]);
            tempUnit = newUnit;
        }
        this.LastUnit = tempUnit;
        this.LastUnit.NextUnit = null;
        this.Size += values.length;
        return true;
    }

    public synchronized Object getValue(int index) {
        if (this.Size < index) {
            return null;
        }
        CLUnit tempUnit = this.FirstUnit;
        while (index > 0 && tempUnit != null) {
            tempUnit = tempUnit.NextUnit;
            --index;
        }
        return tempUnit.Value;
    }

    public synchronized boolean setValues(Object[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        this.Size = 0;
        CLUnit tempUnit = this.FirstUnit = new CLUnit(null, null, values[this.Size++]);
        while (this.Size < values.length) {
            CLUnit newUnit;
            tempUnit.NextUnit = newUnit = new CLUnit(tempUnit, null, values[this.Size++]);
            tempUnit = newUnit;
        }
        this.LastUnit = tempUnit;
        this.LastUnit.NextUnit = null;
        return true;
    }

    public synchronized boolean setValueAt(Object value, int index) {
        if (value == null || this.Size < index) {
            return false;
        }
        CLUnit tempUnit = this.FirstUnit;
        while (index > 0 && tempUnit != null) {
            tempUnit = tempUnit.NextUnit;
            --index;
        }
        tempUnit.Value = value;
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" bears ");
        sb.append(this.Size);
        sb.append(" Values!\r\n");
        int i = 0;
        CLUnit tempUnit = this.FirstUnit;
        while (tempUnit != null) {
            sb.append(i++);
            sb.append(" ");
            sb.append(tempUnit.Value);
            sb.append("\r\n");
            tempUnit = tempUnit.NextUnit;
        }
        return sb.toString();
    }
}

