/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.meLib.io;

import java.util.Hashtable;

public final class SynchronizedKeyQueue {
    static final int MINIMAL_INITIAL_CAPACITY = 10;
    static final int DEFAULT_INITIAL_CAPACITY = 10;
    static final int HASH_ANTICOLLISION_OVERHEAD = 10;
    private Hashtable hashedObjects;
    private ObjectWrapper nextPush;
    private ObjectWrapper nextPop;
    private int elements;
    private int capacity;
    private int popPos;
    private int pushPos;

    SynchronizedKeyQueue() {
        this(10);
    }

    SynchronizedKeyQueue(int capacity) {
        if (capacity < 10) {
            capacity = 10;
        }
        this.hashedObjects = new Hashtable(capacity + 10);
        this.capacity = capacity;
        this.clear();
    }

    public static void main(String[] args) {
        SynchronizedKeyQueue queue = new SynchronizedKeyQueue();
        int TEST_SIZE = 30;
        int x = 0;
        while (x < TEST_SIZE) {
            Integer i = new Integer(x);
            String s = Integer.toString(x);
            queue.push(s, i);
            System.out.println("Pushing... " + x);
            ++x;
        }
        Integer prevValue = new Integer(0);
        int counter = 0;
        while (queue.hasMoreElements()) {
            ++counter;
            Integer value = (Integer)queue.pop();
            System.out.println("Popping... " + value);
            if (value < prevValue) {
                throw new RuntimeException("Error in test");
            }
            prevValue = value;
        }
        if (counter < TEST_SIZE) {
            throw new RuntimeException("Not all elements returned");
        }
        queue.clear();
        if (queue.pop() != null) {
            throw new RuntimeException("Nothing to pop");
        }
        if (queue.hasMoreElements()) {
            throw new RuntimeException("hasMoreElements() works incorrectly");
        }
        String[] sArray = new String[TEST_SIZE];
        int x2 = 0;
        while (x2 < TEST_SIZE) {
            Integer i = new Integer(x2);
            String s = Integer.toString(x2);
            queue.push(s, i);
            sArray[x2] = s;
            ++x2;
        }
        int x3 = 0;
        while (x3 < TEST_SIZE) {
            System.out.println("Verifying the " + x3 + " element");
            if (!queue.containsKey(sArray[x3])) {
                throw new RuntimeException("contains() works incorreclty");
            }
            ++x3;
        }
        int x4 = TEST_SIZE;
        while (x4 < TEST_SIZE + TEST_SIZE) {
            if (queue.containsKey(Integer.toString(x4))) {
                throw new RuntimeException("contains() works incorreclty");
            }
            ++x4;
        }
    }

    synchronized void push(Object hashKey, Object pushObject) {
        if (pushObject == null) {
            throw new RuntimeException("object is null");
        }
        ObjectWrapper objectWithSameKey = (ObjectWrapper)this.hashedObjects.get(hashKey);
        if (objectWithSameKey != null) {
            objectWithSameKey.object = pushObject;
        } else {
            ++this.elements;
            this.nextPush.object = pushObject;
            this.nextPush.hashKey = hashKey;
            this.hashedObjects.put(this.nextPush.hashKey, this.nextPush);
            ObjectWrapper nextPush = new ObjectWrapper();
            nextPush.prev = this.nextPush;
            this.nextPush.next = nextPush;
            this.nextPush = nextPush;
        }
    }

    synchronized Object pop() {
        Object popObject = null;
        if (this.elements > 0) {
            --this.elements;
            popObject = this.nextPop.object;
            this.hashedObjects.remove(this.nextPop.hashKey);
            this.nextPop = this.nextPop.next;
            this.nextPop.prev = null;
        }
        return popObject;
    }

    synchronized boolean hasMoreElements() {
        return this.elements > 0;
    }

    synchronized boolean containsKey(Object hashKey) {
        if (hashKey == null) {
            throw new RuntimeException("Object is null");
        }
        return this.hashedObjects.containsKey(hashKey);
    }

    synchronized Object get(Object hashKey) {
        ObjectWrapper objectWrapper = (ObjectWrapper)this.hashedObjects.get(hashKey);
        return objectWrapper != null ? objectWrapper.object : null;
    }

    synchronized void remove(Object hashKey) {
        if (hashKey == null) {
            throw new RuntimeException("Object is null");
        }
        ObjectWrapper removeObject = (ObjectWrapper)this.hashedObjects.get(hashKey);
        if (removeObject == null) {
            throw new RuntimeException("Object not in queue");
        }
        --this.elements;
        if (removeObject.prev != null) {
            removeObject.prev.next = removeObject.next;
        }
        if (removeObject.next != null) {
            removeObject.next.prev = removeObject.prev;
        }
        this.hashedObjects.remove(this.nextPop.hashKey);
        this.nextPop = this.nextPop.next;
        this.nextPop.prev = null;
    }

    synchronized void clear() {
        this.hashedObjects.clear();
        this.elements = 0;
        this.nextPop = this.nextPush = new ObjectWrapper();
    }

    int size() {
        return this.hashedObjects.size();
    }

    private class ObjectWrapper {
        private ObjectWrapper prev;
        private ObjectWrapper next;
        private Object object;
        private Object hashKey;

        private ObjectWrapper() {
        }
    }
}

