/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.meLib.io;

import com.sap.ip.me.api.conf.Configuration;
import com.sapmarkets.meLib.io.SynchronizedKeyQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FastObjectStorage {
    private static final Hashtable INSTANCES = new Hashtable();
    private static final int HASH_BUFFER_OVERHEAD = 20;
    private static final String ROOT_DIRECTORY = Configuration.getInstance().getProperty("MobileEngine.Runtime.WwwRoot", "wwwroot");
    private static final String MAPPING_TABLE_FILE_NAME_TMP = "mapping.tmp";
    private static final String MAPPING_TABLE_FILE_NAME_BAK = "mapping.bak";
    private static final String OBJECT_FILE_POSTFIX = ".d";
    private static final String MAPPING_TABLE_FILE_NAME = "mapping.dat";
    private static final String DATA_TOP_DIRECTORY = "data";
    private static int _TMP_testcycle;
    private FileAccessor fileAccessor;
    private Hashtable objectCache;
    private Hashtable objectModificationCache;
    private String subDirectory;
    private boolean allObjectsAreCached;
    private boolean isActive;

    private FastObjectStorage(String subDirectory) {
        System.out.println("Creating instance for FastObjectStorage " + subDirectory);
        this.subDirectory = subDirectory;
        this.startup();
    }

    public static synchronized FastObjectStorage getInstance(String iSubDirectory) {
        FastObjectStorage instance = (FastObjectStorage)INSTANCES.get(iSubDirectory);
        if (instance == null) {
            instance = new FastObjectStorage(iSubDirectory);
            INSTANCES.put(iSubDirectory, instance);
        }
        return instance;
    }

    public static void main(String[] args) {
        FastObjectStorage s = FastObjectStorage.getInstance("test");
        String option = "all";
        int testSize = 4;
        int testCycles = 130;
        try {
            if (args.length > 1) {
                testCycles = Integer.parseInt(args[1]);
            }
            if (args.length > 2) {
                testSize = Integer.parseInt(args[2]);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (option.equals("all") || option.equals("r")) {
            FastObjectStorage.readTest(s, testSize);
        }
        if (option.equals("all") || option.equals("w")) {
            FastObjectStorage.writeTest(s, testCycles, testSize);
        }
        if (option.equals("all") || option.equals("r")) {
            FastObjectStorage.readTest(s, testSize);
        }
        try {
            s.shutdown();
        }
        catch (DelayedThrowable t) {
            t.printStackTrace();
        }
    }

    public Object read(String iKey) throws IOException, ClassNotFoundException {
        return this.read(iKey, false);
    }

    public synchronized Object read(String iKey, boolean bypassCache) throws IOException, ClassNotFoundException {
        this.checkActive();
        Object object = null;
        if (!bypassCache) {
            object = this.objectCache.get(iKey);
        }
        if (object == null && (object = this.fileAccessor.read(iKey)) != null) {
            this.objectCache.put(iKey, object);
        }
        return object;
    }

    public synchronized void writeOnCommit(String key, Object value) {
        this.checkActive();
        this.objectModificationCache.put(key, new ModificationWrapper(key, value));
        this.objectCache.put(key, value);
    }

    public synchronized void deleteOnCommit(String key) {
        this.checkActive();
        this.objectModificationCache.put(key, new ModificationWrapper(key, null));
        this.objectCache.remove(key);
    }

    public synchronized void commit() throws DelayedThrowable, IOException {
        DelayedThrowable delayedThrowable;
        this.checkActive();
        if (this.fileAccessor.isBusy()) {
            this.fileAccessor.setNotifyWhenNotBusy();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if ((delayedThrowable = this.fileAccessor.getDelayedThrowable()) != null) {
            throw delayedThrowable;
        }
        Enumeration modObjects = this.objectModificationCache.elements();
        while (modObjects.hasMoreElements()) {
            ModificationWrapper modObj = (ModificationWrapper)modObjects.nextElement();
            this.fileAccessor.prepareModification(modObj);
        }
        this.fileAccessor.setBusy();
        this.objectModificationCache.clear();
    }

    public synchronized void rollback() throws IOException, ClassNotFoundException {
        this.checkActive();
        Enumeration rollbackObjNames = this.objectModificationCache.keys();
        while (rollbackObjNames.hasMoreElements()) {
            String key = ((ModificationWrapper)rollbackObjNames.nextElement()).key;
            this.read(key, true);
        }
        this.objectModificationCache.clear();
    }

    public synchronized Enumeration cachedObjects() {
        this.checkActive();
        return this.objectCache.elements();
    }

    public synchronized Enumeration allObjects() throws IOException, ClassNotFoundException {
        this.checkActive();
        if (!this.allObjectsAreCached) {
            Enumeration objectKeys = this.fileAccessor.keyFilenameMap.mappingTable.keys();
            while (objectKeys.hasMoreElements()) {
                String key = (String)objectKeys.nextElement();
                this.read(key, false);
            }
            this.allObjectsAreCached = true;
        }
        return this.cachedObjects();
    }

    public synchronized void startup() {
        if (!this.isActive) {
            System.out.println("Starting instance for FastObjectStorage " + this.subDirectory);
            this.fileAccessor = new FileAccessor();
            int objectCount = this.fileAccessor.keyFilenameMap.size() + 20;
            this.objectCache = new Hashtable(objectCount);
            this.objectModificationCache = new Hashtable(objectCount);
            this.allObjectsAreCached = false;
            this.isActive = true;
            System.out.println("Started instance for FastObjectStorage " + this.subDirectory);
            System.out.println("Main thread priority: " + Thread.currentThread().getPriority());
            System.out.println("Writer thread priority: " + this.fileAccessor.getPriority());
        }
    }

    public synchronized void shutdown() throws DelayedThrowable {
        if (this.fileAccessor.isBusy()) {
            this.fileAccessor.setNotifyWhenNotBusy();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        DelayedThrowable delayedThrowable = this.fileAccessor.getDelayedThrowable();
        if (this.isActive) {
            this.isActive = false;
            this.objectCache = null;
            this.objectModificationCache = null;
            boolean anyInstanceIsActive = false;
            Enumeration instances = INSTANCES.elements();
            while (instances.hasMoreElements()) {
                if (!((FastObjectStorage)instances.nextElement()).isActive) continue;
                anyInstanceIsActive = true;
            }
            if (!anyInstanceIsActive) {
                this.fileAccessor.finalize();
            }
        }
        if (delayedThrowable != null) {
            throw delayedThrowable;
        }
    }

    protected void finalize() {
        try {
            this.shutdown();
        }
        catch (DelayedThrowable delayedThrowable) {
            // empty catch block
        }
    }

    private static void readTest(FastObjectStorage s, int testSize) {
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("Read test");
        System.out.println();
        System.out.println();
        try {
            int y = 0;
            while (y < testSize) {
                String key = "KEY_" + y;
                String value = (String)s.read(key, true);
                if (value == null) {
                    System.out.println("No value could be read for " + key);
                }
                ++y;
            }
            _TMP_testcycle = (Integer)s.read("TESTCYCLE", true);
            System.out.println("Read testcycle " + _TMP_testcycle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeTest(FastObjectStorage s, int testCycles, int testSize) {
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("Write test");
        System.out.println();
        System.out.println();
        int x = 0;
        while (x < testCycles) {
            int y = 0;
            while (y < testSize) {
                String key = "KEY_" + y;
                String value = "Test cycle " + x + " value " + y;
                s.writeOnCommit(key, value);
                ++y;
            }
            s.writeOnCommit("TESTCYCLE", new Integer(++_TMP_testcycle));
            System.out.println("Wrote testcycle " + _TMP_testcycle);
            try {
                s.commit();
            }
            catch (IOException e) {
            }
            catch (DelayedThrowable e) {
                e.printStackTrace();
                e.getOriginalThrowable().printStackTrace();
            }
            ++x;
        }
    }

    private void checkActive() {
        if (!this.isActive) {
            throw new FatalException("FastObjectStorage: instance has been shutdown - operation cannot be performed");
        }
    }

    private class ModificationWrapper {
        String key;
        Object value;
        String oldFileName = null;
        String newFileName = null;
        ObjectOutputStream oldStream = null;
        ObjectOutputStream newStream = null;

        ModificationWrapper(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class DelayedThrowable
    extends Exception {
        private Throwable originalThrowable;

        private DelayedThrowable(String message, Throwable originalThrowable) {
            super(message);
            this.originalThrowable = originalThrowable;
        }

        public Throwable getOriginalThrowable() {
            return this.originalThrowable;
        }
    }

    public static class FatalException
    extends RuntimeException {
        private FatalException(String message) {
            super(message);
        }
    }

    private final class FileAccessor
    extends Thread {
        private String workingDirectory;
        private String mappingTableFileNameAbsolute;
        private String mappingTableFileNameAbsoluteTmp;
        private String mappingTableFileNameAbsoluteBak;
        private KeyFilenameMap keyFilenameMap;
        private SynchronizedKeyQueue objectsToWrite;
        private boolean isRunning;
        private boolean isBusy = false;
        private boolean notifyWhenNotBusy = false;
        private DelayedThrowable delayedThrowable = null;

        private FileAccessor() {
            super("FastObjectStorage.FileAccessor");
            System.out.println("Creating instance for FastObjectStorage.FileAccessor");
            this.initializeWorkingDirectory();
            this.initializeMapping();
            int numberOfFiles = this.keyFilenameMap.size();
            this.objectsToWrite = new SynchronizedKeyQueue(numberOfFiles);
            this.isRunning = true;
            System.out.println("Starting writer thread in FastObjectStorage.FileAccessor");
            this.start();
        }

        public void run() {
            System.out.println("Writer thread has been started");
            while (this.isRunning) {
                FileAccessor fileAccessor = this;
                synchronized (fileAccessor) {
                    try {
                        System.out.println("Writer is now waiting");
                        this.wait();
                        System.out.println("Writer thread has been waiting and notified");
                    }
                    catch (InterruptedException e) {
                        System.out.println("Writer thread has been waiting and interrupted");
                    }
                }
                this.delayedThrowable = this.applyModifications();
                FileAccessor fileAccessor2 = this;
                synchronized (fileAccessor2) {
                    this.isBusy = false;
                    if (this.notifyWhenNotBusy) {
                        this.notifyWhenNotBusy = false;
                        FastObjectStorage fastObjectStorage = FastObjectStorage.this;
                        synchronized (fastObjectStorage) {
                            FastObjectStorage.this.notify();
                        }
                    }
                }
            }
            System.out.println("Writer thread is terminating");
        }

        public synchronized DelayedThrowable getDelayedThrowable() {
            return this.delayedThrowable;
        }

        protected void finalize() {
            this.isRunning = false;
            FileAccessor fileAccessor = this;
            synchronized (fileAccessor) {
                this.notify();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private DelayedThrowable applyModifications() {
            DelayedThrowable delayedThrowable = null;
            SynchronizedKeyQueue filesToDelete = new SynchronizedKeyQueue(this.objectsToWrite.size());
            try {
                Object modObject;
                while (this.objectsToWrite.hasMoreElements()) {
                    modObject = (ModificationWrapper)this.objectsToWrite.pop();
                    String string = ((ModificationWrapper)modObject).newFileName;
                    synchronized (string) {
                        if (((ModificationWrapper)modObject).newStream != null) {
                            try {
                                ((ModificationWrapper)modObject).newStream.writeObject(((ModificationWrapper)modObject).value);
                            }
                            catch (Throwable t) {
                                ((ModificationWrapper)modObject).newStream.close();
                                return new DelayedThrowable("Throwable thrown during parallel file-writing-access", t);
                            }
                            ((ModificationWrapper)modObject).newStream.close();
                        }
                        if (((ModificationWrapper)modObject).oldStream != null) {
                            filesToDelete.push(((ModificationWrapper)modObject).key, modObject);
                        }
                    }
                }
                modObject = this.keyFilenameMap;
                synchronized (modObject) {
                    if (this.keyFilenameMap.isModified) {
                        ObjectOutputStream outStream = new ObjectOutputStream(new FileOutputStream(this.mappingTableFileNameAbsolute));
                        outStream.writeObject(this.keyFilenameMap);
                        outStream.close();
                    }
                }
                while (filesToDelete.hasMoreElements()) {
                    ModificationWrapper modObject2 = (ModificationWrapper)filesToDelete.pop();
                    String string = modObject2.oldFileName;
                    synchronized (string) {
                        modObject2.oldStream.close();
                        new File(modObject2.oldFileName).delete();
                    }
                }
                return delayedThrowable;
            }
            catch (Throwable t) {
                return new DelayedThrowable("Throwable thrown during parallel file-writing-access", t);
            }
        }

        private void initializeWorkingDirectory() {
            StringBuffer sbDir = new StringBuffer(ROOT_DIRECTORY);
            sbDir.append(File.separator);
            sbDir.append(FastObjectStorage.DATA_TOP_DIRECTORY);
            sbDir.append(File.separator);
            sbDir.append(FastObjectStorage.this.subDirectory);
            this.workingDirectory = new File(sbDir.toString()).getAbsolutePath();
            File dir = new File(this.workingDirectory);
            if (dir.exists() || !dir.mkdirs()) {
                // empty if block
            }
            this.mappingTableFileNameAbsolute = new File(this.workingDirectory, FastObjectStorage.MAPPING_TABLE_FILE_NAME).getAbsolutePath();
            this.mappingTableFileNameAbsoluteTmp = new File(this.workingDirectory, FastObjectStorage.MAPPING_TABLE_FILE_NAME_TMP).getAbsolutePath();
            this.mappingTableFileNameAbsoluteBak = new File(this.workingDirectory, FastObjectStorage.MAPPING_TABLE_FILE_NAME_BAK).getAbsolutePath();
        }

        private void initializeMapping() {
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.mappingTableFileNameAbsolute));
                this.keyFilenameMap = (KeyFilenameMap)is.readObject();
                is.close();
            }
            catch (Throwable t) {
                this.keyFilenameMap = new KeyFilenameMap();
            }
            this.keyFilenameMap.init(this.workingDirectory);
        }

        private synchronized void setNotifyWhenNotBusy() {
            this.notifyWhenNotBusy = true;
        }

        private synchronized boolean isBusy() {
            return this.isBusy;
        }

        private synchronized void setBusy() {
            this.isBusy = true;
            this.notify();
        }

        private Object read(String key) throws ClassNotFoundException, IOException {
            Object object = null;
            String fileName = null;
            KeyFilenameMap keyFilenameMap = this.keyFilenameMap;
            synchronized (keyFilenameMap) {
                fileName = this.keyFilenameMap.getFileName(key);
            }
            if (fileName != null) {
                String string = fileName;
                synchronized (string) {
                    ModificationWrapper modWrapper = (ModificationWrapper)this.objectsToWrite.get(key);
                    if (modWrapper == null) {
                        String absolutePath = new File(fileName).getAbsolutePath();
                        FileInputStream fileInStream = new FileInputStream(absolutePath);
                        ObjectInputStream objectInStream = new ObjectInputStream(fileInStream);
                        object = objectInStream.readObject();
                        objectInStream.close();
                        fileInStream.close();
                    } else {
                        object = modWrapper.value;
                    }
                }
            }
            return object;
        }

        private void prepareModification(ModificationWrapper mod) throws IOException {
            mod.oldFileName = this.keyFilenameMap.getFileName(mod.key);
            if (mod.oldFileName != null) {
                mod.oldStream = new ObjectOutputStream(new FileOutputStream(mod.oldFileName));
            }
            if (mod.value != null) {
                mod.newFileName = this.keyFilenameMap.generateFileName(mod.key);
            }
            if (mod.newFileName != null) {
                mod.newStream = new ObjectOutputStream(new FileOutputStream(mod.newFileName));
            }
            this.objectsToWrite.push(mod.key, mod);
        }

        private class KeyFilenameMap
        implements Serializable {
            private Hashtable mappingTable;
            private int fileNameCounter = Integer.MIN_VALUE;
            private transient boolean isModified = false;
            private transient Hashtable absoluteFileNames;
            private transient String workingDirectory;

            private KeyFilenameMap() {
                this.mappingTable = new Hashtable();
            }

            private void init(String workingDirectory) {
                this.workingDirectory = workingDirectory;
                this.absoluteFileNames = new Hashtable(this.mappingTable.size() + 20);
                Enumeration fileKeys = this.mappingTable.keys();
                while (fileKeys.hasMoreElements()) {
                    String key = (String)fileKeys.nextElement();
                    this.absoluteFileNames.put(key, this.convertToAbsoluteFilename((ObjVersionId)this.mappingTable.get(key)));
                }
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.writeInt(this.fileNameCounter);
                out.writeObject(this.mappingTable);
                this.isModified = false;
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                this.fileNameCounter = in.readInt();
                this.mappingTable = (Hashtable)in.readObject();
            }

            private String convertToAbsoluteFilename(ObjVersionId objVersionId) {
                if (objVersionId == null) {
                    return null;
                }
                StringBuffer absoluteFileName = new StringBuffer(this.workingDirectory);
                absoluteFileName.append(File.separator);
                absoluteFileName.append(Integer.toHexString(objVersionId.objectId));
                absoluteFileName.append(FastObjectStorage.OBJECT_FILE_POSTFIX);
                absoluteFileName.append(Integer.toHexString(objVersionId.versionId));
                return absoluteFileName.toString();
            }

            private String generateFileName(String key) {
                ObjVersionId objVersionId = (ObjVersionId)this.mappingTable.get(key);
                if (objVersionId == null) {
                    objVersionId = new ObjVersionId(this.fileNameCounter++);
                } else {
                    objVersionId.incVersionId();
                }
                this.mappingTable.put(key, objVersionId);
                this.isModified = true;
                String absoluteFileName = this.convertToAbsoluteFilename(objVersionId);
                this.absoluteFileNames.put(key, absoluteFileName);
                return absoluteFileName;
            }

            private String getFileName(String key) {
                return (String)this.absoluteFileNames.get(key);
            }

            private boolean contains(String key) {
                return this.mappingTable.contains(key);
            }

            private String removeFileName(String key) {
                String fileName = this.getFileName(key);
                if (fileName != null) {
                    this.mappingTable.remove(key);
                    this.isModified = true;
                    this.absoluteFileNames.remove(key);
                }
                return fileName;
            }

            private int size() {
                return this.mappingTable.size();
            }

            private class ObjVersionId
            implements Serializable {
                int objectId;
                byte versionId;

                private ObjVersionId(int objectId) {
                    this.objectId = objectId;
                    this.versionId = 0;
                }

                private void incVersionId() {
                    this.versionId = this.versionId < 127 ? (byte)(this.versionId + 1) : (byte)0;
                }
            }
        }
    }
}

