/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.meLib.customerExit;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.ui.microits.IContext;
import com.sapmarkets.meLib.customerExit.ICustomerExit;
import com.sapmarkets.meLib.customerExit.ILitsCustomerExit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CustomerExitAgent {
    private static final String _EXIT_DIRECTORY = "c_exits";
    private static final Hashtable _INSTANCES_FOR_PROP_FILES = new Hashtable();
    private Hashtable _exitInstances = new Hashtable();

    private CustomerExitAgent(String iPropsFileName) {
        this._readData(iPropsFileName);
    }

    public static CustomerExitAgent createInstance(String iPropsFileName) {
        CustomerExitAgent rAgent = (CustomerExitAgent)_INSTANCES_FOR_PROP_FILES.get(iPropsFileName);
        if (rAgent == null) {
            rAgent = new CustomerExitAgent(iPropsFileName);
            _INSTANCES_FOR_PROP_FILES.put(iPropsFileName, rAgent);
        }
        return rAgent;
    }

    public Object getAppSpecificExit(String iExitPos) {
        return this._exitInstances.get(iExitPos);
    }

    public Object callLitsExit(String iExitPos, IContext iContext, Object iObject, String iClassType) {
        return this._callExit(iExitPos, iContext, new Object[]{iObject}, iClassType);
    }

    public Object callLitsExit(String iExitPos, IContext iContext, Object[] iObject, String iClassType) {
        return this._callExit(iExitPos, iContext, iObject, iClassType);
    }

    public Object callExit(String iExitPos, Object iObject, String iClassType) {
        return this._callExit(iExitPos, null, new Object[]{iObject}, iClassType);
    }

    public Object callExit(String iExitPos, Object[] iObject, String iClassType) {
        return this._callExit(iExitPos, null, iObject, iClassType);
    }

    public boolean hasExit(String iExitPos) {
        return iExitPos != null && this._exitInstances.get(iExitPos) != null;
    }

    private Object _callExit(String iExitPos, IContext iContext, Object[] iObject, String iClassType) {
        Object exit;
        if (iExitPos != null && (exit = this._exitInstances.get(iExitPos)) != null) {
            Object[] obj = null;
            if (exit instanceof ILitsCustomerExit) {
                try {
                    obj = ((ILitsCustomerExit)exit).callExit(iExitPos, iContext, iObject);
                }
                catch (Throwable t) {
                    System.err.print("Error in customer exit " + iExitPos + " / class " + obj.getClass().getName());
                    t.printStackTrace();
                }
            } else if (exit instanceof ICustomerExit) {
                try {
                    obj = ((ICustomerExit)exit).callExit(iExitPos, iObject);
                }
                catch (Throwable t) {
                    System.err.print("Error in customer exit " + iExitPos + " / class " + obj.getClass().getName());
                    t.printStackTrace();
                }
            } else {
                System.err.print("Error when instantiating class " + obj.getClass().getName() + " for customer exit " + iExitPos + ":");
                System.err.println(" class does not implement interface com.sapmarkets.apps.addon.ICustomerExit / com.sapmarkets.apps.addon.ILitsCustomerExit");
            }
            if (this._checkReturnClassType(obj, iClassType)) {
                return obj;
            }
            return null;
        }
        return null;
    }

    private boolean _checkReturnClassType(Object iObject, String iClassType) {
        if (iObject == null) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(iClassType);
            return clazz.isInstance(iObject);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void _readData(String iPropsFileName) {
        Properties properties = new Properties();
        try {
            StringBuffer fileLocationBuffer = new StringBuffer(Configuration.getInstance().getProperty("MobileEngine.Runtime.WwwRoot"));
            fileLocationBuffer.append(File.separator).append("me").append(File.separator).append(_EXIT_DIRECTORY).append(File.separator).append(iPropsFileName);
            String fileLocation = fileLocationBuffer.toString();
            FileInputStream fileIn = new FileInputStream(fileLocation);
            properties.load(fileIn);
            fileIn.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Customer exits file not found: " + iPropsFileName);
        }
        catch (Throwable t) {
            System.err.println("Error when reading customer exit file: " + iPropsFileName);
        }
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = properties.getProperty(propName);
            if (propValue == null || propValue.trim().length() <= 0) continue;
            try {
                Class<?> clazz = Class.forName(propValue);
                try {
                    Constructor<?> constr = clazz.getConstructor(null);
                    try {
                        Object exit = constr.newInstance(null);
                        this._exitInstances.put(propName, exit);
                    }
                    catch (Throwable t) {
                        System.err.print("Error when instantiating class " + propValue + " for customer exit " + propName + ":");
                        if (!(t instanceof ClassCastException)) continue;
                        System.err.println(" class does not implement interface com.sapmarkets.apps.addon.ICustomerExit / com.sapmarkets.apps.addon.ILitsCustomerExit / application-defined interface");
                    }
                }
                catch (NoSuchMethodException e) {
                    System.err.println("Class " + propValue + "for customer exit " + propName + " has not the expected default constructor");
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("Class " + propValue + " for customer exit " + propName + " not found");
            }
        }
    }
}

