/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mi.ci;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.CommunicationServer;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.mi.ci.NativeStarter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class ClientInstallerStarter {
    private static final String MI_CLIENTINSTALLER_COMPONENT = "MI/ClientInstaller";
    public static final String MI_HOME_PLACEHOLDER = "%MI_HOME%";
    public static final String JAVA_EXE_PLACEHOLDER = "%JAVA_EXE%";
    public static final String CI_HOME_PLACEHOLDER = "%CI_HOME%";
    public static final String KEY_CI_HOME = "MI.ClientInstaller.Home";
    private static final String KEY_JAVA_EXECUTABLE = "MI.ClientInstaller.JavaExecutable";
    private static final String KEY_CI_COMMAND_LINE = "MI.ClientInstaller.StaticCommandLine ";
    private static final String KEY_MI_HOME = "MI.Home";
    private static final String KEY_COMMUNICATIONPORT = "MI.CommunicationServer.Port";
    private static final String KEY_MI_EXECUTABLE = "MI.Executable";
    private static final String KEY_MI_COMMAND_LINE = "MI.StaticCommandLine";
    private static final String KEY_ARCHIVE_PREFIX = "MI.ClientInstaller.Archives.";
    private static String miHome = Configuration.getInstallationDirectory();
    private static String CI_HOME = null;
    private static String javaexe = null;

    private static String getJavaExecutable() {
        if (javaexe != null) {
            return javaexe;
        }
        Trace trace = Trace.getInstance(MI_CLIENTINSTALLER_COMPONENT);
        String exestring = Configuration.getInstance().getProperty(KEY_JAVA_EXECUTABLE);
        trace.log(90, "Get java executable using executable string ''{0}''", (Object)exestring);
        String javahome = System.getProperty("java.home");
        if (javahome.endsWith("/") || javahome.endsWith("\\")) {
            javahome = javahome.substring(0, javahome.length() - 1);
        }
        trace.log(90, "Get java executable using java home ''{0}''", (Object)javahome);
        if (exestring != null) {
            File f = new File(exestring);
            if (f.exists()) {
                javaexe = exestring;
                trace.log(90, "Use java executable ''{0}'' (completely out of configuration)", (Object)javaexe);
                return exestring;
            }
            trace.log(90, "-- ''{0}'' does not exist", (Object)f.getAbsolutePath());
            StringBuffer sb = new StringBuffer();
            sb.append(javahome);
            sb.append(File.separatorChar).append(exestring);
            f = new File(sb.toString());
            if (f.exists()) {
                javaexe = f.getAbsolutePath();
                trace.log(90, "Use java executable ''{0}'' (partly out of configuration)", (Object)javaexe);
                return javaexe;
            }
            trace.log(90, "-- ''{0}'' does not exist", (Object)f.getAbsolutePath());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(javahome);
        sb.append(File.separatorChar).append("bin");
        sb.append(File.separatorChar).append("java.exe");
        File f = new File(sb.toString());
        if (f.exists()) {
            javaexe = f.getAbsolutePath();
            trace.log(90, "Use java executable ''{0}'' (win32 case)", (Object)javaexe);
            return javaexe;
        }
        trace.log(90, "-- ''{0}'' does not exist", (Object)f.getAbsolutePath());
        sb = new StringBuffer();
        sb.append(javahome);
        sb.append(File.separatorChar).append("bin");
        sb.append(File.separatorChar).append("CrEme.exe");
        f = new File(sb.toString());
        if (f.exists()) {
            javaexe = f.getAbsolutePath();
            trace.log(90, "Use java executable ''{0}'' (creme case)", (Object)javaexe);
            return javaexe;
        }
        trace.log(90, "-- ''{0}'' does not exist", (Object)f.getAbsolutePath());
        javaexe = "";
        return javaexe;
    }

    public static String getClientInstallerHome() {
        if (CI_HOME == null) {
            File f;
            CI_HOME = Configuration.getInstance().getProperty(KEY_CI_HOME, "");
            if (CI_HOME.length() == 0) {
                CI_HOME = Configuration.getInstallationDirectory() + "/bin/ci";
            }
            if (CI_HOME.startsWith(MI_HOME_PLACEHOLDER)) {
                CI_HOME = miHome + CI_HOME.substring(MI_HOME_PLACEHOLDER.length());
            }
            if (!(f = new File(CI_HOME = CI_HOME.replace('/', File.separatorChar))).exists()) {
                f.mkdirs();
            }
        }
        return CI_HOME;
    }

    public static int startClientInstaller() {
        int result = 0;
        Trace trace = Trace.getInstance(MI_CLIENTINSTALLER_COMPONENT);
        Configuration config = Configuration.getInstance();
        String ciHome = ClientInstallerStarter.getClientInstallerHome();
        String executable = ClientInstallerStarter.replacePlaceholders(ClientInstallerStarter.getJavaExecutable());
        if (executable.length() == 0) {
            trace.log(60, "Client installer is not configured");
        }
        StringBuffer command = new StringBuffer(256);
        command.append(ClientInstallerStarter.replacePlaceholders(config.getProperty("MI.ClientInstaller.StaticCommandLine", ""))).append(" ");
        command.append(" -debug ");
        try {
            ClientInstallerStarter.writeParameterFile(ciHome, executable, command.toString());
            trace.log(80, "Call Native Starter with executable ''{0}'' and command ''{1}''", (Object)executable, (Object)command.toString());
            result = NativeStarter.executeCommand(executable, command.toString());
        }
        catch (UnsatisfiedLinkError error) {
            trace.logException(50, "Cannot execute client installer", error, true);
            System.err.println("Cannot execute Client Installer");
            result = -1;
        }
        catch (Exception error) {
            trace.logException(50, "Cannot execute client installer", error, true);
            System.out.println("Cannot execute Client Installer");
            result = -1;
        }
        return result;
    }

    private static void writeParameterFile(String rootfolder, String executable, String command) throws IOException {
        File f = new File(rootfolder, "CIParams.properties");
        Properties props = new Properties();
        MobileSolutionDescriptor[] msds = ApplicationManager.getInstance().getMobileSolutionDescriptors();
        int i = 0;
        while (i < msds.length) {
            if (msds[i].isClientInstallerArchive() && msds[i].isIncomplete() && !msds[i].isFailed()) {
                String[] files = msds[i].getInstalledFiles();
                String filename = "";
                int j = 0;
                while (j < files.length) {
                    if (files[j].toLowerCase().endsWith(".zip")) {
                        filename = files[j].substring(files[j].lastIndexOf(File.separatorChar) + 1);
                        break;
                    }
                    ++j;
                }
                ((Hashtable)props).put(KEY_ARCHIVE_PREFIX + String.valueOf(i) + "." + msds[i].getName() + "." + msds[i].getVersion(), filename);
            }
            ++i;
        }
        Configuration config = Configuration.getInstance();
        ((Hashtable)props).put(KEY_CI_COMMAND_LINE, command);
        ((Hashtable)props).put(KEY_CI_HOME, ClientInstallerStarter.getClientInstallerHome());
        ((Hashtable)props).put(KEY_COMMUNICATIONPORT, String.valueOf(CommunicationServer.getPort()));
        ((Hashtable)props).put(KEY_JAVA_EXECUTABLE, ClientInstallerStarter.getJavaExecutable());
        ((Hashtable)props).put(KEY_MI_COMMAND_LINE, ClientInstallerStarter.replacePlaceholders(config.getProperty(KEY_MI_COMMAND_LINE, "")));
        ((Hashtable)props).put(KEY_MI_EXECUTABLE, ClientInstallerStarter.replacePlaceholders(config.getProperty(KEY_MI_EXECUTABLE, "")));
        ((Hashtable)props).put(KEY_MI_HOME, Configuration.getInstallationDirectory());
        props.save(new FileOutputStream(f), "MI Client Installer Parameter list, do not edit this file manually");
    }

    private static String replacePlaceholders(String source) {
        if (source == null || source.length() < MI_HOME_PLACEHOLDER.length()) {
            return source;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        int copyStartIndex = 0;
        int pos = source.indexOf(37);
        while (pos != -1) {
            String substring = source.substring(pos);
            if (substring.startsWith(MI_HOME_PLACEHOLDER)) {
                result.append(source.substring(copyStartIndex, pos));
                result.append(Configuration.getInstallationDirectory());
                copyStartIndex = pos + MI_HOME_PLACEHOLDER.length();
            } else if (substring.startsWith(CI_HOME_PLACEHOLDER)) {
                result.append(source.substring(copyStartIndex, pos));
                result.append(ClientInstallerStarter.getClientInstallerHome());
                copyStartIndex = pos + CI_HOME_PLACEHOLDER.length();
            } else if (substring.startsWith(JAVA_EXE_PLACEHOLDER)) {
                result.append(source.substring(copyStartIndex, pos));
                result.append(ClientInstallerStarter.getJavaExecutable());
                copyStartIndex = pos + JAVA_EXE_PLACEHOLDER.length();
            } else {
                ++pos;
            }
            pos = source.indexOf(37, copyStartIndex);
        }
        if (copyStartIndex < source.length()) {
            result.append(source.substring(copyStartIndex));
        }
        int sourceChar = 0;
        int targetChar = 0;
        while (sourceChar < result.length()) {
            if (result.charAt(sourceChar) == '\\') {
                if (sourceChar + 1 < result.length() && result.charAt(sourceChar + 1) == '/') {
                    result.setCharAt(targetChar, '/');
                    ++sourceChar;
                } else {
                    result.setCharAt(targetChar, result.charAt(sourceChar));
                }
            } else if (result.charAt(sourceChar) == '/') {
                result.setCharAt(targetChar, File.separatorChar);
            } else {
                result.setCharAt(targetChar, result.charAt(sourceChar));
            }
            ++sourceChar;
            ++targetChar;
        }
        result.setLength(targetChar);
        return result.toString();
    }
}

