/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import com.sap.ip.me.sync.SyncManagerImpl;

public class SyncTimer
extends Thread {
    private static final String NAME = "SyncTimer";
    private long timeBetweenSynchronisations = 36L;
    private boolean stopFlag = false;
    private long delay = System.currentTimeMillis();

    public SyncTimer(long timeInterval) {
        this();
        this.timeBetweenSynchronisations = timeInterval;
    }

    public SyncTimer() {
        super(NAME);
    }

    public long getTimeBetweenSynchronisations() {
        return this.timeBetweenSynchronisations;
    }

    public void run() {
        Trace trace = Trace.getInstance("MI/Sync");
        AppLog applog = AppLog.getInstance("MI/Sync");
        if (this.delay - System.currentTimeMillis() < this.timeBetweenSynchronisations) {
            try {
                trace.log(90, "{0} delay before first sync", (Object)this.getClass().getName());
                Thread.sleep(this.timeBetweenSynchronisations);
            }
            catch (InterruptedException inex) {
                applog.logException(inex);
            }
        }
        while (!this.stopRequested()) {
            trace.log(90, "{0} starting to synchronize", (Object)this.getClass().getName());
            if (UserManagerImpl.getUserManagerImplInstance().isSyncCredentialAvailable()) {
                SmartSyncAdapter smartSyncAdapter = (SmartSyncAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.SmartSyncAdapterImpl");
                smartSyncAdapter.initializeSmartSyncFrameworkForBackgroundSync();
                trace.log(90, "Background Sync started in Thread {0}", (Object)Thread.currentThread().getName());
                SyncManagerImpl smi = (SyncManagerImpl)SyncManager.getInstance();
                smi.synchronizeWithBackendInBackground(VisibilityType.SEPARATED);
            } else {
                applog.log(60, "Synchronization can not be triggered, because of missing user credential.");
            }
            try {
                Thread.sleep(this.timeBetweenSynchronisations);
            }
            catch (InterruptedException inex) {
                applog.logException(inex);
                this.stopFlag = true;
                break;
            }
        }
    }

    public synchronized void stopTimedSync() {
        this.stopFlag = true;
    }

    public String toString() {
        return "com.sap.ip.me.Synctimer: timeBetweenSynchronisations = " + this.timeBetweenSynchronisations + " stopFlag = " + this.stopFlag;
    }

    private synchronized boolean stopRequested() {
        return this.stopFlag;
    }
}

