/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.services.MEException;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.GuidFactory;
import com.sap.ip.me.sync.InboundProcessorRegistryImpl;
import com.sap.ip.me.sync.OutboundFileManager;
import com.sap.ip.me.sync.SyncContainer;
import com.sap.ip.me.sync.SyncContainerItem;
import com.sap.ip.me.sync.SyncFileManager;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncManagerImpl;
import com.sap.ip.me.sync.SyncManagerImplNewProtocol;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public final class SyncOutboundContainer
extends SyncContainer
implements OutboundContainer {
    private static final boolean NEW_PROTOCOL_USED = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false);
    private static final Object lock = new Object();
    private Hashtable lineNumbers = new Hashtable();
    private boolean initialvalueAlreadySet = false;
    private boolean closed = false;
    private ConversationId conversationId = null;

    SyncOutboundContainer(VisibilityType visibility, String method, String type) throws SyncException, IllegalArgumentException {
        this(ConversationIdHandler.getInstance().getCurrentConversationId(visibility), method, type);
    }

    public SyncOutboundContainer(ConversationId convId, String method, String type) throws SyncException, IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("unknown containertype " + type);
        }
        if (!SyncHeader.isKnownOutboundContainerType(type.charAt(0))) {
            throw new IllegalArgumentException("unknown containertype " + type);
        }
        if (!SyncHeader.isProtocolType(type.charAt(0)) && !InboundProcessorRegistry.getInstance().isRegistered(method)) {
            throw new SyncException("Method " + method + " is not registered!");
        }
        this.conversationId = convId;
        this.setHeader(new SyncHeader(GuidFactory.getGUID(), this.conversationId, type, method));
        this.initialvalueAlreadySet = false;
    }

    SyncOutboundContainer(File containerfile) throws SyncException {
        super(containerfile);
        this.closed = true;
        this.initialvalueAlreadySet = true;
        try {
            super.readContainer(true);
            if (SyncSettings.isNewProtocolActive()) {
                this.conversationId = ConversationIdHandler.getInstance().getConversationId(this.getHeader().getConversationId());
            }
        }
        catch (Exception ex) {
            throw new SyncException("Error while reading container from file; " + ex.getMessage());
        }
    }

    SyncOutboundContainer(SyncHeader header) {
        super(header);
        if (SyncSettings.isNewProtocolActive()) {
            this.conversationId = ConversationIdHandler.getInstance().getConversationId(header.getConversationId());
        }
    }

    public void close() throws SyncException {
        if (this.closed) {
            throw new SyncException("Container is already closed");
        }
        Object object = lock;
        synchronized (object) {
            boolean isItAnAcknowledge;
            if (this.closed) {
                throw new SyncException("Container is already closed");
            }
            SyncHeader header = this.getHeader();
            boolean setMsgIndex = header.sequenceNoHasToBeAttached();
            if (NEW_PROTOCOL_USED) {
                if (setMsgIndex) {
                    header.setMsgIndex(this.conversationId.getSequenceNoOut());
                }
                if (header.getSubContainerMax() <= 0) {
                    header.setSubContainerMax(this.getItemCount());
                }
            }
            User user = null;
            user = this.conversationId != null ? this.conversationId.getUser() : UserManagerImpl.getUserManagerImplInstance().getUser(header.getOwner());
            try {
                if (!NEW_PROTOCOL_USED) {
                    OutboundFileManager filemanager = ((SyncManagerImpl)SyncManager.getInstance()).getOutboundFileManager();
                    filemanager.writeContainerToOutboundFile(this, user, 1, -1);
                } else {
                    SyncManagerImplNewProtocol syncmananger = (SyncManagerImplNewProtocol)SyncManager.getInstance();
                    SyncFileManager fm = syncmananger.getSyncFileManager();
                    boolean inTransaction = syncmananger.isInTransactionalContext();
                    fm.writeOutboundContainer(this, user, inTransaction);
                    this.increaseSequenceNumber(setMsgIndex, inTransaction);
                }
            }
            catch (IOException ioException) {
                AppLog.getInstance("MI/Sync").logException("Container can not be written to the outbound file", (Throwable)ioException, true);
                throw new SyncException("Container can not be written to the outbound file");
            }
            boolean bl = isItAnAcknowledge = this.getHeader().isAcknowledge() && this.getHeader().isAcknowledgeReceived();
            if (!isItAnAcknowledge) {
                InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().outboundContainerCreated(user.getUniqueName(), header.getMethod());
            }
            if (NEW_PROTOCOL_USED && this.conversationId != null && this.conversationId.isGeneratedOnServer() && !isItAnAcknowledge) {
                InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().outboundContainerCreated(this.conversationId);
            }
            this.closed = true;
        }
    }

    private void increaseSequenceNumber(boolean setMsgIndex, boolean inTransactionalContext) throws SyncException {
        if (setMsgIndex) {
            try {
                this.conversationId.increaseSequenceNoOut(inTransactionalContext);
            }
            catch (MEException e) {
                AppLog.getInstance("MI/Sync").logException(50, "OutboundContainer can not be created", e, true);
                throw new SyncException("Problems while increasing current outbound sequence number");
            }
        }
    }

    public void addItem(String fieldname, int extLineNumber, String fieldvalue) throws SyncException {
        if (this.closed) {
            throw new SyncException("Container is already closed and a new item can not be added");
        }
        int nextIndex = this.getNextLineNumberForFieldname(fieldname);
        if (extLineNumber == -1) {
            extLineNumber = nextIndex;
        }
        if (fieldvalue == null) {
            throw new IllegalArgumentException("Fieldvalue cannot be null");
        }
        SyncContainerItem item = new SyncContainerItem(this.getItemCount(), fieldname, extLineNumber, fieldvalue);
        this.addItem(item);
        this.initialvalueAlreadySet = true;
        this.setNextLineNumberForFieldname(fieldname, ++extLineNumber);
    }

    public void addItem(String fieldName, String fieldValue) throws SyncException {
        this.addItem(fieldName, -1, fieldValue);
    }

    public ConversationId getConversationId() {
        return this.conversationId;
    }

    public int getNextLineNumberForFieldname(String fieldname) {
        if (fieldname == null || fieldname.length() == 0) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        Object next = this.lineNumbers.get(fieldname);
        int result = next == null ? 0 : (Integer)next;
        return result;
    }

    public boolean setInitialItemCount(int initialItemCount) {
        if (!this.initialvalueAlreadySet && initialItemCount > 0 && this.getItemCount() == 0) {
            this.initializeItems(initialItemCount);
            this.initialvalueAlreadySet = true;
        }
        return false;
    }

    SyncOutboundContainer getSubContainer(String subcontainerid, int indexfrom, int indexto) {
        SyncOutboundContainer subContainer = new SyncOutboundContainer(this.getHeader().clone(subcontainerid, indexfrom, indexto));
        while (indexfrom <= indexto) {
            subContainer.addItem(this.getItemAt(indexfrom));
            ++indexfrom;
        }
        subContainer.closed = this.closed;
        subContainer.initialvalueAlreadySet = this.initialvalueAlreadySet;
        subContainer.lineNumbers = this.lineNumbers;
        return subContainer;
    }

    private void setNextLineNumberForFieldname(String fieldname, int newValue) {
        this.lineNumbers.put(fieldname, new Integer(newValue));
    }
}

