/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.core.ContextSwitch;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.InstallationException;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.ContainerFactory;
import com.sap.ip.me.sync.InboundProcessorRegistryImpl;
import com.sap.ip.me.sync.LogSender;
import com.sap.ip.me.sync.OldSyncLog;
import com.sap.ip.me.sync.PackageManager;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import com.sap.ip.me.sync.SyncFileManager;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncInboundManager;
import com.sap.ip.me.sync.SyncLogImpl;
import com.sap.ip.me.sync.SyncManagerImpl;
import com.sap.ip.me.sync.SyncOutboundContainer;
import com.sapmarkets.web.liTS.util.PerformanceMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SyncManagerImplNewProtocol
extends SyncManagerImpl {
    private boolean inTransactionalContext = false;
    private SyncFileManager syncFileManager = new SyncFileManager();

    boolean isInTransactionalContext() {
        return this.inTransactionalContext;
    }

    private void setInTransactionalContext(boolean inTransactionalContext) {
        this.inTransactionalContext = inTransactionalContext;
    }

    public synchronized void beginTransaction() {
        this.trace.log(80, "Begin transaction for outbound containers");
        this.setInTransactionalContext(true);
    }

    public synchronized void rollbackTransaction() {
        this.trace.log(80, "rollback transaction for outbound containers");
        this.cleanTransactionalContext();
        this.trace.log(80, "Reload conversation ids");
        ConversationIdHandler.getInstance().load();
        this.setInTransactionalContext(false);
    }

    public synchronized void commitTransaction() {
        this.trace.log(80, "Commit transaction for outbound containers");
        this.moveContainers();
        this.trace.log(80, "Save conversation ids");
        ConversationIdHandler.getInstance().saveAll();
        this.setInTransactionalContext(false);
    }

    public SyncManagerImplNewProtocol() {
        SyncEventRegistry synceventreg = SyncEventRegistry.getInstance();
        ((SyncEventRegistryImpl)synceventreg).addSyncEventListener(new LogSender(), ConversationIdHandler.getSharedFrameworkConversationId());
        this.cleanTransactionalContext();
    }

    private void cleanTransactionalContext() {
        this.trace.log(80, "Clean up data container folders (transactional outbound folders)");
        UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
        Enumeration userenum = userManager.getAllUsers();
        SyncFileManager filemanager = this.getSyncFileManager();
        while (userenum.hasMoreElements()) {
            User u = (User)userenum.nextElement();
            filemanager.cleanTransactionOutboundFolder(u);
        }
        filemanager.cleanTransactionOutboundFolder(UserManagerImpl.getSharedUser());
    }

    private void moveContainers() {
        this.trace.log(80, "Move containers from transactional outbound folder to outbound folder");
        UserManagerImpl userManager = UserManagerImpl.getUserManagerImplInstance();
        Enumeration userenum = userManager.getAllUsers();
        SyncFileManager filemanager = this.getSyncFileManager();
        while (userenum.hasMoreElements()) {
            User u = (User)userenum.nextElement();
            filemanager.moveTransactionOutboundFolderToOutboundFolder(u);
        }
        filemanager.moveTransactionOutboundFolderToOutboundFolder(UserManagerImpl.getSharedUser());
    }

    protected void processSyncCycle(User selectedUser) throws SyncException, IOException {
        try {
            boolean morePackagesWaiting = true;
            PackageManager packageManager = new PackageManager(selectedUser, this.getSyncFileManager());
            this.addContainerIdsWithMaxMsgIndexToConversationids(selectedUser, packageManager);
            Hashtable alreadySentContainers = new Hashtable();
            while (morePackagesWaiting) {
                File currentOutboundFile = packageManager.getPackage(alreadySentContainers);
                if (currentOutboundFile != null) {
                    this.trace.log(90, "Package file {0} {1} and {2}", currentOutboundFile.getAbsolutePath(), currentOutboundFile.exists() ? "exists" : "does not exist", currentOutboundFile.canRead() ? "can be read" : "cannot be read");
                }
                if (currentOutboundFile == null || !currentOutboundFile.exists() || currentOutboundFile.length() == 0L) {
                    this.trace.log(80, "Skip sync for user {0} because outboundfile is empty", (Object)selectedUser);
                    break;
                }
                String currentInboundFilePath = this.getOutboundFileManager().getInboundFileName(selectedUser);
                OldSyncLog syncLog = OldSyncLog.getInstance();
                syncLog.started();
                this.trace.logFileContent(90, currentOutboundFile);
                boolean compressed = Configuration.getInstance().getBoolean("MobileEngine.Datacompression.Gzip", false);
                this.getCurrentSynchronizer().exchangeData(selectedUser.getUniqueID(), currentOutboundFile.getAbsolutePath(), currentInboundFilePath, compressed);
                OldSyncLog.getInstance().setStageConnectedOk();
                this.trace.log(80, "Synchronisation successfully connected ");
                SyncLogImpl.getSyncLogImplInstance().connected();
                try {
                    this.processInboundContainers(selectedUser, currentInboundFilePath, currentOutboundFile, packageManager);
                }
                catch (SyncException syncEx) {
                    if (syncEx.isOldDataReceived()) {
                        this.trace.log(60, "Received old data; inbound data ignored; continue with next data");
                    }
                    if (syncEx.isEmptyInboundReceived()) {
                        String msg = "Received empty inbound container file for user " + selectedUser.getUniqueID();
                        this.trace.log(60, msg);
                        syncLog.addMessage(msg);
                        break;
                    }
                    throw syncEx;
                }
                SyncLogImpl.getSyncLogImplInstance().responseProcessed();
                syncLog.inboundProcessingDone();
                boolean bl = morePackagesWaiting = this.getInboundManager().isMorePackagesWaiting() || packageManager.hasMorePackages();
                if (this.discSyncController != null) {
                    morePackagesWaiting = morePackagesWaiting || this.discSyncController.hasMoreSyncPackagesFromInbound(selectedUser.getUniqueID());
                }
                this.trace.log(90, morePackagesWaiting ? "There are more packages waiting" : "There are no more packages waiting");
            }
            InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().resetCreatedOutboundContainers(selectedUser.getUniqueName());
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            ContextSwitch.restoreOriginalContext();
            throw throwable;
        }
        ContextSwitch.restoreOriginalContext();
    }

    private void addContainerIdsWithMaxMsgIndexToConversationids(User selectedUser, PackageManager packageManager) {
        ConversationId[] convids = ConversationIdHandler.getInstance().getAllConversationIdsForUser(selectedUser);
        Hashtable maxContainerIds = packageManager.getLastGeneratedContainerIds();
        int i = 0;
        while (i < convids.length) {
            String containerid = (String)maxContainerIds.get(convids[i].getId());
            if (containerid != null) {
                convids[i].setLastSyncContainerId(containerid);
            }
            ++i;
        }
    }

    protected void createOutboundContainerForEachRegisteredMethod(User selectedUser) throws SyncException {
        this.trace.log(90, "Synchronisation: create outbound container for each conversation id");
        Enumeration methodEnum = InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().getAlLNotNotifiedConvIds(selectedUser.getUniqueName()).elements();
        while (methodEnum.hasMoreElements()) {
            ConversationId convId = (ConversationId)methodEnum.nextElement();
            if (!convId.isGeneratedOnServer()) continue;
            ContainerFactory.createNotifyContainer(convId);
        }
    }

    private void processInboundContainers(User user, String currentInboundFilePath, File outboundFile, PackageManager packageManager) throws SyncException {
        Object perfTag = PerformanceLog.methodStarted(this);
        SyncInboundManager inboundManager = this.getInboundManager();
        boolean isLogging = this.trace.isLogging(90);
        if (isLogging) {
            this.trace.log(90, "Number of pending inbound containers before inbound processing = {0}", (Object)Integer.toString(inboundManager.getPendingContainerCount()));
        }
        inboundManager.readInboundContainerFile(currentInboundFilePath, true);
        if (isLogging) {
            this.trace.log(90, "All inbound containers successfully read from file");
        }
        OldSyncLog.getInstance().inboundStarted();
        SyncInboundContainer[] containers = inboundManager.getArrayOfSyncInboundContainers();
        if (isLogging) {
            this.trace.log(90, "There are {0} inbound containers to be processed", (Object)Integer.toString(containers.length));
        }
        Vector<SyncInboundContainer> toBeProcessedInOrder = new Vector<SyncInboundContainer>();
        Vector<SyncInboundContainer> otherContainers = new Vector<SyncInboundContainer>();
        int acknowledgecounter = 0;
        int subcontainercounter = 0;
        int olddatacounter = 0;
        boolean oldData = this.getInboundManager().isOldData();
        SyncOutboundContainer[] acknowledges = this.collectAcknowledgeContainers(user);
        int i = 0;
        while (i < containers.length) {
            SyncInboundContainer container = containers[i];
            if (oldData || this.isAlreadyAcknowledged(container, acknowledges)) {
                this.trace.log(70, "Received container with id {0} that was already processed; ignore container", (Object)container.getContainerId());
                ++olddatacounter;
            } else if (container.isComplete()) {
                if (container.isAcknowledge()) {
                    packageManager.acknowledgeContainer(container);
                    ++acknowledgecounter;
                } else if (container.isSubContainer()) {
                    packageManager.acknowledgeContainer(container);
                    ++subcontainercounter;
                } else if (container.hasToBeProcessedInOrder()) {
                    toBeProcessedInOrder.addElement(container);
                } else {
                    otherContainers.addElement(container);
                }
            } else {
                this.trace.log(90, "Incomplete container: {0}", (Object)container);
            }
            ++i;
        }
        if (isLogging) {
            if (oldData) {
                this.trace.log(90, "Old data received - Processed {0} acknowledges and generated {1} acknowledges for containers", (Object)Integer.toString(acknowledgecounter), (Object)Integer.toString(olddatacounter));
            } else {
                this.trace.log(90, "Processed {0} acknowledges and  {1} sub-containers", (Object)Integer.toString(acknowledgecounter), (Object)Integer.toString(subcontainercounter));
            }
        }
        Object[] restContainers = new SyncInboundContainer[otherContainers.size()];
        otherContainers.copyInto(restContainers);
        PerformanceMonitor.setTimeStamp("Start processing inbound containers");
        this.processContainers(user, (SyncInboundContainer[])restContainers);
        if (isLogging) {
            this.trace.log(90, "Processed {0} not arranged containers", (Object)Integer.toString(restContainers.length));
        }
        this.processInOrder(toBeProcessedInOrder);
        if (isLogging) {
            this.trace.log(90, "Processed {0} ordered containers", (Object)Integer.toString(toBeProcessedInOrder.size()));
        }
        inboundManager.cleanUpPendingList();
        ContextSwitch.restoreOriginalContext();
        outboundFile.delete();
        if (isLogging) {
            this.trace.log(90, "Number of pending inbound containers after inbound processing = {0}", (Object)Integer.toString(inboundManager.getPendingContainerCount()));
        }
        PerformanceMonitor.setTimeStamp("Finished processing inbound containers");
        PerformanceLog.methodFinished(perfTag, "processInboundContainers");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processContainers(User user, SyncInboundContainer[] containers) {
        InboundProcessorRegistryImpl processorRegistry = InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance();
        SyncInboundManager inboundManager = this.getInboundManager();
        ConversationId defaultConversationId = ConversationIdHandler.getInstance().getCurrentConversationId();
        ConversationId tempConvId = null;
        int j = 0;
        while (j < containers.length) {
            OldSyncLog syncLog = OldSyncLog.getInstance();
            if (processorRegistry.isRegistered(containers[j].getMethod())) {
                block12: {
                    Object var12_13;
                    syncLog.addInboundProc(containers[j].getMethod());
                    ContextSwitch context = null;
                    try {
                        try {
                            tempConvId = containers[j].getConversationId();
                            if (tempConvId == null) {
                                this.trace.log(60, "Container {0} does not contain a conversation id, use defaull: {1}", (Object)containers[j].toString(), (Object)defaultConversationId);
                                context = ContextSwitch.switchContextTo(defaultConversationId);
                            } else {
                                context = ContextSwitch.switchContextTo(tempConvId);
                            }
                            processorRegistry.getInboundProcessor(containers[j].getMethod()).process(containers[j]);
                            this.trace.log(80, "SyncInboundProcessing finished successfully for method {0}", (Object)containers[j].getMethod());
                        }
                        catch (Exception e) {
                            syncLog.processingMethodFailed(containers[j].getMethod(), e);
                            var12_13 = null;
                            ContextSwitch.restoreLastContext(context);
                            break block12;
                        }
                        var12_13 = null;
                    }
                    catch (Throwable throwable) {
                        var12_13 = null;
                        ContextSwitch.restoreLastContext(context);
                        throw throwable;
                    }
                    ContextSwitch.restoreLastContext(context);
                }
                try {
                    ContainerFactory.createAcknowledgeContainer(containers[j], user, "A");
                }
                catch (Exception e) {
                    this.trace.logException("Cannot create acknowledge container for container " + containers[j].getContainerId(), (Throwable)e, true);
                }
                inboundManager.removeProcessedInboundContainer(containers[j]);
            } else {
                syncLog.unregisteredMethod(containers[j].getMethod());
            }
            ++j;
        }
        return;
    }

    private SyncOutboundContainer[] collectAcknowledgeContainers(User user) {
        SyncFileManager fileman = this.getSyncFileManager();
        String[] acknowledges = fileman.getAllOutboundAcknowledgeFileNames(user);
        SyncOutboundContainer[] result = new SyncOutboundContainer[acknowledges.length];
        int i = 0;
        while (i < acknowledges.length) {
            try {
                result[i] = new SyncOutboundContainer(new File(acknowledges[i]));
            }
            catch (Exception ex) {
                result[i] = null;
                this.trace.logException(60, "Cannot read acknowledge container", ex, true);
            }
            ++i;
        }
        return result;
    }

    private boolean isAlreadyAcknowledged(SyncInboundContainer container, SyncOutboundContainer[] acknowledges) {
        boolean result = false;
        SyncHeader contHeader = container.getSyncHeader();
        int i = 0;
        while (i < acknowledges.length) {
            if (acknowledges[i] != null) {
                SyncHeader ackHeader = acknowledges[i].getHeader();
                if (contHeader.getContainerId().equals(ackHeader.getAncestorContainerId()) && contHeader.getSubContainerId().equals(ackHeader.getSubContainerId()) && contHeader.getItemFrom() == ackHeader.getItemFrom() && contHeader.getItemTo() == ackHeader.getItemTo()) {
                    result = true;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processContainersInOrderForConvId(ConversationId convId, Vector unsortedContainers) {
        SyncInboundContainer[] containers = this.sortContainersBySequenceNumber(unsortedContainers, convId.getSequenceNoIn());
        InboundProcessorRegistryImpl processorRegistry = InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance();
        this.trace.log(70, "Process container in order for conversation id {0} ({1} containers)", (Object)convId, (Object)Integer.toString(containers.length));
        boolean isLogging = this.trace.isLogging(90);
        ConversationId defaultConversationId = ConversationIdHandler.getInstance().getCurrentConversationId();
        ConversationId tempConvId = null;
        int j = 0;
        while (true) {
            block16: {
                Object var13_13;
                if (j >= containers.length) {
                    return;
                }
                OldSyncLog syncLog = OldSyncLog.getInstance();
                if (!processorRegistry.isRegistered(containers[j].getMethod())) {
                    syncLog.unregisteredMethod(containers[j].getMethod());
                    AppLog.getInstance("MI/Sync").log(50, "inbound processing for conversation id {0} / {1} stopped, because some containers could not be processed", (Object)convId.getId(), (Object)convId.getServerCommunicationId());
                    return;
                }
                syncLog.addInboundProc(containers[j].getMethod());
                ContextSwitch context = null;
                try {
                    try {
                        tempConvId = containers[j].getConversationId();
                        if (tempConvId == null) {
                            this.trace.log(60, "Container {0} does not contain a conversation id, use defaull: {1}", (Object)containers[j].toString(), (Object)defaultConversationId);
                            context = ContextSwitch.switchContextTo(defaultConversationId);
                        } else {
                            context = ContextSwitch.switchContextTo(tempConvId);
                        }
                        if (isLogging) {
                            this.trace.log(90, "Process container: {0}", (Object)containers[j]);
                        }
                        processorRegistry.getInboundProcessor(containers[j].getMethod()).process(containers[j]);
                    }
                    catch (Exception e) {
                        syncLog.processingMethodFailed(containers[j].getMethod(), e);
                        AppLog.getInstance("MI/Sync").log(50, "inbound processing for conversation id {0} / {1} stopped, because some containers could not be processed", (Object)convId.getId(), (Object)convId.getServerCommunicationId());
                        var13_13 = null;
                        if (convId.getLastSyncContainerId().equals(containers[j].getAncestorContainerId())) {
                            convId.setLastSyncContainerId(null);
                        }
                        ContextSwitch.restoreLastContext(context);
                        break block16;
                    }
                    var13_13 = null;
                    if (convId.getLastSyncContainerId().equals(containers[j].getAncestorContainerId())) {
                        convId.setLastSyncContainerId(null);
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    if (convId.getLastSyncContainerId().equals(containers[j].getAncestorContainerId())) {
                        convId.setLastSyncContainerId(null);
                    }
                    ContextSwitch.restoreLastContext(context);
                    throw throwable;
                }
                ContextSwitch.restoreLastContext(context);
            }
            try {
                convId.increaseSequenceNoIn();
                this.trace.log(80, "SyncInboundProcessing finished successfully for method {0}", (Object)containers[j].getMethod());
                ContainerFactory.createAcknowledgeContainer(containers[j], convId.getUser(), "A");
            }
            catch (InstallationException e) {
                AppLog.getInstance("MI/Sync").logException(50, "Sequence number could not be increased", e, true);
                throw new RuntimeException("Sequence number can not be increased");
            }
            catch (SyncException e) {
                AppLog.getInstance("MI/Sync").logException(50, "Acknowledge container could not be created for already processed container", e, true);
                throw new RuntimeException("Acknowledge container can't be created");
            }
            ++j;
        }
    }

    private void processInOrder(Vector containers) {
        Hashtable containersByConvId = this.sortContainersByConversationId(containers);
        Enumeration convIdEnum = containersByConvId.keys();
        while (convIdEnum.hasMoreElements()) {
            ConversationId convId = (ConversationId)convIdEnum.nextElement();
            Vector containersForConvId = (Vector)containersByConvId.get(convId);
            this.processContainersInOrderForConvId(convId, containersForConvId);
        }
    }

    private SyncInboundContainer[] sortContainersBySequenceNumber(Vector containers, int lastProcessedSeqNo) {
        Enumeration containerEnum = containers.elements();
        SyncInboundContainer[] returnArray = new SyncInboundContainer[containers.size()];
        boolean adjustArray = false;
        while (containerEnum.hasMoreElements()) {
            SyncInboundContainer container = (SyncInboundContainer)containerEnum.nextElement();
            int seqNo = 0;
            try {
                seqNo = container.getSyncHeader().getMsgIndex();
                if (seqNo <= lastProcessedSeqNo) {
                    this.trace.log(70, "Received already processed inbound container with msg index {0}; container ignored", (Object)new Integer(seqNo));
                    adjustArray = true;
                    continue;
                }
                int index = seqNo - lastProcessedSeqNo - 1;
                if (returnArray[index] != null) {
                    adjustArray = true;
                    this.trace.log(60, "Multiple containers with sequence number {0}", (Object)new Integer(seqNo));
                }
                returnArray[index] = container;
            }
            catch (IndexOutOfBoundsException e) {
                AppLog.getInstance("MI/Sync").log(60, "Inbound container {0} with to big sequence number {1} will be ignored; check server outbound queue on server for pending containers", (Object)container.getContainerId(), (Object)new Integer(seqNo));
                adjustArray = true;
            }
        }
        if (!adjustArray) {
            return returnArray;
        }
        return this.getPurSequence(returnArray, lastProcessedSeqNo);
    }

    private Hashtable sortContainersByConversationId(Vector containers) {
        Hashtable<ConversationId, Vector<SyncInboundContainer>> containersByConvId = new Hashtable<ConversationId, Vector<SyncInboundContainer>>();
        Enumeration containerEnum = containers.elements();
        while (containerEnum.hasMoreElements()) {
            SyncInboundContainer container = (SyncInboundContainer)containerEnum.nextElement();
            ConversationId convId = ConversationIdHandler.getInstance().getConversationId(container.getSyncHeader().getConversationId());
            if (convId != null) {
                Vector<SyncInboundContainer> containersPerConvId = (Vector<SyncInboundContainer>)containersByConvId.get(convId);
                if (convId.getSequenceNoIn() < container.getSyncHeader().getMsgIndex()) {
                    if (containersPerConvId == null) {
                        containersPerConvId = new Vector<SyncInboundContainer>();
                    }
                    containersPerConvId.addElement(container);
                    containersByConvId.put(convId, containersPerConvId);
                    continue;
                }
                this.trace.log(70, "Container with id {0} already received and processed", (Object)container.getContainerId());
                continue;
            }
            AppLog.getInstance("MI/Sync").log(60, "Container with unknown conversation id {0} for method {1} received", (Object)container.getSyncHeader().getConversationId(), (Object)container.getSyncHeader().getMethod());
        }
        return containersByConvId;
    }

    private SyncInboundContainer[] getPurSequence(SyncInboundContainer[] containers, int lastProcessedSeqNo) {
        SyncInboundContainer[] returnArray = new SyncInboundContainer[]{};
        int firstNotNullInSequence = -1;
        int lastNotNullInSequence = -1;
        int i = 0;
        while (i < containers.length) {
            if (containers[i] != null) {
                if (firstNotNullInSequence == -1) {
                    firstNotNullInSequence = i;
                }
            } else if (firstNotNullInSequence != -1 && lastNotNullInSequence == -1) {
                lastNotNullInSequence = i - 1;
                break;
            }
            ++i;
        }
        if (firstNotNullInSequence == 0 && lastNotNullInSequence == -1) {
            returnArray = containers;
        } else if (firstNotNullInSequence != -1 || lastNotNullInSequence != -1) {
            if (firstNotNullInSequence != 0 && lastNotNullInSequence == -1) {
                returnArray = new SyncInboundContainer[containers.length - firstNotNullInSequence];
                int i2 = 0;
                while (i2 < returnArray.length) {
                    returnArray[i2] = containers[i2 + firstNotNullInSequence];
                    ++i2;
                }
            } else {
                returnArray = new SyncInboundContainer[lastNotNullInSequence - firstNotNullInSequence + 1];
                int i3 = 0;
                while (i3 < returnArray.length) {
                    returnArray[i3] = containers[i3 + firstNotNullInSequence];
                    ++i3;
                }
            }
        }
        if (returnArray.length != 0 && returnArray[0].getSyncHeader().getMsgIndex() != lastProcessedSeqNo + 1) {
            AppLog.getInstance("MI/Sync").log(60, "Lack between last processed sequence number {0} and the smallest given {1}; check server outbound queue for pending containers", (Object)new Integer(lastProcessedSeqNo), (Object)String.valueOf(returnArray[0].getSyncHeader().getMsgIndex()));
            returnArray = new SyncInboundContainer[]{};
        }
        return returnArray;
    }

    SyncFileManager getSyncFileManager() {
        return this.syncFileManager;
    }
}

