/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.services.MEException;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.api.smartsync.SmartSyncException;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.sync.SyncPasswordException;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ApplicationManager;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.core.ServerExceptionMessage;
import com.sap.ip.me.core.SyncPasswordHandlingOption;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.spi.smartsync.SmartSyncAdapter;
import com.sap.ip.me.sync.ClientHttpSynchronizer;
import com.sap.ip.me.sync.ContainerFactory;
import com.sap.ip.me.sync.DiscSyncConfiguration;
import com.sap.ip.me.sync.DiscSyncController;
import com.sap.ip.me.sync.DiscSynchronizer;
import com.sap.ip.me.sync.HTTPSynchronizer;
import com.sap.ip.me.sync.InboundProcessorRegistryImpl;
import com.sap.ip.me.sync.OldSyncLog;
import com.sap.ip.me.sync.OutboundContainerFormatter;
import com.sap.ip.me.sync.OutboundFileManager;
import com.sap.ip.me.sync.OutboundTokenizer;
import com.sap.ip.me.sync.SyncAcknowledge;
import com.sap.ip.me.sync.SyncEventRegistryImpl;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncInboundManager;
import com.sap.ip.me.sync.SyncLogImpl;
import com.sap.ip.me.sync.SyncOutboundContainer;
import com.sap.ip.me.sync.Synchronizer;
import com.sapmarkets.web.liTS.util.PerformanceMonitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SyncManagerImpl
extends SyncManager {
    private static final String lock = "LOCK";
    protected Trace trace;
    protected DiscSyncController discSyncController = null;
    boolean doSecondSharedUserSync = false;
    private static SyncManagerImpl instance;
    private static int numberOfSyncs;
    private int syncCountOut = 0;
    private File counterFile;
    private OutboundFileManager outboundFileManager;
    private SyncInboundManager inboundManager;
    private int multipleSyncCounter = 0;
    private String SYNCSETTINGS_SYNCHRONIZER = "MobileEngine.Sync.SynchronizerImplementor";
    private boolean DEBUG = false;
    private boolean syncCycleSuppressDownload = false;

    boolean isSyncCycleSuppressDownload() {
        return this.syncCycleSuppressDownload;
    }

    private void setSyncCycleSuppressDownload(boolean activateSuppressDownload) {
        this.syncCycleSuppressDownload = activateSuppressDownload;
    }

    public SyncManagerImpl() {
        if (instance != null) {
            throw new IllegalStateException("SyncManagerImpl already exists");
        }
        instance = this;
        this.trace = Trace.getInstance("MI/Sync");
        this.inboundManager = new SyncInboundManager();
        this.outboundFileManager = new OutboundFileManager();
        String folder = Configuration.getInstallationDirectory() + File.separator + "sync";
        this.counterFile = new File(folder, "counters.sync");
        this.readCountersFromFile();
    }

    public static boolean isDiscSyncEnabled() {
        boolean result = DiscSyncConfiguration.isDiscSyncEnabled();
        if (result) {
            String deviceid = Configuration.getInstance().getProperty("MobileEngine.Sync.Deviceid", "");
            boolean bl = result = result && deviceid.length() > 0;
            if (result) {
                ConversationId[] convids = ConversationIdHandler.getInstance().getAllConversationIdsForUser(UserManagerImpl.getUserManagerImplInstance().getCurrentUser());
                result = false;
                int i = 0;
                while (i < convids.length) {
                    if (convids[i].getMsd().isVisible()) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public void setSyncPasswordOfCurrentUser(String password) throws SyncPasswordException {
        UserManagerImpl.getUserManagerImplInstance().setSyncPasswordOfCurrentUser(password);
    }

    public boolean isSyncCredentialAvailable() {
        return UserManagerImpl.getUserManagerImplInstance().isSyncCredentialAvailable();
    }

    public boolean isSAPLogonTicketSupportEnabled() {
        return Configuration.getInstance().getBoolean("MobileEngine.UM.SAPLogonTicketSupport", false);
    }

    public void synchronizeWithBackend(VisibilityType visibility) {
        this.synchronizeWithBackend(visibility, null, false);
    }

    public void synchronizeWithBackendInBackground(VisibilityType visibility) {
        this.synchronizeWithBackend(visibility, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void synchronizeWithBackend(VisibilityType visibility, DiscSyncController discSyncController, boolean isBackgroundSync) {
        block40: {
            block38: {
                this.trace.log(70, "Synchronize with backend called, Thread=" + Thread.currentThread().getName());
                try {
                    HTTPSynchronizer.setCurrentSessionId(null);
                    int currentCounter = this.multipleSyncCounter;
                    String string = lock;
                    synchronized (string) {
                        block39: {
                            this.trace.log(70, "Thread=" + Thread.currentThread().getName() + " took lock for synchronizeation.");
                            if (currentCounter != this.multipleSyncCounter) {
                                try {
                                    throw new RuntimeException("Multiple synchronization call");
                                }
                                catch (Exception t) {
                                    Trace.getInstance("MI/Sync").logException(70, t);
                                    // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 31] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                                    Object var17_8 = null;
                                    this.trace.log(70, "Synchronization finished, Thread=" + Thread.currentThread().getName());
                                    return;
                                }
                            }
                            if (isBackgroundSync) {
                                this.setSyncCycleSuppressDownload(Configuration.getInstance().getBoolean("MobileEngine.Sync.Background.SuppressDownload", false));
                            } else {
                                this.setSyncCycleSuppressDownload(SyncManager.getInstance().isSuppressDownload());
                            }
                            this.discSyncController = discSyncController;
                            SyncLogImpl.getSyncLogImplInstance().started();
                            if (!SyncSettings.isReadyForSynchronization()) {
                                this.trace.log(70, "Synchronization not started because not all required settings are set up");
                                SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Sync Settings are not set up");
                                // MONITOREXIT @DISABLED, blocks:[0, 6, 28] lbl27 : MonitorExitStatement: MONITOREXIT : var5_5
                                Object var17_9 = null;
                                this.trace.log(70, "Synchronization finished, Thread=" + Thread.currentThread().getName());
                                return;
                            }
                            PerformanceMonitor.setTimeStamp("Start do Sync");
                            if (isBackgroundSync) {
                                this.trace.log(90, "Timed Sync started");
                                if (this.isFilterOnTimedSync()) {
                                    this.trace.log(90, "Filter on Timed Sync active");
                                    if (!this.hasNewSyncData(visibility)) {
                                        this.trace.log(90, "No new application data, Timed Sync aborted");
                                        // MONITOREXIT @DISABLED, blocks:[0, 34, 36, 37, 6] lbl39 : MonitorExitStatement: MONITOREXIT : var5_5
                                        break block38;
                                    }
                                } else {
                                    this.trace.log(90, "Filter on Timed Sync not active");
                                }
                            }
                            this.raiseSyncEvent(0, visibility);
                            try {
                                try {
                                    this.processSynchronization(visibility);
                                    if (this.DEBUG) {
                                        this.enableRepetitiveSync();
                                    }
                                    if (this.isRepetitiveSyncActive()) {
                                        this.doRepetitiveSynchronization(visibility);
                                        this.resetNumberOfSyncs();
                                    }
                                    SyncLogImpl.getSyncLogImplInstance().ready();
                                    this.raiseSyncEvent(2, visibility);
                                    Configuration.getInstance().setDefaultProperty("MobileEngine.Sync.LastSuccessfulSync", Long.toString(System.currentTimeMillis()));
                                }
                                catch (IOException e) {
                                    SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Failed to save partial containers, sync stopped, containers will be resent at next sync ");
                                    AppLog.getInstance("MI/Sync").logException(50, "Synchronization problems while saving inbound containers", e, true);
                                    Object var14_14 = null;
                                    PerformanceMonitor.setTimeStamp("Finished doSync");
                                    this.raiseSyncEvent(1, visibility);
                                    ++this.multipleSyncCounter;
                                    this.discSyncController = null;
                                    this.writeCountersToFile();
                                    break block39;
                                }
                                catch (SyncException e) {
                                    String message = e.getMessage();
                                    String exceptionInfoCodePrefix = "EXCEPTION_INFO_CODE=";
                                    if (message != null && message.startsWith(exceptionInfoCodePrefix)) {
                                        int exceptionInfoCode;
                                        try {
                                            exceptionInfoCode = Integer.parseInt(message.substring(exceptionInfoCodePrefix.length(), message.length()));
                                        }
                                        catch (NumberFormatException ex) {
                                            exceptionInfoCode = -2;
                                        }
                                        ServerExceptionMessage serverMessage = new ServerExceptionMessage(exceptionInfoCode);
                                        SyncLogImpl syncLog = SyncLogImpl.getSyncLogImplInstance();
                                        syncLog.addFailureMessage(serverMessage.getLocalizedMessage());
                                        syncLog.setServerExceptionMessage(serverMessage);
                                    } else if ("Not Authorized for synchronization".equals(message)) {
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation: not authorized to sync with server ");
                                    } else if ("Function module failure".equals(message)) {
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Response received from server didn't contain function module info");
                                    } else if ("Inbound file can not be interpreted".equals(message)) {
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation: response received from server didn't contain inbound containers");
                                    } else if ("Transport-layer sync exception raised".equals(message)) {
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation: exception on file transport layer raised");
                                    } else if ("Transport-layer (http) sync exception raised".equals(message)) {
                                        AppLog.getInstance("MI/Sync").logException(50, "Synchronization problems on http layer", e, true);
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage(message);
                                    } else {
                                        this.trace.logException(60, "Synchronisation problems", e, true);
                                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation problems: " + e.getMessage());
                                    }
                                    Object var14_15 = null;
                                    PerformanceMonitor.setTimeStamp("Finished doSync");
                                    this.raiseSyncEvent(1, visibility);
                                    ++this.multipleSyncCounter;
                                    this.discSyncController = null;
                                    this.writeCountersToFile();
                                    break block39;
                                }
                                catch (Exception t) {
                                    this.trace.logException(60, "Synchronisation problems", t, true);
                                    SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation problems: " + t.getMessage());
                                    Object var14_16 = null;
                                    PerformanceMonitor.setTimeStamp("Finished doSync");
                                    this.raiseSyncEvent(1, visibility);
                                    ++this.multipleSyncCounter;
                                    this.discSyncController = null;
                                    this.writeCountersToFile();
                                    break block39;
                                }
                                Object var14_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var14_17 = null;
                                PerformanceMonitor.setTimeStamp("Finished doSync");
                                this.raiseSyncEvent(1, visibility);
                                ++this.multipleSyncCounter;
                                this.discSyncController = null;
                                this.writeCountersToFile();
                                throw throwable;
                            }
                            PerformanceMonitor.setTimeStamp("Finished doSync");
                            this.raiseSyncEvent(1, visibility);
                            ++this.multipleSyncCounter;
                            this.discSyncController = null;
                            this.writeCountersToFile();
                        }
                        if (SyncPasswordHandlingOption.AT_SYNC == SecurityManager.getInstance().getSelectedSyncPasswordHandlingOption()) {
                            UserManagerImpl.getUserManagerImplInstance().removeSyncPasswordOfCurrentUser();
                        }
                        this.syncCycleSuppressDownload = false;
                        if (!isBackgroundSync) {
                            this.setSuppressDownload(false);
                        }
                    }
                    break block40;
                }
                catch (Throwable throwable) {
                    Object var17_12 = null;
                    this.trace.log(70, "Synchronization finished, Thread=" + Thread.currentThread().getName());
                    throw throwable;
                }
            }
            Object var17_10 = null;
            this.trace.log(70, "Synchronization finished, Thread=" + Thread.currentThread().getName());
            return;
        }
        Object var17_11 = null;
        this.trace.log(70, "Synchronization finished, Thread=" + Thread.currentThread().getName());
    }

    private boolean hasNewSyncData(VisibilityType visibility) {
        boolean hasNewData = true;
        SmartSyncAdapter ssa = (SmartSyncAdapter)Configuration.getInstance().getInstanceForType("MobileEngine.Sync.SmartSync.SmartSyncAdapterImpl");
        try {
            hasNewData = ssa.hasSyncBoOutDelta();
        }
        catch (SmartSyncException sse) {
            hasNewData = false;
            this.trace.logException(60, "Synchronisation problems, can't get SyncBo delta information ", sse, true);
            SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Synchronisation problems, can't get SyncBo delta information: " + sse.getMessage());
        }
        if (!hasNewData) {
            InboundProcessorRegistryImpl ipRegistry = (InboundProcessorRegistryImpl)InboundProcessorRegistry.getInstance();
            if (!ipRegistry.isNewDataAvailable(visibility)) {
                return false;
            }
            this.trace.log(90, "GenericSync data from application found");
        } else {
            this.trace.log(90, "SmartSync data from application found");
        }
        return true;
    }

    public void setDoSecondSharedUserSync(boolean doSecondSharedUserSync) {
        this.doSecondSharedUserSync = doSecondSharedUserSync;
    }

    protected OutboundFileManager getOutboundFileManager() {
        return this.outboundFileManager;
    }

    protected SyncInboundManager getInboundManager() {
        return this.inboundManager;
    }

    protected int getNextSyncCountOut() {
        ++this.syncCountOut;
        this.writeCountersToFile();
        return this.syncCountOut;
    }

    protected void processSynchronization(VisibilityType visibility) throws SyncException, IOException {
        this.syncForUser(UserManagerImpl.getSharedUser());
        User currentUser = UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
        if (VisibilityType.SEPARATED.equals(visibility)) {
            this.syncForUser(currentUser);
        } else {
            Enumeration userEnum = UserManagerImpl.getUserManagerImplInstance().getAllUsers();
            ConversationId id = null;
            ConversationIdHandler handler = ConversationIdHandler.getInstance();
            MobileSolutionDescriptor frameworkmsd = ApplicationManager.getInstance().getFrameworkMobileSolutionDescriptor();
            while (userEnum.hasMoreElements()) {
                User selectedUser = (User)userEnum.nextElement();
                if (!selectedUser.equals(currentUser)) {
                    id = handler.getConversationId(frameworkmsd, selectedUser);
                    if (id == null || !id.isGeneratedOnServer()) {
                        this.trace.log(70, "Skip user " + selectedUser.getUniqueID() + " because user has no server generated conversation id");
                        continue;
                    }
                    this.syncForUser(selectedUser);
                    continue;
                }
                this.trace.log(90, "Sync for current user " + selectedUser.getUniqueID());
                this.syncForUser(selectedUser);
            }
        }
        boolean allowAnotherSharedUserSync = Configuration.getInstance().getBoolean("MobileEngine.Sync.AllowUserSyncFinishedEvent", true);
        if (allowAnotherSharedUserSync) {
            this.raiseSyncEvent(10, visibility);
            if (this.doSecondSharedUserSync) {
                this.syncForUser(UserManagerImpl.getSharedUser());
                this.doSecondSharedUserSync = false;
            }
        }
    }

    protected void processSyncCycle(User selectedUser) throws SyncException, IOException {
        File currentOutboundFile = this.prepareOutbound(selectedUser);
        if (currentOutboundFile == null || !currentOutboundFile.exists()) {
            return;
        }
        String currentInboundFilePath = this.getOutboundFileManager().getInboundFileName(selectedUser);
        OldSyncLog syncLog = OldSyncLog.getInstance();
        syncLog.started();
        this.trace.logFileContent(90, currentOutboundFile);
        this.processSyncCycle(selectedUser, syncLog, currentOutboundFile, currentInboundFilePath);
    }

    protected File prepareOutbound(User selectedUser) throws SyncException, IOException {
        File pendingOutboundFile = this.getOutboundFileManager().getPendingSyncOutboundFile(selectedUser);
        if (pendingOutboundFile != null) {
            this.moveContainersFromOutboundFile(pendingOutboundFile);
            pendingOutboundFile.delete();
        }
        this.createOutboundContainerForEachRegisteredMethod(selectedUser);
        SyncLogImpl.getSyncLogImplInstance().requestContainerForAllRegisteredMethodsCreated();
        return this.getOutboundFileManager().renameOutboundFile(selectedUser);
    }

    protected Synchronizer getCurrentSynchronizer() throws SyncException {
        String connectionType = Configuration.getInstance().getProperty("MobileEngine.Sync.ConnectionType");
        if (this.getDiscSyncController() != null) {
            return new DiscSynchronizer(this.getDiscSyncController());
        }
        if ("http".equalsIgnoreCase(connectionType)) {
            return new ClientHttpSynchronizer();
        }
        if ("disc".equalsIgnoreCase(connectionType)) {
            throw new SyncException("Connection type 'disc' is not supported any more");
        }
        try {
            this.trace.log(70, "Because the value for {0} is {1} customer specified Synchronizer will be created", (Object)"MobileEngine.Sync.ConnectionType", (Object)connectionType);
            String synchronizerName = Configuration.getInstance().getProperty(this.SYNCSETTINGS_SYNCHRONIZER);
            Class<?> clazz = Class.forName(synchronizerName);
            this.trace.log(90, "Synchronizer type is {0}", (Object)synchronizerName);
            return (Synchronizer)clazz.newInstance();
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Sync").logException(50, "customer specific Synchronizer can not be created", e, true);
            throw new SyncException("customer specific Synchronizer can not be created");
        }
    }

    protected void createOutboundContainerForEachRegisteredMethod(User selectedUser) throws SyncException {
        this.trace.log(90, "Synchronisation: create outbound container for each registered method");
        Enumeration methodEnum = InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().getAlLNotNotifiedMethods(selectedUser.getUniqueName()).elements();
        while (methodEnum.hasMoreElements()) {
            String methodName = (String)methodEnum.nextElement();
            ContainerFactory.createNotifyContainer(methodName, selectedUser);
        }
    }

    protected DiscSyncController getDiscSyncController() {
        return this.discSyncController;
    }

    private void resetNumberOfSyncs() {
        numberOfSyncs = 0;
    }

    private void doRepetitiveSynchronization(VisibilityType visibility) throws SyncException, IOException {
        this.trace.log(80, "Starting repetitive sync");
        while (!this.maximumNumberOfRepetitiveSyncsReached()) {
            Vector usersToSyncFor = this.getUsersForWhichAnotherSyncIsNecessary(visibility);
            int numberOfUsersToSyncFor = usersToSyncFor.size();
            if (numberOfUsersToSyncFor == 0) {
                this.trace.log(80, "There are no more users to sync for, therefore stopping repetitive sync");
                break;
            }
            int i = 0;
            while (i < numberOfUsersToSyncFor) {
                User nextUser = (User)usersToSyncFor.elementAt(i);
                this.trace.log(80, "Starting a new synchronization for user " + nextUser.getName());
                this.syncForUser(nextUser);
                ++numberOfSyncs;
                ++i;
            }
            this.setThreadToSleep();
        }
        this.writeDataCompletenessStatusToSyncLog(visibility);
    }

    private void writeDataCompletenessStatusToSyncLog(VisibilityType visibility) {
        Enumeration e = this.getUserEnumerationDependingOnVisibilityType(visibility);
        while (e.hasMoreElements()) {
            User u = (User)e.nextElement();
            if (u.equals(UserManagerImpl.getSharedUser())) continue;
            ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForUser(u);
            int i = 0;
            while (i < cis.length) {
                if (cis[i].getMsd().isItASmartSyncApplication()) {
                    if (cis[i].isSyncComplete()) {
                        this.trace.log(80, "The data is complete for user " + u.getName() + " and application " + cis[i].getMsd().getDescription());
                        SyncLogImpl.getSyncLogImplInstance().addInfoMessage("The data is complete for user " + u.getName() + " and application " + cis[i].getMsd().getDescription());
                    } else {
                        this.trace.log(80, "The data is not complete for user " + u.getName() + " and application " + cis[i].getMsd().getDescription());
                        SyncLogImpl.getSyncLogImplInstance().addInfoMessage("The data is not complete for user " + u.getName() + " and application " + cis[i].getMsd().getDescription());
                    }
                }
                ++i;
            }
        }
    }

    private void setThreadToSleep() {
        this.trace.log(80, "Repetitive sync is sleeping for " + this.getTimeBetweenRepetitiveSyncs());
        try {
            Thread.sleep(this.getTimeBetweenRepetitiveSyncs());
        }
        catch (InterruptedException e) {
            this.trace.logException(e);
        }
    }

    private Vector getUsersForWhichAnotherSyncIsNecessary(VisibilityType visibility) {
        Enumeration userEnum = this.getUserEnumerationDependingOnVisibilityType(visibility);
        Vector<User> usersForWhichAnotherSyncIsNecessary = new Vector<User>();
        while (userEnum.hasMoreElements()) {
            User u = (User)userEnum.nextElement();
            boolean finished = this.isSyncFinishedForUser(u);
            if (finished) continue;
            usersForWhichAnotherSyncIsNecessary.addElement(u);
        }
        return usersForWhichAnotherSyncIsNecessary;
    }

    private boolean isSyncFinishedForUser(User u) {
        ConversationId[] cis = ConversationIdHandler.getInstance().getAllConversationIdsForUser(u);
        boolean userResult = true;
        int i = 0;
        while (i < cis.length) {
            if (cis[i].getMsd().isItASmartSyncApplication()) {
                this.trace.log(80, "isSyncFinishedForUser: " + u.getName() + " : " + cis[i].getMsd().getName() + " : " + cis[i].isSyncComplete());
                userResult = userResult && cis[i].isSyncComplete();
            }
            ++i;
        }
        if (userResult) {
            this.trace.log(80, "Sync is finished for user " + u.getName());
        } else {
            this.trace.log(80, "Sync is not finished for user " + u.getName());
        }
        return userResult;
    }

    private Enumeration getUserEnumerationDependingOnVisibilityType(VisibilityType visibility) {
        if (VisibilityType.SEPARATED.equals(visibility)) {
            Vector<User> vector = new Vector<User>(2);
            vector.addElement(UserManager.getInstance().getCurrentUser());
            vector.addElement(UserManagerImpl.getSharedUser());
            return vector.elements();
        }
        return UserManagerImpl.getUserManagerImplInstance().getAllUsers();
    }

    private boolean maximumNumberOfRepetitiveSyncsReached() {
        int maxNumberOfSyncs = this.getMaximumNumberOfRepetitiveSyncs();
        if (maxNumberOfSyncs == 0) {
            return true;
        }
        if (numberOfSyncs >= maxNumberOfSyncs) {
            this.trace.log(80, "Maximum number of repetitive syncs reached " + this.getMaximumNumberOfRepetitiveSyncs());
            return true;
        }
        this.trace.log(80, "Maximum number of repetitive syncs not yet reached " + numberOfSyncs + " < " + this.getMaximumNumberOfRepetitiveSyncs());
        return false;
    }

    private boolean isRepetitiveSyncActive() {
        if (Configuration.getInstance().getBoolean("MobileEngine.Sync.RepetitiveSyncEnabled", false)) {
            this.trace.log(80, "Repetitive sync is turned on");
            if (this.getTimeBetweenRepetitiveSyncs() <= 0L) {
                this.trace.log(80, "Parameter for MobileEngine.Sync.TimeBetweenRepetitiveSyncs is <=0, so repetive sync is not started");
                return false;
            }
            if (this.getMaximumNumberOfRepetitiveSyncs() <= 0) {
                this.trace.log(80, "Parameter for MobileEngine.Sync.MaximumNumberOfRepetitiveSyncs is <=0, so repetive sync is not started");
                return false;
            }
            if (this.isDiscSyncActive()) {
                this.trace.log(80, "Disc Sync is active, so repetive sync is not started");
                return false;
            }
            this.trace.log(80, "Repetitive sync is truned on and proper values for repetitions and sleeping time are configured");
            return true;
        }
        this.trace.log(80, "Repetitive sync is turned off");
        return false;
    }

    private boolean isDiscSyncActive() {
        String connectionType = Configuration.getInstance().getProperty("MobileEngine.Sync.ConnectionType");
        return connectionType.toLowerCase().startsWith("disc");
    }

    private int getMaximumNumberOfRepetitiveSyncs() {
        return Configuration.getInstance().getInt("MobileEngine.Sync.MaximumNumberOfRepetitiveSyncs", 0);
    }

    private long getTimeBetweenRepetitiveSyncs() {
        return Configuration.getInstance().getLong("MobileEngine.Sync.TimeBetweenRepetitiveSyncs", 0L);
    }

    private void enableRepetitiveSync() {
        Configuration c = Configuration.getInstance();
        c.setDefaultProperty("MobileEngine.Sync.RepetitiveSyncEnabled", "true");
        c.setDefaultProperty("MobileEngine.Sync.TimeBetweenRepetitiveSyncs", "10000");
        c.setDefaultProperty("MobileEngine.Sync.MaximumNumberOfRepetitiveSyncs", "3");
    }

    private void readCountersFromFile() {
        if (!this.counterFile.exists()) {
            this.syncCountOut = 0;
            this.writeCountersToFile();
            this.trace.log(60, "Created new sync counter file");
        } else {
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(this.counterFile));
                this.syncCountOut = in.readInt();
                in.close();
            }
            catch (Exception ex) {
                this.trace.logException(50, "Exception while reading sync counters from file", ex, true);
                this.syncCountOut = 0;
                this.writeCountersToFile();
                this.trace.log(60, "Created new sync counter file");
            }
        }
    }

    private void writeCountersToFile() {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(this.counterFile));
            out.writeInt(this.syncCountOut);
            out.close();
        }
        catch (Exception ex) {
            this.trace.logException(50, "Exception while writing sync counters to file", ex, true);
        }
    }

    private void syncForUser(User selectedUser) throws SyncException, IOException {
        this.trace.log(80, "Synchronization started for user {0}", (Object)selectedUser.getUniqueName());
        try {
            this.processSyncCycle(selectedUser);
            Object var3_2 = null;
            this.deleteInbound(selectedUser);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.deleteInbound(selectedUser);
            throw throwable;
        }
        this.trace.log(80, "Synchronization finished for user {0}", (Object)selectedUser.getUniqueName());
    }

    private void raiseSyncEvent(int eventType, VisibilityType visibility) {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        this.trace.log(90, "Synchronisation: Fire SyncEvent {0}", (Object)Integer.toString(eventType));
        ((SyncEventRegistryImpl)SyncEventRegistry.getInstance()).fireSyncEventNotifierMethod(new SyncEvent(this, eventType), visibility);
        PerformanceLog.methodFinished(perfLogTag, "raiseSyncEvent");
    }

    private void processSyncCycle(User selectedUser, OldSyncLog syncLog, File currentOutboundFile, String currentInboundFilePath) throws SyncException, IOException {
        currentOutboundFile = this.adjustOutboundFileIndices(currentOutboundFile);
        this.getCurrentSynchronizer().exchangeData(selectedUser.getUniqueID(), currentOutboundFile.getAbsolutePath(), currentInboundFilePath, false);
        InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance().resetCreatedOutboundContainers(selectedUser.getUniqueName());
        OldSyncLog.getInstance().setStageConnectedOk();
        this.trace.log(80, "Synchronisation successfully connected ");
        SyncLogImpl.getSyncLogImplInstance().connected();
        this.getInboundManager().verifyResponse(currentInboundFilePath);
        SyncLogImpl.getSyncLogImplInstance().responseReceived();
        this.getOutboundFileManager().removeFile(currentOutboundFile);
        syncLog.ok();
        SyncAcknowledge syncAcknowledge = null;
        try {
            syncAcknowledge = new SyncAcknowledge();
        }
        catch (MEException e) {
            syncLog.acknowledgeFailed(e);
        }
        syncLog.inboundStarted();
        this.processInboundContainers(syncAcknowledge, currentInboundFilePath);
        SyncLogImpl.getSyncLogImplInstance().responseProcessed();
        syncLog.inboundProcessingDone();
        this.sendAcknowledge(syncAcknowledge);
    }

    private File adjustOutboundFileIndices(File outboundFile) throws SyncException {
        OutboundTokenizer tokenizer = null;
        int headerIndex = 1;
        int bodyIndex = 1;
        try {
            try {
                tokenizer = new OutboundTokenizer(outboundFile);
                String originalFileName = outboundFile.getAbsolutePath();
                String temporaryFileName = originalFileName + ".temp";
                BufferedUTF8Writer writer = new BufferedUTF8Writer(temporaryFileName);
                OutboundFileManager filemanager = this.getOutboundFileManager();
                while (tokenizer.hasNext()) {
                    StringBuffer container = tokenizer.next();
                    SyncOutboundContainer outboundContainer = OutboundContainerFormatter.parseOutboundContainer(container);
                    bodyIndex = filemanager.writeContainerToWriter(outboundContainer, headerIndex, bodyIndex, writer);
                    ++headerIndex;
                }
                tokenizer.close();
                tokenizer = null;
                outboundFile.delete();
                writer.close();
                File newOutboundFile = new File(temporaryFileName);
                outboundFile = new File(originalFileName);
                newOutboundFile.renameTo(outboundFile);
                File file = outboundFile;
                Object var12_12 = null;
                if (tokenizer != null) {
                    tokenizer.close();
                }
                return file;
            }
            catch (IOException e) {
                AppLog.getInstance("MI/Sync").logException(50, "Container indices can not adjusted because of IOException", e, true);
                throw new SyncException("Container indices can not adjusted because of IOException");
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var12_13 = null;
                if (tokenizer == null) break block6;
                tokenizer.close();
            }
            throw throwable;
        }
    }

    private ConversationId[] getConversationIDs(VisibilityType visibility, boolean applicationSpecific) throws MEException, SyncException, IOException {
        ConversationId[] convIDs = new ConversationId[]{};
        if (applicationSpecific && VisibilityType.SEPARATED.equals(visibility)) {
            convIDs = new ConversationId[]{ConversationIdHandler.getInstance().getCurrentConversationId()};
        } else if (applicationSpecific && VisibilityType.USER_SHARED.equals(visibility)) {
            convIDs = new ConversationId[]{ConversationIdHandler.getInstance().getCurrentConversationId(), ConversationIdHandler.getInstance().getCurrentConversationId(VisibilityType.USER_SHARED)};
        } else if (!applicationSpecific && VisibilityType.SEPARATED.equals(visibility)) {
            convIDs = ConversationIdHandler.getInstance().getAllConversationIdsForUser(UserManagerImpl.getUserManagerImplInstance().getCurrentUser());
        } else if (!applicationSpecific && VisibilityType.USER_SHARED.equals(visibility)) {
            User user = UserManagerImpl.getUserManagerImplInstance().getCurrentUser();
            ConversationId[] forUser = ConversationIdHandler.getInstance().getAllConversationIdsForUser(user);
            MobileSolutionDescriptor[] msds = ConversationIdHandler.getInstance().getAllMobileSolutionDescriptorsForUser(user);
            convIDs = new ConversationId[msds.length + forUser.length];
            UserManagerImpl.getUserManagerImplInstance();
            User sharedUser = UserManagerImpl.getSharedUser();
            int i = 0;
            while (i < msds.length) {
                convIDs[i] = ConversationIdHandler.getInstance().getConversationId(msds[i], sharedUser);
                ++i;
            }
            int i2 = msds.length;
            while (i2 < msds.length + forUser.length) {
                convIDs[i2] = forUser[i2 - msds.length];
                ++i2;
            }
        } else {
            convIDs = ConversationIdHandler.getInstance().getAllConversationIds();
        }
        return convIDs;
    }

    private void sendAcknowledge(SyncAcknowledge syncAcknowledge) throws IOException, SyncException {
        if (syncAcknowledge != null) {
            String acknowledgeURL = SyncSettings.createUrlString() + "~event=Acknowledge&";
            PerformanceMonitor.setTimeStamp("Start sending acknowledge to ITS");
            SyncLogImpl.getSyncLogImplInstance().acknowledgePrepared();
            syncAcknowledge.send(acknowledgeURL);
            SyncLogImpl.getSyncLogImplInstance().acknowledgeSend();
            PerformanceMonitor.setTimeStamp("Finished sending acknowledge to ITS");
        }
    }

    private void moveContainersFromOutboundFile(File outboundFile) throws SyncException {
        OutboundTokenizer tokenizer = null;
        try {
            try {
                tokenizer = new OutboundTokenizer(outboundFile);
                while (tokenizer.hasNext()) {
                    StringBuffer container = tokenizer.next();
                    SyncOutboundContainer outboundContainer = OutboundContainerFormatter.parseOutboundContainer(container);
                    outboundContainer.close();
                }
            }
            catch (IOException e) {
                AppLog.getInstance("MI/Sync").logException(50, "Containers can not moved to current outbound file because of IOException", e, true);
                throw new SyncException("Containers can not moved to current outbound file because of IOException");
            }
            Object var6_6 = null;
            if (tokenizer != null) {
                tokenizer.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (tokenizer != null) {
                tokenizer.close();
            }
            throw throwable;
        }
    }

    private void processInboundContainers(SyncAcknowledge syncAcknowledge, String currentInboundFilePath) throws SyncException {
        SyncInboundManager inboundManager = this.getInboundManager();
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "Number of pending inbound containers before inbound processing = {0}", (Object)Integer.toString(inboundManager.getPendingContainerCount()));
        }
        inboundManager.readInboundContainerFile(currentInboundFilePath, false);
        SyncInboundContainer[] inboundContainers = inboundManager.getArrayOfSyncInboundContainers();
        InboundProcessorRegistryImpl processorRegistry = InboundProcessorRegistryImpl.getInboundProcessorRegistryImplInstance();
        PerformanceMonitor.setTimeStamp("Start processing inbound containers");
        int j = 0;
        while (j < inboundContainers.length) {
            if (inboundContainers[j].isEmpty()) {
                inboundManager.removeProcessedInboundContainer(inboundContainers[j]);
            } else if (syncAcknowledge.checkIfPending(inboundContainers[j].getSyncHeader())) {
                inboundManager.removeProcessedInboundContainer(inboundContainers[j]);
            } else {
                OldSyncLog syncLog = OldSyncLog.getInstance();
                if (processorRegistry.isRegistered(inboundContainers[j].getMethod())) {
                    syncLog.addInboundProc(inboundContainers[j].getMethod());
                    try {
                        processorRegistry.getInboundProcessor(inboundContainers[j].getMethod()).process(inboundContainers[j]);
                        this.trace.log(80, "SyncInboundProcessing finished successfully for method {0}", (Object)inboundContainers[j].getMethod());
                        syncAcknowledge.addHeader(inboundContainers[j].getSyncHeader());
                    }
                    catch (Exception e) {
                        syncLog.processingMethodFailed(inboundContainers[j].getMethod(), e);
                    }
                } else {
                    syncLog.unregisteredMethod(inboundContainers[j].getMethod());
                }
                inboundManager.removeProcessedInboundContainer(inboundContainers[j]);
                inboundContainers[j] = null;
            }
            ++j;
        }
        if (this.trace.isLogging(90)) {
            this.trace.log(90, "Number of pending inbound containers after inbound processing = {0}", (Object)Integer.toString(inboundManager.getPendingContainerCount()));
        }
        PerformanceMonitor.setTimeStamp("Finished processing inbound containers");
    }

    private void deleteInbound(User user) {
        File helperFile = new File(this.getOutboundFileManager().getInboundFileName(user));
        if (helperFile.exists()) {
            helperFile.delete();
        }
    }

    static {
        numberOfSyncs = 0;
    }
}

