/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.sync.SyncLog;
import com.sap.ip.me.core.ServerExceptionMessage;
import java.util.Date;
import java.util.Vector;

public class SyncLogImpl
extends SyncLog {
    public static final Object INITIAL = new Object();
    public static final Object STARTED = new Object();
    public static final Object REQUEST_CONTAINER_CREATED = new Object();
    public static final Object CONNECTED = new Object();
    public static final Object RESPONSE_RECEIVED = new Object();
    public static final Object RESPONSE_PROCESSED = new Object();
    public static final Object ACKNOWLEDGE_PREPARED = new Object();
    public static final Object ACKNOWLEDGE_SEND = new Object();
    public static final Object READY = new Object();
    private static SyncLogImpl instance = null;
    private Object syncState = INITIAL;
    private Exception exception = null;
    private Vector failureMessages = new Vector();
    private Vector processedMethods = new Vector();
    private Date lastSyncTime = null;
    private Date lastSuccessfulSync = null;
    private Vector processedStates = new Vector();
    private Vector infoMessages = new Vector();
    private ServerExceptionMessage serverExceptionMessage = null;

    public SyncLogImpl() {
        if (instance != null) {
            throw new IllegalStateException("SyncLogImpl already exists");
        }
        instance = this;
    }

    public static SyncLogImpl getSyncLogImplInstance() {
        return (SyncLogImpl)SyncLog.getInstance();
    }

    public boolean isReady() {
        return this.syncState == READY && this.failureMessages.isEmpty() && this.exception == null;
    }

    public String[] getFailureMessages() {
        Object[] s = new String[this.failureMessages.size()];
        this.failureMessages.copyInto(s);
        return s;
    }

    public String[] getInfoMessages() {
        Object[] s = new String[this.infoMessages.size()];
        this.infoMessages.copyInto(s);
        return s;
    }

    public Exception getSyncException() {
        return this.exception;
    }

    public Date getDateOfLastSync() {
        return this.lastSyncTime;
    }

    public Date getDateOfLastSuccessfulSync() {
        return this.lastSuccessfulSync;
    }

    public Object getCurrentState() {
        return this.syncState;
    }

    public void reset() {
        this.syncState = INITIAL;
        this.exception = null;
        this.serverExceptionMessage = null;
        this.failureMessages.removeAllElements();
        this.infoMessages.removeAllElements();
        this.processedMethods.removeAllElements();
        this.processedStates.removeAllElements();
    }

    public String[] getProcessedMethods() {
        Object[] s = new String[this.processedMethods.size()];
        this.processedMethods.copyInto(s);
        return s;
    }

    public Vector getProcessedStates() {
        return this.processedStates;
    }

    void started() {
        this.syncState = STARTED;
        this.lastSyncTime = new Date();
        this.exception = null;
        this.failureMessages.removeAllElements();
        this.processedMethods.removeAllElements();
        this.processedStates.removeAllElements();
        this.processedStates.addElement(STARTED);
    }

    void requestContainerForAllRegisteredMethodsCreated() {
        this.syncState = REQUEST_CONTAINER_CREATED;
        this.processedStates.addElement(REQUEST_CONTAINER_CREATED);
    }

    void connected() {
        this.syncState = CONNECTED;
        this.processedStates.addElement(CONNECTED);
    }

    void responseReceived() {
        this.syncState = RESPONSE_RECEIVED;
        this.processedStates.addElement(RESPONSE_RECEIVED);
    }

    void responseProcessed() {
        this.syncState = RESPONSE_PROCESSED;
        this.processedStates.addElement(RESPONSE_PROCESSED);
    }

    void acknowledgePrepared() {
        this.syncState = ACKNOWLEDGE_PREPARED;
        this.processedStates.addElement(ACKNOWLEDGE_PREPARED);
    }

    void acknowledgeSend() {
        this.syncState = ACKNOWLEDGE_SEND;
        this.processedStates.addElement(ACKNOWLEDGE_SEND);
    }

    void ready() {
        this.syncState = READY;
        this.lastSuccessfulSync = this.lastSyncTime;
        this.processedStates.addElement(READY);
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    public void addFailureMessage(String failureMessage) {
        this.failureMessages.addElement(failureMessage);
    }

    void addInfoMessage(String infoMessage) {
        this.infoMessages.addElement(infoMessage);
    }

    void addprocessedMethod(String methodName) {
        if (!this.processedMethods.contains(methodName)) {
            this.processedMethods.addElement(methodName);
        }
    }

    void setServerExceptionMessage(ServerExceptionMessage m) {
        this.serverExceptionMessage = m;
    }

    public ServerExceptionMessage getServerExceptionMessage() {
        return this.serverExceptionMessage;
    }
}

