/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.sync.InboundTokenizer;
import com.sap.ip.me.sync.OldSyncLog;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncInboundContainer;
import com.sap.ip.me.sync.SyncLogImpl;
import com.sapmarkets.web.liTS.util.PerformanceMonitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SyncInboundManager {
    private static final boolean NEWPROTOCOL_USED = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false);
    private static final String MEREPLICATION_ENABLED_HEADER = "MEREPLICATION";
    private static final String WAF_SYNC = "WAF_SYNC";
    private static final String HEADERS = "HEADERS";
    private static final String CONTAINERS = "CONTAINERS";
    private static final String HEADER_TYPE = "HeaderType";
    private static final String STATUS = "Status";
    private static final String EXECTIME = "Execution Time";
    private static final String MOREPACKAGES = "MORE_PACKAGES_WAITING";
    private static final String SYNCCOUNTER = "SyncCounter";
    private static final String A = "A";
    private static final String XML = "XML";
    private static final String X = "X";
    private static final String EXCEPTION_INFO_CODE = "EXCEPTION_INFO_CODE";
    String lastReadHeaderType = "";
    private Vector inboundContainers;
    private Hashtable headerList;
    private boolean prolog_MorePackagesWaiting = false;
    private boolean oldData = true;
    private String pendingInboundContainersName;
    private String pendingInboundHeadersName;
    private int syncCountIn = 0;
    private Trace trace = Trace.getInstance("MI/Sync");
    private File counterFile;

    boolean isMorePackagesWaiting() {
        return this.prolog_MorePackagesWaiting;
    }

    boolean isOldData() {
        return this.oldData;
    }

    SyncInboundManager() {
        StringBuffer commonpart = new StringBuffer(84);
        Configuration config = Configuration.getInstance();
        commonpart.append(config.getProperty("MobileEngine.InstallationPath"));
        commonpart.append(File.separatorChar);
        commonpart.append(Configuration.getInstance().getProperty("MobileEngine.Sync.Directory"));
        commonpart.append(File.separatorChar);
        commonpart.append("pendingInbound");
        commonpart.append(File.separatorChar);
        StringBuffer pendingDir = new StringBuffer(commonpart.length() + 12);
        pendingDir.append(commonpart.toString());
        pendingDir.append("pendCont.in");
        this.pendingInboundContainersName = pendingDir.toString();
        pendingDir = new StringBuffer(pendingDir.length());
        pendingDir.append(commonpart.toString());
        pendingDir.append("pendHead.in");
        this.pendingInboundHeadersName = pendingDir.toString();
        this.loadPendingInboundContainers();
        String folder = Configuration.getInstallationDirectory() + File.separator + "sync";
        this.counterFile = new File(folder, "incount.sync");
        this.readInboundCounterFromFile();
    }

    SyncInboundContainer[] getArrayOfSyncInboundContainers() {
        Object[] finalInboundContainers = new SyncInboundContainer[this.inboundContainers.size()];
        this.inboundContainers.copyInto(finalInboundContainers);
        PerformanceMonitor.setTimeStamp("Finished reading inbound containers");
        return finalInboundContainers;
    }

    void removeProcessedInboundContainer(SyncInboundContainer container) {
        this.inboundContainers.removeElement(container);
        this.headerList.remove(container.getSyncHeader());
    }

    void verifyResponse(String currentInboundFilePath) throws SyncException {
        InboundTokenizer tokenizer = null;
        try {
            tokenizer = new InboundTokenizer(currentInboundFilePath);
            this.verifyResponse(tokenizer, false);
            Object var4_3 = null;
            if (tokenizer != null) {
                tokenizer.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tokenizer != null) {
                tokenizer.close();
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void readInboundContainerFile(String currentInboundFilePath, boolean updateSyncLog) throws SyncException {
        try {
            Vector subcontainers;
            block24: {
                PerformanceMonitor.setTimeStamp("Start reading inbound containers");
                this.prolog_MorePackagesWaiting = false;
                this.oldData = true;
                InboundTokenizer st = null;
                subcontainers = new Vector(2);
                try {
                    Object var10_13;
                    try {
                        st = new InboundTokenizer(currentInboundFilePath);
                        int numElements = 0;
                        boolean readNext = false;
                        String nextToken = null;
                        nextToken = st.nextToken().trim();
                        if (WAF_SYNC.equalsIgnoreCase(nextToken)) {
                            nextToken = this.verifyResponse(st, true);
                        }
                        if (updateSyncLog) {
                            SyncLogImpl.getSyncLogImplInstance().responseReceived();
                            OldSyncLog.getInstance().ok();
                        }
                        while (st.hasMoreTokens()) {
                            if (readNext) {
                                nextToken = st.nextToken().trim();
                            } else {
                                readNext = true;
                            }
                            try {
                                if (HEADERS.equalsIgnoreCase(nextToken)) {
                                    if (!this.isOldData()) {
                                        this.readHeader(this.lastReadHeaderType, this.headerList, st);
                                        continue;
                                    }
                                } else {
                                    if (!CONTAINERS.equalsIgnoreCase(nextToken)) continue;
                                    if (!this.isOldData()) {
                                        numElements = this.readContainerBody(this.lastReadHeaderType, st, numElements, subcontainers);
                                        continue;
                                    }
                                }
                                break;
                            }
                            catch (NoSuchElementException e) {
                                break;
                            }
                        }
                    }
                    catch (SyncException e) {
                        if ("End of file reached".equals(e.getMessage())) {
                            AppLog.getInstance("MI/Sync").logException(50, (Throwable)e, false);
                        } else {
                            if (!"Function module failure".equals(e.getMessage())) throw e;
                            AppLog.getInstance("MI/Sync").logException(60, "Package has not been processed on server side (no execution time set); ignore this package", e, false);
                        }
                        var10_13 = null;
                        if (st != null) {
                            st.close();
                        }
                        break block24;
                    }
                    var10_13 = null;
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (st == null) throw throwable;
                    st.close();
                    throw throwable;
                }
            }
            int subcontainersize = subcontainers.size();
            int i = 0;
            while (true) {
                if (i >= subcontainersize) {
                    subcontainers.removeAllElements();
                    Object var12_16 = null;
                    this.trace.logFileContent(90, new File(currentInboundFilePath));
                    return;
                }
                SyncInboundContainer container = (SyncInboundContainer)subcontainers.elementAt(i);
                container.increaseCurrentSubContainerCount();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.trace.logFileContent(90, new File(currentInboundFilePath));
            throw throwable;
        }
    }

    int getPendingContainerCount() {
        return this.inboundContainers.size();
    }

    void _cleanUpLists() {
        this.inboundContainers.removeAllElements();
        this.headerList.clear();
    }

    void cleanUpPendingList() {
        int maxcount = this.inboundContainers.size();
        int i = maxcount - 1;
        while (i >= 0) {
            SyncInboundContainer container = (SyncInboundContainer)this.inboundContainers.elementAt(i);
            if (container.isComplete()) {
                this.inboundContainers.removeElementAt(i);
                this.headerList.remove(container.getSyncHeader());
            } else {
                Trace.getInstance("MI/Sync").log(70, "Pending container = {0}", (Object)container);
            }
            --i;
        }
        this.savePendingInboundContainers();
    }

    private String verifyResponse(InboundTokenizer tokenizer, boolean headerAlreadyRead) throws SyncException {
        boolean fileWasOfKnownType = false;
        boolean authorized = true;
        boolean functionModuleFailed = true;
        String exceptionInfoCode = null;
        String lastReadToken = null;
        this.lastReadHeaderType = "";
        if (tokenizer.hasMoreTokens()) {
            String string = lastReadToken = headerAlreadyRead ? WAF_SYNC : tokenizer.nextToken().trim();
            if (WAF_SYNC.equalsIgnoreCase(lastReadToken)) {
                fileWasOfKnownType = true;
                if (tokenizer.hasMoreTokens()) {
                    lastReadToken = tokenizer.nextToken().trim();
                    while (tokenizer.hasMoreTokens() && !HEADERS.equalsIgnoreCase(lastReadToken)) {
                        if (STATUS.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens()) {
                            lastReadToken = tokenizer.nextToken().trim();
                            if (A.equalsIgnoreCase(lastReadToken)) {
                                authorized = false;
                            }
                        } else if (EXECTIME.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens()) {
                            lastReadToken = tokenizer.nextToken().trim();
                            if (lastReadToken.length() != 0) {
                                functionModuleFailed = false;
                            }
                        } else if (MOREPACKAGES.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens()) {
                            lastReadToken = tokenizer.nextToken().trim();
                            this.prolog_MorePackagesWaiting = X.equalsIgnoreCase(lastReadToken);
                        } else if (HEADER_TYPE.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens()) {
                            this.lastReadHeaderType = tokenizer.nextToken().trim();
                        } else if (EXCEPTION_INFO_CODE.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens()) {
                            exceptionInfoCode = lastReadToken = tokenizer.nextToken().trim();
                        } else if (SYNCCOUNTER.equalsIgnoreCase(lastReadToken) && tokenizer.hasMoreTokens() && !functionModuleFailed) {
                            lastReadToken = tokenizer.nextToken().trim();
                            int synccount = Integer.parseInt(lastReadToken);
                            boolean bl = this.oldData = !this.isSyncCountValid(synccount);
                        }
                        if (!tokenizer.hasMoreTokens()) continue;
                        lastReadToken = tokenizer.nextToken().trim();
                    }
                }
            }
        }
        if (exceptionInfoCode != null) {
            throw new SyncException("EXCEPTION_INFO_CODE=" + exceptionInfoCode);
        }
        if (fileWasOfKnownType) {
            if (!authorized) {
                throw new SyncException("Not Authorized for synchronization");
            }
            if (functionModuleFailed) {
                throw new SyncException("Function module failure");
            }
            return lastReadToken;
        }
        throw new SyncException("Inbound file can not be interpreted");
    }

    private int readContainerBody(String headerType, InboundTokenizer st, int numElements, Vector subcontainers) throws SyncException {
        ++numElements;
        st.nextToken();
        String containerIDOfElement = st.nextToken().trim();
        if (headerType.equalsIgnoreCase(MEREPLICATION_ENABLED_HEADER)) {
            st.nextToken();
        }
        String name = st.nextToken().trim();
        String index = st.nextToken().trim();
        String valueString = st.nextToken();
        StringBuffer value = new StringBuffer(valueString);
        SyncInboundContainer container = this.getSyncInboundSubContainerParent(containerIDOfElement);
        if (container != null) {
            if (XML.trim().equalsIgnoreCase(name)) {
                value.setLength(value.length() - 1);
                container.appendGenericBody(value.toString(), Integer.parseInt(index));
            } else {
                container.addElement(name, index, value);
            }
            if (!subcontainers.contains(container)) {
                subcontainers.addElement(container);
            }
        } else {
            AppLog.getInstance("MI/Sync").log(60, "There is no container header for container id {0}", (Object)containerIDOfElement);
        }
        return numElements;
    }

    private void readHeader(String headerType, Hashtable headerList, InboundTokenizer st) throws SyncException {
        SyncHeader nextHeader;
        st.nextToken();
        if (MEREPLICATION_ENABLED_HEADER.equalsIgnoreCase(headerType)) {
            nextHeader = new SyncHeader(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
            if (NEWPROTOCOL_USED) {
                if (nextHeader.getSubContainerId().length() > 0) {
                    int intvalue;
                    String token = st.nextToken().trim();
                    try {
                        intvalue = Integer.parseInt(token);
                        if (intvalue < 0) {
                            intvalue = -1;
                        }
                    }
                    catch (Exception ex) {
                        intvalue = -1;
                    }
                    nextHeader.setItemFrom(intvalue);
                    token = st.nextToken().trim();
                    try {
                        intvalue = Integer.parseInt(token);
                        if (intvalue < 0) {
                            intvalue = -1;
                        }
                    }
                    catch (Exception ex) {
                        intvalue = -1;
                    }
                    nextHeader.setItemTo(intvalue);
                } else {
                    st.nextToken().trim();
                    st.nextToken().trim();
                    nextHeader.setItemFrom(-1);
                    nextHeader.setItemTo(-1);
                }
            }
        } else {
            nextHeader = new SyncHeader(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
        }
        if (!headerList.contains(nextHeader)) {
            SyncInboundContainer cont = new SyncInboundContainer(nextHeader);
            this.inboundContainers.addElement(cont);
            if (cont.isSubContainer() && !cont.isAcknowledge()) {
                SyncInboundContainer parentSub = this.getSyncInboundSubContainerParent(nextHeader.getContainerId());
                if (parentSub == null) {
                    parentSub = new SyncInboundContainer(SyncHeader.createSyncHeaderForSubContainerParent(nextHeader));
                    parentSub.setParentForSubContainer();
                    this.inboundContainers.addElement(parentSub);
                }
                if (NEWPROTOCOL_USED) {
                    parentSub.setInternalIndexForAdd(cont.getSyncHeader().getItemFrom());
                }
            }
            headerList.put(nextHeader, nextHeader);
        }
    }

    private SyncInboundContainer getSyncInboundSubContainerParent(String containerId) {
        int maxelements = this.inboundContainers.size();
        int i = 0;
        while (i < maxelements) {
            SyncInboundContainer container = (SyncInboundContainer)this.inboundContainers.elementAt(i);
            if (containerId.equalsIgnoreCase(container.getContainerId()) && !container.isSubContainer()) {
                return container;
            }
            ++i;
        }
        return null;
    }

    private boolean isSyncCountValid(int syncCounterToCompare) {
        boolean result = false;
        if (syncCounterToCompare > this.syncCountIn || syncCounterToCompare == 0) {
            if (syncCounterToCompare == 0 && this.syncCountIn > 0) {
                this.trace.log(60, "Received initial sync counter {0} although current sync counter was {1}", (Object)String.valueOf(syncCounterToCompare), (Object)String.valueOf(this.syncCountIn));
            }
            this.syncCountIn = syncCounterToCompare;
            this.writeInboundCounterToFile();
            result = true;
        }
        this.trace.log(80, "Received sync counter {0} is {1}valid", (Object)String.valueOf(syncCounterToCompare), (Object)(result ? "" : "not "));
        return result;
    }

    private void readInboundCounterFromFile() {
        if (!this.counterFile.exists()) {
            this.syncCountIn = -1;
            this.writeInboundCounterToFile();
            this.trace.log(60, "Created new sync counter file");
        } else {
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(this.counterFile));
                this.syncCountIn = in.readInt();
                in.close();
            }
            catch (Exception ex) {
                this.trace.logException(50, "Exception while reading sync counters from file", ex, true);
                this.syncCountIn = -1;
                this.writeInboundCounterToFile();
                this.trace.log(60, "Created new sync counter file");
            }
        }
    }

    private void writeInboundCounterToFile() {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(this.counterFile));
            out.writeInt(this.syncCountIn);
            out.close();
        }
        catch (Exception ex) {
            this.trace.logException(50, "Exception while writing sync counters to file", ex, true);
        }
    }

    private void savePendingInboundContainers() {
        IOUtils.serializeObjectToFile(new File(this.pendingInboundContainersName), this.inboundContainers);
        IOUtils.serializeObjectToFile(new File(this.pendingInboundHeadersName), this.headerList);
    }

    private void loadPendingInboundContainers() {
        File f = new File(this.pendingInboundContainersName);
        if (f.exists()) {
            this.inboundContainers = (Vector)IOUtils.readSerializedObjectFromFile(f);
            if (this.inboundContainers == null) {
                AppLog.getInstance("MI/Sync").log(50, "Cannot read pending sync inbound containers");
                this.inboundContainers = new Vector(100);
            }
        } else {
            Trace.getInstance("MI/Sync").log(70, "There are no pending inbound containers to load");
            this.inboundContainers = new Vector(100);
        }
        if ((f = new File(this.pendingInboundHeadersName)).exists()) {
            this.headerList = (Hashtable)IOUtils.readSerializedObjectFromFile(f);
            if (this.headerList == null) {
                AppLog.getInstance("MI/Sync").log(50, "Cannot read pending sync inbound container headers");
                this.headerList = new Hashtable(100);
            }
        } else {
            Trace.getInstance("MI/Sync").log(70, "There are no pending sync inbound container headers to load");
            this.headerList = new Hashtable(100);
        }
    }
}

