/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundContainerElement;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.sync.SyncContainerItem;
import com.sap.ip.me.sync.SyncHeader;
import java.io.Serializable;
import java.util.Vector;

public class SyncInboundContainer
implements InboundContainer,
Serializable {
    static final long serialVersionUID = -4531967579800433404L;
    private static final String EOL_STRING = "<EOL>";
    private static final String GENERIC_BODY_TYPE_NAME = "XML";
    private static final int LENGTH_OF_GEN_BODY_FRAGMENT = 255;
    private SyncHeader syncHeader;
    private Vector items;
    private boolean hasGenericBody;
    private int currentSubContainerCount = 0;
    private boolean parentForSubContainer = false;
    private transient int indexForAdd = 0;
    private int lastElementIndexInSequence = -1;
    private String genBody = null;

    protected SyncInboundContainer(SyncHeader syncHeader) {
        this.syncHeader = syncHeader;
        if (this.isSubContainer()) {
            this.items = new Vector(0);
            this.hasGenericBody = false;
        } else {
            String bt = syncHeader.getBodyType();
            int itemcount = 10;
            if (bt != null && bt.length() > 0) {
                this.hasGenericBody = true;
                int length = syncHeader.getBodyLength();
                itemcount = length == 0 ? 100 : length / 255 + 3;
            } else {
                this.hasGenericBody = false;
            }
            if (syncHeader.isAcknowledge() || syncHeader.isAcknowledgeReceived() || syncHeader.isNotify()) {
                this.items = new Vector(1);
            } else {
                int size = Math.max(itemcount, syncHeader.getSubContainerMax());
                this.items = new Vector(size);
                this.items.setSize(size);
            }
            this.lastElementIndexInSequence = -1;
        }
        Trace trace = Trace.getInstance("MI/Sync");
        if (trace.isLogging(70)) {
            trace.log(70, "------ InboundContainer created: {0}", (Object)this);
        }
    }

    public String getMethod() {
        return this.syncHeader.getMethod();
    }

    public String getSendDate() {
        return this.syncHeader.getSendDate();
    }

    public String getSendTime() {
        return this.syncHeader.getSendTime();
    }

    public String getOwner() {
        return this.syncHeader.getOwner();
    }

    public String getStatus() {
        return this.syncHeader.getStatus();
    }

    public String getExecutionDate() {
        return this.syncHeader.getExecutionDate();
    }

    public String getExecutionTime() {
        return this.syncHeader.getExecutionTime();
    }

    public String getGenericBody() {
        if (this.syncHeader.getBodyType() == null || this.syncHeader.getBodyType().length() == 0 || !this.hasGenericBody) {
            return null;
        }
        if (this.genBody != null) {
            return this.genBody;
        }
        int itemssize = -1;
        if (this.syncHeader.getSubContainerMax() > 0) {
            itemssize = this.syncHeader.getSubContainerMax();
            this.updateLastElementInSequence();
            if (this.lastElementIndexInSequence + 1 != itemssize) {
                Trace trace = Trace.getInstance("MI/Sync");
                trace.log(60, "Internal item {0} is not set within container {1}", (Object)String.valueOf(this.lastElementIndexInSequence + 1), (Object)this.getContainerId());
                return "ERROR in com.sap.ip.me.sync.SyncInboundContainer: There are some at least one container item missed";
            }
        } else {
            itemssize = this.items.size();
        }
        String[] bodyFragments = new String[itemssize];
        int valuesize = 0;
        int pos = -2;
        try {
            int i = 0;
            while (i < itemssize) {
                InboundContainerElement ice = (InboundContainerElement)this.items.elementAt(i);
                if (ice != null) {
                    String v;
                    pos = ice.getLineNumberAsInt();
                    bodyFragments[pos] = v = ice.getFieldValue();
                    valuesize += v.length();
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            Trace.getInstance("MI/Sync").logException(50, "Cannot create generic body for container {0} because the item line number {1} is not valid", new Object[]{this.syncHeader.getContainerId(), Integer.toString(pos)}, outOfBounds, true);
            bodyFragments = null;
            return "ERROR in com.sap.ip.me.sync.SyncInboundContainer constructor : Array index out of bounds";
        }
        StringBuffer genericBody = new StringBuffer(valuesize);
        int numFragments = bodyFragments.length;
        int i = 0;
        while (i < numFragments) {
            if (bodyFragments[i] != null) {
                genericBody.append(bodyFragments[i]);
            }
            ++i;
        }
        SyncInboundContainer.decode(genericBody);
        this.syncHeader.setBodyLength(genericBody.length());
        this.genBody = genericBody.toString();
        bodyFragments = null;
        return this.genBody;
    }

    public String getContainerId() {
        return this.syncHeader.getContainerId();
    }

    public String getAncestorContainerId() {
        return this.syncHeader.getAncestorContainerId();
    }

    public InboundContainerElement[] getAllElements() {
        int size = this.items.size();
        while (size > 0) {
            if (this.items.elementAt(size - 1) != null) break;
            --size;
        }
        InboundContainerElement[] elements = new InboundContainerElement[size];
        int i = 0;
        while (i < size) {
            elements[i] = (InboundContainerElement)this.items.elementAt(i);
            ++i;
        }
        return elements;
    }

    public InboundContainerElement[] getElementsWithFieldName(String fieldName) {
        Vector elementWithFieldNameV = this.getElementsAsVector(fieldName);
        Object[] elementsWithFieldName = new SyncContainerItem[elementWithFieldNameV.size()];
        elementWithFieldNameV.copyInto(elementsWithFieldName);
        return elementsWithFieldName;
    }

    public InboundContainerElement getElement(String fieldName, String lineNumber) {
        int numberOfElements = this.items.size();
        int i = 0;
        while (i < numberOfElements) {
            SyncContainerItem element = (SyncContainerItem)this.items.elementAt(i);
            if (element != null && element.getFieldName().equalsIgnoreCase(fieldName) && element.getLineNumber().equalsIgnoreCase(lineNumber)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public VisibilityType getVisibility() {
        return VisibilityType.SEPARATED;
    }

    public String getType() {
        return this.syncHeader.getType();
    }

    public String getBodyType() {
        return this.syncHeader.getBodyType();
    }

    public int getBodyLength() {
        return this.syncHeader.getBodyLength();
    }

    public SyncHeader getSyncHeader() {
        return this.syncHeader;
    }

    public ConversationId getConversationId() {
        return ConversationIdHandler.getInstance().getConversationId(this.syncHeader.getConversationId());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append("Type:").append(this.getType());
        sb.append(",Id:").append(this.getContainerId()).append(",SId:");
        sb.append(this.getSyncHeader().getSubContainerId()).append(",Items:");
        sb.append(this.lastElementIndexInSequence + 1).append(",MaxI:").append(this.getSyncHeader().getSubContainerMax());
        return sb.toString();
    }

    protected void addElement(String name, String index, StringBuffer value) {
        if (this.indexForAdd >= this.items.size()) {
            SyncContainerItem element = new SyncContainerItem(this.items.size(), name, index, SyncInboundContainer.decode(value).toString());
            this.items.addElement(element);
        } else {
            SyncContainerItem element = new SyncContainerItem(this.indexForAdd, name, index, SyncInboundContainer.decode(value).toString());
            this.items.setElementAt(element, this.indexForAdd);
        }
        ++this.indexForAdd;
        this.updateLastElementInSequence();
    }

    void updateLastElementInSequence() {
        int i = this.lastElementIndexInSequence + 1;
        while (i < this.items.size()) {
            if (this.items.elementAt(i) == null) break;
            this.lastElementIndexInSequence = i++;
        }
    }

    protected boolean isEmpty() {
        return this.items.isEmpty() || this.lastElementIndexInSequence == -1;
    }

    protected boolean isComplete() {
        return this.isAcknowledge() || this.isSubContainer() || this.lastElementIndexInSequence + 1 >= this.getSyncHeader().getSubContainerMax();
    }

    protected boolean isAcknowledge() {
        String type = this.syncHeader.getType();
        return "A".equals(type) || "C".equals(type);
    }

    protected boolean isAcknowledgeReceived() {
        String type = this.syncHeader.getType();
        return "C".equals(type);
    }

    static StringBuffer decode(StringBuffer value) {
        int i = 0;
        int j = 0;
        int length = value.length();
        while (i < length) {
            char c = value.charAt(i);
            if (c == '%' && length >= i + 3) {
                if (value.charAt(i + 1) == '2' && value.charAt(i + 2) == '6') {
                    value.setCharAt(j, '&');
                    i += 2;
                    ++j;
                } else if (value.charAt(i + 1) == '3' && value.charAt(i + 2) == 'd') {
                    value.setCharAt(j, '=');
                    i += 2;
                    ++j;
                } else {
                    value.setCharAt(j, c);
                    ++j;
                }
            } else {
                value.setCharAt(j, c);
                ++j;
            }
            ++i;
        }
        value.setLength(j);
        return value;
    }

    boolean hasToBeProcessedInOrder() {
        boolean processInOrder;
        boolean bl = processInOrder = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true) && ("O".equals(this.getType()) || "R".equals(this.getType()) && "SMARTSYNC".equals(this.getMethod()));
        if (processInOrder) {
            if ("".equals(this.syncHeader.getConversationId()) || this.syncHeader.getMsgIndex() <= 0) {
                AppLog.getInstance("MI/Sync").log(50, "Container {0} should be processed in order but can not be", (Object)this.getContainerId());
                return false;
            }
            return true;
        }
        return false;
    }

    void appendGenericBody(String value_, int index) {
        String value = this.adjustGenericBodyValue(value_);
        if (this.indexForAdd >= this.items.size()) {
            this.items.addElement(new SyncContainerItem(this.items.size(), GENERIC_BODY_TYPE_NAME, index, value));
        } else {
            this.items.setElementAt(new SyncContainerItem(this.indexForAdd, GENERIC_BODY_TYPE_NAME, index, value), this.indexForAdd);
        }
        ++this.indexForAdd;
        this.updateLastElementInSequence();
    }

    boolean isSubContainer() {
        String subCID = this.syncHeader.getSubContainerId();
        return subCID != null && subCID.length() != 0;
    }

    void increaseCurrentSubContainerCount() {
        ++this.currentSubContainerCount;
    }

    boolean isParentForSubContainer() {
        return this.parentForSubContainer;
    }

    void setParentForSubContainer() {
        this.parentForSubContainer = true;
    }

    private String adjustGenericBodyValue(String value) {
        if (value.trim().endsWith(EOL_STRING)) {
            value = value.substring(0, value.indexOf(EOL_STRING));
        } else {
            StringBuffer s = new StringBuffer(Math.max(value.length(), 255));
            s.append(value);
            byte[] b = value.getBytes();
            int spacesToBeAppended = 255 - b.length;
            Trace trace = Trace.getInstance("MI/Sync");
            if (trace.isLogging(90)) {
                trace.log(90, "SyncInboundContainer.appendGenericBody: Length of body fragment adjusted ( added {0} spaces )due to unsent spaces at the end", (Object)Integer.toString(spacesToBeAppended));
                trace.log(90, "SyncInboundContainer.appendGenericBody: Length of body fragment evaluated by (old) method via StringBuffer.length() {0}", (Object)Integer.toString(s.length()));
                trace.log(90, "SyncInboundContainer.appendGenericBody: Length of body fragment evaluated by (new) method via Byte.length() ", (Object)Integer.toString(b.length));
            }
            while (spacesToBeAppended > 0) {
                s.append(' ');
                --spacesToBeAppended;
            }
            value = s.toString();
        }
        return value;
    }

    void setInternalIndexForAdd(int indexForAdd) {
        this.indexForAdd = indexForAdd;
    }

    private Vector getElementsAsVector(String fieldName) {
        int maxsize = this.items.size();
        Vector<InboundContainerElement> elementWithFieldNameV = new Vector<InboundContainerElement>(maxsize);
        int i = 0;
        while (i < maxsize) {
            InboundContainerElement ice = (InboundContainerElement)this.items.elementAt(i);
            if (ice != null && ice.getFieldName().equalsIgnoreCase(fieldName)) {
                elementWithFieldNameV.addElement(ice);
            }
            ++i;
        }
        return elementWithFieldNameV;
    }
}

