/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class SyncHeader
implements Serializable {
    static final boolean USE_NEW_PROTOCOL = Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true);
    static final long serialVersionUID = -7386012152323171979L;
    public static final String TYPE_NOTIFY = "N";
    public static final String TYPE_ACKNOWLEDGE = "A";
    public static final String TYPE_ACKNOWLEDGE_R = "C";
    public static final String TYPE_INBOUND = "O";
    public static final String TYPE_OUTBOUND = new String("I");
    public static final String TYPE_REQUEST = new String("R");
    private static final String OUTBOUND_TYPES = "NAC" + TYPE_OUTBOUND + TYPE_REQUEST;
    private static final String PROTOCOL_TYPES = "NAC";
    private static final int HEADER_END = 0x55AA55AA;
    private String containerId = "";
    private String owner = "";
    private String type = "";
    private String method = "";
    private String sendDate = "";
    private String sendTime = "";
    private String executionDate = "";
    private String executionTime = "";
    private String status = "";
    private String conversationId = "";
    private String ancestorContainerId = "";
    private int msgIndex = -1;
    private String msgType = "";
    private String serverId = "";
    private String bodyType = "";
    private int bodyLength = 0;
    private String subContainerId = "";
    private int subContainerMax = 0;
    private int itemFrom = -1;
    private int itemTo = -1;
    private transient String containerFilename = null;

    static boolean isKnownOutboundContainerType(char type) {
        return OUTBOUND_TYPES.indexOf(type) >= 0;
    }

    static boolean isProtocolType(char type) {
        return PROTOCOL_TYPES.indexOf(type) >= 0;
    }

    public final boolean isNotify() {
        return TYPE_NOTIFY.equals(this.getType());
    }

    public final boolean isAcknowledge() {
        return TYPE_ACKNOWLEDGE.equals(this.getType());
    }

    public final boolean isAcknowledgeReceived() {
        return TYPE_ACKNOWLEDGE_R.equals(this.getType());
    }

    public final boolean isInbound() {
        return TYPE_INBOUND.equals(this.getType());
    }

    protected SyncHeader(String containerId, ConversationId convId, String type, String method) {
        this.setContainerId(containerId);
        this.setOwner(convId == null ? ConversationIdHandler.getInstance().getCurrentConversationId().getUser().getUniqueName() : convId.getUser().getUniqueName());
        this.setConversationId(convId);
        this.type = type;
        this.method = method;
        this.setNewProtocolFlag();
    }

    protected SyncHeader(String containerId, String owner, String type, String method, String sendDate, String sendTime, String executionDate, String executionTime, String status, String conversationId, String parcontId, String msgIndex, String msgType, String serverId, String bodyType, String bodyLength, String subContainerId, String subContainerCountMax) {
        this.setContainerId(containerId);
        this.setSubContainerId(subContainerId);
        this.setOwner(owner);
        this.type = type;
        this.method = method;
        this.sendDate = sendDate;
        this.sendTime = sendTime;
        this.executionDate = executionDate;
        this.executionTime = executionTime;
        this.status = status;
        if (Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", false)) {
            this.conversationId = conversationId;
        }
        this.ancestorContainerId = parcontId;
        this.setMsgIndex(msgIndex);
        this.msgType = msgType;
        this.serverId = serverId;
        this.bodyType = bodyType;
        try {
            this.setBodyLength(Integer.parseInt(bodyLength));
        }
        catch (NumberFormatException e) {
            this.setBodyLength(0);
        }
        try {
            this.setSubContainerMax(Integer.parseInt(subContainerCountMax));
        }
        catch (NumberFormatException e) {
            this.setSubContainerMax(0);
        }
        this.setNewProtocolFlag();
    }

    protected SyncHeader(String containerId, String owner, String type, String method, String sendDate, String sendTime, String executionDate, String executionTime, String status) {
        this.setContainerId(containerId);
        this.setOwner(owner);
        this.type = type;
        this.method = method;
        this.sendDate = sendDate;
        this.sendTime = sendTime;
        this.executionDate = executionDate;
        this.executionTime = executionTime;
        this.status = status;
        this.setConversationId(ConversationIdHandler.getInstance().getCurrentConversationId());
        this.setNewProtocolFlag();
    }

    protected SyncHeader(String containerId, String owner, String type, String method, String sendDate, String sendTime, String executionDate, String executionTime) {
        this.setContainerId(containerId);
        this.setOwner(owner);
        this.type = type;
        this.method = method;
        this.sendDate = sendDate;
        this.sendTime = sendTime;
        this.executionDate = executionDate;
        this.executionTime = executionTime;
        this.setConversationId(ConversationIdHandler.getInstance().getCurrentConversationId());
        this.setNewProtocolFlag();
    }

    protected SyncHeader(String containerId) {
        this.setContainerId(containerId);
        this.setConversationId(ConversationIdHandler.getInstance().getCurrentConversationId());
        this.setNewProtocolFlag();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncHeader)) {
            return false;
        }
        SyncHeader sh = (SyncHeader)obj;
        return this.containerId.equalsIgnoreCase(sh.getContainerId()) && this.subContainerId.equalsIgnoreCase(sh.getSubContainerId());
    }

    public int hashCode() {
        return this.containerId.hashCode() ^ this.subContainerId.hashCode();
    }

    public String toString() {
        return new String("Id: " + this.containerId);
    }

    public boolean isBodyLengthInitial() {
        return this.bodyLength == 0;
    }

    public boolean sequenceNoHasToBeAttached() {
        return Configuration.getInstance().getBoolean("MobileEngine.Sync.NewProtocol", true) && ("I".equals(this.type) || "R".equals(this.type) && "SMARTSYNC".equals(this.method));
    }

    static SyncHeader createSyncHeaderForSubContainerParent(SyncHeader subContainerHeader) {
        SyncHeader clone = new SyncHeader(subContainerHeader.containerId);
        clone.ancestorContainerId = subContainerHeader.ancestorContainerId;
        clone.bodyLength = subContainerHeader.bodyLength;
        clone.bodyType = subContainerHeader.bodyType;
        clone.conversationId = subContainerHeader.conversationId;
        clone.executionDate = subContainerHeader.executionDate;
        clone.executionTime = subContainerHeader.executionTime;
        clone.method = subContainerHeader.method;
        clone.msgIndex = subContainerHeader.msgIndex;
        clone.msgType = subContainerHeader.msgType;
        clone.owner = subContainerHeader.owner;
        clone.sendDate = subContainerHeader.sendDate;
        clone.sendTime = subContainerHeader.sendTime;
        clone.serverId = subContainerHeader.serverId;
        clone.status = subContainerHeader.status;
        clone.subContainerId = "";
        clone.subContainerMax = subContainerHeader.subContainerMax;
        clone.type = subContainerHeader.type;
        return clone;
    }

    SyncHeader clone(String newSubContainerId, int itemfrom, int itemto) {
        SyncHeader clone = new SyncHeader(this.containerId, this.owner, this.type, this.method, this.sendDate, this.sendTime, this.executionDate, this.executionTime, this.status, this.conversationId, this.ancestorContainerId, String.valueOf(this.msgIndex), this.msgType, this.serverId, this.bodyType, String.valueOf(this.bodyLength), newSubContainerId, String.valueOf(this.subContainerMax));
        clone.itemFrom = itemfrom;
        clone.itemTo = itemto;
        return clone;
    }

    private void setNewProtocolFlag() {
        if (USE_NEW_PROTOCOL) {
            this.serverId = "NEW_PROTOCOL";
        }
    }

    public final String getAncestorContainerId() {
        return this.ancestorContainerId;
    }

    protected void setAncestorContainerId(String ancestorContainerId) {
        this.ancestorContainerId = ancestorContainerId;
    }

    public final int getBodyLength() {
        return this.bodyLength;
    }

    protected void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    public final String getBodyType() {
        return this.bodyType;
    }

    protected void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public final String getContainerId() {
        return this.containerId;
    }

    protected void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public final String getConversationId() {
        return this.conversationId;
    }

    protected void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    protected void setConversationId(ConversationId conversationId) {
        if (conversationId.isGeneratedOnServer()) {
            this.conversationId = conversationId.getServerCommunicationId();
        }
    }

    public final String getExecutionDate() {
        return this.executionDate;
    }

    protected void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public final String getExecutionTime() {
        return this.executionTime;
    }

    protected void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    public final int getItemFrom() {
        return this.itemFrom;
    }

    protected void setItemFrom(int itemFrom) {
        this.itemFrom = itemFrom;
    }

    public final int getItemTo() {
        return this.itemTo;
    }

    protected void setItemTo(int itemTo) {
        this.itemTo = itemTo;
    }

    public final String getMethod() {
        return this.method;
    }

    protected void setMethod(String method) {
        this.method = method;
    }

    public final int getMsgIndex() {
        return this.msgIndex;
    }

    protected void setMsgIndex(int msgIndex) {
        this.msgIndex = msgIndex <= 0 ? -1 : msgIndex;
    }

    void setMsgIndex(String msgIndex) {
        if (msgIndex == null) {
            msgIndex = "-1";
        }
        try {
            this.msgIndex = Integer.parseInt(msgIndex);
            if (this.msgIndex <= 0) {
                this.msgIndex = -1;
            }
        }
        catch (Exception ex) {
            this.msgIndex = -1;
        }
    }

    public final String getMsgType() {
        return this.msgType;
    }

    protected void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public final String getOwner() {
        return this.owner;
    }

    protected void setOwner(String owner) {
        this.owner = UserManagerImpl.getUserManagerImplInstance().checkIfShared(owner) ? "" : owner;
    }

    public final String getSendDate() {
        return this.sendDate;
    }

    protected void setSendDate(String sendDate) {
        this.sendDate = sendDate;
    }

    public final String getSendTime() {
        return this.sendTime;
    }

    protected void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public final String getServerId() {
        return this.serverId;
    }

    protected void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public final String getStatus() {
        return this.status;
    }

    protected void setStatus(String status) {
        this.status = status;
    }

    public final String getSubContainerId() {
        return this.subContainerId;
    }

    protected void setSubContainerId(String subContainerId) {
        int value = -1;
        try {
            value = Integer.parseInt(subContainerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.subContainerId = value <= 0 ? "" : this.getFormatedNumber(value, 10);
    }

    private String getFormatedNumber(int n, int len) {
        StringBuffer result = new StringBuffer(len);
        String value = Integer.toString(n);
        if (value.length() > len) {
            return value.substring(value.length() - len);
        }
        int zeros = len - value.length();
        int i = 0;
        while (i < zeros) {
            result.append("0");
            ++i;
        }
        result.append(value);
        return result.toString();
    }

    public final int getSubContainerMax() {
        return this.subContainerMax;
    }

    protected void setSubContainerMax(int subContainerMax) {
        this.subContainerMax = subContainerMax;
    }

    public final String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void writeHeaderToStream(DataOutputStream out) throws IOException {
        out.writeUTF(this.containerId);
        out.writeUTF(this.owner);
        out.writeUTF(this.type);
        out.writeUTF(this.method);
        out.writeUTF(this.sendDate);
        out.writeUTF(this.sendTime);
        out.writeUTF(this.executionDate);
        out.writeUTF(this.executionTime);
        out.writeUTF(this.status);
        out.writeUTF(this.conversationId);
        out.writeUTF(this.ancestorContainerId);
        out.writeInt(this.msgIndex);
        out.writeUTF(this.msgType);
        out.writeUTF(this.serverId);
        out.writeUTF(this.bodyType);
        out.writeInt(this.bodyLength);
        out.writeUTF(this.subContainerId);
        out.writeInt(this.subContainerMax);
        out.writeInt(this.itemFrom);
        out.writeInt(this.itemTo);
        out.writeInt(0x55AA55AA);
    }

    String getContainerFilename() {
        return this.containerFilename;
    }

    void setContainerFilename(String newFilename) {
        this.containerFilename = newFilename;
    }

    private SyncHeader() {
    }

    protected static SyncHeader createHeaderFromStream(DataInputStream in) throws IOException {
        SyncHeader result = new SyncHeader();
        result.containerId = in.readUTF();
        result.owner = in.readUTF();
        result.type = in.readUTF();
        result.method = in.readUTF();
        result.sendDate = in.readUTF();
        result.sendTime = in.readUTF();
        result.executionDate = in.readUTF();
        result.executionTime = in.readUTF();
        result.status = in.readUTF();
        result.conversationId = in.readUTF();
        result.ancestorContainerId = in.readUTF();
        result.msgIndex = in.readInt();
        result.msgType = in.readUTF();
        result.serverId = in.readUTF();
        result.bodyType = in.readUTF();
        result.bodyLength = in.readInt();
        result.subContainerId = in.readUTF();
        result.subContainerMax = in.readInt();
        result.itemFrom = in.readInt();
        result.itemTo = in.readInt();
        int headerend = in.readInt();
        if (headerend != 0x55AA55AA) {
            throw new IOException("Error while reading container; container header is corrupted");
        }
        return result;
    }
}

