/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.sync.SyncFilenameFilter;
import com.sap.ip.me.sync.SyncHeader;
import com.sap.ip.me.sync.SyncOutboundContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class SyncFileManager {
    private static final String OUTBOUNDFOLDER_NAME = "out";
    private static final String TRANSACTION_OUTBOUNDFOLDER_NAME = "ta";
    private static final String SYNCFOLDER_NAME = "sync";
    private static final String ACKNOWLEDGE_PREFIX = "a";
    private static final String ACKNOWLEDGE_RECEIVED_PREFIX = "c";
    private static final String HEADER_PREFIX = "h";
    static final String SYNCEXTENSION = ".sync";
    static final String TEMP_INBOUND_FILENAME = "syncin.tmp";
    static final String OUTBOUND_PACKAGE_FILENAME = "package.out";
    private Trace trace = Trace.getInstance("MI/Sync");
    Hashtable out_containerCounters = new Hashtable(16);
    Hashtable out_acknowledgesCounters = new Hashtable(16);
    Hashtable out_acknowledgesReceivedCounters = new Hashtable(16);

    private File getOutboundFolder(User u) {
        return this.getOutboundFolder(u, false);
    }

    private File getOutboundFolder(User u, boolean inTransaction) {
        String path;
        File dir;
        String instFolder = Configuration.getInstallationDirectory();
        String username = u.getUniqueName();
        StringBuffer pathBuffer = new StringBuffer(instFolder.length() + username.length() + 20);
        pathBuffer.append(instFolder).append(File.separatorChar).append(SYNCFOLDER_NAME);
        pathBuffer.append(File.separatorChar).append(username);
        pathBuffer.append(File.separatorChar).append(OUTBOUNDFOLDER_NAME);
        if (inTransaction) {
            pathBuffer.append(File.separatorChar).append(TRANSACTION_OUTBOUNDFOLDER_NAME);
        }
        if (!(dir = new File(path = pathBuffer.toString())).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    File getOutboundPackageFile(User u) {
        return new File(this.getOutboundFolder(u).getAbsolutePath(), OUTBOUND_PACKAGE_FILENAME);
    }

    private File getNextOutboundContainerFile(User u, boolean inTransaction) {
        StringBuffer filenameBuffer = new StringBuffer(13);
        filenameBuffer.append(HEADER_PREFIX).append(this.getFormatedNumber(this.getNextCounter(u, this.out_containerCounters, HEADER_PREFIX), 7, 36)).append(SYNCEXTENSION);
        File f = new File(this.getOutboundFolder(u, inTransaction), filenameBuffer.toString());
        return f;
    }

    private File getNextOutboundAcknowledgeFile(User u) {
        StringBuffer filenameBuffer = new StringBuffer(13);
        filenameBuffer.append(ACKNOWLEDGE_PREFIX).append(this.getFormatedNumber(this.getNextCounter(u, this.out_acknowledgesCounters, ACKNOWLEDGE_PREFIX), 7, 36)).append(SYNCEXTENSION);
        File f = new File(this.getOutboundFolder(u), filenameBuffer.toString());
        return f;
    }

    private File getNextOutboundAcknowledgeReceivedFile(User u) {
        StringBuffer filenameBuffer = new StringBuffer(13);
        filenameBuffer.append(ACKNOWLEDGE_RECEIVED_PREFIX).append(this.getFormatedNumber(this.getNextCounter(u, this.out_acknowledgesReceivedCounters, ACKNOWLEDGE_RECEIVED_PREFIX), 7, 36)).append(SYNCEXTENSION);
        File f = new File(this.getOutboundFolder(u), filenameBuffer.toString());
        return f;
    }

    synchronized String getNextSubContainerCount(String containerid, User user) {
        File counterFile = new File(this.getOutboundFolder(user).getAbsolutePath(), containerid);
        long counter = 0L;
        if (counterFile.exists()) {
            DataInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(counterFile));
                counter = in.readLong();
                in.close();
            }
            catch (IOException ioex) {
                Trace.getInstance("MI/Sync").logException(50, "Cannot read sub container counter from file", ioex, true);
                counter = 0L;
            }
        }
        ++counter;
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(counterFile));
            out.writeLong(counter);
            out.close();
        }
        catch (IOException ioex) {
            Trace.getInstance("MI/Sync").logException(50, "Cannot write sub container counter to file", ioex, true);
            counter = 1L;
        }
        return counter <= 0L ? "" : this.getFormatedNumber(counter, 10, 10);
    }

    synchronized String[] getAllOutboundContainerFileNames(User u) {
        return this.getOutboundContainerFileNames(u, HEADER_PREFIX);
    }

    synchronized String[] getAllOutboundAcknowledgeFileNames(User u) {
        return this.getOutboundContainerFileNames(u, ACKNOWLEDGE_PREFIX);
    }

    synchronized String[] getAllOutboundAcknowledgeReceivedFileNames(User u) {
        return this.getOutboundContainerFileNames(u, ACKNOWLEDGE_RECEIVED_PREFIX);
    }

    private String[] getOutboundContainerFileNames(User u, String prefix) {
        File outfolder = this.getOutboundFolder(u);
        String[] filelist = outfolder.list(new SyncFilenameFilter(prefix));
        String[] result = null;
        if (filelist == null || filelist.length == 0) {
            result = new String[]{};
        } else {
            this.sort(filelist, 0, filelist.length - 1);
            result = new String[filelist.length];
            int i = 0;
            while (i < result.length) {
                result[i] = new File(outfolder, filelist[i]).getAbsolutePath();
                ++i;
            }
        }
        return result;
    }

    protected void sort(String[] array, int start, int end) {
        if (start < end) {
            int p = this.partition(array, start, end);
            this.sort(array, start, p);
            this.sort(array, p + 1, end);
        }
    }

    private int partition(String[] array, int start, int end) {
        String partitionElement = array[start];
        int left = start - 1;
        int right = end + 1;
        while (true) {
            if (partitionElement.compareTo(array[--right]) < 0) {
                if (right != start) {
                    continue;
                }
            }
            while (partitionElement.compareTo(array[++left]) > 0) {
                if (left == end) break;
            }
            if (left >= right) break;
            this.swap(array, left, right);
        }
        return right;
    }

    private void swap(String[] array, int i, int j) {
        String temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    synchronized void writeOutboundContainer(SyncOutboundContainer outboundcontainer, User user, boolean inTransaction) throws IOException {
        File file = null;
        try {
            SyncHeader header = outboundcontainer.getHeader();
            file = header.isAcknowledge() ? this.getNextOutboundAcknowledgeFile(user) : (header.isAcknowledgeReceived() ? this.getNextOutboundAcknowledgeReceivedFile(user) : this.getNextOutboundContainerFile(user, inTransaction));
            outboundcontainer.writeContainerToFile(file);
        }
        catch (IOException ioex) {
            if (file != null) {
                file.delete();
            }
            throw ioex;
        }
    }

    synchronized void cleanTransactionOutboundFolder(User user) {
        File folder = this.getOutboundFolder(user, true);
        boolean result = IOUtils.deleteDirectoryRecursively(folder);
        if (this.trace.isLogging(90)) {
            this.trace.log(90, result ? "Successfully cleaned transactional outbound folder {0}" : "Cannot clean transactional outbound folder {0}", (Object)folder.getAbsolutePath());
        }
    }

    synchronized void moveTransactionOutboundFolderToOutboundFolder(User user) {
        File sourceFolder = this.getOutboundFolder(user, true);
        File targetFolder = this.getOutboundFolder(user, false);
        String[] files = sourceFolder.list();
        boolean result = true;
        int i = 0;
        while (i < files.length) {
            File sourcefile = new File(sourceFolder, files[i]);
            File targetfile = new File(targetFolder, files[i]);
            result = sourcefile.renameTo(targetfile);
            if (this.trace.isLogging(90)) {
                this.trace.log(90, result ? "Successfully moved transactional outbound container file {0} to {1}" : "Cannot move transactional outbound container file {0} to {1}", (Object)sourcefile.getAbsolutePath(), (Object)targetfile.getAbsolutePath());
            }
            ++i;
        }
    }

    private long getNextCounter(User u, Hashtable t, String prefix) {
        Long current = (Long)t.get(u.getUniqueID());
        Long newCounter = null;
        newCounter = current == null ? this.getNextCounter(u, prefix) : new Long(current + 1L);
        t.put(u.getUniqueID(), newCounter);
        return newCounter;
    }

    private Long getNextCounter(User u, String prefix) {
        Long newCounter;
        File dir = this.getOutboundFolder(u);
        String[] files = dir.list(new SyncFilenameFilter(prefix));
        if (files == null || files.length == 0) {
            newCounter = new Long(1L);
        } else {
            long maxcounter = 0L;
            int i = 0;
            while (i < files.length) {
                String s = files[i];
                long filecount = Long.parseLong(s.substring(1, 8), 36);
                if (filecount > maxcounter) {
                    maxcounter = filecount;
                }
                ++i;
            }
            newCounter = new Long(maxcounter + 1L);
        }
        return newCounter;
    }

    private String getFormatedNumber(long number, int length, int base) {
        StringBuffer sb = new StringBuffer(length);
        String formatted = Long.toString(number, base);
        int zeros = length - formatted.length();
        if (zeros > 0) {
            int i = 0;
            while (i < zeros) {
                sb.append('0');
                ++i;
            }
            sb.append(formatted);
        } else if (zeros == 0) {
            sb.append(formatted);
        } else {
            sb.append(formatted.substring(-zeros));
        }
        return sb.toString();
    }
}

