/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.services.IOUtils;
import com.sap.ip.me.api.sync.SyncEvent;
import com.sap.ip.me.api.sync.SyncEventListener;
import com.sap.ip.me.api.sync.SyncEventRegistry;
import com.sap.ip.me.api.user.User;
import com.sap.ip.me.api.user.UserManager;
import com.sap.ip.me.core.ContextSwitch;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.UserManagerImpl;
import com.sap.ip.me.sync.SyncLogImpl;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class SyncEventRegistryImpl
extends SyncEventRegistry {
    private Hashtable syncEventListeners;
    private File listenersFile;

    public SyncEventRegistryImpl() {
        try {
            StringBuffer listenersFileName = new StringBuffer(84);
            listenersFileName.append(Configuration.getInstallationDirectory());
            listenersFileName.append(File.separator);
            listenersFileName.append("sync");
            listenersFileName.append(File.separator);
            listenersFileName.append("eventListeners");
            this.listenersFile = new File(listenersFileName.toString());
            this.syncEventListeners = IOUtils.readHashtableFromDirectory(this.listenersFile);
        }
        catch (Exception e) {
            SyncEventRegistry.trace.logException(50, "Registered sync Event listeners could not be read from file; use empty registry", e, true);
        }
        if (this.syncEventListeners == null) {
            this.syncEventListeners = new Hashtable();
        }
    }

    public boolean isRegistered(SyncEventListener l) {
        return this.isRegistered(l, null);
    }

    public boolean isRegistered(SyncEventListener l, ConversationId convId) {
        if (l == null) {
            return false;
        }
        if (convId == null) {
            convId = ConversationIdHandler.getInstance().getCurrentConversationId();
        }
        String key = l.getClass().getName() + "/" + (convId == null ? "" : convId.getId());
        return this.syncEventListeners.containsKey(key);
    }

    public synchronized void addSyncEventListener(SyncEventListener l) throws IllegalArgumentException {
        this.addSyncEventListener(l, null);
    }

    public synchronized void addSyncEventListener(SyncEventListener l, ConversationId convId) throws IllegalArgumentException {
        if (l == null) {
            throw new IllegalArgumentException("SyncEventListener is null");
        }
        if (convId == null) {
            convId = ConversationIdHandler.getInstance().getCurrentConversationId();
        }
        String convidstring = convId == null ? "" : convId.getId();
        String key = l.getClass().getName() + "/" + convidstring;
        SyncEventRegistryEntry entry = new SyncEventRegistryEntry(convidstring, l);
        this.syncEventListeners.put(key, entry);
        IOUtils.saveHashtableToDirectory(this.listenersFile, this.syncEventListeners);
    }

    public synchronized void removeSyncEventListener(SyncEventListener l) {
        this.removeSyncEventListener(l, null);
    }

    public synchronized void removeSyncEventListener(SyncEventListener l, ConversationId convId) {
        String key;
        Object listenerEntry;
        if (l == null) {
            return;
        }
        if (convId == null) {
            convId = ConversationIdHandler.getInstance().getCurrentConversationId();
        }
        if ((listenerEntry = this.syncEventListeners.get(key = l.getClass().getName() + "/" + (convId == null ? "" : convId.getId()))) != null) {
            this.syncEventListeners.remove(key);
            IOUtils.saveHashtableToDirectory(this.listenersFile, this.syncEventListeners);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fireSyncEventNotifierMethod(SyncEvent event, VisibilityType visibility) {
        Enumeration enumeration = this.syncEventListeners.elements();
        SyncEventRegistryEntry entry = null;
        SyncEventListener listener = null;
        ContextSwitch context = null;
        ConversationIdHandler convIdHandler = ConversationIdHandler.getInstance();
        ConversationId id = null;
        User currentUser = UserManager.getInstance().getCurrentUser();
        boolean isLogging = SyncEventRegistry.trace.isLogging(70);
        while (enumeration.hasMoreElements()) {
            Object var13_12;
            try {
                block8: {
                    try {
                        entry = (SyncEventRegistryEntry)enumeration.nextElement();
                        id = convIdHandler.getConversationId(entry.getConversationId());
                        if (id == null || !visibility.equals(VisibilityType.USER_SHARED) && !UserManagerImpl.getSharedUser().equals(id.getUser()) && !id.getUser().equals(currentUser)) break block8;
                        context = ContextSwitch.switchContextTo(id);
                        listener = entry.getEventListener();
                        if (isLogging) {
                            SyncEventRegistry.trace.log(70, "SyncEvent Performing {0}", (Object)listener.getClass().getName());
                        }
                        listener.actionPerformed(event);
                    }
                    catch (Exception ex) {
                        AppLog.getInstance("MI/API/Sync").logException(50, "Problems while sync event processing", ex, true);
                        SyncLogImpl.getSyncLogImplInstance().addFailureMessage("Exception while sync event processing: " + ex.getLocalizedMessage() + " (" + ex.getClass().getName() + ")");
                        var13_12 = null;
                        if (context == null) continue;
                        ContextSwitch.restoreLastContext(context);
                        context = null;
                        continue;
                    }
                }
                var13_12 = null;
                if (context == null) continue;
            }
            catch (Throwable throwable) {
                var13_12 = null;
                if (context != null) {
                    ContextSwitch.restoreLastContext(context);
                    context = null;
                }
                throw throwable;
            }
            ContextSwitch.restoreLastContext(context);
            context = null;
        }
        return;
    }

    static class SyncEventRegistryEntry
    implements Serializable {
        private String conversationId;
        private SyncEventListener eventListener;

        protected SyncEventRegistryEntry() {
        }

        SyncEventRegistryEntry(String conversationId, SyncEventListener listener) {
            this.conversationId = conversationId;
            this.eventListener = listener;
        }

        String getConversationId() {
            return this.conversationId;
        }

        SyncEventListener getEventListener() {
            return this.eventListener;
        }
    }
}

