/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.sync.InboundContainerElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;

public class SyncContainerItem
implements InboundContainerElement,
Serializable {
    private int index;
    private String name;
    private String lineNumber;
    private int lineNumberAsInt = -2;
    private String value;
    private boolean alreadyAcknowledged;

    SyncContainerItem(int index, String name, String linenumber, String value) {
        this.index = index;
        this.name = name;
        this.lineNumber = linenumber;
        this.lineNumberAsInt = -2;
        this.value = value;
    }

    SyncContainerItem(int index, String name, int linenumber, String value) {
        this.index = index;
        this.name = name;
        this.lineNumber = String.valueOf(linenumber);
        this.lineNumberAsInt = linenumber;
        this.value = value;
    }

    int getIndex() {
        return this.index;
    }

    boolean isAlreadyAcknowledged() {
        return this.alreadyAcknowledged;
    }

    void setAlreadyAcknowledged(boolean alreadyAcknowledged) {
        this.alreadyAcknowledged = alreadyAcknowledged;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public int getLineNumberAsInt() {
        if (this.lineNumberAsInt == -2) {
            try {
                this.lineNumberAsInt = Integer.parseInt(this.lineNumber);
            }
            catch (NumberFormatException nfEx) {
                AppLog.getInstance("MI/Sync").logException(60, "Cannot parse container element line number", nfEx, true);
                this.lineNumberAsInt = -1;
            }
        }
        return this.lineNumberAsInt;
    }

    public String getFieldName() {
        return this.name;
    }

    public String getFieldValue() {
        return this.value;
    }

    public String getFieldValueSubstring(int begin, int length) {
        if (this.value.length() < begin + length) {
            if (this.value.length() > begin) {
                return this.value.substring(begin, this.value.length());
            }
            return "";
        }
        return this.value.substring(begin, begin + length);
    }

    void writeItemToStream(DataOutputStream file) throws IOException {
        file.writeInt(this.index);
        file.writeUTF(this.name);
        file.writeUTF(this.lineNumber);
        file.writeInt(this.lineNumberAsInt);
        file.writeUTF(this.value);
        file.writeBoolean(this.alreadyAcknowledged);
        file.writeByte(0);
    }

    private SyncContainerItem() {
    }

    static SyncContainerItem createContainerItemFromStream(DataInputStream file) throws IOException {
        SyncContainerItem item = new SyncContainerItem();
        try {
            item.index = file.readInt();
            item.name = file.readUTF();
            item.lineNumber = file.readUTF();
            item.lineNumberAsInt = file.readInt();
            item.value = file.readUTF();
            item.alreadyAcknowledged = file.readBoolean();
            file.readByte();
            return item;
        }
        catch (EOFException endoffile) {
            return null;
        }
    }
}

