/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.sync.SyncContainerItem;
import com.sap.ip.me.sync.SyncHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class SyncContainer
implements Serializable {
    private static final SyncContainerItem EMPTYITEM = new SyncContainerItem(-1, "", -1, "");
    private SyncHeader header;
    private Vector items;
    private transient File containerFile = null;
    private transient boolean loaded = true;

    public boolean equals(Object obj) {
        return this.getHeader().equals(((SyncContainer)obj).getHeader());
    }

    public int hashCode() {
        return this.getHeader().hashCode();
    }

    protected SyncContainer() {
        this.header = null;
        this.initializeItems(-1);
        this.containerFile = null;
        this.loaded = true;
    }

    protected SyncContainer(File containerFile) {
        this.header = null;
        this.containerFile = containerFile;
        this.initializeItems(-1);
        this.loaded = false;
    }

    protected SyncContainer(SyncHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("Cannot create SyncContainer with 'null'-header");
        }
        this.header = header;
        this.initializeItems(-1);
        this.containerFile = null;
        this.loaded = true;
    }

    protected void setHeader(SyncHeader header) {
        this.header = header;
        this.initializeItems(-1);
    }

    SyncHeader getHeader() {
        if (this.header == null && !this.loaded) {
            try {
                this.readContainer(true);
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").logException(50, "Cannot read container header from file", ex, true);
                throw new IllegalStateException("Cannot read container header from file");
            }
        }
        return this.header;
    }

    protected void initializeItems(int initalSize) {
        if (this.items != null && this.items.size() > 0) {
            throw new IllegalStateException("Cannot initialize SyncContainer items because there are already items contained");
        }
        if (initalSize > 0) {
            this.items = new Vector(initalSize);
        } else if (this.getHeader() == null) {
            this.items = new Vector();
        } else {
            int maxitems = this.getHeader().getSubContainerMax();
            this.items = !this.isSubContainer() && maxitems > 0 ? new Vector(maxitems) : new Vector();
        }
    }

    void addItem(SyncContainerItem item) {
        this.items.addElement(item);
    }

    SyncContainerItem getItemAt(int itemPos) {
        if (itemPos < 0 || itemPos >= this.items.size()) {
            throw new ArrayIndexOutOfBoundsException("There is no sync container item at " + itemPos);
        }
        if (!this.loaded) {
            try {
                this.readContainer(false);
            }
            catch (Exception ex) {
                Trace.getInstance("MI/Sync").logException(50, "Lazy loading of container items failed", ex, true);
                throw new IllegalStateException("Lazy loading of container items failed");
            }
        }
        return (SyncContainerItem)this.items.elementAt(itemPos);
    }

    boolean isSubContainer() {
        SyncHeader header = this.getHeader();
        return !"".equals(header.getSubContainerId()) && !header.isAcknowledge() && !header.isAcknowledgeReceived() && !header.isNotify();
    }

    int getItemCount() {
        return this.items.size();
    }

    public String getContainerId() {
        return this.header.getContainerId();
    }

    File getContainerFile() {
        return this.containerFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeContainerToFile(File file) throws IOException {
        this.containerFile = new File(file.getParent(), file.getName());
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        try {
            this.getHeader().writeHeaderToStream(out);
            this.writeAdditionalContainerHeaderData(out);
            out.writeInt(this.getItemCount());
            if (this.getItemCount() > 0) {
                SyncContainerItem item = null;
                int i = 0;
                while (i < this.getItemCount()) {
                    item = this.getItemAt(i);
                    item.writeItemToStream(out);
                    this.writeAdditionalItemData(out, item);
                    ++i;
                }
            }
            Object var6_5 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    protected void writeAdditionalContainerHeaderData(DataOutputStream out) throws IOException {
    }

    protected void writeAdditionalItemData(DataOutputStream out, SyncContainerItem currentitem) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readContainer(boolean lazy) throws IOException {
        if (this.containerFile == null) {
            throw new IOException("No container file set");
        }
        if (this.loaded) {
            return;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(this.containerFile));
        try {
            SyncHeader aheader = SyncHeader.createHeaderFromStream(in);
            aheader = this.readCustomContainerHeaderData(in, aheader);
            if (this.header == null) {
                this.header = aheader;
            }
            int itemcount = in.readInt();
            this.items = new Vector(itemcount);
            this.items.setSize(itemcount);
            SyncContainerItem item = null;
            if (!lazy) {
                this.loaded = true;
                int i = 0;
                while (i < itemcount) {
                    item = SyncContainerItem.createContainerItemFromStream(in);
                    item = this.readCustomItemData(in, item);
                    this.items.setElementAt(item, i);
                    ++i;
                }
            } else {
                this.loaded = false;
                int i = 0;
                while (i < itemcount) {
                    this.items.setElementAt(null, i);
                    ++i;
                }
            }
            Object var8_8 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    protected SyncHeader readCustomContainerHeaderData(DataInputStream in, SyncHeader currentHeader) throws IOException {
        return currentHeader;
    }

    protected SyncContainerItem readCustomItemData(DataInputStream in, SyncContainerItem currentitem) throws IOException {
        return currentitem;
    }
}

