/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.sync;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.services.BufferedUTF8Reader;
import com.sap.ip.me.api.services.BufferedUTF8Writer;
import com.sap.ip.me.api.services.MEException;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.core.SyncSettings;
import com.sap.ip.me.sync.ClientHttpSynchronizer;
import com.sap.ip.me.sync.SyncHeader;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileListHandling;
import com.sapmarkets.web.liTS.util.PDAFile.PDAFileStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyncAcknowledge
extends PDAFileListHandling {
    private static final String HEADER_TYPE = "HeaderType";
    private static final String MEREPLICATION_ENABLED_HEADER = "MEREPLICATION";
    private static String fileNameOut;
    private static File fileOut;
    private static File fileIn;
    private static BufferedUTF8Writer fileOutWriter;
    private Vector containerIDs = new Vector();

    public SyncAcknowledge() throws MEException {
        super(PDAFileStructure.SYNC_DIR, ".txt");
        String installDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        fileIn = new File(installDir, "syncain" + ".txt");
        fileOut = new File(installDir, "syncaout" + ".txt");
        fileNameOut = fileOut.getAbsolutePath();
        this.containerIDs = this.readPending();
    }

    public boolean checkIfPending(SyncHeader h) {
        return this.containerIDs.contains(h);
    }

    public void addHeader(SyncHeader header) {
        this.containerIDs.addElement(header);
    }

    public void send(String url) throws SyncException {
        ClientHttpSynchronizer httpSynchronizer = new ClientHttpSynchronizer();
        Vector pendingIDs = new Vector();
        this.writeIDsToFile();
        SyncSettings.updateSystemProxySettings();
        try {
            Configuration config = Configuration.getInstance();
            httpSynchronizer.synchronize(url, fileOut.getAbsolutePath(), fileIn.getAbsolutePath(), config.getBoolean("MobileEngine.Datacompression.Gzip", false));
            pendingIDs = this.getIDsStillPending();
        }
        catch (MEException ex) {
            pendingIDs = this.containerIDs;
            this.savePending(pendingIDs);
            throw new SyncException(ex.getMessage());
        }
        this.savePending(pendingIDs);
    }

    private void writeIDsToFile() throws SyncException {
        try {
            File acknowledgeFile = new File(fileNameOut);
            boolean append = true;
            fileOutWriter = acknowledgeFile.exists() ? new BufferedUTF8Writer(fileNameOut, append) : new BufferedUTF8Writer(fileNameOut, false);
        }
        catch (IOException io) {
            AppLog.getInstance("MI/Sync").logException("cannot open file: " + fileNameOut, (Throwable)io, true);
            throw new SyncException("cannot open file: " + fileNameOut);
        }
        StringBuffer sb = new StringBuffer();
        Enumeration ids = this.containerIDs.elements();
        int count = 1;
        SyncHeader nextElement = null;
        while (ids.hasMoreElements()) {
            nextElement = (SyncHeader)ids.nextElement();
            sb.append("OUTBOUND_HEADERS-CONT_ID[").append(count).append("]=");
            sb.append(nextElement.getContainerId());
            sb.append("&");
            sb.append("OUTBOUND_HEADERS-SUBCONT_ID[").append(count).append("]=");
            sb.append(nextElement.getSubContainerId());
            sb.append("&");
            ++count;
        }
        String output = sb.toString();
        try {
            fileOutWriter.write(output);
            fileOutWriter.flush();
            fileOutWriter.close();
        }
        catch (IOException io) {
            throw new SyncException(io.getMessage());
        }
        catch (NullPointerException se) {
            throw new SyncException(se.getLocalizedMessage());
        }
    }

    private Vector getIDsStillPending() throws SyncException {
        String line = null;
        BufferedUTF8Reader reader = null;
        String content = null;
        try {
            reader = new BufferedUTF8Reader(fileIn);
            StringBuffer contentBuffer = new StringBuffer(250);
            while ((line = reader.readLine()) != null) {
                contentBuffer.append(line);
            }
            content = contentBuffer.toString();
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Sync").logException(60, (Throwable)e, true);
            return this.containerIDs;
        }
        StringTokenizer st = new StringTokenizer(content, "&=", false);
        boolean merep = false;
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.equalsIgnoreCase(HEADER_TYPE) && st.nextToken().trim().equalsIgnoreCase(MEREPLICATION_ENABLED_HEADER)) {
                merep = true;
            }
            try {
                if (!nextToken.equalsIgnoreCase("HEADERS")) continue;
                st.nextToken();
                SyncHeader h = merep ? new SyncHeader(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim()) : new SyncHeader(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
                Enumeration c = this.containerIDs.elements();
                while (c.hasMoreElements()) {
                    SyncHeader sh = (SyncHeader)c.nextElement();
                    if (!sh.equals(h)) continue;
                    this.containerIDs.removeElement(sh);
                }
            }
            catch (NoSuchElementException e) {
                break;
            }
        }
        return this.containerIDs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector readPending() {
        Vector vector;
        Vector pendingIDs = new Vector();
        FileInputStream fs = null;
        ObjectInputStream objstream = null;
        String installDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
        File fileIn = new File(installDir, "syncapen.txt");
        File fileInAbsolutePath = new File(fileIn.getAbsolutePath());
        if (!fileInAbsolutePath.exists()) {
            return pendingIDs;
        }
        try {
            try {
                fs = new FileInputStream(fileIn.getAbsolutePath());
                objstream = new ObjectInputStream(fs);
                try {
                    pendingIDs = (Vector)objstream.readObject();
                    objstream.close();
                    fs.close();
                    vector = pendingIDs;
                    Object var10_10 = null;
                }
                catch (ClassNotFoundException c) {
                    Object var10_11 = null;
                    try {
                        objstream.close();
                        fs.close();
                        return pendingIDs;
                    }
                    catch (IOException e2) {
                        AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.readPending : " + e2.getMessage(), (Throwable)e2, true);
                        return pendingIDs;
                    }
                }
            }
            catch (IOException e) {
                Vector vector2 = pendingIDs;
                Object var10_12 = null;
                try {}
                catch (IOException e2) {
                    AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.readPending : " + e2.getMessage(), (Throwable)e2, true);
                    return vector2;
                }
                objstream.close();
                fs.close();
                return pendingIDs;
            }
            catch (Exception ex) {
                AppLog.getInstance("MI/Sync").logException(60, "SyncAcknowledge.readPending : " + ex.getMessage(), ex, true);
                Object var10_13 = null;
                try {}
                catch (IOException e2) {
                    AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.readPending : " + e2.getMessage(), (Throwable)e2, true);
                    return pendingIDs;
                }
                objstream.close();
                fs.close();
                return pendingIDs;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {}
            catch (IOException e2) {
                AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.readPending : " + e2.getMessage(), (Throwable)e2, true);
                throw throwable;
            }
            objstream.close();
            fs.close();
            return pendingIDs;
        }
        try {}
        catch (IOException e2) {
            AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.readPending : " + e2.getMessage(), (Throwable)e2, true);
            return vector;
        }
        objstream.close();
        fs.close();
        return pendingIDs;
    }

    /*
     * Loose catch block
     */
    private void savePending(Vector ids) {
        block8: {
            FileOutputStream fs = null;
            ObjectOutputStream objstream = null;
            String installDir = Configuration.getInstance().getProperty("MobileEngine.InstallationPath");
            File fileOut = new File(installDir, "syncapen.txt");
            fs = new FileOutputStream(fileOut.getAbsolutePath());
            objstream = new ObjectOutputStream(fs);
            objstream.writeObject(ids);
            objstream.close();
            fs.close();
            Object var8_6 = null;
            try {
                objstream.close();
                fs.close();
            }
            catch (IOException e2) {
                AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.savePending : " + e2.getMessage(), (Throwable)e2, true);
            }
            break block8;
            {
                catch (IOException e) {
                    AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.savePending : " + e.getMessage(), (Throwable)e, true);
                    Object var8_7 = null;
                    try {
                        objstream.close();
                        fs.close();
                    }
                    catch (IOException e2) {
                        AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.savePending : " + e2.getMessage(), (Throwable)e2, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    objstream.close();
                    fs.close();
                }
                catch (IOException e2) {
                    AppLog.getInstance("MI/Sync").logException("SyncAcknowledge.savePending : " + e2.getMessage(), (Throwable)e2, true);
                }
                throw throwable;
            }
        }
    }
}

